/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.AbstractNodeFeatureTest;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.InertData;
import com.vaadin.flow.internal.nodefeature.ShadowRootHost;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InertDataTest
extends AbstractNodeFeatureTest<InertData> {
    private StateNode parent;
    private StateNode child;
    private StateNode grandchild;

    @Before
    public void setup() {
        this.parent = InertDataTest.createNode(null);
        this.child = InertDataTest.createNode(this.parent);
        this.grandchild = InertDataTest.createNode(this.child);
    }

    @Test
    public void inertData_defaults() {
        Element element = ElementFactory.createDiv();
        Assert.assertFalse((String)"Elements should not have InertData by default", (boolean)element.getNode().getFeatureIfInitialized(InertData.class).isPresent());
        InertData inertData = (InertData)element.getNode().getFeature(InertData.class);
        Assert.assertFalse((boolean)inertData.isInertSelf());
        Assert.assertFalse((boolean)inertData.isIgnoreParentInert());
        Assert.assertTrue((boolean)inertData.allowsChanges());
    }

    @Test
    public void inertData_hasShadowRoot_handlesInertCheck() {
        this.parent = InertDataTest.createNode(null);
        StateNode shadow = new StateNode(new Class[]{ElementChildrenList.class, ShadowRootHost.class});
        ((ElementChildrenList)this.parent.getFeature(ElementChildrenList.class)).add(0, shadow);
        this.grandchild = InertDataTest.createNode(shadow);
        InertData parentFeature = (InertData)this.parent.getFeature(InertData.class);
        parentFeature.setInertSelf(true);
        parentFeature.generateChangesFromEmpty();
        Assert.assertTrue((boolean)parentFeature.isInert());
        Assert.assertFalse((boolean)this.grandchild.getFeatureIfInitialized(InertData.class).isPresent());
    }

    @Test
    public void inertData_inheritingInert_allPermutations() {
        InertData childFeature = (InertData)this.child.getFeature(InertData.class);
        childFeature.setIgnoreParentInert(true);
        Assert.assertFalse((boolean)childFeature.isInert());
        childFeature.generateChangesFromEmpty();
        InertData parentFeature = (InertData)this.parent.getFeature(InertData.class);
        parentFeature.setInertSelf(true);
        parentFeature.generateChangesFromEmpty();
        Assert.assertTrue((boolean)parentFeature.isInert());
        Assert.assertFalse((boolean)childFeature.isInert());
        Assert.assertFalse((boolean)this.grandchild.getFeatureIfInitialized(InertData.class).isPresent());
        childFeature.setIgnoreParentInert(false);
        childFeature.generateChangesFromEmpty();
        Assert.assertTrue((boolean)parentFeature.isInert());
        Assert.assertTrue((boolean)childFeature.isInert());
        Assert.assertFalse((boolean)this.grandchild.getFeatureIfInitialized(InertData.class).isPresent());
        childFeature.setIgnoreParentInert(true);
        childFeature.generateChangesFromEmpty();
        Assert.assertTrue((boolean)parentFeature.isInert());
        Assert.assertFalse((boolean)childFeature.isInert());
        Assert.assertFalse((boolean)this.grandchild.getFeatureIfInitialized(InertData.class).isPresent());
        childFeature.setInertSelf(true);
        childFeature.generateChangesFromEmpty();
        Assert.assertTrue((boolean)parentFeature.isInert());
        Assert.assertTrue((boolean)childFeature.isInert());
        Assert.assertFalse((boolean)this.grandchild.getFeatureIfInitialized(InertData.class).isPresent());
        parentFeature.setInertSelf(false);
        parentFeature.generateChangesFromEmpty();
        Assert.assertFalse((boolean)parentFeature.isInert());
        Assert.assertTrue((boolean)childFeature.isInert());
        Assert.assertFalse((boolean)this.grandchild.getFeatureIfInitialized(InertData.class).isPresent());
        childFeature.setInertSelf(false);
        childFeature.generateChangesFromEmpty();
        Assert.assertFalse((boolean)parentFeature.isInert());
        Assert.assertFalse((boolean)childFeature.isInert());
        Assert.assertFalse((boolean)this.grandchild.getFeatureIfInitialized(InertData.class).isPresent());
        childFeature.setIgnoreParentInert(false);
        parentFeature.setInertSelf(true);
        parentFeature.generateChangesFromEmpty();
        Assert.assertTrue((boolean)parentFeature.isInert());
        Assert.assertTrue((boolean)childFeature.isInert());
        Assert.assertFalse((boolean)this.grandchild.getFeatureIfInitialized(InertData.class).isPresent());
    }

    @Test
    public void inertDataUpdates_hierarchyWithGaps_updatesCascaded() {
        StateNode greatgrandchild = InertDataTest.createNode(this.grandchild);
        InertData greatgrandchildFeature = (InertData)greatgrandchild.getFeature(InertData.class);
        greatgrandchildFeature.setInertSelf(false);
        greatgrandchildFeature.generateChangesFromEmpty();
        Assert.assertFalse((boolean)greatgrandchild.isInert());
        InertData parentFeature = (InertData)this.parent.getFeature(InertData.class);
        parentFeature.setInertSelf(true);
        parentFeature.generateChangesFromEmpty();
        Assert.assertTrue((boolean)this.parent.isInert());
        Assert.assertTrue((boolean)this.child.isInert());
        Assert.assertTrue((boolean)this.grandchild.isInert());
        Assert.assertTrue((boolean)greatgrandchild.isInert());
        InertData grandchildFeature = (InertData)this.grandchild.getFeature(InertData.class);
        grandchildFeature.setIgnoreParentInert(true);
        grandchildFeature.generateChangesFromEmpty();
        Assert.assertTrue((boolean)this.parent.isInert());
        Assert.assertTrue((boolean)this.child.isInert());
        Assert.assertFalse((boolean)this.grandchild.isInert());
        Assert.assertFalse((boolean)greatgrandchild.isInert());
        parentFeature.setInertSelf(false);
        parentFeature.generateChangesFromEmpty();
        Assert.assertFalse((boolean)this.parent.isInert());
        Assert.assertFalse((boolean)this.child.isInert());
        Assert.assertFalse((boolean)this.grandchild.isInert());
        Assert.assertFalse((boolean)greatgrandchild.isInert());
        parentFeature.setInertSelf(true);
        parentFeature.generateChangesFromEmpty();
        Assert.assertTrue((boolean)this.parent.isInert());
        Assert.assertTrue((boolean)this.child.isInert());
        Assert.assertFalse((boolean)this.grandchild.isInert());
        Assert.assertFalse((boolean)greatgrandchild.isInert());
        grandchildFeature.setIgnoreParentInert(false);
        grandchildFeature.generateChangesFromEmpty();
        Assert.assertTrue((boolean)this.parent.isInert());
        Assert.assertTrue((boolean)this.child.isInert());
        Assert.assertTrue((boolean)this.grandchild.isInert());
        Assert.assertTrue((boolean)greatgrandchild.isInert());
        parentFeature.setInertSelf(false);
        parentFeature.generateChangesFromEmpty();
        Assert.assertFalse((boolean)this.parent.isInert());
        Assert.assertFalse((boolean)this.child.isInert());
        Assert.assertFalse((boolean)this.grandchild.isInert());
        Assert.assertFalse((boolean)greatgrandchild.isInert());
        parentFeature.setInertSelf(true);
        grandchildFeature.setIgnoreParentInert(true);
        parentFeature.generateChangesFromEmpty();
        Assert.assertTrue((boolean)this.parent.isInert());
        Assert.assertTrue((boolean)this.child.isInert());
        Assert.assertFalse((boolean)this.grandchild.isInert());
        Assert.assertFalse((boolean)greatgrandchild.isInert());
    }

    private static StateNode createNode(StateNode parent) {
        StateNode stateNode = new StateNode(new Class[]{ElementChildrenList.class, InertData.class});
        if (parent != null) {
            ((ElementChildrenList)parent.getFeature(ElementChildrenList.class)).add(0, stateNode);
        }
        return stateNode;
    }
}

