/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.ActiveStyleSheetTracker;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.VaadinService;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ActiveStyleSheetTrackerTest {
    @Test
    public void singletonPerContext() {
        MockVaadinServletService service = new MockVaadinServletService();
        ActiveStyleSheetTracker t1 = ActiveStyleSheetTracker.get((VaadinService)service);
        ActiveStyleSheetTracker t2 = ActiveStyleSheetTracker.get((VaadinService)service);
        Assert.assertSame((Object)t1, (Object)t2);
    }

    @Test
    public void addRemoveAndAppShellMerge() {
        MockVaadinServletService service = new MockVaadinServletService();
        ActiveStyleSheetTracker tracker = ActiveStyleSheetTracker.get((VaadinService)service);
        Assert.assertTrue((boolean)tracker.getActiveUrls().isEmpty());
        tracker.trackForAppShell(Set.of("context://css/app.css"));
        Assert.assertEquals(Set.of("context://css/app.css"), (Object)tracker.getActiveUrls());
        tracker.trackAddForComponent("context://css/view.css");
        Assert.assertTrue((boolean)tracker.getActiveUrls().contains("context://css/app.css"));
        Assert.assertTrue((boolean)tracker.getActiveUrls().contains("context://css/view.css"));
        tracker.trackRemoveForComponent("context://css/view.css");
        Assert.assertTrue((boolean)tracker.getActiveUrls().contains("context://css/app.css"));
        Assert.assertFalse((boolean)tracker.getActiveUrls().contains("context://css/view.css"));
    }
}

