/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.AbstractNodeTest;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementAttachListener;
import com.vaadin.flow.dom.ElementDetachListener;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.dom.NodeVisitor;
import com.vaadin.flow.dom.ShadowRoot;
import com.vaadin.flow.dom.TestNodeVisitor;
import com.vaadin.flow.dom.impl.ShadowRootStateProvider;
import com.vaadin.flow.internal.NullOwner;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class ShadowRootTest
extends AbstractNodeTest {
    @Test
    public void publicElementMethodsShouldReturnElement() {
        HashSet<String> ignore = new HashSet<String>();
        ignore.add("toString");
        ignore.add("hashCode");
        ignore.add("equals");
        ignore.add("indexOfChild");
        this.assertMethodsReturnType(ShadowRoot.class, ignore);
    }

    @Test
    public void insertAtCurrentPositionNoOp() {
        UI ui = new UI();
        ShadowRoot parent = ui.getElement().attachShadow();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        child.addDetachListener((ElementDetachListener & Serializable)e -> Assert.fail((String)"Child should not be detached"));
        parent.insertChild(0, new Element[]{child});
    }

    @Test
    public void equalsSelf() {
        ShadowRoot root = this.createParentNode();
        Assert.assertTrue((boolean)root.equals((Object)root));
    }

    @Test
    public void notEqualsNull() {
        ShadowRoot root = this.createParentNode();
        Assert.assertFalse((boolean)root.equals(null));
    }

    @Test
    public void attachListener_parentAttach_childListenersTriggered() {
        Element body = new UI().getElement();
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        Element grandChild = ElementFactory.createDiv();
        AtomicInteger childTriggered = new AtomicInteger();
        AtomicInteger grandChildTriggered = new AtomicInteger();
        Registration registrationHandle = child.addAttachListener((ElementAttachListener & Serializable)event -> childTriggered.addAndGet(1));
        child.addAttachListener((ElementAttachListener & Serializable)event -> Assert.assertEquals((Object)child, (Object)event.getSource()));
        grandChild.addAttachListener((ElementAttachListener & Serializable)event -> grandChildTriggered.addAndGet(1));
        grandChild.addAttachListener((ElementAttachListener & Serializable)event -> Assert.assertEquals((Object)grandChild, (Object)event.getSource()));
        parent.attachShadow().appendChild(new Element[]{child});
        child.appendChild(new Element[]{grandChild});
        Assert.assertEquals((long)childTriggered.get(), (long)0L);
        Assert.assertEquals((long)grandChildTriggered.get(), (long)0L);
        body.appendChild(new Element[]{parent});
        Assert.assertEquals((long)childTriggered.get(), (long)1L);
        Assert.assertEquals((long)grandChildTriggered.get(), (long)1L);
        body.removeAllChildren();
        ((ShadowRoot)parent.getShadowRoot().get()).removeAllChildren();
        body.appendChild(new Element[]{parent});
        ((ShadowRoot)parent.getShadowRoot().get()).appendChild(new Element[]{child});
        Assert.assertEquals((long)childTriggered.get(), (long)2L);
        Assert.assertEquals((long)grandChildTriggered.get(), (long)2L);
        registrationHandle.remove();
        body.removeAllChildren();
        body.appendChild(new Element[]{child});
        Assert.assertEquals((long)childTriggered.get(), (long)2L);
        Assert.assertEquals((long)grandChildTriggered.get(), (long)3L);
    }

    @Test
    public void detachListener_parentDetach_childListenersTriggered() {
        Element body = new UI().getElement();
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        Element grandChild = ElementFactory.createDiv();
        AtomicInteger triggered = new AtomicInteger();
        Registration registrationHandle = child.addDetachListener((ElementDetachListener & Serializable)event -> {
            triggered.addAndGet(1);
            Assert.assertEquals((Object)child, (Object)event.getSource());
        });
        grandChild.addDetachListener((ElementDetachListener & Serializable)event -> {
            triggered.addAndGet(1);
            Assert.assertEquals((Object)grandChild, (Object)event.getSource());
        });
        child.appendChild(new Element[]{grandChild});
        parent.attachShadow().appendChild(new Element[]{child});
        body.appendChild(new Element[]{parent});
        Assert.assertEquals((long)triggered.get(), (long)0L);
        body.removeAllChildren();
        Assert.assertEquals((long)triggered.get(), (long)2L);
        body.appendChild(new Element[]{parent});
        body.removeAllChildren();
        Assert.assertEquals((long)triggered.get(), (long)4L);
        body.appendChild(new Element[]{parent});
        registrationHandle.remove();
        body.removeAllChildren();
        Assert.assertEquals((long)triggered.get(), (long)5L);
    }

    @Test
    public void attachListener_eventOrder_childFirst() {
        Element body = new UI().getElement();
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        parent.attachShadow().appendChild(new Element[]{child});
        AtomicBoolean parentAttached = new AtomicBoolean();
        AtomicBoolean childAttached = new AtomicBoolean();
        child.addAttachListener((ElementAttachListener & Serializable)event -> {
            childAttached.set(true);
            Assert.assertFalse((boolean)parentAttached.get());
        });
        parent.addAttachListener((ElementAttachListener & Serializable)event -> {
            parentAttached.set(true);
            Assert.assertTrue((boolean)childAttached.get());
        });
        body.appendChild(new Element[]{parent});
        Assert.assertTrue((boolean)parentAttached.get());
        Assert.assertTrue((boolean)childAttached.get());
    }

    @Test
    public void detachListener_eventOrder_childFirst() {
        Element body = new UI().getElement();
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        parent.attachShadow().appendChild(new Element[]{child});
        body.appendChild(new Element[]{parent});
        AtomicBoolean parentDetached = new AtomicBoolean();
        AtomicBoolean childDetached = new AtomicBoolean();
        child.addDetachListener((ElementDetachListener & Serializable)event -> {
            childDetached.set(true);
            Assert.assertFalse((boolean)parentDetached.get());
        });
        parent.addDetachListener((ElementDetachListener & Serializable)event -> {
            parentDetached.set(true);
            Assert.assertTrue((boolean)childDetached.get());
        });
        body.removeAllChildren();
        Assert.assertTrue((boolean)parentDetached.get());
        Assert.assertTrue((boolean)childDetached.get());
    }

    @Test
    public void attachDetach_elementMoved_bothEventsTriggered() {
        ShadowRoot bodyShadow = new UI().getElement().attachShadow();
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        bodyShadow.appendChild(new Element[]{parent});
        AtomicBoolean attached = new AtomicBoolean();
        AtomicBoolean detached = new AtomicBoolean();
        child.addAttachListener((ElementAttachListener & Serializable)event -> {
            attached.set(true);
            Assert.assertTrue((boolean)detached.get());
        });
        child.addDetachListener((ElementDetachListener & Serializable)event -> {
            detached.set(true);
            Assert.assertFalse((boolean)attached.get());
        });
        bodyShadow.appendChild(new Element[]{child});
        Assert.assertTrue((boolean)attached.get());
        Assert.assertTrue((boolean)detached.get());
    }

    @Test
    public void attachEvent_stateTreeCanFound() {
        ShadowRoot bodyShadow = new UI().getElement().attachShadow();
        Element child = ElementFactory.createDiv();
        AtomicInteger attached = new AtomicInteger();
        child.addAttachListener((ElementAttachListener & Serializable)event -> {
            Assert.assertNotNull((Object)event.getSource().getNode().getOwner());
            Assert.assertNotEquals((Object)NullOwner.get(), (Object)event.getSource().getNode().getOwner());
        });
        child.addAttachListener((ElementAttachListener & Serializable)event -> attached.incrementAndGet());
        bodyShadow.appendChild(new Element[]{child});
        Assert.assertEquals((long)1L, (long)attached.get());
    }

    @Test
    public void detachEvent_stateTreeCanFound() {
        ShadowRoot bodyShadow = new UI().getElement().attachShadow();
        Element child = ElementFactory.createDiv();
        bodyShadow.appendChild(new Element[]{child});
        AtomicInteger detached = new AtomicInteger();
        child.addDetachListener((ElementDetachListener & Serializable)event -> {
            Assert.assertNotNull((Object)event.getSource().getNode().getOwner());
            Assert.assertNotEquals((Object)NullOwner.get(), (Object)event.getSource().getNode().getOwner());
        });
        child.addDetachListener((ElementDetachListener & Serializable)event -> detached.incrementAndGet());
        bodyShadow.removeAllChildren();
        Assert.assertEquals((long)1L, (long)detached.get());
    }

    @Test
    public void getParentNode_parentNodeIsNull() {
        ShadowRoot root = this.createParentNode();
        Assert.assertNull((Object)root.getParentNode());
    }

    @Test
    public void visitOnlyNode_hasDescendants_nodeVisitedAndNoDescendantsVisited() {
        TestNodeVisitor visitor = new TestNodeVisitor(false);
        HashMap map = new HashMap();
        ShadowRoot subject = this.createHierarchy(map);
        ShadowRootStateProvider.get().visit(subject.getNode(), (NodeVisitor)visitor);
        Assert.assertEquals((long)1L, (long)visitor.getVisited().size());
        Assert.assertEquals((Object)subject, visitor.getVisited().keySet().iterator().next());
        Assert.assertEquals(null, (Object)visitor.getVisited().values().iterator().next());
    }

    @Test
    public void visitOnlyNode_hasDescendants_nodeAndDescendatnsAreVisited() {
        TestNodeVisitor visitor = new TestNodeVisitor(true);
        HashMap map = new HashMap();
        ShadowRoot subject = this.createHierarchy(map);
        ShadowRootStateProvider.get().visit(subject.getNode(), (NodeVisitor)visitor);
        Assert.assertTrue((map.size() > 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The collected descendants doesn't match expected descendatns", map, visitor.getVisited());
    }

    private ShadowRoot createHierarchy(Map<Node<?>, NodeVisitor.ElementType> map) {
        Element root = ElementFactory.createDiv();
        ShadowRoot shadowRoot = root.attachShadow();
        map.put((Node<?>)shadowRoot, (NodeVisitor.ElementType)null);
        Element shadowChild = ElementFactory.createAnchor();
        Element shadowVirtualChild = ElementFactory.createBr();
        shadowRoot.appendChild(new Element[]{shadowChild});
        shadowRoot.appendVirtualChild(new Element[]{shadowVirtualChild});
        map.put((Node<?>)shadowChild, NodeVisitor.ElementType.REGULAR);
        map.put((Node<?>)shadowVirtualChild, NodeVisitor.ElementType.VIRTUAL);
        Element virtualGrandChild = ElementFactory.createDiv();
        shadowChild.getStateProvider().appendVirtualChild(shadowChild.getNode(), virtualGrandChild, "@id", "id");
        map.put((Node<?>)virtualGrandChild, NodeVisitor.ElementType.VIRTUAL_ATTACHED);
        return shadowRoot;
    }

    protected ShadowRoot createParentNode() {
        return ElementFactory.createDiv().attachShadow();
    }
}

