/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.dom.AbstractNodeTest;
import com.vaadin.flow.dom.BasicElementStateProviderTest;
import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementAttachListener;
import com.vaadin.flow.dom.ElementDetachListener;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.dom.ShadowRoot;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.dom.impl.BasicElementStateProvider;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.NullOwner;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ComponentMapping;
import com.vaadin.flow.internal.nodefeature.ElementAttributeMap;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.internal.nodefeature.ElementListenersTest;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.ElementStylePropertyMap;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.tests.util.MockUI;
import com.vaadin.tests.util.TestUtil;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Date;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import net.jcip.annotations.NotThreadSafe;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.ObjectNode;

@NotThreadSafe
public class ElementJacksonTest
extends AbstractNodeTest {
    @Test
    public void createElementWithTag() {
        Element e = ElementFactory.createDiv();
        Assert.assertEquals((Object)"div", (Object)e.getTag());
        Assert.assertFalse((boolean)e.hasAttribute("is"));
        Assert.assertFalse((boolean)e.isTextNode());
    }

    @Test(expected=IllegalArgumentException.class)
    public void createElementWithInvalidTag() {
        new Element("<div>");
    }

    @Test(expected=IllegalArgumentException.class)
    public void createElementWithEmptyTag() {
        new Element("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void createElementWithNullTag() {
        new Element(null);
    }

    @Test
    public void elementsUpdateSameData() {
        Element te = new Element("testelem");
        Element e = Element.get((StateNode)te.getNode());
        Assert.assertEquals((Object)te, (Object)e);
        te.setAttribute("foo", "bar");
        Assert.assertEquals((Object)"bar", (Object)e.getAttribute("foo"));
        e.setAttribute("baz", "123");
        Assert.assertEquals((Object)"123", (Object)te.getAttribute("baz"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getElementFromInvalidNode() {
        StateNode node = new StateNode(new Class[]{ElementPropertyMap.class});
        Element.get((StateNode)node);
    }

    @Test
    public void publicElementMethodsShouldReturnElement() {
        HashSet<String> ignore = new HashSet<String>();
        ignore.add("toString");
        ignore.add("hashCode");
        ignore.add("equals");
        ignore.add("addEventListener");
        ignore.add("addAttachListener");
        ignore.add("addDetachListener");
        ignore.add("addPropertyChangeListener");
        ignore.add("indexOfChild");
        ignore.add("as");
        ignore.add("callFunction");
        ignore.add("executeJavaScript");
        ignore.add("callJsFunction");
        ignore.add("executeJs");
        ignore.add("attachShadow");
        ignore.add("getShadowRoot");
        ignore.add("bindProperty");
        ignore.add("bindAttribute");
        ignore.add("bindText");
        this.assertMethodsReturnType(Element.class, ignore);
    }

    @Test
    public void publicElementStyleMethodsShouldReturnElement() {
        HashSet<String> ignore = new HashSet<String>();
        ignore.add("toString");
        ignore.add("hashCode");
        ignore.add("equals");
        for (Method m : Style.class.getDeclaredMethods()) {
            if (!Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers()) || m.getName().startsWith("get") || m.getName().startsWith("has") || m.getName().startsWith("is") || ignore.contains(m.getName())) continue;
            Class<?> returnType = m.getReturnType();
            Assert.assertEquals((String)("Method " + m.getName() + " has invalid return type"), Style.class, returnType);
        }
    }

    @Test
    public void stringAttribute() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("foo", "bar");
        Assert.assertEquals((Object)"bar", (Object)e.getAttribute("foo"));
    }

    @Test
    public void setEmptyAttribute() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("foo", "");
        Assert.assertEquals((Object)"", (Object)e.getAttribute("foo"));
    }

    @Test
    public void setBooleanAttribute() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("foo", true);
        Assert.assertEquals((Object)"", (Object)e.getAttribute("foo"));
        Assert.assertTrue((boolean)e.hasAttribute("foo"));
        e.setAttribute("foo", false);
        Assert.assertEquals(null, (Object)e.getAttribute("foo"));
        Assert.assertFalse((boolean)e.hasAttribute("foo"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void setNullAttribute() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("foo", (String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNullAttribute() {
        Element e = ElementFactory.createDiv();
        e.getAttribute(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void hasNullAttribute() {
        Element e = ElementFactory.createDiv();
        e.hasAttribute(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void removeNullAttribute() {
        Element e = ElementFactory.createDiv();
        e.removeAttribute(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setInvalidAttribute() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("\"foo\"", "bar");
    }

    @Test
    public void hasDefinedAttribute() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("foo", "bar");
        Assert.assertTrue((boolean)e.hasAttribute("foo"));
    }

    @Test
    public void doesNotHaveUndefinedAttribute() {
        Element e = ElementFactory.createDiv();
        Assert.assertFalse((boolean)e.hasAttribute("foo"));
    }

    @Test
    public void doesNotHaveRemovedAttribute() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("foo", "bar");
        e.removeAttribute("foo");
        Assert.assertFalse((boolean)e.hasAttribute("foo"));
    }

    @Test
    public void removeNonExistingAttributeIsNoOp() {
        Element e = ElementFactory.createDiv();
        Assert.assertFalse((boolean)e.hasAttribute("foo"));
        e.removeAttribute("foo");
        Assert.assertFalse((boolean)e.hasAttribute("foo"));
    }

    @Test
    public void attributesWhenNoneDefined() {
        Element e = ElementFactory.createDiv();
        Assert.assertEquals((long)0L, (long)e.getAttributeNames().count());
    }

    @Test
    public void attributesNames() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("foo", "bar");
        Assert.assertArrayEquals((Object[])new String[]{"foo"}, (Object[])e.getAttributeNames().toArray());
    }

    @Test
    public void attributesNamesAfterRemoved() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("foo", "bar");
        e.setAttribute("bar", "baz");
        e.removeAttribute("foo");
        Assert.assertArrayEquals((Object[])new String[]{"bar"}, (Object[])e.getAttributeNames().toArray());
    }

    @Test
    public void setGetAttributeValueCaseSensitive() {
        Element e = new Element("span");
        e.setAttribute("foo", "bAr");
        Assert.assertEquals((Object)"bAr", (Object)e.getAttribute("foo"));
        e.setAttribute("foo", "BAR");
        Assert.assertEquals((Object)"BAR", (Object)e.getAttribute("foo"));
    }

    @Test
    public void setGetAttributeNameCaseInsensitive() {
        Element e = new Element("span");
        e.setAttribute("foo", "bar");
        e.setAttribute("FOO", "baz");
        Assert.assertEquals((Object)"baz", (Object)e.getAttribute("foo"));
        Assert.assertEquals((Object)"baz", (Object)e.getAttribute("FOO"));
    }

    @Test
    public void hasAttributeNamesCaseInsensitive() {
        Element e = new Element("span");
        e.setAttribute("fooo", "bar");
        Assert.assertTrue((boolean)e.hasAttribute("fOoO"));
    }

    @Test
    public void getAttributeNamesLowerCase() {
        Element e = new Element("span");
        e.setAttribute("FOO", "bar");
        e.setAttribute("Baz", "bar");
        Set attributeNames = e.getAttributeNames().collect(Collectors.toSet());
        Assert.assertTrue((boolean)attributeNames.contains("foo"));
        Assert.assertFalse((boolean)attributeNames.contains("FOO"));
        Assert.assertTrue((boolean)attributeNames.contains("baz"));
        Assert.assertFalse((boolean)attributeNames.contains("Baz"));
    }

    @Test
    public void removeDetachedFromParent() {
        Element otherElement = new Element("other");
        Assert.assertNull((Object)otherElement.getParent());
        otherElement.removeFromParent();
        Assert.assertNull((Object)otherElement.getParent());
    }

    @Test
    public void getDetachedParent() {
        Element otherElement = new Element("other");
        Assert.assertNull((Object)otherElement.getParent());
        Assert.assertNull((Object)otherElement.getParentNode());
    }

    @Test(expected=IllegalArgumentException.class)
    public void addNullEventListener() {
        Element e = ElementFactory.createDiv();
        e.addEventListener("foo", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void addEventListenerForNullType() {
        Element e = ElementFactory.createDiv();
        e.addEventListener(null, (DomEventListener & Serializable)ignore -> {});
    }

    @Test
    public void equalsSelf() {
        Element e = ElementFactory.createDiv();
        Assert.assertTrue((boolean)e.equals((Object)e));
    }

    @Test
    public void notEqualsNull() {
        Element e = ElementFactory.createDiv();
        Assert.assertFalse((boolean)e.equals(null));
    }

    @Test
    public void notEqualsString() {
        Element e = ElementFactory.createDiv();
        Assert.assertFalse((boolean)e.equals((Object)"div"));
    }

    @Test
    public void getPropertyDefaults() {
        Element element = ElementFactory.createDiv();
        element.setProperty("null", null);
        element.setProperty("empty", "");
        Assert.assertEquals((Object)"d", (Object)element.getProperty("null", "d"));
        Assert.assertEquals((Object)"d", (Object)element.getProperty("notThere", "d"));
        Assert.assertNotEquals((Object)"d", (Object)element.getProperty("empty", "d"));
        Assert.assertTrue((boolean)element.getProperty("null", true));
        Assert.assertFalse((boolean)element.getProperty("null", false));
        Assert.assertTrue((boolean)element.getProperty("notThere", true));
        Assert.assertFalse((boolean)element.getProperty("notThere", false));
        Assert.assertFalse((boolean)element.getProperty("empty", true));
        Assert.assertFalse((boolean)element.getProperty("empty", false));
        Assert.assertEquals((double)0.1, (double)element.getProperty("null", 0.1), (double)0.0);
        Assert.assertEquals((double)0.1, (double)element.getProperty("notThere", 0.1), (double)0.0);
        Assert.assertNotEquals((double)0.1, (double)element.getProperty("empty", 0.1), (double)0.0);
        Assert.assertEquals((long)42L, (long)element.getProperty("null", 42));
        Assert.assertEquals((long)42L, (long)element.getProperty("notThere", 42));
        Assert.assertNotEquals((long)42L, (long)element.getProperty("empty", 42));
    }

    @Test
    public void getPropertyStringConversions() {
        ElementJacksonTest.assertPropertyString(null, null);
        ElementJacksonTest.assertPropertyString("foo", "foo");
        ElementJacksonTest.assertPropertyString("", "");
        ElementJacksonTest.assertPropertyString("45.6e1", "45.6e1");
        ElementJacksonTest.assertPropertyString("true", Boolean.TRUE);
        ElementJacksonTest.assertPropertyString("false", Boolean.FALSE);
        ElementJacksonTest.assertPropertyString(String.valueOf(1.43534123423243E34), 1.43534123423243E34);
        ElementJacksonTest.assertPropertyString("42", 42.0);
        ElementJacksonTest.assertPropertyString(null, JacksonUtils.nullNode());
        ElementJacksonTest.assertPropertyString("{}", JacksonUtils.createObjectNode());
    }

    private static void assertPropertyString(String expected, Object value) {
        Element element = ElementJacksonTest.createPropertyAssertElement(value);
        Assert.assertEquals((Object)expected, (Object)element.getProperty("property"));
    }

    @Test
    public void testPropertyBooleanConversions() {
        ElementJacksonTest.assertPropertyBoolean(true, Boolean.TRUE);
        ElementJacksonTest.assertPropertyBoolean(false, Boolean.FALSE);
        ElementJacksonTest.assertPropertyBoolean(true, "true");
        ElementJacksonTest.assertPropertyBoolean(true, "false");
        ElementJacksonTest.assertPropertyBoolean(false, "");
        ElementJacksonTest.assertPropertyBoolean(true, 1.0);
        ElementJacksonTest.assertPropertyBoolean(true, 3.14);
        ElementJacksonTest.assertPropertyBoolean(false, 0.0);
        ElementJacksonTest.assertPropertyBoolean(false, Double.NaN);
        ElementJacksonTest.assertPropertyBoolean(false, JacksonUtils.nullNode());
        ElementJacksonTest.assertPropertyBoolean(false, JacksonUtils.createNode((Object)false));
        ElementJacksonTest.assertPropertyBoolean(true, JacksonUtils.createNode((Object)true));
        ElementJacksonTest.assertPropertyBoolean(true, JacksonUtils.createObjectNode());
    }

    private static void assertPropertyBoolean(boolean expected, Object value) {
        Element element = ElementJacksonTest.createPropertyAssertElement(value);
        boolean actual = element.getProperty("property", !expected);
        if (expected) {
            Assert.assertTrue((boolean)actual);
        } else {
            Assert.assertFalse((boolean)actual);
        }
    }

    @Test
    public void testPropertyDoubleConversions() {
        ElementJacksonTest.assertPropertyDouble(1.0, 1.0);
        ElementJacksonTest.assertPropertyDouble(0.1, 0.1);
        ElementJacksonTest.assertPropertyDouble(Double.NaN, Double.NaN);
        ElementJacksonTest.assertPropertyDouble(1.0, "1");
        ElementJacksonTest.assertPropertyDouble(0.1, ".1");
        ElementJacksonTest.assertPropertyDouble(1.234E57, "12.34e56");
        ElementJacksonTest.assertPropertyDouble(Double.NaN, "foo");
        ElementJacksonTest.assertPropertyDouble(1.0, Boolean.TRUE);
        ElementJacksonTest.assertPropertyDouble(0.0, Boolean.FALSE);
        ElementJacksonTest.assertPropertyDouble(0.1, JacksonUtils.createNode((Object)0.1));
        ElementJacksonTest.assertPropertyDouble(1.0, JacksonUtils.createNode((Object)true));
        ElementJacksonTest.assertPropertyDouble(0.0, JacksonUtils.createNode((Object)false));
        ElementJacksonTest.assertPropertyDouble(0.1, JacksonUtils.createNode((Object)".1"));
        ElementJacksonTest.assertPropertyDouble(Double.NaN, JacksonUtils.createNode((Object)"foo"));
        ElementJacksonTest.assertPropertyDouble(Double.NaN, JacksonUtils.createObjectNode());
    }

    private static void assertPropertyDouble(double expected, Object value) {
        Element element = ElementJacksonTest.createPropertyAssertElement(value);
        boolean delta = false;
        double defaultValue = 1234.0;
        if (defaultValue == expected) {
            throw new IllegalArgumentException("Expecting the default value might cause unintended results");
        }
        Assert.assertEquals((double)expected, (double)element.getProperty("property", defaultValue), (double)((double)delta));
    }

    @Test
    public void testPropertyIntConversions() {
        ElementJacksonTest.assertPropertyInt(1, 1.0);
        ElementJacksonTest.assertPropertyInt(1, 1.9);
        ElementJacksonTest.assertPropertyInt(0, Double.NaN);
        ElementJacksonTest.assertPropertyInt(Integer.MAX_VALUE, 1.234E57);
        ElementJacksonTest.assertPropertyInt(1, "1");
        ElementJacksonTest.assertPropertyInt(1, "1.9");
        ElementJacksonTest.assertPropertyInt(Integer.MAX_VALUE, "12.34e56");
        ElementJacksonTest.assertPropertyInt(0, "foo");
        ElementJacksonTest.assertPropertyInt(1, Boolean.TRUE);
        ElementJacksonTest.assertPropertyInt(0, Boolean.FALSE);
        ElementJacksonTest.assertPropertyInt(1, JacksonUtils.createNode((Object)1));
        ElementJacksonTest.assertPropertyInt(1, JacksonUtils.createNode((Object)1.9));
        ElementJacksonTest.assertPropertyInt(1, JacksonUtils.createNode((Object)true));
        ElementJacksonTest.assertPropertyInt(0, JacksonUtils.createNode((Object)false));
        ElementJacksonTest.assertPropertyInt(1, JacksonUtils.createNode((Object)"1"));
        ElementJacksonTest.assertPropertyInt(0, JacksonUtils.createNode((Object)"foo"));
        ElementJacksonTest.assertPropertyInt(0, JacksonUtils.createObjectNode());
    }

    private static void assertPropertyInt(int expected, Object value) {
        Element element = ElementJacksonTest.createPropertyAssertElement(value);
        int defaultValue = 1234;
        if (defaultValue == expected) {
            throw new IllegalArgumentException("Expecting the default value might cause unintended results");
        }
        Assert.assertEquals((long)expected, (long)element.getProperty("property", defaultValue));
    }

    @Test
    public void propertyRawValues() {
        Element element = ElementFactory.createDiv();
        element.setProperty("p", "v");
        Assert.assertEquals((Object)"v", (Object)element.getPropertyRaw("p"));
        element.setProperty("p", true);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)element.getPropertyRaw("p"));
        element.setProperty("p", 3.14);
        Assert.assertEquals((Object)3.14, (Object)element.getPropertyRaw("p"));
        element.setPropertyJson("p", (BaseJsonNode)JacksonUtils.createObjectNode());
        Assert.assertEquals(ObjectNode.class, element.getPropertyRaw("p").getClass());
        element.setPropertyJson("p", (BaseJsonNode)JacksonUtils.beanToJson((Object)new SimpleBean()));
        JsonNode json = (JsonNode)element.getPropertyRaw("p");
        Assert.assertEquals((Object)"value", (Object)json.get("string").textValue());
        Assert.assertEquals((double)1.0, (double)json.get("number").doubleValue(), (double)0.0);
        Assert.assertEquals((double)2.3f, (double)json.get("flt").floatValue(), (double)0.0);
        Assert.assertEquals((double)4.56, (double)json.get("dbl").doubleValue(), (double)0.0);
        ArrayList<SimpleBean> list = new ArrayList<SimpleBean>();
        SimpleBean bean1 = new SimpleBean();
        bean1.string = "bean1";
        SimpleBean bean2 = new SimpleBean();
        bean2.string = "bean2";
        list.add(bean1);
        list.add(bean2);
        element.setPropertyJson("p", (BaseJsonNode)JacksonUtils.listToJson(list));
        ArrayNode jsonArray = (ArrayNode)element.getPropertyRaw("p");
        Assert.assertEquals((Object)"bean1", (Object)jsonArray.get(0).get("string").textValue());
        Assert.assertEquals((Object)"bean2", (Object)jsonArray.get(1).get("string").textValue());
        HashMap<String, SimpleBean> map = new HashMap<String, SimpleBean>();
        map.put("one", bean1);
        map.put("two", bean2);
        element.setPropertyJson("p", (BaseJsonNode)JacksonUtils.mapToJson(map));
        JsonNode jsonObject = (JsonNode)element.getPropertyRaw("p");
        Assert.assertEquals((Object)"bean1", (Object)jsonObject.get("one").get("string").textValue());
        Assert.assertEquals((Object)"bean2", (Object)jsonObject.get("two").get("string").textValue());
    }

    @Test
    public void addAndRemoveProperty() {
        Element element = ElementFactory.createDiv();
        Assert.assertFalse((boolean)element.hasProperty("foo"));
        element.removeProperty("foo");
        Assert.assertFalse((boolean)element.hasProperty("foo"));
        element.setProperty("foo", "bar");
        Assert.assertTrue((boolean)element.hasProperty("foo"));
        element.setProperty("foo", null);
        Assert.assertTrue((boolean)element.hasProperty("foo"));
        element.removeProperty("foo");
        Assert.assertFalse((boolean)element.hasProperty("foo"));
    }

    @Test
    public void propertyNames() {
        Element element = ElementFactory.createDiv();
        Assert.assertEquals((long)0L, (long)element.getPropertyNames().count());
        element.setProperty("foo", "bar");
        Assert.assertEquals(Collections.singleton("foo"), element.getPropertyNames().collect(Collectors.toSet()));
        element.removeProperty("foo");
        Assert.assertEquals((long)0L, (long)element.getPropertyNames().count());
    }

    @Test
    public void setProperty_javaTimeObject() {
        BeanWithTemporalFields bean = new BeanWithTemporalFields();
        Element element = ElementFactory.createDiv();
        element.setPropertyBean("bean", (Object)bean);
        ObjectNode json = (ObjectNode)element.getPropertyRaw("bean");
        Assert.assertTrue((String)"LocalTime not serialized as expected", (boolean)JacksonUtils.jsonEquals((JsonNode)JacksonUtils.createNode((Object)"10:23:55"), (JsonNode)json.get("localTime")));
        Assert.assertTrue((String)"LocalDate not serialized as expected", (boolean)JacksonUtils.jsonEquals((JsonNode)JacksonUtils.createNode((Object)"2024-06-26"), (JsonNode)json.get("localDate")));
        Assert.assertTrue((String)"LocalDateTime not serialized as expected", (boolean)JacksonUtils.jsonEquals((JsonNode)JacksonUtils.createNode((Object)"2024-06-26T10:23:55"), (JsonNode)json.get("localDateTime")));
        Assert.assertEquals((String)"ZonedDateTime not serialized as expected", (float)bean.zonedDateTime.toEpochSecond(), (float)ZonedDateTime.parse(json.get("zonedDateTime").asString()).toEpochSecond(), (float)0.0f);
        Assert.assertEquals((String)"ZonedDateTime not serialized as expected", (float)bean.sqlDate.getTime(), (float)ZonedDateTime.parse(json.get("sqlDate").asString()).toInstant().toEpochMilli(), (float)0.0f);
        Assert.assertEquals((String)"ZonedDateTime not serialized as expected", (float)bean.date.getTime(), (float)ZonedDateTime.parse(json.get("date").asString()).toInstant().toEpochMilli(), (float)0.0f);
        Assert.assertEquals((double)10.0, (double)Duration.parse(json.get("duration").asString()).toSeconds(), (double)0.0);
    }

    private static Element createPropertyAssertElement(Object value) {
        Element element = ElementFactory.createDiv();
        if (value instanceof Number && !(value instanceof Double)) {
            throw new IllegalArgumentException("Double is the only accepted numeric type");
        }
        if (value instanceof BaseJsonNode) {
            element.setPropertyJson("property", (BaseJsonNode)value);
        } else if (value instanceof Serializable) {
            BasicElementStateProvider.get().setProperty(element.getNode(), "property", (Serializable)value, true);
        } else if (value == null) {
            element.setProperty("property", null);
        } else {
            throw new IllegalArgumentException("Invalid value type: " + String.valueOf(value.getClass()));
        }
        return element;
    }

    @Test
    public void testGetTextContent() {
        Element child = new Element("child");
        child.appendChild(new Element[]{Element.createText((String)"bar")});
        Element element = ElementFactory.createDiv();
        element.appendChild(new Element[]{Element.createText((String)"foo")});
        element.appendChild(new Element[]{child});
        Assert.assertEquals((Object)"foobar", (Object)element.getTextRecursively());
    }

    @Test
    public void testSetTextContent() {
        Element element = ElementFactory.createDiv();
        element.setText("foo");
        Assert.assertEquals((Object)"foo", (Object)element.getTextRecursively());
        Assert.assertEquals((long)1L, (long)element.getChildCount());
        Assert.assertTrue((boolean)element.getChild(0).isTextNode());
    }

    @Test
    public void testSetTextContentRemovesOldContent() {
        Element child = new Element("child");
        Element element = ElementFactory.createDiv();
        element.appendChild(new Element[]{child});
        element.setText("foo");
        Assert.assertNull((Object)child.getParent());
        Assert.assertEquals((Object)"foo", (Object)element.getTextRecursively());
    }

    @Test
    public void testSetTextReplacesOldTextNode() {
        Element element = ElementFactory.createDiv();
        Element text = Element.createText((String)"foo");
        element.appendChild(new Element[]{text});
        element.setText("bar");
        Assert.assertEquals((Object)element, (Object)text.getParent());
        Assert.assertEquals((Object)"bar", (Object)text.getTextRecursively());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetTextContentPropertyThrows() {
        Element element = new Element("element");
        element.setProperty("textContent", "foo");
    }

    @Test(expected=IllegalArgumentException.class)
    public void setOuterHtmlProperty_throws() {
        Element element = new Element("element");
        element.setProperty("outerHTML", "<br>");
    }

    @Test
    public void setInnerHtmlProeprty_setValueAndRemoveAllChildren() {
        Element element = new Element("element");
        element.appendChild(new Element[]{ElementFactory.createAnchor(), ElementFactory.createDiv()});
        element.setProperty("innerHTML", "<br>");
        Assert.assertEquals((long)0L, (long)element.getChildCount());
        Assert.assertEquals((Object)"<br>", (Object)element.getProperty("innerHTML"));
    }

    @Test
    public void testGetTextContentProperty() {
        Element element = ElementFactory.createDiv();
        element.setText("foo");
        Assert.assertFalse((boolean)element.hasProperty("textContent"));
        Assert.assertNull((Object)element.getProperty("textContent"));
    }

    @Test
    public void clearTextContentRemovesChild() {
        Element element = ElementFactory.createDiv();
        element.setText("foo");
        Assert.assertEquals((long)1L, (long)element.getChildCount());
        element.setText("");
        Assert.assertEquals((long)0L, (long)element.getChildCount());
    }

    @Test
    public void newElementClasses() {
        Element element = ElementFactory.createDiv();
        Assert.assertFalse((boolean)element.hasAttribute("class"));
        Assert.assertEquals(Collections.emptySet(), (Object)element.getClassList());
    }

    @Test
    public void addElementClasses() {
        Element element = ElementFactory.createDiv();
        element.getClassList().add((Object)"foo");
        Assert.assertEquals(Collections.singleton("foo"), (Object)element.getClassList());
        Assert.assertTrue((boolean)element.hasAttribute("class"));
        Assert.assertEquals(Collections.singleton("class"), element.getAttributeNames().collect(Collectors.toSet()));
        Assert.assertTrue((boolean)element.hasAttribute("class"));
        Assert.assertEquals((Object)"foo", (Object)element.getAttribute("class"));
        element.getClassList().add((Object)"bar");
        Assert.assertEquals((Object)"foo bar", (Object)element.getAttribute("class"));
    }

    @Test
    public void testSetClassAttribute() {
        Element element = ElementFactory.createDiv();
        ClassList classList = element.getClassList();
        element.setAttribute("class", "       foo bar ");
        Assert.assertEquals((long)2L, (long)classList.size());
        Assert.assertTrue((boolean)classList.contains("foo"));
        Assert.assertTrue((boolean)classList.contains("bar"));
        Assert.assertNull((String)"class should not be stored as a regular attribute", (Object)((ElementAttributeMap)element.getNode().getFeature(ElementAttributeMap.class)).get("class"));
    }

    @Test
    public void testSetEmptyClassAttribute() {
        Element element = new Element("div");
        ClassList classList = element.getClassList();
        element.setAttribute("class", "");
        Assert.assertEquals((long)0L, (long)classList.size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddEmptyClassname() {
        Element element = new Element("div");
        ClassList classList = element.getClassList();
        classList.add("");
    }

    @Test
    public void testRemoveClassName() {
        Element element = ElementFactory.createDiv();
        element.setAttribute("class", "foo bar");
        element.getClassList().remove((Object)"foo");
        Assert.assertEquals((Object)"bar", (Object)element.getAttribute("class"));
        element.getClassList().remove((Object)"bar");
        Assert.assertNull((Object)element.getAttribute("class"));
        Assert.assertFalse((boolean)element.hasAttribute("class"));
        Assert.assertEquals((long)0L, (long)element.getAttributeNames().count());
    }

    @Test
    public void testRemoveClassAttribute() {
        Element element = ElementFactory.createDiv();
        ClassList classList = element.getClassList();
        classList.add("foo");
        element.removeAttribute("class");
        Assert.assertEquals(Collections.emptySet(), (Object)classList);
    }

    @Test
    public void addExistingClass_noop() {
        Element element = ElementFactory.createDiv();
        element.setAttribute("class", "foo");
        element.getClassList().add((Object)"foo");
        Assert.assertEquals(Collections.singleton("foo"), (Object)element.getClassList());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddClassWithSpaces_throws() {
        ElementFactory.createDiv().getClassList().add((Object)"foo bar");
    }

    @Test
    public void testRemoveClassWithSpaces() {
        ClassList cl = ElementFactory.createDiv().getClassList();
        cl.add((Object)"foo");
        cl.add((Object)"bar");
        cl.remove((Object)"foo bar");
        Assert.assertEquals((long)2L, (long)cl.size());
    }

    @Test
    public void testContainsClassWithSpaces() {
        ClassList cl = ElementFactory.createDiv().getClassList();
        cl.add((Object)"foo");
        cl.add((Object)"bar");
        Assert.assertFalse((boolean)cl.contains((Object)"foo bar"));
    }

    @Test
    public void classListSetAdd() {
        Element e = new Element("div");
        Assert.assertTrue((boolean)e.getClassList().set("foo", true));
        Assert.assertEquals((Object)"foo", (Object)e.getAttribute("class"));
        Assert.assertFalse((boolean)e.getClassList().set("foo", true));
        Assert.assertEquals((Object)"foo", (Object)e.getAttribute("class"));
    }

    @Test
    public void classListSetRemove() {
        Element e = new Element("div");
        e.setAttribute("class", "foo bar");
        Assert.assertTrue((boolean)e.getClassList().set("foo", false));
        Assert.assertEquals((Object)"bar", (Object)e.getAttribute("class"));
        Assert.assertFalse((boolean)e.getClassList().set("foo", false));
        Assert.assertEquals((Object)"bar", (Object)e.getAttribute("class"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testClassListProperty_throws() {
        ElementFactory.createDiv().setProperty("classList", "foo");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testClassNameProperty_throws() {
        ElementFactory.createDiv().setProperty("className", "foo");
    }

    @Test
    public void setStyle() {
        Element e = ElementFactory.createDiv();
        Style s = e.getStyle();
        s.set("foo", "bar");
        Assert.assertEquals((Object)"bar", (Object)s.get("foo"));
        s.set("--lumo-primary-text-color", "hsl(12, 12%, 12%)");
        Assert.assertEquals((Object)"hsl(12, 12%, 12%)", (Object)s.get("--lumo-primary-text-color"));
    }

    @Test
    public void getUnsetStyle() {
        Element e = ElementFactory.createDiv();
        Style s = e.getStyle();
        Assert.assertNull((Object)s.get("foo"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNullStyle() {
        Element e = ElementFactory.createDiv();
        Style s = e.getStyle();
        s.get(null);
    }

    @Test
    public void replaceStyle() {
        Element e = ElementFactory.createDiv();
        Style s = e.getStyle();
        s.set("foo", "bar");
        s.set("foo", "baz");
        Assert.assertEquals((Object)"baz", (Object)s.get("foo"));
    }

    @Test
    public void removeSingleStyle() {
        Element e = ElementFactory.createDiv();
        Style s = e.getStyle();
        s.set("foo", "bar");
        s.remove("foo");
        Assert.assertEquals(null, (Object)s.get("foo"));
    }

    @Test
    public void emptyStyleAsAttribute() {
        Element e = ElementFactory.createDiv();
        Assert.assertFalse((boolean)e.hasAttribute("style"));
        Assert.assertNull((Object)e.getAttribute("style"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void semicolonInStyle() {
        Element e = ElementFactory.createDiv();
        Style s = e.getStyle();
        s.set("border", "1 px solid black;");
    }

    @Test
    public void getSingleStyleAsAttribute() {
        Element e = ElementFactory.createDiv();
        Style s = e.getStyle();
        s.setBorder("1px solid black");
        Assert.assertTrue((boolean)e.hasAttribute("style"));
        Assert.assertEquals((Object)"border:1px solid black", (Object)e.getAttribute("style"));
    }

    @Test
    public void getMultipleStylesAsAttribute() {
        Element e = ElementFactory.createDiv();
        Style s = e.getStyle();
        s.set("border", "1px solid black");
        s.setMargin("1em");
        Assert.assertTrue((boolean)e.hasAttribute("style"));
        this.assertEqualsOne(new String[]{"border:1px solid black;margin:1em", "margin:1em;border:1px solid black"}, e.getAttribute("style"));
    }

    @Test
    public void setSingleStyleAsAttribute() {
        Element e = ElementFactory.createDiv();
        String style = "width:12em";
        e.setAttribute("style", style);
        Assert.assertEquals((Object)style, (Object)e.getAttribute("style"));
    }

    @Test
    public void setStyleAttributeMultipleTimes() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("style", "width:12em");
        e.setAttribute("style", "height:12em");
        Assert.assertEquals((Object)"height:12em", (Object)e.getAttribute("style"));
    }

    @Test
    public void setMultipleStylesAsAttribute() {
        Element e = ElementFactory.createDiv();
        String style = "width:12em;height:2em";
        e.setAttribute("style", style);
        Assert.assertEquals((Object)style, (Object)e.getAttribute("style"));
        Assert.assertEquals((Object)"2em", (Object)e.getStyle().get("height"));
    }

    @Test
    public void setComplexStylesAsAttribute() {
        this.testStyleAttribute("background:rgb(0,255,0) url(http://foo.bar/smiley.gif) no-repeat fixed center");
        this.testStyleAttribute("content:\"content: bar\"");
        this.testStyleAttribute("width:12px;content:\"content: bar\";height:12px");
        this.testStyleAttribute("width:calc(100% - 80px)");
        this.testStyleAttribute("width:var(--widthB)");
        this.testStyleAttribute("color:var(--mainColor)");
        this.testStyleAttribute("font-size:calc(var(--fontSize) * 2)");
        this.testStyleAttribute("--lumo-primary-text-color:hsl(12, 12%, 12%)");
        this.testStyleAttribute("background:url(\"https://example.com/images/myImg.jpg?q;param\")");
        Style style = this.testStyleAttribute("background-image:cross-fade(20% url(first.png?foo;bar&d=3), url(second.png))");
        Assert.assertEquals((Object)"cross-fade(20% url(first.png?foo;bar&d=3), url(second.png))", (Object)style.get("background-image"));
        this.testStyleAttribute("mask-image:image(url(mask.png), skyblue, linear-gradient(rgb(0 0 0 / 100%), transparent))");
        style = this.testStyleAttribute("width:var(--widthB);color:var(--mainColor);background-image:cross-fade(20% url(first.png?foo;bar&d=3), url(second.png))");
        Assert.assertEquals((Object)"var(--widthB)", (Object)style.get("width"));
        Assert.assertEquals((Object)"var(--mainColor)", (Object)style.get("color"));
        Assert.assertEquals((Object)"cross-fade(20% url(first.png?foo;bar&d=3), url(second.png))", (Object)style.get("background-image"));
    }

    private Style testStyleAttribute(String style) {
        Element e = ElementFactory.createDiv();
        e.setAttribute("style", style);
        Assert.assertEquals((Object)style, (Object)e.getAttribute("style"));
        return e.getStyle();
    }

    @Test(expected=IllegalArgumentException.class)
    public void setInvalidStyleAsAttribute() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("style", "width:");
    }

    @Test(expected=IllegalArgumentException.class)
    public void setInvalidStyleAsAttribute2() {
        Element e = ElementFactory.createDiv();
        e.setAttribute("style", "width");
    }

    @Test
    public void setVendorSpecificStylesProperty() {
        Element e = ElementFactory.createDiv();
        String style = "-moz-user-input:inherit";
        e.setAttribute("style", style);
        Assert.assertEquals((Object)"inherit", (Object)e.getStyle().get("mozUserInput"));
        Assert.assertEquals((Object)style, (Object)e.getAttribute("style"));
    }

    @Test
    public void setVendorSpecificStylesValue() {
        Element e = ElementFactory.createDiv();
        String style = "display:-moz-box";
        e.setAttribute("style", style);
        Assert.assertEquals((Object)"-moz-box", (Object)e.getStyle().get("display"));
        Assert.assertEquals((Object)style, (Object)e.getAttribute("style"));
    }

    @Test
    public void setStyleAttributeTrailingSemicolon() {
        Element e = ElementFactory.createDiv();
        String style = "width:12em";
        e.setAttribute("style", style + ";");
        Assert.assertEquals((Object)style, (Object)e.getAttribute("style"));
    }

    private void assertEqualsOne(String[] expected, String actual) {
        for (String string : expected) {
            if (!string.equals(actual)) continue;
            return;
        }
        String expectedString = Arrays.stream(expected).collect(Collectors.joining("> or <"));
        Assert.fail((String)("expected: <" + expectedString + "> but was <" + actual + ">"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void setEmptyStyleName() {
        Element e = ElementFactory.createDiv();
        e.getStyle().set("", "foo");
    }

    @Test(expected=IllegalArgumentException.class)
    public void setStyleNameExtraWhitespace() {
        Element e = ElementFactory.createDiv();
        e.getStyle().set("   color", "red");
    }

    @Test(expected=IllegalArgumentException.class)
    public void setStyleNameColon() {
        Element e = ElementFactory.createDiv();
        e.getStyle().set("color:", "red");
    }

    @Test
    public void setStyleValueExtraWhitespace() {
        Element e = ElementFactory.createDiv();
        e.getStyle().setColor("red   ");
        Assert.assertEquals((Object)"color:red", (Object)e.getAttribute("style"));
        Assert.assertEquals((Object)"red", (Object)e.getStyle().get("color"));
    }

    @Test
    public void removeStyles() {
        Element element = ElementFactory.createDiv();
        element.getStyle().setZIndex(Integer.valueOf(12));
        element.getStyle().set("background", "blue");
        element.getStyle().remove("background");
        Assert.assertEquals((Object)"z-index:12", (Object)element.getAttribute("style"));
        element.getStyle().setZIndex(null);
        Assert.assertNull((Object)element.getAttribute("style"));
        Assert.assertFalse((boolean)element.hasAttribute("style"));
        Assert.assertEquals((long)0L, (long)element.getStyle().getNames().count());
    }

    @Test
    public void removeStyleAttribute() {
        Element element = ElementFactory.createDiv();
        Style style = element.getStyle();
        style.setBorder("1px solid green");
        element.removeAttribute("style");
        Assert.assertEquals((long)0L, (long)style.getNames().count());
    }

    @Test
    public void validStyleWithSemicolon() {
        Element element = ElementFactory.createDiv();
        String validStyle = "background: url('foo;bar')";
        Style style = element.getStyle();
        style.setBackground(validStyle);
        Assert.assertEquals((Object)validStyle, (Object)style.get("background"));
    }

    @Test
    public void dashSeparatedSetStyle() {
        Element element = ElementFactory.createDiv();
        Style style = element.getStyle();
        style.set("border-color", "blue");
        Assert.assertEquals((Object)"blue", (Object)style.get("border-color"));
    }

    @Test
    public void dashSeparatedGetStyle() {
        Element element = ElementFactory.createDiv();
        Style style = element.getStyle();
        style.set("borderColor", "blue");
        style.set("border-foo", "bar");
        Assert.assertEquals((Object)"blue", (Object)style.get("border-color"));
        Assert.assertEquals((Object)"bar", (Object)style.get("border-foo"));
    }

    @Test
    public void dashSeparatedHasStyle() {
        Element element = ElementFactory.createDiv();
        Style style = element.getStyle();
        style.set("borderColor", "blue");
        style.set("border-foo", "bar");
        Assert.assertTrue((boolean)style.has("border-color"));
        Assert.assertTrue((boolean)style.has("border-foo"));
    }

    @Test
    public void dashSeparatedRemoveStyle() {
        Element element = ElementFactory.createDiv();
        Style style = element.getStyle();
        style.set("borderColor", "blue");
        style.set("border-foo", "bar");
        style.remove("border-color");
        style.remove("border-foo");
        Assert.assertFalse((boolean)style.has("border-color"));
        Assert.assertFalse((boolean)style.has("border-foo"));
    }

    @Test
    public void styleGetNamesDashAndCamelCase() {
        Element element = ElementFactory.createDiv();
        Style style = element.getStyle();
        style.set("borderColor", "blue");
        style.set("border-foo", "bar");
        List styles = style.getNames().collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)styles.size());
        Assert.assertTrue((boolean)styles.contains("border-color"));
        Assert.assertTrue((boolean)styles.contains("border-foo"));
    }

    @Test
    public void nullStyleValue() {
        Element element = ElementFactory.createDiv();
        Style style = element.getStyle();
        style.set("borderColor", "blue");
        style.set("borderColor", null);
        List styles = style.getNames().collect(Collectors.toList());
        Assert.assertFalse((boolean)styles.contains("borderColor"));
    }

    @Test
    public void sendPropertyInCorrectFormatToClient() {
        this.assertClientStyleKey("--some-variable", "--some-variable");
        this.assertClientStyleKey("-webkit-border", "-webkit-border");
        this.assertClientStyleKey("background-color", "background-color");
        this.assertClientStyleKey("color", "color");
        this.assertClientStyleKey("-webkit-border", "webkitBorder");
        this.assertClientStyleKey("background-color", "backgroundColor");
    }

    private void assertClientStyleKey(String sentToClient, String setUsingStyleApi) {
        Element element = ElementFactory.createDiv();
        StateNode stateNode = element.getNode();
        ElementStylePropertyMap map = (ElementStylePropertyMap)stateNode.getFeature(ElementStylePropertyMap.class);
        Style style = element.getStyle();
        style.set(setUsingStyleApi, "foo");
        Assert.assertEquals((Object)"foo", (Object)style.get(setUsingStyleApi));
        Assert.assertEquals((Object)sentToClient, (Object)map.getPropertyNames().toArray()[0]);
        Assert.assertEquals((Object)"foo", (Object)map.getProperty(sentToClient));
    }

    @Test
    public void customPropertyStyle() {
        Element element = ElementFactory.createDiv();
        Style style = element.getStyle();
        style.set("--some-variable", "foo");
        Assert.assertEquals((Object)"foo", (Object)style.get("--some-variable"));
    }

    @Test
    public void useCustomPropertyStyle() {
        Element element = ElementFactory.createDiv();
        Style style = element.getStyle();
        style.setColor("var(--some-var)");
        Assert.assertEquals((Object)"var(--some-var)", (Object)style.get("color"));
    }

    @Test(expected=IllegalStateException.class)
    public void addAsOwnChild() {
        Element element = ElementFactory.createDiv();
        element.appendChild(new Element[]{element});
    }

    @Test(expected=IllegalStateException.class)
    public void addAsChildOfChild() {
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        child.appendChild(new Element[]{parent});
    }

    @Override
    protected void checkIsNotChild(Node<?> parent, Element child) {
        Assert.assertNotEquals((Object)child.getParent(), parent);
        super.checkIsNotChild(parent, child);
    }

    @Test
    public void testGetOwnTextContent() {
        Element element = ElementFactory.createDiv();
        element.setText("foo");
        element.appendChild(new Element[]{(Element)ElementFactory.createDiv().appendChild(new Element[]{ElementFactory.createSpan((String)"span contents")})});
        element.appendChild(new Element[]{ElementFactory.createStrong((String)"strong contents")});
        element.appendChild(new Element[]{Element.createText((String)"Another text node")});
        Assert.assertEquals((Object)"fooAnother text node", (Object)element.getText());
        Assert.assertEquals((Object)"foospan contentsstrong contentsAnother text node", (Object)element.getTextRecursively());
    }

    @Test
    public void setResourceAttribute_elementIsNotAttached_elementHasAttribute() {
        UI.setCurrent((UI)this.createUI());
        Element element = ElementFactory.createDiv();
        String resName = "resource";
        StreamResource resource = this.createEmptyResource(resName);
        element.setAttribute("foo", (AbstractStreamResource)resource);
        Assert.assertTrue((boolean)element.hasAttribute("foo"));
        Assert.assertTrue((boolean)element.getAttribute("foo").endsWith(resName));
    }

    @Test
    public void setResourceAttribute_elementIsNotAttachedAndHasAttribute_elementHasAttribute() {
        UI.setCurrent((UI)this.createUI());
        Element element = ElementFactory.createDiv();
        element.setAttribute("foo", "bar");
        String resName = "resource";
        StreamResource resource = this.createEmptyResource(resName);
        element.setAttribute("foo", (AbstractStreamResource)resource);
        Assert.assertTrue((boolean)element.hasAttribute("foo"));
        Assert.assertTrue((boolean)element.getAttribute("foo").endsWith(resName));
    }

    @Test
    public void setResourceAttributeSeveralTimes_elementIsNotAttached_elementHasAttribute() {
        UI.setCurrent((UI)this.createUI());
        Element element = ElementFactory.createDiv();
        String resName = "resource";
        StreamResource resource = this.createEmptyResource(resName);
        element.setAttribute("foo", (AbstractStreamResource)resource);
        Assert.assertTrue((boolean)element.hasAttribute("foo"));
        resName = "resource1";
        resource = this.createEmptyResource(resName);
        element.setAttribute("foo", (AbstractStreamResource)resource);
        Assert.assertTrue((boolean)element.hasAttribute("foo"));
        Assert.assertTrue((boolean)element.getAttribute("foo").endsWith(resName));
    }

    @Test(expected=IllegalArgumentException.class)
    public void setResourceAttribute_nullValue() {
        Element element = ElementFactory.createDiv();
        element.setAttribute("foo", (AbstractStreamResource)((StreamResource)null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void setResourceAttribute_classAttribute() {
        Element element = ElementFactory.createDiv();
        element.setAttribute("class", (AbstractStreamResource)Mockito.mock(StreamResource.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void setResourceAttribute_nullAttribute() {
        Element element = ElementFactory.createDiv();
        element.setAttribute(null, (AbstractStreamResource)Mockito.mock(StreamResource.class));
    }

    @Test
    public void setResourceAttribute_elementIsAttached_elementHasAttribute() {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        String resName = "resource";
        StreamResource resource = this.createEmptyResource(resName);
        ui.getElement().setAttribute("foo", (AbstractStreamResource)resource);
        Assert.assertTrue((boolean)ui.getElement().hasAttribute("foo"));
        Assert.assertTrue((boolean)ui.getElement().getAttribute("foo").endsWith(resName));
    }

    @Test
    public void setResourceAttribute_elementIsAttached_setAnotherResource() throws URISyntaxException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource1");
        ui.getElement().setAttribute("foo", (AbstractStreamResource)resource);
        String uri = ui.getElement().getAttribute("foo");
        Optional res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, new URI(uri));
        Assert.assertTrue((boolean)res.isPresent());
        String resName = "resource2";
        ui.getElement().setAttribute("foo", (AbstractStreamResource)this.createEmptyResource(resName));
        res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, new URI(uri));
        Assert.assertFalse((boolean)res.isPresent());
        Assert.assertTrue((boolean)ui.getElement().hasAttribute("foo"));
        Assert.assertTrue((boolean)ui.getElement().getAttribute("foo").endsWith(resName));
    }

    @Test
    public void setResourceAttribute_elementIsAttached_setRawAttribute() throws URISyntaxException, InterruptedException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource");
        ui.getElement().setAttribute("foo", (AbstractStreamResource)resource);
        String uri = ui.getElement().getAttribute("foo");
        Optional res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, new URI(uri));
        Assert.assertTrue((boolean)res.isPresent());
        res = null;
        WeakReference<StreamResource> ref = new WeakReference<StreamResource>(resource);
        resource = null;
        ui.getElement().setAttribute("foo", "bar");
        TestUtil.isGarbageCollected(ref);
        res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, new URI(uri));
        Assert.assertFalse((boolean)res.isPresent());
        Assert.assertTrue((boolean)ui.getElement().hasAttribute("foo"));
        Assert.assertTrue((boolean)ui.getElement().getAttribute("foo").equals("bar"));
    }

    @Test
    public void setResourceAttribute_elementIsAttached_removeAttribute() throws URISyntaxException, InterruptedException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource");
        ui.getElement().setAttribute("foo", (AbstractStreamResource)resource);
        String uri = ui.getElement().getAttribute("foo");
        Optional res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, new URI(uri));
        Assert.assertTrue((boolean)res.isPresent());
        res = null;
        WeakReference<StreamResource> ref = new WeakReference<StreamResource>(resource);
        resource = null;
        ui.getElement().removeAttribute("foo");
        TestUtil.isGarbageCollected(ref);
        res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, new URI(uri));
        Assert.assertFalse((boolean)res.isPresent());
        Assert.assertFalse((boolean)ui.getElement().hasAttribute("foo"));
        Assert.assertNull((Object)ui.getElement().getAttribute("foo"));
    }

    @Test
    public void setResourceAttribute_attachElement_resourceIsRegistered() throws URISyntaxException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource");
        Element element = ElementFactory.createDiv();
        element.setAttribute("foo", (AbstractStreamResource)resource);
        ui.getElement().appendChild(new Element[]{element});
        Assert.assertTrue((boolean)element.hasAttribute("foo"));
        String uri = element.getAttribute("foo");
        Optional res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, new URI(uri));
        Assert.assertTrue((boolean)res.isPresent());
    }

    @Test
    public void setResourceAttribute_attachElement_setAnotherResource() throws URISyntaxException, InterruptedException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource1");
        Element element = ElementFactory.createDiv();
        element.setAttribute("foo", (AbstractStreamResource)resource);
        WeakReference<StreamResource> ref = new WeakReference<StreamResource>(resource);
        resource = null;
        String resName = "resource2";
        element.setAttribute("foo", (AbstractStreamResource)this.createEmptyResource(resName));
        ui.getElement().appendChild(new Element[]{element});
        Assert.assertTrue((boolean)element.hasAttribute("foo"));
        String uri = element.getAttribute("foo");
        Optional res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, new URI(uri));
        Assert.assertTrue((boolean)res.isPresent());
        Assert.assertTrue((boolean)uri.endsWith(resName));
        element = null;
        TestUtil.isGarbageCollected(ref);
    }

    @Test
    public void setResourceAttribute_attachElement_setRawAttribute() throws URISyntaxException, InterruptedException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource");
        Element element = ElementFactory.createDiv();
        element.setAttribute("foo", (AbstractStreamResource)resource);
        WeakReference<StreamResource> ref = new WeakReference<StreamResource>(resource);
        resource = null;
        element.setAttribute("foo", "bar");
        TestUtil.isGarbageCollected(ref);
        ui.getElement().appendChild(new Element[]{element});
        Assert.assertTrue((boolean)element.hasAttribute("foo"));
        Assert.assertEquals((Object)"bar", (Object)element.getAttribute("foo"));
    }

    @Test
    public void setResourceAttribute_attachElement_removeAttribute() throws URISyntaxException, InterruptedException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource");
        Element element = ElementFactory.createDiv();
        element.setAttribute("foo", (AbstractStreamResource)resource);
        WeakReference<StreamResource> ref = new WeakReference<StreamResource>(resource);
        resource = null;
        element.removeAttribute("foo");
        ui.getElement().appendChild(new Element[]{element});
        TestUtil.isGarbageCollected(ref);
        Assert.assertFalse((boolean)element.hasAttribute("foo"));
        Assert.assertNull((Object)element.getAttribute("foo"));
    }

    @Test
    public void setResourceAttribute_attachElement_setAnotherResourceAfterAttaching() throws URISyntaxException, InterruptedException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource1");
        Element element = ElementFactory.createDiv();
        element.setAttribute("foo", (AbstractStreamResource)resource);
        WeakReference<StreamResource> ref = new WeakReference<StreamResource>(resource);
        resource = null;
        ui.getElement().appendChild(new Element[]{element});
        String resName = "resource2";
        element.setAttribute("foo", (AbstractStreamResource)this.createEmptyResource(resName));
        Assert.assertTrue((boolean)element.hasAttribute("foo"));
        TestUtil.isGarbageCollected(ref);
        Assert.assertNull(ref.get());
        String uri = element.getAttribute("foo");
        Optional res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, new URI(uri));
        Assert.assertTrue((boolean)res.isPresent());
        Assert.assertTrue((boolean)uri.endsWith(resName));
    }

    @Test
    public void setResourceAttribute_attachElement_setRawAttributeAfterAttaching() throws URISyntaxException, InterruptedException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource");
        Element element = ElementFactory.createDiv();
        element.setAttribute("foo", (AbstractStreamResource)resource);
        WeakReference<StreamResource> ref = new WeakReference<StreamResource>(resource);
        resource = null;
        ui.getElement().appendChild(new Element[]{element});
        element.setAttribute("foo", "bar");
        TestUtil.isGarbageCollected(ref);
        Assert.assertNull(ref.get());
        Assert.assertTrue((boolean)element.hasAttribute("foo"));
        Assert.assertEquals((Object)"bar", (Object)element.getAttribute("foo"));
    }

    @Test
    public void setResourceAttribute_attachElement_removeAttributeAfterAttaching() throws URISyntaxException, InterruptedException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        StreamResource resource = this.createEmptyResource("resource");
        Element element = ElementFactory.createDiv();
        element.setAttribute("foo", (AbstractStreamResource)resource);
        WeakReference<StreamResource> ref = new WeakReference<StreamResource>(resource);
        resource = null;
        ui.getElement().appendChild(new Element[]{element});
        element.removeAttribute("foo");
        TestUtil.isGarbageCollected(ref);
        Assert.assertNull(ref.get());
        Assert.assertFalse((boolean)element.hasAttribute("foo"));
        Assert.assertNull((Object)element.getAttribute("foo"));
    }

    @Test
    public void setResourceAttribute_detachElement_resourceIsUnregistered() throws URISyntaxException, InterruptedException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        Element element = ElementFactory.createDiv();
        ui.getElement().appendChild(new Element[]{element});
        String resName = "resource";
        StreamResource resource = this.createEmptyResource(resName);
        element.setAttribute("foo", (AbstractStreamResource)resource);
        String attribute = element.getAttribute("foo");
        WeakReference<StreamResource> ref = new WeakReference<StreamResource>(resource);
        resource = null;
        URI uri = new URI(attribute);
        Optional res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, uri);
        Assert.assertTrue((boolean)res.isPresent());
        ui.getElement().removeAllChildren();
        res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, uri);
        Assert.assertFalse((boolean)res.isPresent());
        Assert.assertTrue((boolean)element.hasAttribute("foo"));
        Assert.assertNotNull((Object)element.getAttribute("foo"));
        Assert.assertTrue((boolean)element.getAttribute("foo").endsWith(resName));
        element.setAttribute("foo", "bar");
        Assert.assertTrue((boolean)element.hasAttribute("foo"));
        Assert.assertEquals((Object)"bar", (Object)element.getAttribute("foo"));
        TestUtil.isGarbageCollected(ref);
    }

    @Test
    public void setResourceAttribute_detachAndReattachElement_resourceReregistered() throws URISyntaxException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        Element element = ElementFactory.createDiv();
        ui.getElement().appendChild(new Element[]{element});
        String resName = "resource";
        StreamResource resource = this.createEmptyResource(resName);
        element.setAttribute("foo", (AbstractStreamResource)resource);
        String attribute = element.getAttribute("foo");
        URI uri = new URI(attribute);
        Optional res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, uri);
        Assert.assertTrue((boolean)res.isPresent());
        ui.getElement().removeAllChildren();
        res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, uri);
        Assert.assertFalse((boolean)res.isPresent());
        ui.getElement().appendChild(new Element[]{element});
        res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, uri);
        Assert.assertTrue((boolean)res.isPresent());
    }

    @Test
    public void setResourceAttribute_attachAndDetachAndReattachElement_resourceReregistered() throws URISyntaxException {
        UI ui = this.createUI();
        UI.setCurrent((UI)ui);
        Element element = ElementFactory.createDiv();
        String resName = "resource";
        StreamResource resource = this.createEmptyResource(resName);
        element.setAttribute("foo", (AbstractStreamResource)resource);
        String attribute = element.getAttribute("foo");
        ui.getElement().appendChild(new Element[]{element});
        URI uri = new URI(attribute);
        Optional res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, uri);
        Assert.assertTrue((boolean)res.isPresent());
        ui.getElement().removeAllChildren();
        res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, uri);
        Assert.assertFalse((boolean)res.isPresent());
        ui.getElement().appendChild(new Element[]{element});
        res = ui.getSession().getResourceRegistry().getResource(StreamResource.class, uri);
        Assert.assertTrue((boolean)res.isPresent());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void setResourceAttribute_elementIsText_operationIsNotSupported() {
        Element.createText((String)"").setAttribute("foo", (AbstractStreamResource)Mockito.mock(StreamResource.class));
    }

    @Test
    public void testAttachListener_parentAttach_childListenersTriggered() {
        Element body = new UI().getElement();
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        Element grandChild = ElementFactory.createDiv();
        AtomicInteger childTriggered = new AtomicInteger();
        AtomicInteger grandChildTriggered = new AtomicInteger();
        Registration registrationHandle = child.addAttachListener((ElementAttachListener & Serializable)event -> childTriggered.addAndGet(1));
        child.addAttachListener((ElementAttachListener & Serializable)event -> Assert.assertEquals((Object)child, (Object)event.getSource()));
        grandChild.addAttachListener((ElementAttachListener & Serializable)event -> grandChildTriggered.addAndGet(1));
        grandChild.addAttachListener((ElementAttachListener & Serializable)event -> Assert.assertEquals((Object)grandChild, (Object)event.getSource()));
        parent.appendChild(new Element[]{child});
        child.appendChild(new Element[]{grandChild});
        Assert.assertEquals((long)childTriggered.get(), (long)0L);
        Assert.assertEquals((long)grandChildTriggered.get(), (long)0L);
        body.appendChild(new Element[]{parent});
        Assert.assertEquals((long)childTriggered.get(), (long)1L);
        Assert.assertEquals((long)grandChildTriggered.get(), (long)1L);
        body.removeAllChildren();
        parent.removeAllChildren();
        body.appendChild(new Element[]{parent});
        parent.appendChild(new Element[]{child});
        Assert.assertEquals((long)childTriggered.get(), (long)2L);
        Assert.assertEquals((long)grandChildTriggered.get(), (long)2L);
        registrationHandle.remove();
        body.removeAllChildren();
        body.appendChild(new Element[]{child});
        Assert.assertEquals((long)childTriggered.get(), (long)2L);
        Assert.assertEquals((long)grandChildTriggered.get(), (long)3L);
    }

    @Test
    public void testDetachListener_parentDetach_childListenersTriggered() {
        Element body = new UI().getElement();
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        Element grandChild = ElementFactory.createDiv();
        AtomicInteger triggered = new AtomicInteger();
        Registration registrationHandle = child.addDetachListener((ElementDetachListener & Serializable)event -> {
            triggered.addAndGet(1);
            Assert.assertEquals((Object)child, (Object)event.getSource());
        });
        grandChild.addDetachListener((ElementDetachListener & Serializable)event -> {
            triggered.addAndGet(1);
            Assert.assertEquals((Object)grandChild, (Object)event.getSource());
        });
        child.appendChild(new Element[]{grandChild});
        parent.appendChild(new Element[]{child});
        body.appendChild(new Element[]{parent});
        Assert.assertEquals((long)triggered.get(), (long)0L);
        body.removeAllChildren();
        Assert.assertEquals((long)triggered.get(), (long)2L);
        body.appendChild(new Element[]{parent});
        body.removeAllChildren();
        Assert.assertEquals((long)triggered.get(), (long)4L);
        body.appendChild(new Element[]{parent});
        registrationHandle.remove();
        body.removeAllChildren();
        Assert.assertEquals((long)triggered.get(), (long)5L);
    }

    @Test
    public void testAttachListener_eventOrder_childFirst() {
        Element body = new UI().getElement();
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        AtomicBoolean parentAttached = new AtomicBoolean();
        AtomicBoolean childAttached = new AtomicBoolean();
        child.addAttachListener((ElementAttachListener & Serializable)event -> {
            childAttached.set(true);
            Assert.assertFalse((boolean)parentAttached.get());
        });
        parent.addAttachListener((ElementAttachListener & Serializable)event -> {
            parentAttached.set(true);
            Assert.assertTrue((boolean)childAttached.get());
        });
        body.appendChild(new Element[]{parent});
        Assert.assertTrue((boolean)parentAttached.get());
        Assert.assertTrue((boolean)childAttached.get());
    }

    @Test
    public void testDetachListener_eventOrder_childFirst() {
        Element body = new UI().getElement();
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        body.appendChild(new Element[]{parent});
        AtomicBoolean parentDetached = new AtomicBoolean();
        AtomicBoolean childDetached = new AtomicBoolean();
        child.addDetachListener((ElementDetachListener & Serializable)event -> {
            childDetached.set(true);
            Assert.assertFalse((boolean)parentDetached.get());
        });
        parent.addDetachListener((ElementDetachListener & Serializable)event -> {
            parentDetached.set(true);
            Assert.assertTrue((boolean)childDetached.get());
        });
        body.removeAllChildren();
        Assert.assertTrue((boolean)parentDetached.get());
        Assert.assertTrue((boolean)childDetached.get());
    }

    @Test
    public void testAttachDetach_elementMoved_bothEventsTriggered() {
        Element body = new UI().getElement();
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        body.appendChild(new Element[]{parent});
        AtomicBoolean attached = new AtomicBoolean();
        AtomicBoolean detached = new AtomicBoolean();
        child.addAttachListener((ElementAttachListener & Serializable)event -> {
            attached.set(true);
            Assert.assertTrue((boolean)detached.get());
        });
        child.addDetachListener((ElementDetachListener & Serializable)event -> {
            detached.set(true);
            Assert.assertFalse((boolean)attached.get());
        });
        body.appendChild(new Element[]{child});
        Assert.assertTrue((boolean)attached.get());
        Assert.assertTrue((boolean)detached.get());
    }

    @Test
    public void testAttachEvent_stateTreeCanFound() {
        Element body = new UI().getElement();
        Element child = ElementFactory.createDiv();
        AtomicInteger attached = new AtomicInteger();
        child.addAttachListener((ElementAttachListener & Serializable)event -> {
            Assert.assertNotNull((Object)event.getSource().getNode().getOwner());
            Assert.assertNotEquals((Object)NullOwner.get(), (Object)event.getSource().getNode().getOwner());
        });
        child.addAttachListener((ElementAttachListener & Serializable)event -> attached.incrementAndGet());
        body.appendChild(new Element[]{child});
        Assert.assertEquals((long)1L, (long)attached.get());
    }

    @Test
    public void testDetachEvent_stateTreeCanFound() {
        Element body = new UI().getElement();
        Element child = ElementFactory.createDiv();
        body.appendChild(new Element[]{child});
        AtomicInteger detached = new AtomicInteger();
        child.addDetachListener((ElementDetachListener & Serializable)event -> {
            Assert.assertNotNull((Object)event.getSource().getNode().getOwner());
            Assert.assertNotEquals((Object)NullOwner.get(), (Object)event.getSource().getNode().getOwner());
        });
        child.addDetachListener((ElementDetachListener & Serializable)event -> detached.incrementAndGet());
        body.removeAllChildren();
        Assert.assertEquals((long)1L, (long)detached.get());
    }

    @Test
    public void testMoveFromUiToUi_doesNotThrow() {
        Element body = new UI().getElement();
        Element child = ElementFactory.createDiv();
        body.appendChild(new Element[]{child});
        child.removeFromTree();
        body = new UI().getElement();
        body.appendChild(new Element[]{child});
        Assert.assertEquals((Object)body, (Object)child.getParent());
    }

    @Test
    public void testRemoveFromTree_inDetachListener_removedFromParent() {
        Element body = new UI().getElement();
        Element child = ElementFactory.createDiv();
        body.appendChild(new Element[]{child});
        child.addDetachListener((ElementDetachListener & Serializable)event -> child.removeFromTree());
        body.removeAllChildren();
        Assert.assertEquals(null, (Object)child.getParent());
    }

    @Test
    public void testRemoveFromTree_isVirtualChild_removedFromParent() {
        Element body = new UI().getElement();
        Element child = ElementFactory.createDiv();
        ((VirtualChildrenList)body.getNode().getFeature(VirtualChildrenList.class)).append(child.getNode(), "");
        Assert.assertTrue((boolean)child.isVirtualChild());
        child.removeFromTree();
        Assert.assertFalse((boolean)child.isVirtualChild());
        Assert.assertEquals((long)0L, (long)((VirtualChildrenList)body.getNode().getFeature(VirtualChildrenList.class)).size());
    }

    private StreamResource createEmptyResource(String resName) {
        return new StreamResource(resName, (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(new byte[0]));
    }

    private UI createUI() {
        final AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)new MockVaadinServletService());
        UI ui = new UI(){

            public VaadinSession getSession() {
                return session;
            }
        };
        return ui;
    }

    @Test
    public void insertAtCurrentPositionNoOp() {
        UI ui = new UI();
        Element parent = ui.getElement();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        child.addDetachListener((ElementDetachListener & Serializable)e -> Assert.fail((String)"Child should not be detached"));
        parent.insertChild(0, new Element[]{child});
    }

    @Test
    public void textNodeTransformsNullToEmptyAndDoesNotThrowException() {
        Element e = Element.createText(null);
        Assert.assertEquals((Object)"", (Object)e.getText());
    }

    @Test
    public void textNodeOuterHtml() {
        Element e = Element.createText((String)"foobar");
        Assert.assertEquals((Object)"foobar", (Object)e.getOuterHTML());
    }

    @Test
    public void singleElementOuterHtml() {
        Element e = ElementFactory.createAnchor();
        Assert.assertEquals((Object)"<a></a>", (Object)e.getOuterHTML());
    }

    @Test
    public void elementTreeOuterHtml() {
        Element div = ElementFactory.createDiv();
        Element span = ElementFactory.createSpan();
        Element button = ElementFactory.createButton((String)"hello");
        div.appendChild(new Element[]{span});
        span.appendChild(new Element[]{button});
        Assert.assertEquals((Object)"<div>\n <span>\n  <button>hello</button>\n </span>\n</div>", (Object)div.getOuterHTML());
    }

    @Test
    public void elementAttributesOuterHtml() {
        Element div = ElementFactory.createDiv();
        div.setAttribute("foo", "bar");
        div.getStyle().setWidth("20px");
        div.getClassList().add((Object)"cls");
        div.setAttribute("pin", "");
        Assert.assertEquals((Object)"<div pin foo=\"bar\" style=\"width:20px\" class=\"cls\"></div>", (Object)div.getOuterHTML());
    }

    @Test
    public void elementAttributeSpecialCharactersOuterHtml() {
        Element div = ElementFactory.createDiv();
        div.setAttribute("foo", "bar\"'&quot;");
        Assert.assertEquals((Object)"<div foo=\"bar&quot;'&amp;quot;\"></div>", (Object)div.getOuterHTML());
    }

    @Test
    public void htmlComponentOuterHtml() {
        Html html = new Html("<div style='background:green'><span><button>hello</button></span></div>");
        Assert.assertEquals((Object)"<div style=\"background:green\">\n <span>\n  <button>hello</button>\n </span>\n</div>", (Object)html.getElement().getOuterHTML());
    }

    @Test
    public void callFunctionBeforeAttach() {
        MockUI ui = new MockUI();
        Element element = ElementFactory.createDiv();
        element.callJsFunction("noArgsMethod", new Object[0]);
        ui.getElement().appendChild(new Element[]{element});
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.assertPendingJs(ui, "return $0.noArgsMethod()", element);
    }

    @Test
    public void callFunctionAfterAttach() {
        MockUI ui = new MockUI();
        Element element = ElementFactory.createDiv();
        ui.getElement().appendChild(new Element[]{element});
        element.callJsFunction("noArgsMethod", new Object[0]);
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.assertPendingJs(ui, "return $0.noArgsMethod()", element);
    }

    @Test
    public void callFunctionBeforeDetach() {
        MockUI ui = new MockUI();
        Element element = ElementFactory.createDiv();
        ui.getElement().appendChild(new Element[]{element});
        element.callJsFunction("noArgsMethod", new Object[0]);
        ui.getElement().removeAllChildren();
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        List invocations = ui.getInternals().dumpPendingJavaScriptInvocations();
        Assert.assertTrue((boolean)invocations.isEmpty());
    }

    @Test
    public void callFunctionBeforeReAttach() {
        MockUI ui = new MockUI();
        Element element = ElementFactory.createDiv();
        ui.getElement().appendChild(new Element[]{element});
        element.callJsFunction("noArgsMethod", new Object[0]);
        Element div = ElementFactory.createDiv();
        ui.getElement().appendChild(new Element[]{div});
        div.appendChild(new Element[]{element});
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.assertPendingJs(ui, "return $0.noArgsMethod()", element);
    }

    @Test
    public void callFunctionOneParam() {
        MockUI ui = new MockUI();
        Element element = ElementFactory.createDiv();
        element.callJsFunction("method", new Object[]{"foo"});
        ui.getElement().appendChild(new Element[]{element});
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.assertPendingJs(ui, "return $0.method($1)", element, "foo");
    }

    @Test
    public void callFunctionTwoParams() {
        MockUI ui = new MockUI();
        Element element = ElementFactory.createDiv();
        element.callJsFunction("method", new Object[]{"foo", 123});
        ui.getElement().appendChild(new Element[]{element});
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.assertPendingJs(ui, "return $0.method($1,$2)", element, "foo", 123);
    }

    @Test
    public void callFunctionWithBean() {
        MockUI ui = new MockUI();
        Element element = ElementFactory.createDiv();
        SimpleBean bean = new SimpleBean();
        element.callJsFunction("method", new Object[]{bean});
        ui.getElement().appendChild(new Element[]{element});
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.assertPendingJs(ui, "return $0.method($1)", element, bean);
    }

    @Test
    public void callFunctionOnProperty() {
        MockUI ui = new MockUI();
        Element element = ElementFactory.createDiv();
        element.callJsFunction("property.method", new Object[0]);
        ui.getElement().appendChild(new Element[]{element});
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.assertPendingJs(ui, "return $0.property.method()", element);
    }

    @Test
    public void callFunctionOnSubProperty() {
        MockUI ui = new MockUI();
        Element element = ElementFactory.createDiv();
        element.callJsFunction("property.other.method", new Object[0]);
        ui.getElement().appendChild(new Element[]{element});
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.assertPendingJs(ui, "return $0.property.other.method()", element);
    }

    @Test
    public void attachShadowRoot_shadowRootCreatedAndChildrenArePreserved() {
        Element element = ElementFactory.createDiv();
        Element button = ElementFactory.createButton();
        Element emphasis = ElementFactory.createEmphasis();
        element.appendChild(new Element[]{button, emphasis});
        ShadowRoot shadow = element.attachShadow();
        Assert.assertNotNull((Object)shadow);
        Assert.assertEquals((Object)element, (Object)shadow.getHost());
        Assert.assertEquals((Object)shadow, element.getShadowRoot().get());
        Assert.assertEquals((long)2L, (long)element.getChildCount());
        Assert.assertEquals((long)2L, (long)element.getChildren().count());
        Assert.assertEquals((Object)button, (Object)element.getChild(0));
        Assert.assertEquals((Object)emphasis, (Object)element.getChild(1));
    }

    @Test
    public void getShadowRoot_shadowRootIsEmpty() {
        Element element = ElementFactory.createDiv();
        Assert.assertFalse((boolean)element.getShadowRoot().isPresent());
    }

    @Test
    public void getParentNode_parentNodeIsTheSameAsParent() {
        Element element = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        element.appendChild(new Element[]{child});
        Assert.assertEquals((Object)child.getParent(), (Object)child.getParentNode());
    }

    @Test
    public void getParentNode_elementInShadowRoot_parentIsNull() {
        ShadowRoot element = ElementFactory.createDiv().attachShadow();
        Element child = ElementFactory.createDiv();
        element.appendChild(new Element[]{child});
        Assert.assertNull((Object)child.getParent());
        Assert.assertEquals((Object)element, (Object)child.getParentNode());
    }

    @Test
    public void parentIsDisabled_childIsDisabled() {
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        Assert.assertTrue((String)"Parent should be enabled", (boolean)parent.isEnabled());
        Assert.assertTrue((String)"Child should be enabled", (boolean)child.isEnabled());
        parent.setEnabled(false);
        Assert.assertFalse((String)"Parent should be disabled", (boolean)parent.isEnabled());
        Assert.assertFalse((String)"Child should be disabled", (boolean)child.isEnabled());
        child.removeFromParent();
        Assert.assertTrue((String)"Child should be enabled", (boolean)child.isEnabled());
    }

    @Test
    public void emptyElement_setDisabled_noChildFeatures() {
        Element element = ElementFactory.createDiv();
        element.setEnabled(false);
        BasicElementStateProviderTest.assertNoChildFeatures(element);
    }

    @Test
    public void emptyElement_isVirtualChild_noChildFeatures() {
        Element element = ElementFactory.createDiv();
        element.isVirtualChild();
        BasicElementStateProviderTest.assertNoChildFeatures(element);
    }

    @Test
    public void elementWithoutComponent_getComponentFeature() {
        Element element = ElementFactory.createDiv();
        element.appendChild(new Element[]{ElementFactory.createDiv()});
        element.getComponent();
        Assert.assertFalse((String)"getComponent() shouldn't initialize a component mapping feature", (boolean)element.getNode().getFeatureIfInitialized(ComponentMapping.class).isPresent());
    }

    @Test
    public void readMissingProperty_noFeatureInitialized() {
        Element element = ElementFactory.createDiv();
        element.getProperty("foo");
        element.hasProperty("foo");
        element.removeProperty("foo");
        element.getPropertyNames().collect(Collectors.toList());
        Assert.assertFalse((String)"reading a property value shouldn't initialize a property map feature", (boolean)element.getNode().getFeatureIfInitialized(ElementPropertyMap.class).isPresent());
    }

    @Test
    public void readMissingAttribute_noFeatureInitialized() {
        Element element = ElementFactory.createDiv();
        element.getAttribute("foo");
        element.hasAttribute("foo");
        element.removeAttribute("foo");
        element.getAttributeNames().collect(Collectors.toList());
        Assert.assertFalse((String)"reading an attribute value shouldn't initialize an attribute map feature", (boolean)element.getNode().getFeatureIfInitialized(ElementAttributeMap.class).isPresent());
    }

    @Test
    public void virtualChildren_areIdentifiedAsSuch() {
        Element parent = ElementFactory.createDiv();
        Element child = ElementFactory.createDiv();
        Element virtualChild = ElementFactory.createDiv();
        Element grandVirtualChild = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        parent.appendVirtualChild(new Element[]{virtualChild});
        virtualChild.appendChild(new Element[]{grandVirtualChild});
        Assert.assertFalse((boolean)parent.isVirtualChild());
        Assert.assertFalse((boolean)child.isVirtualChild());
        Assert.assertTrue((boolean)virtualChild.isVirtualChild());
        Assert.assertFalse((boolean)grandVirtualChild.isVirtualChild());
    }

    @Test
    public void domPropertyListener_registersListenerAndDomTrigger() {
        Element element = ElementFactory.createDiv();
        AtomicReference listenerValue = new AtomicReference();
        element.addPropertyChangeListener("property", "event", (PropertyChangeListener & Serializable)event -> {
            if (listenerValue.getAndSet(event.getValue()) != null) {
                Assert.fail((String)"Unexpected event");
            }
        });
        Assert.assertEquals((String)"The property should be synchronized", (Object)DisabledUpdateMode.ONLY_WHEN_ENABLED, (Object)((ElementListenerMap)element.getNode().getFeature(ElementListenerMap.class)).getPropertySynchronizationMode("property"));
        ElementListenerMap listenerMap = (ElementListenerMap)element.getNode().getFeature(ElementListenerMap.class);
        Assert.assertEquals((String)"A DOM event synchronization should be defined", Collections.singleton("}property"), ElementListenersTest.getExpressions(listenerMap, "event"));
        element.setProperty("property", "value");
        Assert.assertEquals((String)"Listener shold be registered", listenerValue.get(), (Object)"value");
    }

    @Test
    public void domPropertyListener_unregisterCleansEverything() {
        Element element = ElementFactory.createDiv();
        DomListenerRegistration registration = element.addPropertyChangeListener("property", "event", (PropertyChangeListener & Serializable)event -> Assert.fail((String)"Unexpected event"));
        registration.remove();
        Assert.assertNull((String)"The property should not be synchronized", (Object)((ElementListenerMap)element.getNode().getFeature(ElementListenerMap.class)).getPropertySynchronizationMode("property"));
        ElementListenerMap listenerMap = (ElementListenerMap)element.getNode().getFeature(ElementListenerMap.class);
        Assert.assertEquals((String)"There should be no DOM listener", Collections.emptySet(), ElementListenersTest.getExpressions(listenerMap, "event"));
        element.setProperty("property", "value");
    }

    @Test
    public void removingVirtualChildrenIsPossible() {
        Element parent = new Element("root");
        Element child1 = new Element("main");
        Element child2 = new Element("menu");
        parent.appendVirtualChild(new Element[]{child1, child2});
        parent.removeVirtualChild(new Element[]{child2, child1});
        Assert.assertNull((Object)child1.getParent());
        Assert.assertFalse((boolean)child1.isVirtualChild());
        Assert.assertNull((Object)child2.getParent());
        Assert.assertFalse((boolean)child2.isVirtualChild());
    }

    @Test(expected=IllegalArgumentException.class)
    public void removeVirtualChildren_notVirtualChild_fails() {
        Element parent = new Element("root");
        Element child1 = new Element("main");
        parent.appendChild(new Element[]{child1});
        parent.removeVirtualChild(new Element[]{child1});
    }

    @Test(expected=IllegalArgumentException.class)
    public void removeFromParent_virtualChild_fails() {
        Element parent = new Element("root");
        Element child1 = new Element("main");
        parent.appendVirtualChild(new Element[]{child1});
        child1.removeFromParent();
    }

    @Test
    public void executeJavaScript_delegatesToExecJs() {
        final AtomicReference invokedExpression = new AtomicReference();
        final AtomicReference invokedParams = new AtomicReference();
        Element element = new Element("div"){

            public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
                String oldExpression = invokedExpression.getAndSet(expression);
                Assert.assertNull((String)"There should be no old expression", (Object)oldExpression);
                Object[] oldParams = invokedParams.getAndSet(parameters);
                Assert.assertNull((String)"There should be no old params", (Object)oldParams);
                return null;
            }
        };
        element.executeJs("foo", new Object[]{1, true});
        Assert.assertEquals((Object)"foo", invokedExpression.get());
        Assert.assertEquals((Object)1, (Object)((Object[])invokedParams.get())[0]);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)((Object[])invokedParams.get())[1]);
    }

    @Test
    public void callFunction_delegatesToCallJsFunction() {
        final AtomicReference invokedFuction = new AtomicReference();
        final AtomicReference invokedParams = new AtomicReference();
        Element element = new Element("div"){

            public PendingJavaScriptResult callJsFunction(String functionName, Object ... arguments) {
                String oldExpression = invokedFuction.getAndSet(functionName);
                Assert.assertNull((String)"There should be no old function name", (Object)oldExpression);
                Object[] oldParams = invokedParams.getAndSet(arguments);
                Assert.assertNull((String)"There should be no old params", (Object)oldParams);
                return null;
            }
        };
        element.callJsFunction("foo", new Object[]{1, true});
        Assert.assertEquals((Object)"foo", invokedFuction.get());
        Assert.assertEquals((Object)1, (Object)((Object[])invokedParams.get())[0]);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)((Object[])invokedParams.get())[1]);
    }

    protected Element createParentNode() {
        return ElementFactory.createDiv();
    }

    @Override
    protected void assertChild(Node<?> parent, int index, Element child) {
        Assert.assertEquals(parent, (Object)child.getParent());
        Assert.assertEquals((Object)child, (Object)parent.getChild(index));
    }

    private void assertPendingJs(UI ui, String js, Object ... arguments) {
        List pendingJs = ui.getInternals().dumpPendingJavaScriptInvocations();
        UIInternals.JavaScriptInvocation expected = new UIInternals.JavaScriptInvocation(js, arguments);
        Assert.assertEquals((long)1L, (long)pendingJs.size());
        this.assertEquals(expected, ((PendingJavaScriptInvocation)pendingJs.get(0)).getInvocation());
    }

    private void assertEquals(UIInternals.JavaScriptInvocation expected, UIInternals.JavaScriptInvocation actual) {
        Assert.assertEquals((Object)expected.getExpression(), (Object)actual.getExpression());
        Assert.assertArrayEquals((Object[])expected.getParameters().toArray(), (Object[])actual.getParameters().toArray());
    }

    private static ArrayNode createNumberArray(double ... items) {
        return (ArrayNode)DoubleStream.of(items).mapToObj(JacksonUtils::createNode).collect(JacksonUtils.asArray());
    }

    public static class SimpleBean {
        private String string = "value";
        private int number = 1;
        private float flt = 2.3f;
        private double dbl = 4.56;

        public String getString() {
            return this.string;
        }

        public int getNumber() {
            return this.number;
        }

        public float getFlt() {
            return this.flt;
        }

        public double getDbl() {
            return this.dbl;
        }
    }

    public static class BeanWithTemporalFields {
        public LocalTime localTime = LocalTime.of(10, 23, 55);
        public LocalDate localDate = LocalDate.of(2024, 6, 26);
        public LocalDateTime localDateTime = this.localDate.atTime(this.localTime);
        public Date sqlDate = Date.valueOf(this.localDate);
        public java.util.Date date = new java.util.Date(this.sqlDate.getTime());
        public ZonedDateTime zonedDateTime = ZonedDateTime.of(this.localDateTime, ZoneId.of("Europe/Rome"));
        public Duration duration = Duration.ofSeconds(10L);
    }
}

