/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.NodeOwner;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.StreamRegistration;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class ElementAttributeMap
extends NodeMap {
    private Map<String, StreamRegistration> resourceRegistrations;
    private Map<String, Registration> pendingRegistrations;

    public ElementAttributeMap(StateNode node) {
        super(node);
    }

    public void set(String attribute, String value) {
        if (this.hasSignal(attribute)) {
            throw new BindingActiveException("setAttribute is not allowed while a binding for the given attribute exists.");
        }
        this.doSet(attribute, (Serializable)((Object)value));
    }

    public void bindSignal(Element owner, String attribute, Signal<String> signal) {
        this.bindSignal(owner, attribute, signal, (element, value) -> this.doSet(attribute, (Serializable)((Object)value)), null);
    }

    public boolean has(String attribute) {
        if (this.contains(attribute)) {
            if (this.hasSignal(attribute)) {
                NodeMap.SignalBinding binding = (NodeMap.SignalBinding)super.get(attribute);
                return binding.value() != null;
            }
            return true;
        }
        return false;
    }

    @Override
    public Serializable remove(String attribute) {
        if (this.hasSignal(attribute)) {
            throw new BindingActiveException("removeAttribute is not allowed while a binding for the given attribute exists.");
        }
        this.unregisterResource(attribute);
        return super.remove(attribute);
    }

    public String get(String attribute) {
        Serializable value = super.get(attribute);
        if (value == null || value instanceof String) {
            return (String)((Object)value);
        }
        if (value instanceof JsonNode) {
            JsonNode node = (JsonNode)value;
            assert (node.has("uri"));
            return node.get("uri").asString();
        }
        assert (value instanceof NodeMap.SignalBinding);
        return (String)((Object)((NodeMap.SignalBinding)value).value());
    }

    public Stream<String> attributes() {
        return super.keySet().stream();
    }

    public void setResource(String attribute, AbstractStreamResource resource) {
        this.doSetResource(attribute, resource);
        if (this.getNode().isAttached()) {
            this.registerResource(attribute, resource);
        } else {
            this.deferRegistration(attribute, resource);
        }
    }

    private void doSetResource(String attribute, AbstractStreamResource resource) {
        URI targetUri;
        if (VaadinSession.getCurrent() != null) {
            StreamResourceRegistry resourceRegistry = VaadinSession.getCurrent().getResourceRegistry();
            targetUri = resourceRegistry.getTargetURI(resource);
        } else {
            targetUri = StreamResourceRegistry.getURI(resource);
        }
        ObjectNode object = JacksonUtils.createObjectNode();
        object.put("uri", targetUri.toASCIIString());
        this.doSet(attribute, (Serializable)object);
    }

    private void ensurePendingRegistrations() {
        if (this.pendingRegistrations == null) {
            this.pendingRegistrations = new HashMap<String, Registration>();
        }
    }

    private void ensureResourceRegistrations() {
        if (this.resourceRegistrations == null) {
            this.resourceRegistrations = new HashMap<String, StreamRegistration>();
        }
    }

    private void unregisterResource(String attribute) {
        this.ensureResourceRegistrations();
        this.ensurePendingRegistrations();
        StreamRegistration registration = this.resourceRegistrations.remove(attribute);
        Registration handle = this.pendingRegistrations.remove(attribute);
        if (handle != null) {
            handle.remove();
        }
        if (registration != null) {
            registration.unregister();
        }
        if (this.resourceRegistrations.isEmpty()) {
            this.resourceRegistrations = null;
        }
        if (this.pendingRegistrations.isEmpty()) {
            this.pendingRegistrations = null;
        }
    }

    private void deferRegistration(final String attribute, final AbstractStreamResource resource) {
        this.ensurePendingRegistrations();
        assert (!this.pendingRegistrations.containsKey(attribute));
        Registration handle = this.getNode().addAttachListener(new Command(){

            @Override
            public void execute() {
                ElementAttributeMap.this.doSetResource(attribute, resource);
                ElementAttributeMap.this.registerResource(attribute, resource);
            }
        });
        this.pendingRegistrations.put(attribute, handle);
    }

    private void registerResource(final String attribute, AbstractStreamResource resource) {
        this.ensureResourceRegistrations();
        this.ensurePendingRegistrations();
        assert (!this.resourceRegistrations.containsKey(attribute));
        StreamRegistration registration = this.getSession().getResourceRegistry().registerResource(resource);
        this.resourceRegistrations.put(attribute, registration);
        Registration handle = this.pendingRegistrations.remove(attribute);
        if (handle != null) {
            handle.remove();
        }
        this.pendingRegistrations.put(attribute, this.getNode().addDetachListener(new Command(){

            @Override
            public void execute() {
                ElementAttributeMap.this.unsetResource(attribute);
            }
        }));
    }

    private void doSet(String attribute, Serializable value) {
        this.unregisterResource(attribute);
        if (this.hasSignal(attribute)) {
            NodeMap.SignalBinding binding = (NodeMap.SignalBinding)super.get(attribute);
            this.put(attribute, new NodeMap.SignalBinding(binding.signal(), binding.registration(), (Serializable)((Object)((String)((Object)value))), null));
        } else if (value == null) {
            super.remove(attribute);
        } else {
            this.put(attribute, value);
        }
    }

    private void unsetResource(String attribute) {
        this.ensureResourceRegistrations();
        StreamRegistration registration = this.resourceRegistrations.get(attribute);
        Optional<Object> resource = Optional.empty();
        if (registration != null) {
            resource = Optional.ofNullable(registration.getResource());
        }
        this.unregisterResource(attribute);
        resource.ifPresent(res -> this.deferRegistration(attribute, (AbstractStreamResource)res));
    }

    private VaadinSession getSession() {
        NodeOwner owner = this.getNode().getOwner();
        assert (owner instanceof StateTree);
        return ((StateTree)owner).getUI().getSession();
    }
}

