/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.geolocation;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.geolocation.GeolocationError;
import com.vaadin.flow.component.geolocation.GeolocationOptions;
import com.vaadin.flow.component.geolocation.GeolocationPosition;
import com.vaadin.flow.component.geolocation.GeolocationState;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import java.io.Serializable;
import java.util.UUID;

public class Geolocation
implements Serializable {
    private final ValueSignal<GeolocationState> stateSignal = new ValueSignal<GeolocationState.Pending>(new GeolocationState.Pending());

    private Geolocation() {
    }

    public static void get(SerializableConsumer<GeolocationPosition> onSuccess) {
        Geolocation.get(null, onSuccess);
    }

    public static void get(GeolocationOptions options, SerializableConsumer<GeolocationPosition> onSuccess) {
        Geolocation.get(options, onSuccess, null);
    }

    public static void get(SerializableConsumer<GeolocationPosition> onSuccess, SerializableConsumer<GeolocationError> onError) {
        Geolocation.get(null, onSuccess, onError);
    }

    public static void get(GeolocationOptions options, SerializableConsumer<GeolocationPosition> onSuccess, SerializableConsumer<GeolocationError> onError) {
        UI ui = UI.getCurrent();
        ui.getElement().executeJs("return window.Vaadin.Flow.geolocation.get($0)", options).then(GetResult.class, result -> {
            if (result.position() != null) {
                onSuccess.accept(result.position());
            } else if (onError != null && result.error() != null) {
                onError.accept(result.error());
            }
        });
    }

    public static Geolocation track(Component owner) {
        return Geolocation.track(owner, null);
    }

    public static Geolocation track(Component owner, GeolocationOptions options) {
        Geolocation geo = new Geolocation();
        Element el = owner.getElement();
        DomListenerRegistration posReg = el.addEventListener("vaadin-geolocation-position", e -> geo.stateSignal.set(e.getEventDetail(GeolocationPosition.class))).addEventDetail().allowInert();
        DomListenerRegistration errReg = el.addEventListener("vaadin-geolocation-error", e -> geo.stateSignal.set(e.getEventDetail(GeolocationError.class))).addEventDetail().allowInert();
        String watchKey = UUID.randomUUID().toString();
        el.executeJs("window.Vaadin.Flow.geolocation.watch(this, $0, $1)", options, watchKey);
        owner.addDetachListener(e -> {
            e.getUI().getPage().executeJs("window.Vaadin.Flow.geolocation.clearWatch($0)", watchKey);
            posReg.remove();
            errReg.remove();
        });
        return geo;
    }

    public Signal<GeolocationState> state() {
        return this.stateSignal;
    }

    private record GetResult(GeolocationPosition position, GeolocationError error) implements Serializable
    {
    }
}

