/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.experimental;

import com.vaadin.experimental.CoreFeatureFlagProvider;
import com.vaadin.experimental.Feature;
import com.vaadin.experimental.FeatureFlagProvider;
import com.vaadin.experimental.FlowComponentsFeatureFlagProvider;
import com.vaadin.experimental.HillaFeatureFlagProvider;
import com.vaadin.experimental.UnknownFeatureException;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureFlags
implements Serializable {
    public static final String PROPERTIES_FILENAME = "vaadin-featureflags.properties";
    public static final String SYSTEM_PROPERTY_PREFIX_EXPERIMENTAL = "vaadin.experimental.";
    public static final Feature COLLABORATION_ENGINE_BACKEND = CoreFeatureFlagProvider.COLLABORATION_ENGINE_BACKEND;
    public static final Feature ACCESSIBLE_DISABLED_BUTTONS = CoreFeatureFlagProvider.ACCESSIBLE_DISABLED_BUTTONS;
    public static final Feature COMPONENT_STYLE_INJECTION = CoreFeatureFlagProvider.COMPONENT_STYLE_INJECTION;
    public static final Feature HILLA_FULLSTACK_SIGNALS = HillaFeatureFlagProvider.HILLA_FULLSTACK_SIGNALS;
    public static final Feature MASTER_DETAIL_LAYOUT_COMPONENT = FlowComponentsFeatureFlagProvider.MASTER_DETAIL_LAYOUT_COMPONENT;
    public static final Feature LAYOUT_COMPONENT_IMPROVEMENTS = FlowComponentsFeatureFlagProvider.LAYOUT_COMPONENT_IMPROVEMENTS;
    public static final Feature DEFAULT_AUTO_RESPONSIVE_FORM_LAYOUT = FlowComponentsFeatureFlagProvider.DEFAULT_AUTO_RESPONSIVE_FORM_LAYOUT;
    private List<Feature> features = new ArrayList<Feature>();
    File propertiesFolder = null;
    private final Lookup lookup;
    private ApplicationConfiguration configuration;
    private boolean isPropertiesFileChecked = false;
    private boolean isSystemPropertiesChecked = false;

    public FeatureFlags(Lookup lookup) {
        this.lookup = lookup;
        this.loadFeaturesFromProviders();
        this.loadProperties();
    }

    public static FeatureFlags get(VaadinContext context) {
        assert (context != null);
        FeatureFlagsWrapper attribute = context.getAttribute(FeatureFlagsWrapper.class, () -> {
            FeatureFlags featureFlags = new FeatureFlags(context.getAttribute(Lookup.class));
            featureFlags.configuration = ApplicationConfiguration.get(context);
            featureFlags.loadProperties();
            return new FeatureFlagsWrapper(featureFlags);
        });
        return attribute.getFeatureFlags();
    }

    public void setPropertiesLocation(File propertiesFolder) {
        this.propertiesFolder = propertiesFolder;
        this.loadProperties();
    }

    public void loadProperties() {
        URL applicationResource;
        ResourceProvider resourceProvider = this.lookup.lookup(ResourceProvider.class);
        if (resourceProvider != null && (applicationResource = resourceProvider.getApplicationResource(PROPERTIES_FILENAME)) != null) {
            this.getLogger().debug("Properties loaded from classpath.");
            try (InputStream propertiesStream = applicationResource.openStream();){
                this.loadProperties(propertiesStream);
                return;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read properties file from classpath", e);
            }
        }
        File featureFlagFile = this.getFeatureFlagFile();
        if (featureFlagFile == null || !featureFlagFile.exists()) {
            this.checkForUnsupportedSystemProperties();
            for (Feature f : this.features) {
                f.setEnabled(Boolean.getBoolean(SYSTEM_PROPERTY_PREFIX_EXPERIMENTAL + f.getId()));
            }
        } else {
            try (FileInputStream propertiesStream = new FileInputStream(featureFlagFile);){
                this.getLogger().debug("Loading properties from file '{}'", (Object)featureFlagFile);
                this.loadProperties(propertiesStream);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read properties file from filesystem", e);
            }
        }
    }

    void loadProperties(InputStream propertiesStream) {
        try {
            Properties props = new Properties();
            if (propertiesStream != null) {
                props.load(propertiesStream);
                this.checkForUnsupportedFileProperties(props);
            }
            this.checkForUnsupportedSystemProperties();
            for (Feature f : this.features) {
                String propertyValue = System.getProperty(SYSTEM_PROPERTY_PREFIX_EXPERIMENTAL + f.getId(), props.getProperty(this.getFilePropertyName(f.getId())));
                f.setEnabled(Boolean.parseBoolean(propertyValue));
            }
        }
        catch (IOException e) {
            this.getLogger().error("Unable to read feature flags", (Throwable)e);
        }
    }

    private void saveProperties() {
        File featureFlagFile = this.getFeatureFlagFile();
        if (featureFlagFile == null) {
            throw new IllegalStateException("Unable to determine feature flag file location");
        }
        StringBuilder properties = new StringBuilder();
        for (Feature feature : this.features) {
            if (!feature.isEnabled()) continue;
            properties.append("# ").append(feature.getTitle()).append("\n");
            properties.append(this.getFilePropertyName(feature.getId())).append("=true\n");
        }
        if (!featureFlagFile.getParentFile().exists()) {
            featureFlagFile.getParentFile().mkdirs();
        }
        try {
            Files.writeString(featureFlagFile.toPath(), (CharSequence)properties, new OpenOption[0]);
        }
        catch (IOException e) {
            this.getLogger().error("Unable to store feature flags", (Throwable)e);
        }
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public boolean isEnabled(Feature feature) {
        return this.getFeature(feature.getId()).orElseThrow(() -> new UnknownFeatureException(feature.getTitle())).isEnabled();
    }

    public boolean isEnabled(String featureId) {
        return this.getFeature(featureId).map(Feature::isEnabled).orElse(false);
    }

    private Optional<Feature> getFeature(String featureId) {
        return this.features.stream().filter(feature -> feature.getId().equals(featureId)).findFirst();
    }

    private String getFilePropertyName(String featureId) {
        return "com.vaadin.experimental." + featureId;
    }

    private String getSystemPropertyName(String featureId) {
        return SYSTEM_PROPERTY_PREFIX_EXPERIMENTAL + featureId;
    }

    public void setEnabled(String featureId, boolean enabled) {
        if (!this.isDevelopmentMode()) {
            throw new IllegalStateException("Feature flags can only be toggled when in development mode");
        }
        Optional<Feature> maybeFeature = this.getFeature(featureId);
        if (!maybeFeature.isPresent()) {
            throw new IllegalArgumentException("Unknown feature " + featureId);
        }
        Feature feature = maybeFeature.get();
        if (feature.isEnabled() == enabled) {
            return;
        }
        maybeFeature.get().setEnabled(enabled);
        this.saveProperties();
        this.getLogger().info("Set feature {} to {}", (Object)featureId, (Object)enabled);
    }

    private File getFeatureFlagFile() {
        if (this.propertiesFolder == null) {
            if (this.configuration == null) {
                return null;
            }
            this.propertiesFolder = this.configuration.getJavaResourceFolder();
        }
        return new File(this.propertiesFolder, PROPERTIES_FILENAME);
    }

    private boolean isDevelopmentMode() {
        return this.configuration != null && !this.configuration.isProductionMode();
    }

    public String getEnableHelperMessage(Feature feature) {
        return feature.getTitle() + " is not enabled. Enable it in the debug window or by adding " + this.getFilePropertyName(feature.getId()) + "=true to src/main/resources/vaadin-featureflags.properties";
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(FeatureFlags.class);
    }

    private void checkForUnsupportedFileProperties(Properties fileProps) {
        if (!this.isPropertiesFileChecked) {
            this.checkForUnsupportedFeatureFlags(fileProps, this::getFilePropertyName);
            this.isPropertiesFileChecked = true;
        }
    }

    private void checkForUnsupportedSystemProperties() {
        if (!this.isSystemPropertiesChecked) {
            Properties filteredSystemProps = new Properties();
            System.getProperties().entrySet().stream().filter(property -> property.getKey().toString().startsWith(SYSTEM_PROPERTY_PREFIX_EXPERIMENTAL)).forEach(property -> filteredSystemProps.put(property.getKey(), property.getValue()));
            this.checkForUnsupportedFeatureFlags(filteredSystemProps, this::getSystemPropertyName);
            this.isSystemPropertiesChecked = true;
        }
    }

    private void checkForUnsupportedFeatureFlags(Properties props, Function<String, String> propertyWithPrefix) {
        for (Object property : props.keySet()) {
            if (!this.features.stream().noneMatch(feature -> ((String)propertyWithPrefix.apply(feature.getId())).equals(property))) continue;
            this.getLogger().warn("Unsupported feature flag is present: {}", property);
        }
    }

    private void loadFeaturesFromProviders() {
        try {
            ServiceLoader<FeatureFlagProvider> loader = ServiceLoader.load(FeatureFlagProvider.class, this.getClass().getClassLoader());
            HashMap<String, String> featureIdToProvider = new HashMap<String, String>();
            for (FeatureFlagProvider provider : loader) {
                List<Feature> providerFeatures = provider.getFeatures();
                if (providerFeatures == null) continue;
                String providerName = provider.getClass().getName();
                for (Feature feature : providerFeatures) {
                    String existingProvider = (String)featureIdToProvider.get(feature.getId());
                    if (existingProvider != null) {
                        this.getLogger().warn("Feature flag conflict: Feature ID '{}' is defined by both '{}' and '{}'. Using the first definition from '{}'. Each feature flag should have a unique ID across all providers.", new Object[]{feature.getId(), existingProvider, providerName, existingProvider});
                        continue;
                    }
                    featureIdToProvider.put(feature.getId(), providerName);
                    this.features.add(new Feature(feature));
                }
            }
            if (!this.features.isEmpty()) {
                this.getLogger().debug("Loaded {} feature flags from providers", (Object)this.features.size());
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to load feature flags from providers", (Throwable)e);
        }
    }

    protected static class FeatureFlagsWrapper
    implements Serializable {
        private final FeatureFlags featureFlags;

        public FeatureFlagsWrapper(FeatureFlags featureFlags) {
            this.featureFlags = featureFlags;
        }

        public FeatureFlags getFeatureFlags() {
            return this.featureFlags;
        }
    }
}

