/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared.impl;

import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.Node;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.TestUtil;
import com.vaadin.flow.signals.function.ValueSupplier;
import com.vaadin.flow.signals.impl.TransientListener;
import com.vaadin.flow.signals.shared.SharedListSignal;
import com.vaadin.flow.signals.shared.impl.CommandResult;
import com.vaadin.flow.signals.shared.impl.CommandsAndHandlers;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import com.vaadin.flow.signals.shared.impl.SynchronousSignalTree;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.DoubleNode;
import tools.jackson.databind.node.StringNode;

public class SynchronousSignalTreeTest {
    @Test
    void constructor_false_regularSyncTree() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Assertions.assertEquals((Object)SignalTree.Type.SYNCHRONOUS, (Object)tree.type());
    }

    @Test
    void constructor_true_computedTree() {
        SynchronousSignalTree tree = new SynchronousSignalTree(true);
        Assertions.assertEquals((Object)SignalTree.Type.COMPUTED, (Object)tree.type());
    }

    @Test
    void hasLock_newInstance_notLocked() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Assertions.assertFalse((boolean)tree.hasLock());
    }

    @Test
    void getWithLock_usesTheLock() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Boolean hasLock = (Boolean)tree.getWithLock((ValueSupplier & Serializable)() -> tree.hasLock());
        Assertions.assertTrue((boolean)hasLock);
    }

    @Test
    void runWithLock_usesTheLock() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        AtomicBoolean hasLock = new AtomicBoolean();
        tree.runWithLock((SerializableRunnable & Serializable)() -> hasLock.set(tree.hasLock()));
        Assertions.assertTrue((boolean)hasLock.get());
    }

    @Test
    void wrapWithLock_usesTheLock() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        AtomicBoolean hasLock = new AtomicBoolean();
        SerializableRunnable wrapped = tree.wrapWithLock((SerializableRunnable & Serializable)() -> hasLock.set(tree.hasLock()));
        Assertions.assertFalse((boolean)hasLock.get());
        wrapped.run();
        Assertions.assertTrue((boolean)hasLock.get());
    }

    @Test
    void emptyTree_noChanges_hasEmptyRootNode() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Map nodes = tree.confirmed().nodes();
        Assertions.assertEquals((int)1, (int)nodes.size());
        Node.Data root = (Node.Data)nodes.get(Id.ZERO);
        Assertions.assertNotNull((Object)root);
        Assertions.assertNull((Object)root.value());
        Assertions.assertEquals((int)0, (int)root.listChildren().size());
        Assertions.assertEquals((int)0, (int)root.mapChildren().size());
    }

    @Test
    void commit_withoutLock_throws() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Assertions.assertThrows(AssertionError.class, () -> tree.prepareCommit(new CommandsAndHandlers()));
    }

    @Test
    void commit_acceptableCommand_changeAppliedAndPublished() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        tree.getLock().lock();
        AtomicReference result = new AtomicReference();
        SignalTree.PendingCommit commit = tree.prepareCommit(new CommandsAndHandlers(TestUtil.writeRootValueCommand(), result::set));
        Assertions.assertNull((Object)TestUtil.readConfirmedRootValue((SignalTree)tree));
        Assertions.assertNull(result.get());
        Assertions.assertTrue((boolean)commit.canCommit());
        commit.applyChanges();
        Assertions.assertNotNull((Object)TestUtil.readConfirmedRootValue((SignalTree)tree));
        Assertions.assertSame((Object)tree.confirmed(), (Object)tree.submitted());
        Assertions.assertNull(result.get());
        commit.publishChanges();
        Assertions.assertInstanceOf(CommandResult.Accept.class, result.get());
    }

    @Test
    void commit_failingCommand_cannotCommitAndErrorReported() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        tree.getLock().lock();
        AtomicReference result = new AtomicReference();
        SignalTree.PendingCommit commit = tree.prepareCommit(new CommandsAndHandlers(TestUtil.failingCommand(), result::set));
        Assertions.assertNull(result.get());
        Assertions.assertFalse((boolean)commit.canCommit());
        commit.markAsAborted();
        Assertions.assertInstanceOf(CommandResult.Reject.class, result.get());
    }

    @Test
    void commit_failingCommand_applyAndPublishTrows() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        tree.getLock().lock();
        SignalTree.PendingCommit commit = tree.prepareCommit(new CommandsAndHandlers(TestUtil.failingCommand(), (CommandsAndHandlers.CommandResultHandler & Serializable)ignore -> {}));
        Assertions.assertThrows(AssertionError.class, () -> commit.applyChanges());
        Assertions.assertThrows(AssertionError.class, () -> commit.publishChanges());
    }

    @Test
    void apply_multipleAcceptableCommands_allApplied() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        tree.getLock().lock();
        Id a = Id.random();
        AtomicReference aResult = new AtomicReference();
        Id b = Id.random();
        AtomicReference bResult = new AtomicReference();
        SignalTree.PendingCommit commit = tree.prepareCommit(new CommandsAndHandlers(List.of(new SignalCommand.SetCommand(a, Id.ZERO, (JsonNode)new DoubleNode(41.0)), new SignalCommand.IncrementCommand(b, Id.ZERO, 1.0)), Map.of(a, aResult::set, b, bResult::set)));
        commit.applyChanges();
        commit.publishChanges();
        Assertions.assertInstanceOf(CommandResult.Accept.class, aResult.get());
        Assertions.assertInstanceOf(CommandResult.Accept.class, bResult.get());
        Assertions.assertEquals((Object)new DoubleNode(42.0), (Object)TestUtil.readConfirmedRootValue((SignalTree)tree));
    }

    @Test
    void apply_secondCommandInvalidBecauseOfFirst_noneApplied() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        tree.getLock().lock();
        Id a = Id.random();
        AtomicReference aResult = new AtomicReference();
        Id b = Id.random();
        AtomicReference bResult = new AtomicReference();
        SignalTree.PendingCommit commit = tree.prepareCommit(new CommandsAndHandlers(List.of(new SignalCommand.SetCommand(a, Id.ZERO, (JsonNode)new StringNode("text")), new SignalCommand.IncrementCommand(b, Id.ZERO, 1.0)), Map.of(a, aResult::set, b, bResult::set)));
        Assertions.assertFalse((boolean)commit.canCommit());
        commit.markAsAborted();
        Assertions.assertEquals((Object)"Transaction aborted", (Object)((CommandResult.Reject)aResult.get()).reason());
        Assertions.assertEquals((Object)"Value is not numeric", (Object)((CommandResult.Reject)bResult.get()).reason());
        Assertions.assertNull((Object)TestUtil.readConfirmedRootValue((SignalTree)tree));
    }

    @Test
    void applyChange_goodCommand_applied() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        tree.commitSingleCommand(TestUtil.writeRootValueCommand());
        Assertions.assertNotNull((Object)TestUtil.readConfirmedRootValue((SignalTree)tree));
    }

    @Test
    void applyChange_badCommnad_errorReported() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        AtomicReference result = new AtomicReference();
        tree.commitSingleCommand(TestUtil.failingCommand(), result::set);
        Assertions.assertInstanceOf(CommandResult.Reject.class, result.get());
    }

    @Test
    void applyChange_multipleChanges_allApplied() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        tree.commitSingleCommand((SignalCommand)new SignalCommand.SetCommand(Id.random(), Id.ZERO, (JsonNode)new DoubleNode(41.0)));
        tree.commitSingleCommand((SignalCommand)new SignalCommand.IncrementCommand(Id.random(), Id.ZERO, 1.0));
        Assertions.assertNotNull((Object)TestUtil.readConfirmedRootValue((SignalTree)tree));
    }

    @Test
    void observe_multipleChanges_invokedOnce() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        AtomicInteger count = new AtomicInteger();
        tree.observeNextChange(Id.ZERO, (TransientListener & Serializable)immediate -> {
            count.incrementAndGet();
            return false;
        });
        tree.commitSingleCommand((SignalCommand)new SignalCommand.SetCommand(Id.random(), Id.ZERO, (JsonNode)new DoubleNode(2.0)));
        Assertions.assertEquals((int)1, (int)count.get());
        tree.commitSingleCommand((SignalCommand)new SignalCommand.SetCommand(Id.random(), Id.ZERO, (JsonNode)new DoubleNode(3.0)));
        Assertions.assertEquals((int)1, (int)count.get());
    }

    @Test
    void observe_observerReturnsTrue_observerPreserved() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        AtomicInteger count = new AtomicInteger();
        tree.observeNextChange(Id.ZERO, (TransientListener & Serializable)immediate -> {
            count.incrementAndGet();
            return true;
        });
        tree.commitSingleCommand((SignalCommand)new SignalCommand.SetCommand(Id.random(), Id.ZERO, (JsonNode)new DoubleNode(2.0)));
        Assertions.assertEquals((int)1, (int)count.get());
        tree.commitSingleCommand((SignalCommand)new SignalCommand.SetCommand(Id.random(), Id.ZERO, (JsonNode)new DoubleNode(3.0)));
        Assertions.assertEquals((int)2, (int)count.get());
    }

    @Test
    void observe_cancelled_notInvoked() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Registration canceler = tree.observeNextChange(Id.ZERO, (TransientListener & Serializable)immediate -> (Boolean)Assertions.fail());
        canceler.remove();
        tree.commitSingleCommand((SignalCommand)new SignalCommand.SetCommand(Id.random(), Id.ZERO, (JsonNode)new DoubleNode(2.0)));
    }

    @Test
    void observe_otherNodeChanged_notInvoked() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Id child = Id.random();
        tree.commitSingleCommand((SignalCommand)new SignalCommand.InsertCommand(child, Id.ZERO, null, null, SharedListSignal.ListPosition.first()));
        tree.observeNextChange(Id.ZERO, (TransientListener & Serializable)immediate -> (Boolean)Assertions.fail());
        tree.commitSingleCommand((SignalCommand)new SignalCommand.SetCommand(Id.random(), child, (JsonNode)new StringNode("value")));
    }

    @Test
    void observe_observeInCallback_registeredAgain() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        AtomicInteger count = new AtomicInteger();
        tree.observeNextChange(Id.ZERO, (TransientListener & Serializable)immediate -> {
            tree.observeNextChange(Id.ZERO, (TransientListener & Serializable)immediage -> {
                count.incrementAndGet();
                return false;
            });
            return false;
        });
        tree.commitSingleCommand((SignalCommand)new SignalCommand.SetCommand(Id.random(), Id.ZERO, (JsonNode)new DoubleNode(2.0)));
        Assertions.assertEquals((int)0, (int)count.get());
        tree.commitSingleCommand((SignalCommand)new SignalCommand.SetCommand(Id.random(), Id.ZERO, (JsonNode)new DoubleNode(3.0)));
        Assertions.assertEquals((int)1, (int)count.get());
    }

    @Test
    void observe_observeAnotherNodeInCallback_observerAdded() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Id childId = Id.random();
        AtomicInteger count = new AtomicInteger();
        tree.observeNextChange(Id.ZERO, (TransientListener & Serializable)immediate -> {
            tree.observeNextChange(childId, (TransientListener & Serializable)immediate2 -> {
                count.incrementAndGet();
                return false;
            });
            return false;
        });
        tree.commitSingleCommand((SignalCommand)new SignalCommand.InsertCommand(childId, Id.ZERO, null, (JsonNode)new DoubleNode(2.0), SharedListSignal.ListPosition.last()));
        Assertions.assertEquals((int)0, (int)count.get());
        tree.commitSingleCommand(TestUtil.writeRootValueCommand());
        Assertions.assertEquals((int)0, (int)count.get());
        tree.commitSingleCommand((SignalCommand)new SignalCommand.SetCommand(Id.random(), childId, (JsonNode)new DoubleNode(3.0)));
        Assertions.assertEquals((int)1, (int)count.get());
    }

    @Test
    void subscribeToProcessed_noChanges_doesNotReceive() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        AtomicReference resultContainer = new AtomicReference();
        tree.subscribeToProcessed((SignalTree.CommandSubscriber & Serializable)(event, result) -> resultContainer.set(Map.entry(event, result)));
        Assertions.assertNull(resultContainer.get());
    }

    @Test
    void subscribeToProcessed_receivesProcessed_bothAcceptedAndFailed() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        AtomicReference resultContainer = new AtomicReference();
        tree.subscribeToProcessed((SignalTree.CommandSubscriber & Serializable)(event, result) -> resultContainer.set(Map.entry(event, result)));
        Id id1 = Id.random();
        tree.commitSingleCommand((SignalCommand)new SignalCommand.SetCommand(id1, Id.ZERO, (JsonNode)new DoubleNode(2.0)));
        Assertions.assertEquals((Object)id1, (Object)((SignalCommand)((Map.Entry)resultContainer.get()).getKey()).commandId());
        Assertions.assertTrue((boolean)((CommandResult)((Map.Entry)resultContainer.get()).getValue()).accepted());
        Id id2 = Id.random();
        tree.commitSingleCommand((SignalCommand)new SignalCommand.RemoveByKeyCommand(id2, Id.ZERO, "3"));
        Assertions.assertEquals((Object)id2, (Object)((SignalCommand)((Map.Entry)resultContainer.get()).getKey()).commandId());
        Assertions.assertFalse((boolean)((CommandResult)((Map.Entry)resultContainer.get()).getValue()).accepted());
    }

    @Test
    void subscribeToProcessed_transactionCommand_receives() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        AtomicReference resultContainer = new AtomicReference();
        AtomicInteger count = new AtomicInteger();
        tree.subscribeToProcessed((SignalTree.CommandSubscriber & Serializable)(event, result) -> {
            count.incrementAndGet();
            resultContainer.set(Map.entry(event, result));
        });
        Id conditionId = Id.random();
        SignalCommand.ValueCondition conditionCommand = new SignalCommand.ValueCondition(conditionId, Id.ZERO, null);
        Id setCommandId = Id.random();
        SignalCommand.SetCommand setCommand = new SignalCommand.SetCommand(setCommandId, Id.ZERO, (JsonNode)new DoubleNode(2.0));
        Id txCommandID = Id.random();
        SignalCommand.TransactionCommand transactionCommand = new SignalCommand.TransactionCommand(txCommandID, List.of(conditionCommand, setCommand));
        tree.commitSingleCommand((SignalCommand)transactionCommand);
        Assertions.assertEquals((int)1, (int)count.get());
        Assertions.assertEquals((Object)txCommandID, (Object)((SignalCommand)((Map.Entry)resultContainer.get()).getKey()).commandId());
    }

    @Test
    void subscribeToProcessed_subscriberRemoved_doesNotReceiveAnymore() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        AtomicReference resultContainer1 = new AtomicReference();
        AtomicReference resultContainer2 = new AtomicReference();
        Registration canceler1 = tree.subscribeToProcessed((SignalTree.CommandSubscriber & Serializable)(event, result) -> resultContainer1.set(Map.entry(event, result)));
        Registration canceler2 = tree.subscribeToProcessed((SignalTree.CommandSubscriber & Serializable)(event, result) -> resultContainer2.set(Map.entry(event, result)));
        Id id1 = Id.random();
        tree.commitSingleCommand((SignalCommand)new SignalCommand.SetCommand(id1, Id.ZERO, (JsonNode)new DoubleNode(2.0)));
        Assertions.assertEquals((Object)id1, (Object)((SignalCommand)((Map.Entry)resultContainer1.get()).getKey()).commandId());
        Assertions.assertEquals((Object)id1, (Object)((SignalCommand)((Map.Entry)resultContainer2.get()).getKey()).commandId());
        canceler1.remove();
        resultContainer1.set(null);
        resultContainer2.set(null);
        tree.commitSingleCommand((SignalCommand)new SignalCommand.SetCommand(id1, Id.ZERO, (JsonNode)new DoubleNode(3.0)));
        Assertions.assertNull(resultContainer1.get());
        Assertions.assertEquals((Object)id1, (Object)((SignalCommand)((Map.Entry)resultContainer2.get()).getKey()).commandId());
        canceler2.remove();
        resultContainer2.set(null);
        tree.commitSingleCommand((SignalCommand)new SignalCommand.SetCommand(id1, Id.ZERO, (JsonNode)new DoubleNode(4.0)));
        Assertions.assertNull(resultContainer1.get());
        Assertions.assertNull(resultContainer2.get());
    }
}

