/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared.impl;

import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.Node;
import com.vaadin.flow.signals.shared.impl.MutableTreeRevision;
import com.vaadin.flow.signals.shared.impl.Snapshot;
import com.vaadin.flow.signals.shared.impl.TreeRevision;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SnapshotTest {
    @Test
    void emptyConstructor_withoutMaxNode_hasOnlyZeroNode() {
        Id id = Id.random();
        Snapshot snapshot = new Snapshot(id, false);
        Assertions.assertEquals((Object)id, (Object)snapshot.ownerId());
        Assertions.assertEquals(Set.of(Id.ZERO), snapshot.nodes().keySet());
    }

    @Test
    void emptyConstructor_withMaxNode_hasZeroAndMaxNodes() {
        Id id = Id.random();
        Snapshot snapshot = new Snapshot(id, true);
        Assertions.assertEquals((Object)id, (Object)snapshot.ownerId());
        Assertions.assertEquals(Set.of(Id.ZERO, Id.MAX), snapshot.nodes().keySet());
    }

    @Test
    void copyingConstructor_baseUpdated_snapshotFrozen() {
        MutableTreeRevision mutable = new MutableTreeRevision((TreeRevision)new Snapshot(Id.random(), false));
        Snapshot snapshot = new Snapshot(mutable);
        mutable.nodes().put(Id.random(), Node.EMPTY);
        mutable.originalInserts().put(Id.random(), null);
        Assertions.assertEquals(Set.of(Id.ZERO), snapshot.nodes().keySet());
        Assertions.assertEquals(Map.of(), (Object)snapshot.originalInserts());
    }
}

