/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared.impl;

import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.shared.impl.CommandResult;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CommandResultTest {
    @Test
    void rejectAll() {
        Map<Id, CommandResult.Reject> in = Map.of(new Id(1L), CommandResult.ok(), new Id(2L), CommandResult.fail((String)"Original"));
        Map out = CommandResult.rejectAll(in, (String)"New");
        Assertions.assertEquals(Map.of(new Id(1L), CommandResult.fail((String)"New"), new Id(2L), CommandResult.fail((String)"Original")), (Object)out);
    }

    @Test
    void conditional_true_accepted() {
        CommandResult result = CommandResult.conditional((boolean)true, (String)"ignored");
        Assertions.assertTrue((boolean)result.accepted());
    }

    @Test
    void conditional_false_rejected() {
        CommandResult result = CommandResult.conditional((boolean)false, (String)"reason");
        Assertions.assertFalse((boolean)result.accepted());
        Assertions.assertEquals((Object)"reason", (Object)((CommandResult.Reject)result).reason());
    }

    @Test
    void onlyUpdate_singleChange_changeReturned() {
        CommandResult.NodeModification modification = new CommandResult.NodeModification(null, null);
        CommandResult.Accept result = new CommandResult.Accept(Map.of(Id.random(), modification), Map.of());
        CommandResult.NodeModification update = result.onlyUpdate();
        Assertions.assertSame((Object)modification, (Object)update);
    }

    @Test
    void onlyUpdate_noChanges_throws() {
        CommandResult.Accept result = new CommandResult.Accept(Map.of(), Map.of());
        Assertions.assertThrows(AssertionError.class, () -> result.onlyUpdate());
    }

    @Test
    void onlyUpdate_multipleChanges_throws() {
        CommandResult.NodeModification modification = new CommandResult.NodeModification(null, null);
        CommandResult.Accept result = new CommandResult.Accept(Map.of(Id.random(), modification, Id.random(), modification), Map.of());
        Assertions.assertThrows(AssertionError.class, () -> result.onlyUpdate());
    }
}

