/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.server.startup.CustomElements;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CustomElementsTest {
    private CustomElements customElements;

    CustomElementsTest() {
    }

    @BeforeEach
    public void setUp() {
        this.customElements = new CustomElements();
    }

    @Test
    public void addSingleElement() {
        this.addElementsAndCheckResults(Collections.singletonList(CustomElement.class), Collections.singletonList(CustomElement.class));
    }

    @Test
    public void addDifferentElements() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.addElementsAndCheckResults(Arrays.asList(Tag2_Extend.class, Tag2_NotExtend.class), Arrays.asList(Tag2_Extend.class, Tag2_NotExtend.class)));
    }

    @Test
    public void addExtendingElements_superclassFirst() {
        this.addElementsAndCheckResults(Arrays.asList(CustomElement.class, Tag1_Extend1.class, Tag1_Extend2.class, Tag1_Extend3.class), Collections.singletonList(CustomElement.class));
    }

    @Test
    public void addExtendingElements_superclassLast() {
        this.addElementsAndCheckResults(Arrays.asList(Tag1_Extend1.class, Tag1_Extend2.class, Tag1_Extend3.class, CustomElement.class), Collections.singletonList(CustomElement.class));
    }

    @Test
    public void addTwoExtendingWithDifferentTag() {
        this.addElementsAndCheckResults(Arrays.asList(Tag1_Extend1.class, Tag2_Extend.class), Arrays.asList(Tag1_Extend1.class, Tag2_Extend.class));
    }

    private void addElementsAndCheckResults(List<Class<? extends Component>> elementsToAdd, List<Class<? extends Component>> expectedClasses) {
        elementsToAdd.forEach(element -> this.customElements.addElement(CustomElementsTest.getTag(element), element));
        MatcherAssert.assertThat((String)"Custom elements should contain only one class that we put into", (Object)this.customElements.computeTagToElementRelation(), (Matcher)CoreMatchers.is(expectedClasses.stream().collect(Collectors.toMap(CustomElementsTest::getTag, Function.identity()))));
    }

    private static String getTag(Class<?> clazz) {
        return clazz.getAnnotation(Tag.class).value();
    }

    @Tag(value="custom-element")
    private static class CustomElement
    extends Component {
        private CustomElement() {
        }
    }

    @Tag(value="custom-element")
    private static class Tag1_Extend1
    extends CustomElement {
        private Tag1_Extend1() {
        }
    }

    @Tag(value="custom-element")
    private static class Tag1_Extend2
    extends CustomElement {
        private Tag1_Extend2() {
        }
    }

    @Tag(value="custom-element")
    private static class Tag1_Extend3
    extends CustomElement {
        private Tag1_Extend3() {
        }
    }

    @Tag(value="different-element")
    private static class Tag2_Extend
    extends CustomElement {
        private Tag2_Extend() {
        }
    }

    @Tag(value="different-element")
    private static class Tag2_NotExtend
    extends CustomElement {
        private Tag2_NotExtend() {
        }
    }
}

