/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.AllowInert;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.polymertemplate.EventHandler;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.MockServletServiceSessionSetup;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.rpc.PublishedServerEventHandlerRpcHandler;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import com.vaadin.tests.util.MockUI;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

@NotThreadSafe
class PublishedServerEventHandlerRpcHandlerTest {
    private VaadinService service;
    private VaadinSession session;

    PublishedServerEventHandlerRpcHandlerTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        Assertions.assertNull((Object)System.getSecurityManager());
        MockServletServiceSessionSetup setup = new MockServletServiceSessionSetup();
        this.service = setup.getService();
        MockDeploymentConfiguration configuration = setup.getDeploymentConfiguration();
        configuration.setProductionMode(false);
        VaadinService.setCurrent((VaadinService)this.service);
        this.session = setup.getSession();
        Mockito.when((Object)this.session.hasLock()).thenReturn((Object)true);
    }

    @AfterEach
    public void tearDown() {
        this.service = null;
        VaadinService.setCurrent(null);
    }

    @Test
    public void methodIsInvoked() {
        ComponentWithCompute component = new ComponentWithCompute();
        PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"method", (ArrayNode)JacksonUtils.createArrayNode(), (int)-1);
        Assertions.assertTrue((boolean)component.isInvoked);
    }

    @Test
    public void methodIsNotInvokedWhenInert() {
        ComponentWithCompute component = new ComponentWithCompute();
        PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"method", (ArrayNode)JacksonUtils.createArrayNode(), (int)-1, (boolean)true);
        Assertions.assertFalse((boolean)component.isInvoked);
    }

    @Test
    public void methodIsInvokedWhenInertAndInertAllowed() {
        ComponentWithCompute component = new ComponentWithCompute();
        PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"methodThatCanBeCalledWhenInert", (ArrayNode)JacksonUtils.createArrayNode(), (int)-1, (boolean)true);
        Assertions.assertTrue((boolean)component.isInvoked);
    }

    @Test
    public void methodIsInvokedOnCompositeContent() {
        CompositeOfComponentWithCompute composite = new CompositeOfComponentWithCompute();
        ComponentWithCompute component = (ComponentWithCompute)composite.getContent();
        PublishedServerEventHandlerRpcHandler.invokeMethod((Component)composite, ((Object)((Object)composite)).getClass(), (String)"method", (ArrayNode)JacksonUtils.createArrayNode(), (int)-1);
        Assertions.assertTrue((boolean)component.isInvoked);
    }

    @Test
    public void methodIsInvokectOnCompositeOfComposite() {
        CompositeOfComposite composite = new CompositeOfComposite();
        ComponentWithCompute component = (ComponentWithCompute)((CompositeOfComponentWithCompute)composite.getContent()).getContent();
        PublishedServerEventHandlerRpcHandler.invokeMethod((Component)composite, ((Object)((Object)composite)).getClass(), (String)"method", (ArrayNode)JacksonUtils.createArrayNode(), (int)-1);
        Assertions.assertTrue((boolean)component.isInvoked);
    }

    @Test
    public void methodWithDecoderParameters_convertableValues_methodIsInvoked() {
        ArrayNode params = JacksonUtils.createArrayNode();
        params.add("264");
        params.add("MRS");
        DecoderParameters component = new DecoderParameters();
        UI ui = new UI();
        ui.getInternals().setSession(this.session);
        ui.add(new Component[]{component});
        PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"method", (ArrayNode)params, (int)-1);
        Assertions.assertTrue((boolean)component.isInvoked);
    }

    @Test
    public void methodWithDecoderParameters_nonConvertableValues_methodIsInvoked() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ArrayNode params = JacksonUtils.createArrayNode();
            params.add("264.1");
            params.add("MR");
            UI ui = new UI();
            ui.getInternals().setSession(this.session);
            DecoderParameters component = new DecoderParameters();
            ui.add(new Component[]{component});
            PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"method", (ArrayNode)params, (int)-1);
        });
    }

    @Test
    public void methodWithoutArgs_argsProvided() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ArrayNode args = JacksonUtils.createArrayNode();
            args.add(true);
            ComponentWithCompute component = new ComponentWithCompute();
            PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"method", (ArrayNode)args, (int)-1);
        });
    }

    @Test
    public void promiseSuccess() {
        int promiseId = 4;
        ArrayNode args = JacksonUtils.createArrayNode();
        args.add(36);
        ComponentWithCompute component = new ComponentWithCompute();
        UI ui = new UI();
        ui.getInternals().setSession(this.session);
        ui.add(new Component[]{component});
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        ui.getInternals().dumpPendingJavaScriptInvocations();
        PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"compute", (ArrayNode)args, (int)promiseId);
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        List pendingJavaScriptInvocations = ui.getInternals().dumpPendingJavaScriptInvocations();
        Assertions.assertEquals((int)1, (int)pendingJavaScriptInvocations.size());
        UIInternals.JavaScriptInvocation invocation = ((PendingJavaScriptInvocation)pendingJavaScriptInvocations.get(0)).getInvocation();
        Assertions.assertTrue((boolean)invocation.getExpression().contains("}p"), (String)"Invocation does not look like a promise callback");
        List parameters = invocation.getParameters();
        Assertions.assertEquals((int)3, (int)parameters.size(), (String)"Expected three paramters: promiseId, value, target");
        Assertions.assertEquals((Object)promiseId, parameters.get(0), (String)"Promise id should match the value passed to invokeMethod");
        Assertions.assertEquals((Object)6, parameters.get(1), (String)"Promise value should be sqrt(36) = 6");
        Assertions.assertEquals((Object)component.getElement(), parameters.get(2), (String)"Target should be the component's element");
    }

    @Test
    public void promiseFailure() {
        int promiseId = 4;
        ArrayNode args = JacksonUtils.createArrayNode();
        args.add(-36);
        ComponentWithCompute component = new ComponentWithCompute();
        UI ui = new UI();
        ui.getInternals().setSession(this.session);
        ui.add(new Component[]{component});
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        ui.getInternals().dumpPendingJavaScriptInvocations();
        try {
            PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"compute", (ArrayNode)args, (int)promiseId);
            Assertions.fail((String)"Exception should be thrown");
        }
        catch (RuntimeException e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof ArithmeticException));
        }
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        List pendingJavaScriptInvocations = ui.getInternals().dumpPendingJavaScriptInvocations();
        Assertions.assertEquals((int)1, (int)pendingJavaScriptInvocations.size());
        UIInternals.JavaScriptInvocation invocation = ((PendingJavaScriptInvocation)pendingJavaScriptInvocations.get(0)).getInvocation();
        Assertions.assertTrue((boolean)invocation.getExpression().contains("}p"), (String)"Invocation does not look like a promise callback");
        List parameters = invocation.getParameters();
        Assertions.assertEquals((int)2, (int)parameters.size(), (String)"Expected two paramters: promiseId,  target");
        Assertions.assertEquals((Object)promiseId, parameters.get(0), (String)"Promise id should match the value passed to invokeMethod");
        Assertions.assertEquals((Object)component.getElement(), parameters.get(1), (String)"Target should be the component's element");
    }

    @Test
    public void methodWithVarArg_acceptNoValues() {
        ArrayNode array = JacksonUtils.createArrayNode();
        MethodWithVarArgParameter component = new MethodWithVarArgParameter();
        PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"varArgMethod", (ArrayNode)array, (int)-1);
        Assertions.assertEquals((int)0, (int)component.varArg.length);
    }

    @Test
    public void methodWithJsonValueIsInvoked() {
        ArrayNode array = JacksonUtils.createArrayNode();
        ObjectNode json = JacksonUtils.createObjectNode();
        json.put("foo", "bar");
        array.add((JsonNode)json);
        MethodWithParameters component = new MethodWithParameters();
        MockUI ui = new MockUI();
        ui.add(new Component[]{component});
        PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"method4", (ArrayNode)array, (int)-1);
        Assertions.assertEquals((Object)component.jsonValue, (Object)json);
    }

    @Test
    public void methodWithJacksonJsonValueIsInvoked() {
        ArrayNode array = JacksonUtils.createArrayNode();
        ObjectNode json = JacksonUtils.createObjectNode();
        json.put("foo", "bar");
        array.add((JsonNode)json);
        MethodWithParameters component = new MethodWithParameters();
        MockUI ui = new MockUI();
        ui.add(new Component[]{component});
        PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"method5", (ArrayNode)array, (int)-1);
        Assertions.assertEquals((Object)component.jsonNode, (Object)json);
    }

    @Test
    public void methodWithSeveralArgsAndVarArg_acceptNoValues() {
        ArrayNode array = JacksonUtils.createArrayNode();
        ArrayNode firstArg = JacksonUtils.createArrayNode();
        firstArg.add(5.6);
        firstArg.add(78.36);
        array.add((JsonNode)firstArg);
        MethodWithParameters component = new MethodWithParameters();
        PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"method2", (ArrayNode)array, (int)-1);
        Assertions.assertArrayEquals((Object[])new Double[]{firstArg.get(0).doubleValue(), firstArg.get(1).doubleValue()}, (Object[])component.doubleArg);
        Assertions.assertNotNull((Object)component.varArg);
        Assertions.assertEquals((int)0, (int)component.varArg.length);
    }

    @Test
    public void methodWithVarArg_acceptOneValue() {
        ArrayNode array = JacksonUtils.createArrayNode();
        array.add("foo");
        MethodWithVarArgParameter component = new MethodWithVarArgParameter();
        PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"varArgMethod", (ArrayNode)array, (int)-1);
        Assertions.assertEquals((int)1, (int)component.varArg.length);
        Assertions.assertEquals((Object)"foo", (Object)component.varArg[0]);
    }

    @Test
    public void methodWithVarArg_arrayIsCorrectlyHandled() {
        ArrayNode array = JacksonUtils.createArrayNode();
        ArrayNode value = JacksonUtils.createArrayNode();
        value.add("foo");
        array.add((JsonNode)value);
        MethodWithVarArgParameter component = new MethodWithVarArgParameter();
        PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"varArgMethod", (ArrayNode)array, (int)-1);
        Assertions.assertArrayEquals((Object[])new String[]{value.get(0).asString()}, (Object[])component.varArg);
    }

    @Test
    public void nullValueShouldReturnZeroForPrimitive() {
        ArrayNode array = JacksonUtils.createArrayNode();
        array.add((JsonNode)JacksonUtils.nullNode());
        MethodWithParameters component = new MethodWithParameters();
        component.intArg = -1;
        component.booleanArg = true;
        PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"intMethod", (ArrayNode)array, (int)-1);
        Assertions.assertEquals((int)0, (int)component.intArg);
    }

    @Test
    public void noClientCallableMethodException() {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            ComponentWithNoClientCallableMethod component = new ComponentWithNoClientCallableMethod();
            PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"operation", (ArrayNode)JacksonUtils.createArrayNode(), (int)-1);
        });
    }

    @Test
    public void noMethodException() {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            ComponentWithNoClientCallableMethod component = new ComponentWithNoClientCallableMethod();
            PublishedServerEventHandlerRpcHandler.invokeMethod((Component)component, ((Object)((Object)component)).getClass(), (String)"operation1", (ArrayNode)JacksonUtils.createArrayNode(), (int)-1);
        });
    }

    @Test
    public void enabledElement_methodIsInvoked() {
        UI ui = new UI();
        ComponentWithCompute component = new ComponentWithCompute();
        ui.add(new Component[]{component});
        this.requestInvokeMethod(component);
        Assertions.assertTrue((boolean)component.isInvoked);
    }

    @Test
    public void disabledElement_ClientCallableIsNotInvoked() {
        UI ui = new UI();
        ComponentWithCompute component = new ComponentWithCompute();
        ui.add(new Component[]{component});
        component.getElement().setEnabled(false);
        this.requestInvokeMethod(component);
        Assertions.assertFalse((boolean)component.isInvoked);
    }

    @Test
    public void disabledElement_clientDelegateAllowsRPC_methodIsInvoked() {
        UI ui = new UI();
        EnabledHandler component = new EnabledHandler();
        ui.add(new Component[]{component});
        component.getElement().setEnabled(false);
        Assertions.assertFalse((boolean)component.isInvoked);
        this.requestInvokeMethod(component, "operation");
        Assertions.assertTrue((boolean)component.isInvoked);
    }

    private void requestInvokeMethod(Component component) {
        this.requestInvokeMethod(component, "method");
    }

    private void requestInvokeMethod(Component component, String method) {
        ObjectNode json = JacksonUtils.createObjectNode();
        json.put("templateEventMethodName", method);
        new PublishedServerEventHandlerRpcHandler().handleNode(component.getElement().getNode(), (JsonNode)json);
    }

    @Tag(value="a")
    public static class ComponentWithCompute
    extends Component {
        private boolean isInvoked;

        protected void intMethod(int i) {
        }

        @ClientCallable
        private void method() {
            this.isInvoked = true;
        }

        @ClientCallable
        @AllowInert
        private void methodThatCanBeCalledWhenInert() {
            this.isInvoked = true;
        }

        @ClientCallable
        private int compute(int input) {
            if (input < 0) {
                throw new ArithmeticException();
            }
            return (int)Math.sqrt(input);
        }
    }

    public static class CompositeOfComponentWithCompute
    extends Composite<ComponentWithCompute> {
    }

    public static class CompositeOfComposite
    extends Composite<CompositeOfComponentWithCompute> {
    }

    @Tag(value="div")
    public static class DecoderParameters
    extends Component {
        private boolean isInvoked;

        @ClientCallable
        private void method(Long longValue, Title title) {
            this.isInvoked = true;
        }
    }

    public static class MethodWithVarArgParameter
    extends ComponentWithCompute {
        private String[] varArg;

        @ClientCallable
        protected void varArgMethod(String ... args) {
            this.varArg = args;
        }
    }

    public static class MethodWithParameters
    extends ComponentWithCompute {
        private int intArg;
        private boolean booleanArg;
        private String strArg;
        private boolean[] arrayArg;
        private Double[] doubleArg;
        private Integer[] varArg;
        private int[][] doubleArray;
        private JsonNode jsonValue;
        private JsonNode jsonNode;

        @Override
        @ClientCallable
        protected void intMethod(@EventData(value="foo") int i) {
            this.intArg = i;
        }

        @EventHandler
        protected void booleanMethod(@EventData(value="foo") boolean value) {
            this.booleanArg = value;
        }

        @ClientCallable
        protected void method1(@EventData(value="foo") String str, @EventData(value="bar") boolean[] array) {
            this.strArg = str;
            this.arrayArg = array;
        }

        @ClientCallable
        protected void method2(@EventData(value="foo") Double[] arg1, Integer ... varArg) {
            this.doubleArg = arg1;
            this.varArg = varArg;
        }

        @ClientCallable
        protected void method3(@EventData(value="foo") int[][] array) {
            this.doubleArray = array;
        }

        @ClientCallable
        protected void method4(@EventData(value="foo") JsonNode value) {
            this.jsonValue = value;
        }

        @ClientCallable
        protected void method5(@EventData(value="foo") JsonNode value) {
            this.jsonNode = value;
        }
    }

    @Tag(value="div")
    public static class EnabledHandler
    extends Component {
        private boolean isInvoked;

        @ClientCallable(value=DisabledUpdateMode.ALWAYS)
        private void operation() {
            this.isInvoked = true;
        }
    }

    public static class ComponentWithNoClientCallableMethod
    extends ComponentWithCompute {
        public void operation() {
        }
    }

    static enum Title {
        MR,
        MRS;

    }
}

