/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.internal.JacksonCodec;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.ModelList;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.NodeFeatureRegistry;
import com.vaadin.flow.server.communication.rpc.MapSyncRpcHandler;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

class MapSyncRpcHandlerTest {
    private static final String NEW_VALUE = "newValue";
    private static final String DUMMY_EVENT = "dummy-event";
    private static final String TEST_PROPERTY = "test-property";

    MapSyncRpcHandlerTest() {
    }

    @Test
    public void testSynchronizeProperty() throws Exception {
        TestComponent c = new TestComponent();
        Element element = c.getElement();
        ElementPropertyMap.getModel((StateNode)element.getNode()).setUpdateFromClientFilter((SerializablePredicate & Serializable)name -> true);
        UI ui = new UI();
        ui.add(new Component[]{c});
        Assertions.assertFalse((boolean)element.hasProperty(TEST_PROPERTY));
        MapSyncRpcHandlerTest.sendSynchronizePropertyEvent(element, ui, TEST_PROPERTY, (Serializable)((Object)"value1"));
        Assertions.assertEquals((Object)"value1", (Object)element.getPropertyRaw(TEST_PROPERTY));
        MapSyncRpcHandlerTest.sendSynchronizePropertyEvent(element, ui, TEST_PROPERTY, (Serializable)((Object)"value2"));
        Assertions.assertEquals((Object)"value2", (Object)element.getPropertyRaw(TEST_PROPERTY));
    }

    @Test
    public void syncJSON_jsonIsForStateNodeInList_propertySetToStateNodeCopy() throws Exception {
        TestComponent component = new TestComponent();
        Element element = component.getElement();
        UI ui = new UI();
        ui.add(new Component[]{component});
        StateNode node = element.getNode();
        ElementPropertyMap propertyMap = (ElementPropertyMap)node.getFeature(ElementPropertyMap.class);
        propertyMap.setUpdateFromClientFilter((SerializablePredicate & Serializable)name -> true);
        ModelList modelList = propertyMap.resolveModelList("foo");
        StateNode item = new StateNode(new Class[]{ElementPropertyMap.class});
        modelList.add(item);
        ((ElementPropertyMap)item.getFeature(ElementPropertyMap.class)).setProperty("bar", (Serializable)((Object)"baz"));
        ObjectNode json = JacksonUtils.createObjectNode();
        json.put("nodeId", item.getId());
        MapSyncRpcHandlerTest.sendSynchronizePropertyEvent(element, ui, TEST_PROPERTY, (Serializable)json);
        Serializable testPropertyValue = propertyMap.getProperty(TEST_PROPERTY);
        Assertions.assertTrue((boolean)(testPropertyValue instanceof StateNode));
        StateNode newNode = (StateNode)testPropertyValue;
        Assertions.assertNotEquals((int)item.getId(), (int)newNode.getId());
        Assertions.assertEquals((Object)"baz", (Object)((ElementPropertyMap)newNode.getFeature(ElementPropertyMap.class)).getProperty("bar"));
    }

    @Test
    public void syncJSON_jsonIsPropertyValueOfStateNode_propertySetToNode() throws Exception {
        TestComponent component = new TestComponent();
        Element element = component.getElement();
        UI ui = new UI();
        ui.add(new Component[]{component});
        StateNode node = element.getNode();
        ElementPropertyMap propertyMap = (ElementPropertyMap)node.getFeature(ElementPropertyMap.class);
        propertyMap.setUpdateFromClientFilter((SerializablePredicate & Serializable)name -> true);
        ElementPropertyMap modelMap = propertyMap.resolveModelMap("foo");
        StateNode model = modelMap.getNode();
        modelMap.setProperty("bar", (Serializable)((Object)"baz"));
        ObjectNode json = JacksonUtils.createObjectNode();
        json.put("nodeId", model.getId());
        MapSyncRpcHandlerTest.sendSynchronizePropertyEvent(element, ui, "foo", (Serializable)json);
        Serializable testPropertyValue = propertyMap.getProperty("foo");
        Assertions.assertTrue((boolean)(testPropertyValue instanceof StateNode));
        StateNode newNode = (StateNode)testPropertyValue;
        Assertions.assertSame((Object)model, (Object)newNode);
    }

    @Test
    public void syncJSON_jsonIsNotListItemAndNotPropertyValue_propertySetToJSON() throws Exception {
        TestComponent component = new TestComponent();
        Element element = component.getElement();
        UI ui = new UI();
        ui.add(new Component[]{component});
        StateNode node = element.getNode();
        TestComponent anotherComonent = new TestComponent();
        StateNode anotherNode = anotherComonent.getElement().getNode();
        ElementPropertyMap.getModel((StateNode)node).setUpdateFromClientFilter((SerializablePredicate & Serializable)name -> true);
        ObjectNode json = JacksonUtils.createObjectNode();
        json.put("nodeId", anotherNode.getId());
        MapSyncRpcHandlerTest.sendSynchronizePropertyEvent(element, ui, "foo", (Serializable)json);
        Serializable testPropertyValue = ((ElementPropertyMap)node.getFeature(ElementPropertyMap.class)).getProperty("foo");
        Assertions.assertNotSame((Object)anotherNode, (Object)testPropertyValue);
        Assertions.assertTrue((boolean)(testPropertyValue instanceof JsonNode));
    }

    @Test
    public void disabledElement_updateDisallowed_updateIsNotDone() throws Exception {
        Element element = ElementFactory.createDiv();
        UI ui = new UI();
        ui.getElement().appendChild(new Element[]{element});
        element.setEnabled(false);
        element.addPropertyChangeListener(TEST_PROPERTY, DUMMY_EVENT, (PropertyChangeListener & Serializable)event -> {}).setDisabledUpdateMode(DisabledUpdateMode.ONLY_WHEN_ENABLED);
        MapSyncRpcHandlerTest.sendSynchronizePropertyEvent(element, ui, TEST_PROPERTY, (Serializable)((Object)NEW_VALUE));
        Assertions.assertNotEquals((Object)NEW_VALUE, (Object)element.getPropertyRaw(TEST_PROPERTY));
    }

    @Test
    public void disabledElement_updateIsAllowedBySynchronizeProperty_updateIsDone() throws Exception {
        Element element = ElementFactory.createDiv();
        UI ui = new UI();
        ui.getElement().appendChild(new Element[]{element});
        element.setEnabled(false);
        element.addPropertyChangeListener(TEST_PROPERTY, DUMMY_EVENT, (PropertyChangeListener & Serializable)event -> {}).setDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
        MapSyncRpcHandlerTest.sendSynchronizePropertyEvent(element, ui, TEST_PROPERTY, (Serializable)((Object)NEW_VALUE));
        Assertions.assertEquals((Object)NEW_VALUE, (Object)element.getPropertyRaw(TEST_PROPERTY));
    }

    @Test
    public void disabledElement_updateIsAllowedByEventListener_updateIsDone() throws Exception {
        Element element = ElementFactory.createDiv();
        UI ui = new UI();
        ui.getElement().appendChild(new Element[]{element});
        element.setEnabled(false);
        element.addEventListener(DUMMY_EVENT, (DomEventListener & Serializable)event -> {}).synchronizeProperty(TEST_PROPERTY).setDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
        MapSyncRpcHandlerTest.sendSynchronizePropertyEvent(element, ui, TEST_PROPERTY, (Serializable)((Object)NEW_VALUE));
        Assertions.assertEquals((Object)NEW_VALUE, (Object)element.getPropertyRaw(TEST_PROPERTY));
    }

    @Test
    public void implicitlyDisabledElement_updateIsAllowedBySynchronizeProperty_updateIsDone() throws Exception {
        Element element = ElementFactory.createDiv();
        UI ui = new UI();
        ui.getElement().appendChild(new Element[]{element});
        ui.setEnabled(false);
        element.addPropertyChangeListener(TEST_PROPERTY, DUMMY_EVENT, (PropertyChangeListener & Serializable)event -> {}).setDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
        MapSyncRpcHandlerTest.sendSynchronizePropertyEvent(element, ui, TEST_PROPERTY, (Serializable)((Object)NEW_VALUE));
        Assertions.assertEquals((Object)NEW_VALUE, (Object)element.getPropertyRaw(TEST_PROPERTY));
    }

    @Test
    public void implicitlyDisabledElement_updateIsAllowedByEventListener_updateIsDone() throws Exception {
        Element element = ElementFactory.createDiv();
        UI ui = new UI();
        ui.getElement().appendChild(new Element[]{element});
        ui.setEnabled(false);
        element.addEventListener(DUMMY_EVENT, (DomEventListener & Serializable)event -> {}).synchronizeProperty(TEST_PROPERTY).setDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
        MapSyncRpcHandlerTest.sendSynchronizePropertyEvent(element, ui, TEST_PROPERTY, (Serializable)((Object)NEW_VALUE));
        Assertions.assertEquals((Object)NEW_VALUE, (Object)element.getPropertyRaw(TEST_PROPERTY));
    }

    @Test
    public void noSyncPropertiesFeature_noExplicitAllow_throws() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            StateNode noSyncProperties = new StateNode(new Class[]{ElementPropertyMap.class});
            ElementPropertyMap map = (ElementPropertyMap)noSyncProperties.getFeature(ElementPropertyMap.class);
            new MapSyncRpcHandler().handleNode(noSyncProperties, MapSyncRpcHandlerTest.createSyncPropertyInvocation(noSyncProperties, TEST_PROPERTY, (Serializable)((Object)NEW_VALUE)));
            Assertions.assertEquals((Object)NEW_VALUE, (Object)map.getProperty(TEST_PROPERTY));
        });
    }

    @Test
    public void propertyIsNotExplicitlyAllowed_throwsWithElementTagInfo() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Element element = new Element("foo");
            new MapSyncRpcHandler().handleNode(element.getNode(), MapSyncRpcHandlerTest.createSyncPropertyInvocation(element.getNode(), TEST_PROPERTY, (Serializable)((Object)NEW_VALUE)));
        });
        Assertions.assertTrue((boolean)thrown.getMessage().contains("Element with tag 'foo'"));
        Assertions.assertTrue((boolean)thrown.getMessage().contains("'test-property'"));
    }

    @Test
    public void propertyIsNotExplicitlyAllowed_throwsWithComponentInfo() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            TestComponent component = new TestComponent();
            Element element = component.getElement();
            new MapSyncRpcHandler().handleNode(element.getNode(), MapSyncRpcHandlerTest.createSyncPropertyInvocation(element.getNode(), TEST_PROPERTY, (Serializable)((Object)NEW_VALUE)));
        });
        Assertions.assertTrue((boolean)thrown.getMessage().contains("Component " + TestComponent.class.getName()));
        Assertions.assertTrue((boolean)thrown.getMessage().contains("'test-property'"));
    }

    @Test
    public void propertyIsNotExplicitlyAllowed_subproperty_throwsWithComponentInfo() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            TestComponent component = new TestComponent();
            Element element = component.getElement();
            StateNode node = element.getNode();
            ElementPropertyMap propertyMap = ((ElementPropertyMap)node.getFeature(ElementPropertyMap.class)).resolveModelMap("foo.bar");
            new MapSyncRpcHandler().handleNode(propertyMap.getNode(), MapSyncRpcHandlerTest.createSyncPropertyInvocation(propertyMap.getNode(), TEST_PROPERTY, (Serializable)((Object)NEW_VALUE)));
        });
        Assertions.assertTrue((boolean)thrown.getMessage().contains("Component " + TestComponent.class.getName()));
        Assertions.assertTrue((boolean)thrown.getMessage().contains("'test-property'"));
    }

    @Test
    public void handleNode_callsElementPropertyMapDeferredUpdateFromClient() {
        final AtomicInteger deferredUpdateInvocations = new AtomicInteger();
        final AtomicReference deferredKey = new AtomicReference();
        StateNode node = new StateNode(new Class[]{ElementPropertyMap.class}){
            private ElementPropertyMap map;
            {
                super(arg0);
                this.map = new ElementPropertyMap(this){

                    public Runnable deferredUpdateFromClient(String key, Serializable value) {
                        deferredUpdateInvocations.incrementAndGet();
                        deferredKey.set(key);
                        return () -> {};
                    }
                };
            }

            public <F extends NodeFeature> F getFeature(Class<F> featureType) {
                if (featureType.equals(ElementPropertyMap.class)) {
                    return (F)((NodeFeature)featureType.cast(this.map));
                }
                return (F)super.getFeature(featureType);
            }
        };
        new MapSyncRpcHandler().handleNode(node, MapSyncRpcHandlerTest.createSyncPropertyInvocation(node, TEST_PROPERTY, (Serializable)((Object)NEW_VALUE)));
        Assertions.assertEquals((int)1, (int)deferredUpdateInvocations.get());
        Assertions.assertEquals((Object)TEST_PROPERTY, deferredKey.get());
    }

    @Test
    public void handleNode_stateNodePropertyDefaultValueNotSet_doesNotWarnForUnsetDisabledPropertyChange() {
        ElementPropertyMap map = (ElementPropertyMap)Mockito.mock(ElementPropertyMap.class);
        Mockito.when((Object)map.getProperty(ArgumentMatchers.anyString())).thenReturn(null);
        StateNode disabledNode = (StateNode)Mockito.mock(StateNode.class);
        Mockito.when((Object)disabledNode.getFeatureIfInitialized(ElementPropertyMap.class)).thenReturn(Optional.of(map));
        Mockito.when((Object)disabledNode.isEnabled()).thenReturn((Object)false);
        Logger logger = (Logger)Mockito.spy(Logger.class);
        try (MockedStatic mockedLoggerFactory = Mockito.mockStatic(LoggerFactory.class);){
            mockedLoggerFactory.when(() -> LoggerFactory.getLogger(MapSyncRpcHandler.class)).thenReturn((Object)logger);
            new MapSyncRpcHandler().handleNode(disabledNode, MapSyncRpcHandlerTest.createSyncPropertyInvocation(disabledNode, TEST_PROPERTY, (Serializable)((Object)NEW_VALUE)));
            ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)0))).warn(ArgumentMatchers.anyString(), (Object)ArgumentMatchers.anyString());
            ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).debug(ArgumentMatchers.anyString(), (Object)ArgumentMatchers.anyString());
        }
    }

    @Test
    public void handleNode_stateNodePropertyDefaultValueSet_warnsForSetDisabledPropertyChange() {
        ElementPropertyMap map = (ElementPropertyMap)Mockito.mock(ElementPropertyMap.class);
        Mockito.when((Object)map.getProperty(ArgumentMatchers.anyString())).thenReturn((Object)NEW_VALUE);
        StateNode disabledNode = (StateNode)Mockito.mock(StateNode.class);
        Mockito.when((Object)disabledNode.getFeatureIfInitialized(ElementPropertyMap.class)).thenReturn(Optional.of(map));
        Mockito.when((Object)disabledNode.isEnabled()).thenReturn((Object)false);
        Logger logger = (Logger)Mockito.spy(Logger.class);
        try (MockedStatic mockedLoggerFactory = Mockito.mockStatic(LoggerFactory.class);){
            mockedLoggerFactory.when(() -> LoggerFactory.getLogger(MapSyncRpcHandler.class)).thenReturn((Object)logger);
            new MapSyncRpcHandler().handleNode(disabledNode, MapSyncRpcHandlerTest.createSyncPropertyInvocation(disabledNode, TEST_PROPERTY, (Serializable)((Object)NEW_VALUE)));
            ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).warn(ArgumentMatchers.anyString(), (Object)ArgumentMatchers.anyString());
            ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)0))).debug(ArgumentMatchers.anyString(), (Object)ArgumentMatchers.anyString());
        }
    }

    private static void sendSynchronizePropertyEvent(Element element, UI ui, String eventType, Serializable value) throws Exception {
        new MapSyncRpcHandler().handle(ui, MapSyncRpcHandlerTest.createSyncPropertyInvocation(element, eventType, value));
    }

    private static JsonNode createSyncPropertyInvocation(Element element, String property, Serializable value) {
        return MapSyncRpcHandlerTest.createSyncPropertyInvocation(element.getNode(), property, value);
    }

    private static JsonNode createSyncPropertyInvocation(StateNode node, String property, Serializable value) {
        ObjectNode message = JacksonUtils.createObjectNode();
        message.put("node", node.getId());
        message.put("feature", NodeFeatureRegistry.getId(ElementPropertyMap.class));
        message.put("property", property);
        message.set("value", JacksonCodec.encodeWithoutTypeInfo((Object)value));
        return message;
    }

    @Tag(value="a")
    public static class TestComponent
    extends Component {
    }
}

