/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.component.webcomponent.WebComponent;
import com.vaadin.flow.component.webcomponent.WebComponentConfiguration;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.DefaultDeploymentConfiguration;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.MockInstantiator;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.WebComponentProvider;
import com.vaadin.flow.server.webcomponent.WebComponentConfigurationRegistry;
import com.vaadin.flow.shared.communication.PushMode;
import jakarta.servlet.ServletContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jcip.annotations.NotThreadSafe;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@NotThreadSafe
class WebComponentProviderTest {
    @Mock
    VaadinSession session;
    @Mock
    VaadinServletRequest request;
    @Mock
    VaadinResponse response;
    @Mock
    VaadinServletService service;
    @Mock
    VaadinServletContext context;
    @Mock
    DeploymentConfiguration configuration;
    WebComponentProvider provider;
    WebComponentConfigurationRegistry registry;

    WebComponentProviderTest() {
    }

    @BeforeEach
    public void init() {
        MockitoAnnotations.initMocks((Object)this);
        this.registry = this.setUpRegistry();
        Mockito.when((Object)this.request.getService()).thenReturn((Object)this.service);
        Mockito.when((Object)this.session.getService()).thenReturn((Object)this.service);
        Mockito.when((Object)this.service.getContext()).thenReturn((Object)this.context);
        Mockito.when((Object)((WebComponentConfigurationRegistry)this.context.getAttribute(WebComponentConfigurationRegistry.class))).then(invocationOnMock -> this.registry);
        Mockito.when((Object)((WebComponentConfigurationRegistry)this.context.getAttribute((Class)ArgumentMatchers.eq(WebComponentConfigurationRegistry.class), (Supplier)ArgumentMatchers.any()))).then(invocationOnMock -> this.registry);
        ((VaadinServletContext)Mockito.doAnswer(invocationOnMock -> {
            this.registry = (WebComponentConfigurationRegistry)invocationOnMock.getArguments()[0];
            return this.registry;
        }).when((Object)this.context)).setAttribute(ArgumentMatchers.any(WebComponentConfigurationRegistry.class));
        Lookup lookup = (Lookup)Mockito.mock(Lookup.class);
        Mockito.when((Object)((Lookup)this.context.getAttribute(Lookup.class))).thenReturn((Object)lookup);
        ((VaadinServletContext)Mockito.doAnswer(i -> ((Supplier)i.getArgument(1, Supplier.class)).get()).when((Object)this.context)).getAttribute((Class)ArgumentMatchers.argThat(aClass -> "FeatureFlagsWrapper".equals(aClass.getSimpleName())), (Supplier)ArgumentMatchers.any());
        VaadinService.setCurrent((VaadinService)this.service);
        Mockito.when((Object)this.service.getInstantiator()).thenReturn((Object)new MockInstantiator(new VaadinServiceInitListener[0]));
        Mockito.when((Object)this.service.getDeploymentConfiguration()).thenReturn((Object)this.configuration);
        VaadinServletService service = (VaadinServletService)Mockito.mock(VaadinServletService.class);
        ((VaadinServletService)Mockito.doCallRealMethod().when((Object)service)).getContextRootRelativePath((VaadinRequest)Mockito.any());
        ((VaadinServletService)Mockito.doCallRealMethod().when((Object)service)).getContextRootRelativePath((VaadinRequest)Mockito.any());
        this.provider = new WebComponentProvider();
    }

    @AfterEach
    public void cleanUp() {
        CurrentInstance.clearAll();
    }

    @Test
    public void nonHandledPaths_handlerInformsNotHandled() throws IOException {
        Mockito.when((Object)this.request.getPathInfo()).thenReturn(null);
        Assertions.assertFalse((boolean)this.provider.canHandleRequest((VaadinRequest)this.request), (String)"Provider shouldn't handle null path");
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"");
        Assertions.assertFalse((boolean)this.provider.canHandleRequest((VaadinRequest)this.request), (String)"Provider shouldn't handle empty path");
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/home");
        Assertions.assertFalse((boolean)this.provider.canHandleRequest((VaadinRequest)this.request), (String)"Provider shouldn't handle non web-component path");
    }

    @Test
    public void faultyTag_handlerInformsNotHandled() throws IOException {
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/web-component/extensionless-component");
        Assertions.assertFalse((boolean)this.provider.synchronizedHandleRequest(this.session, (VaadinRequest)this.request, this.response), (String)"Provider shouldn't handle path without extension");
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/web-component/component.js");
        Assertions.assertFalse((boolean)this.provider.synchronizedHandleRequest(this.session, (VaadinRequest)this.request, this.response), (String)"Provider shouldn't handle request for non-custom element name");
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/web-component/my-component.html");
        Assertions.assertFalse((boolean)this.provider.synchronizedHandleRequest(this.session, (VaadinRequest)this.request, this.response), (String)"Provider shouldn't handle html extensions in npm mode");
    }

    @Test
    public void webComponentNotPresent_responseReturns404() throws IOException {
        ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)this.request.getServletContext()).thenReturn((Object)servletContext);
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/web-component/my-component.js");
        Assertions.assertTrue((boolean)this.provider.synchronizedHandleRequest(this.session, (VaadinRequest)this.request, this.response), (String)"Provider should handle web-component request");
        ((VaadinResponse)Mockito.verify((Object)this.response)).sendError(HttpStatusCode.NOT_FOUND.getCode(), "No web component for my-component");
    }

    @Test
    public void webComponentGenerator_responseGetsResult() throws IOException {
        this.registry = this.setupConfigurations(MyComponentExporter.class);
        ByteArrayOutputStream out = (ByteArrayOutputStream)Mockito.spy((Object)new ByteArrayOutputStream());
        DefaultDeploymentConfiguration configuration = (DefaultDeploymentConfiguration)Mockito.mock(DefaultDeploymentConfiguration.class);
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)out);
        Mockito.when((Object)this.session.getConfiguration()).thenReturn((Object)configuration);
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/web-component/my-component.js");
        Assertions.assertTrue((boolean)this.provider.synchronizedHandleRequest(this.session, (VaadinRequest)this.request, this.response), (String)"Provider should handle web-component request");
        Assertions.assertTrue((boolean)out.toString().contains("window.Vaadin.featureFlagsUpdaters.push((activator) => {"), (String)"Response should have Feature Flags updater function");
        ((VaadinResponse)Mockito.verify((Object)this.response)).getOutputStream();
        ((ByteArrayOutputStream)Mockito.verify((Object)out)).write((byte[])Mockito.any(), Mockito.anyInt(), Mockito.anyInt());
    }

    @Test
    public void providesDifferentGeneratedHTMLForEachExportedComponent() throws IOException {
        ArgumentCaptor captor = ArgumentCaptor.forClass(byte[].class);
        this.registry = this.setupConfigurations(MyComponentExporter.class, OtherComponentExporter.class);
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        DefaultDeploymentConfiguration configuration = (DefaultDeploymentConfiguration)Mockito.mock(DefaultDeploymentConfiguration.class);
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)out1);
        Mockito.when((Object)this.session.getConfiguration()).thenReturn((Object)configuration);
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/web-component/my-component.js");
        Assertions.assertTrue((boolean)this.provider.synchronizedHandleRequest(this.session, (VaadinRequest)this.request, this.response), (String)"Provider should handle first web-component request");
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)out2);
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/web-component/other-component.js");
        Assertions.assertTrue((boolean)this.provider.synchronizedHandleRequest(this.session, (VaadinRequest)this.request, this.response), (String)"Provider should handle second web-component request");
        ((VaadinResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).getOutputStream();
        byte[] first = out1.toByteArray();
        byte[] second = out2.toByteArray();
        Assertions.assertNotEquals((Object)first, (Object)second, (String)"Stream output should not match");
    }

    @Test
    public void setExporters_exportersHasVariousPushes_throws() {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            WebComponentConfigurationRegistry registry = this.setupConfigurations(ThemedComponentExporter.class, AnotherPushComponentExporter.class);
        });
    }

    @Test
    public void setExporters_exportersHasOnePush_pushIsSet() {
        WebComponentConfigurationRegistry registry = this.setupConfigurations(ThemedComponentExporter.class, MyComponentExporter.class);
        Assertions.assertTrue((boolean)registry.getEmbeddedApplicationAnnotation(Push.class).isPresent());
    }

    @Test
    public void setExporters_exportersHasSamePushDeclarations_pushIsSet() {
        WebComponentConfigurationRegistry registry = this.setupConfigurations(ThemedComponentExporter.class, SameThemedComponentExporter.class);
        Assertions.assertTrue((boolean)registry.getEmbeddedApplicationAnnotation(Push.class).isPresent());
        Assertions.assertEquals((Object)PushMode.AUTOMATIC, (Object)((Push)registry.getEmbeddedApplicationAnnotation(Push.class).get()).value());
    }

    @Test
    public void canHandleRequest_hasNoWebComponentConfigPathIsWebComponentUI_returnsFalse() {
        WebComponentProvider handler = new WebComponentProvider();
        VaadinRequest request = this.mockRequest(false);
        Assertions.assertFalse((boolean)handler.canHandleRequest(request));
    }

    @Test
    public void canHandleRequest_hasWebComponentConfigPathIsWebComponentUI_returnsTrue() {
        WebComponentProvider handler = new WebComponentProvider();
        VaadinRequest request = this.mockRequest(true);
        Assertions.assertTrue((boolean)handler.canHandleRequest(request));
    }

    private VaadinRequest mockRequest(boolean hasConfig) {
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        Mockito.when((Object)request.getService()).thenReturn((Object)service);
        Mockito.when((Object)service.getContext()).thenReturn((Object)context);
        WebComponentConfigurationRegistry registry = (WebComponentConfigurationRegistry)Mockito.mock(WebComponentConfigurationRegistry.class);
        Mockito.when((Object)((WebComponentConfigurationRegistry)context.getAttribute((Class)Mockito.eq(WebComponentConfigurationRegistry.class), (Supplier)Mockito.any()))).thenReturn((Object)registry);
        Mockito.when((Object)registry.hasConfigurations()).thenReturn((Object)hasConfig);
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"/web-component/a-b.js");
        return request;
    }

    @SafeVarargs
    private WebComponentConfigurationRegistry setupConfigurations(Class<? extends WebComponentExporter<? extends Component>> ... exporters) {
        WebComponentConfigurationRegistry registry = this.setUpRegistry();
        Set set = Stream.of(exporters).collect(Collectors.toSet());
        WebComponentExporter.WebComponentConfigurationFactory factory = new WebComponentExporter.WebComponentConfigurationFactory();
        HashSet<WebComponentConfiguration> configurations = new HashSet<WebComponentConfiguration>();
        for (Class<? extends WebComponentExporter<? extends Component>> exporter : exporters) {
            configurations.add(factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(exporter).create()));
        }
        registry.setConfigurations(configurations);
        return registry;
    }

    private WebComponentConfigurationRegistry setUpRegistry() {
        return new WebComponentConfigurationRegistry(){};
    }

    public static class MyComponentExporter
    extends WebComponentExporter<MyComponent> {
        public MyComponentExporter() {
            super("my-component");
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class OtherComponentExporter
    extends WebComponentExporter<OtherComponent> {
        public OtherComponentExporter() {
            super("other-component");
        }

        public void configureInstance(WebComponent<OtherComponent> webComponent, OtherComponent component) {
        }
    }

    @Push
    public static class ThemedComponentExporter
    extends WebComponentExporter<Component> {
        public ThemedComponentExporter() {
            super("foo");
        }

        public void configureInstance(WebComponent<Component> webComponent, Component component) {
        }
    }

    @Push(value=PushMode.AUTOMATIC)
    public static class SameThemedComponentExporter
    extends WebComponentExporter<Component> {
        public SameThemedComponentExporter() {
            super("foo");
        }

        public void configureInstance(WebComponent<Component> webComponent, Component component) {
        }
    }

    @Push(value=PushMode.DISABLED)
    public static class AnotherPushComponentExporter
    extends WebComponentExporter<Component> {
        public AnotherPushComponentExporter() {
            super("foo-bar");
        }

        public void configureInstance(WebComponent<Component> webComponent, Component component) {
        }
    }

    @Tag(value="another-component")
    public static class OtherComponent
    extends Component {
    }

    @Tag(value="my-component")
    public static class MyComponent
    extends Component {
    }
}

