/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.ExtendedClientDetails;
import com.vaadin.flow.component.page.History;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.internal.menu.MenuRegistry;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationObserver;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.Layout;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationStateBuilder;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.PreserveOnRefresh;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.TestRouteRegistry;
import com.vaadin.flow.router.internal.AbstractNavigationStateRenderer;
import com.vaadin.flow.router.internal.NavigationStateRenderer;
import com.vaadin.flow.server.MockInstantiator;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.flow.server.menu.AvailableViewInfo;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import com.vaadin.tests.util.MockUI;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.SyntheticState;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.jcip.annotations.NotThreadSafe;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.BaseJsonNode;

@NotThreadSafe
class NavigationStateRendererTest {
    private Router router;
    private static AtomicInteger layoutAttachCount;
    private static AtomicInteger viewAttachCount;
    private static AtomicInteger beforeEnterCount;
    private static String layoutUUID;
    private static String viewUUID;

    NavigationStateRendererTest() {
    }

    @BeforeEach
    public void init() {
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)new MockVaadinContext());
        this.router = new Router((RouteRegistry)registry);
    }

    @Test
    public void getRouterLayoutForSingle() {
        NavigationStateRenderer childRenderer = new NavigationStateRenderer(this.navigationStateFromTarget(RouteParentLayout.class));
        List routerLayoutTypes = childRenderer.getRouterLayoutTypes(RouteParentLayout.class, this.router);
        Assertions.assertEquals((int)0, (int)routerLayoutTypes.size(), (String)"Found layout even though RouteParentLayout doesn't have any parents.");
    }

    @Test
    public void getRouterLayoutForSingleParent() {
        NavigationStateRenderer childRenderer = new NavigationStateRenderer(this.navigationStateFromTarget(SingleView.class));
        RouteConfiguration.forRegistry((RouteRegistry)this.router.getRegistry()).setAnnotatedRoute(SingleView.class);
        List routerLayoutTypes = childRenderer.getRouterLayoutTypes(SingleView.class, this.router);
        Assertions.assertEquals((int)1, (int)routerLayoutTypes.size(), (String)"Not all expected layouts were found");
        Assertions.assertEquals(RouteParentLayout.class, routerLayoutTypes.get(0), (String)"Wrong class found");
    }

    @Test
    public void getRouterLayoutForMulipleLayers() {
        NavigationStateRenderer childRenderer = new NavigationStateRenderer(this.navigationStateFromTarget(ChildConfiguration.class));
        RouteConfiguration.forRegistry((RouteRegistry)this.router.getRegistry()).setAnnotatedRoute(ChildConfiguration.class);
        List routerLayoutTypes = childRenderer.getRouterLayoutTypes(ChildConfiguration.class, this.router);
        Assertions.assertEquals((int)2, (int)routerLayoutTypes.size(), (String)"Not all expected layouts were found");
        Assertions.assertEquals(MiddleLayout.class, routerLayoutTypes.get(0), (String)"Wrong class found as first in array");
        Assertions.assertEquals(RouteParentLayout.class, routerLayoutTypes.get(1), (String)"Wrong class found as second in array");
    }

    @Test
    public void instantiatorUse() {
        MockVaadinServletService service = new MockVaadinServletService();
        service.init(new MockInstantiator(new VaadinServiceInitListener[0]){

            public <T extends HasElement> T createRouteTarget(Class<T> routeTargetType, NavigationEvent event) {
                Assertions.assertEquals(Component.class, routeTargetType);
                return (T)new Text("foo");
            }
        });
        MockUI ui = new MockUI(new AlwaysLockedVaadinSession((VaadinService)service));
        NavigationEvent event = new NavigationEvent(new Router((RouteRegistry)new TestRouteRegistry()), new Location(""), (UI)ui, NavigationTrigger.PAGE_LOAD);
        NavigationStateRenderer renderer = new NavigationStateRenderer(this.navigationStateFromTarget(ChildConfiguration.class));
        Component routeTarget = (Component)renderer.getRouteTarget(Component.class, event, true);
        Assertions.assertEquals(Text.class, routeTarget.getClass());
        UI.setCurrent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getRouteTarget_supportsProxyClasses() {
        try {
            final Class routeProxyClass = new ByteBuddy().subclass(ProxyableView.class).modifiers(new ModifierContributor.ForType[]{Visibility.PUBLIC, SyntheticState.SYNTHETIC}).make().load(ProxyableView.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded();
            final AtomicInteger routeCreationCounter = new AtomicInteger(0);
            MockVaadinServletService service = new MockVaadinServletService();
            service.init(new MockInstantiator(new VaadinServiceInitListener[0]){

                public <T extends HasElement> T createRouteTarget(Class<T> routeTargetType, NavigationEvent event) {
                    Assertions.assertEquals(ProxyableView.class, routeTargetType);
                    routeCreationCounter.incrementAndGet();
                    return (T)((HasElement)ReflectTools.createInstance((Class)routeProxyClass));
                }
            });
            final DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
            AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service){

                public DeploymentConfiguration getConfiguration() {
                    return configuration;
                }
            };
            Mockito.when((Object)configuration.isReactEnabled()).thenReturn((Object)true);
            MockUI ui = new MockUI(session);
            NavigationEvent event = new NavigationEvent(new Router((RouteRegistry)new TestRouteRegistry()), new Location("child"), (UI)ui, NavigationTrigger.UI_NAVIGATE);
            NavigationStateRenderer renderer = new NavigationStateRenderer(this.navigationStateFromTarget(ProxyableView.class));
            renderer.handle(event);
            HasElement view = (HasElement)ui.getInternals().getActiveRouterTargetsChain().get(0);
            Component routeTarget = (Component)renderer.getRouteTarget(ProxyableView.class, event, true);
            Assertions.assertEquals((int)1, (int)routeCreationCounter.get(), (String)"Only one view instance should have been created");
            Assertions.assertSame((Object)view, (Object)routeTarget);
        }
        finally {
            UI.setCurrent(null);
        }
    }

    @Test
    public void handle_preserveOnRefreshAndWindowNameNotKnown_clientSideCallTriggered() {
        MockVaadinServletService service = this.createMockServiceWithInstantiator();
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service);
        NavigationStateRenderer renderer = new NavigationStateRenderer(this.navigationStateFromTarget(PreservedView.class));
        AbstractNavigationStateRenderer.setPreservedChain((VaadinSession)session, (String)"", (Location)new Location("preserved"), new ArrayList<Component>(Collections.singletonList((Component)Mockito.mock(Component.class))));
        final AtomicBoolean jsInvoked = new AtomicBoolean(false);
        MockUI ui = new MockUI(session){
            final Page page;
            {
                super(session);
                this.page = new Page(this){

                    public PendingJavaScriptResult executeJs(String expression, Object ... params) {
                        jsInvoked.set(true);
                        return super.executeJs(expression, params);
                    }
                };
            }

            @Override
            public Page getPage() {
                return this.page;
            }
        };
        renderer.handle(new NavigationEvent(new Router((RouteRegistry)new TestRouteRegistry()), new Location("preserved"), (UI)ui, NavigationTrigger.PAGE_LOAD));
        Assertions.assertTrue((boolean)jsInvoked.get(), (String)"Expected JS invocation");
    }

    @Test
    public void handle_preserveOnRefreshAndWindowNameKnown_componentIsCachedRetrievedAndFlushed() {
        MockVaadinServletService service = this.createMockServiceWithInstantiator();
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service);
        MockUI ui1 = new MockUI(session);
        ExtendedClientDetails details = (ExtendedClientDetails)Mockito.mock(ExtendedClientDetails.class);
        Mockito.when((Object)details.getWindowName()).thenReturn((Object)"ROOT.123");
        ui1.getInternals().setExtendedClientDetails(details);
        NavigationStateRenderer renderer1 = new NavigationStateRenderer(this.navigationStateFromTarget(PreservedView.class));
        renderer1.handle(new NavigationEvent(new Router((RouteRegistry)new TestRouteRegistry()), new Location("preserved"), (UI)ui1, NavigationTrigger.PAGE_LOAD));
        Assertions.assertTrue((boolean)AbstractNavigationStateRenderer.getPreservedChain((VaadinSession)session, (String)"ROOT.123", (Location)new Location("preserved")).isPresent(), (String)"Session expected to have cached view");
        Component view = ui1.getCurrentView();
        MockUI ui2 = new MockUI(session);
        ui2.getInternals().setExtendedClientDetails(details);
        NavigationStateRenderer renderer2 = new NavigationStateRenderer(this.navigationStateFromTarget(PreservedView.class));
        renderer2.handle(new NavigationEvent(new Router((RouteRegistry)new TestRouteRegistry()), new Location("preserved"), (UI)ui2, NavigationTrigger.PAGE_LOAD));
        Assertions.assertEquals((Object)view, ui1.getInternals().getActiveRouterTargetsChain().get(0), (String)"Expected same view");
        MockUI ui3 = new MockUI(session);
        ui3.getInternals().setExtendedClientDetails(details);
        NavigationStateRenderer renderer3 = new NavigationStateRenderer(this.navigationStateFromTarget(RegularView.class));
        renderer3.handle(new NavigationEvent(new Router((RouteRegistry)new TestRouteRegistry()), new Location("regular"), (UI)ui2, NavigationTrigger.PAGE_LOAD));
        Assertions.assertFalse((boolean)AbstractNavigationStateRenderer.hasPreservedChainOfLocation((VaadinSession)session, (Location)new Location("preserved")), (String)"Session expected to not have cached view");
    }

    @Test
    public void handle_preserveOnRefresh_refreshIsFlaggedInEvent() {
        MockVaadinServletService service = this.createMockServiceWithInstantiator();
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service);
        MockUI ui = new MockUI(session);
        ExtendedClientDetails details = (ExtendedClientDetails)Mockito.mock(ExtendedClientDetails.class);
        Mockito.when((Object)details.getWindowName()).thenReturn((Object)"ROOT.123");
        ui.getInternals().setExtendedClientDetails(details);
        NavigationStateRenderer renderer = new NavigationStateRenderer(this.navigationStateFromTarget(PreservedEventView.class));
        renderer.handle(new NavigationEvent(new Router((RouteRegistry)new TestRouteRegistry()), new Location("preserved"), (UI)ui, NavigationTrigger.PAGE_LOAD));
        Assertions.assertTrue((boolean)AbstractNavigationStateRenderer.getPreservedChain((VaadinSession)session, (String)"ROOT.123", (Location)new Location("preserved")).isPresent(), (String)"Session expected to have cached view");
        PreservedEventView view = (PreservedEventView)((Object)ui.getInternals().getActiveRouterTargetsChain().get(0));
        Assertions.assertFalse((boolean)PreservedEventView.refreshBeforeEnter, (String)"Initial view load should not be a refresh for before");
        Assertions.assertFalse((boolean)PreservedEventView.refreshAfterNavigation, (String)"Initial view load should not be a refresh for after");
        renderer.handle(new NavigationEvent(new Router((RouteRegistry)new TestRouteRegistry()), new Location("preserved"), (UI)ui, NavigationTrigger.PAGE_LOAD));
        Assertions.assertEquals((Object)((Object)view), ui.getInternals().getActiveRouterTargetsChain().get(0), (String)"Expected same view");
        Assertions.assertTrue((boolean)PreservedEventView.refreshBeforeEnter, (String)"Reload should be flagged for before");
        Assertions.assertTrue((boolean)PreservedEventView.refreshAfterNavigation, (String)"Reload should be flagged for after");
    }

    @Test
    public void handle_preserveOnRefresh_otherUIChildrenAreMoved() {
        MockVaadinServletService service = this.createMockServiceWithInstantiator();
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service);
        NavigationStateRenderer renderer = new NavigationStateRenderer(this.navigationStateFromTarget(PreservedView.class));
        PreservedView view = new PreservedView();
        AbstractNavigationStateRenderer.setPreservedChain((VaadinSession)session, (String)"ROOT.123", (Location)new Location("preserved"), new ArrayList<PreservedView>(List.of(view)));
        MockUI ui0 = new MockUI(session);
        ui0.add(new Component[]{view});
        Element otherElement = new Element("div");
        ui0.getElement().insertChild(1, new Element[]{otherElement});
        MockUI ui1 = new MockUI(session);
        ExtendedClientDetails details = (ExtendedClientDetails)Mockito.mock(ExtendedClientDetails.class);
        Mockito.when((Object)details.getWindowName()).thenReturn((Object)"ROOT.123");
        ui1.getInternals().setExtendedClientDetails(details);
        renderer.handle(new NavigationEvent(new Router((RouteRegistry)new TestRouteRegistry()), new Location("preserved"), (UI)ui1, NavigationTrigger.PAGE_LOAD));
        Set uiChildren = ui1.getElement().getChildren().collect(Collectors.toSet());
        Assertions.assertEquals((int)2, (int)uiChildren.size());
        Assertions.assertTrue((boolean)uiChildren.contains(view.getElement()), (String)"Component element expected transferred");
        Assertions.assertTrue((boolean)uiChildren.contains(otherElement), (String)"Extra element expected transferred");
    }

    @Test
    public void handle_preserveOnRefreshView_routerLayoutIsPreserved_oldUiIsClosed() {
        MockVaadinServletService service = this.createMockServiceWithInstantiator();
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service);
        this.router = session.getService().getRouter();
        NavigationStateRenderer renderer = new NavigationStateRenderer(new NavigationStateBuilder(this.router).withTarget(PreservedNestedView.class).withPath("preservedNested").build());
        this.router.getRegistry().setRoute("preservedNested", PreservedNestedView.class, List.of(PreservedLayout.class));
        PreservedLayout layout = new PreservedLayout();
        PreservedNestedView nestedView = new PreservedNestedView();
        MockUI previousUi = new MockUI(session);
        previousUi.add(new Component[]{nestedView});
        AbstractNavigationStateRenderer.setPreservedChain((VaadinSession)session, (String)"ROOT.123", (Location)new Location("preservedNested"), new ArrayList<Component>(Arrays.asList(new Component[]{nestedView, layout})));
        MockUI ui = new MockUI(session);
        ExtendedClientDetails details = (ExtendedClientDetails)Mockito.mock(ExtendedClientDetails.class);
        Mockito.when((Object)details.getWindowName()).thenReturn((Object)"ROOT.123");
        ui.getInternals().setExtendedClientDetails(details);
        renderer.handle(new NavigationEvent(this.router, new Location("preservedNested"), (UI)ui, NavigationTrigger.PAGE_LOAD));
        Assertions.assertEquals((Object)((Object)nestedView), ui.getInternals().getActiveRouterTargetsChain().get(0), (String)"Expected same view");
        Assertions.assertEquals((Object)((Object)layout), ui.getInternals().getActiveRouterTargetsChain().get(1), (String)"Expected same router layout");
        Assertions.assertTrue((boolean)previousUi.isClosing());
    }

    @Test
    public void handle_preserveOnRefresh_sameUI_uiIsNotClosed_childrenAreNotRemoved() {
        MockVaadinServletService service = this.createMockServiceWithInstantiator();
        String path = "foo";
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service);
        NavigationStateRenderer renderer = new NavigationStateRenderer(this.navigationStateFromTarget(PreservedView.class));
        PreservedView view = new PreservedView();
        MockUI ui = new MockUI(session);
        ui.add(new Component[]{view});
        AbstractNavigationStateRenderer.setPreservedChain((VaadinSession)session, (String)"ROOT.123", (Location)new Location(path, new QueryParameters(Collections.singletonMap("a", Collections.emptyList()))), new ArrayList<PreservedView>(List.of(view)));
        ExtendedClientDetails details = (ExtendedClientDetails)Mockito.mock(ExtendedClientDetails.class);
        Mockito.when((Object)details.getWindowName()).thenReturn((Object)"ROOT.123");
        ui.getInternals().setExtendedClientDetails(details);
        AtomicInteger count = new AtomicInteger();
        view.addDetachListener((ComponentEventListener & Serializable)event -> count.getAndIncrement());
        NavigationEvent event2 = new NavigationEvent(new Router((RouteRegistry)new TestRouteRegistry()), new Location(path, new QueryParameters(Collections.singletonMap("b", Collections.emptyList()))), (UI)ui, NavigationTrigger.ROUTER_LINK, (BaseJsonNode)new ObjectMapper().createObjectNode(), false);
        renderer.handle(event2);
        Assertions.assertFalse((boolean)ui.isClosing());
        Assertions.assertEquals((int)0, (int)count.get());
    }

    @Test
    public void handle_preserveOnRefreshView_refreshCurrentRouteRecreatesComponents() {
        layoutAttachCount = new AtomicInteger();
        viewAttachCount = new AtomicInteger();
        MockVaadinServletService service = this.createMockServiceWithInstantiator();
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service);
        this.router = session.getService().getRouter();
        NavigationStateRenderer renderer = new NavigationStateRenderer(new NavigationStateBuilder(this.router).withTarget(PreservedNestedView.class).withPath("preservedNested").build());
        this.router.getRegistry().setRoute("preservedNested", PreservedNestedView.class, List.of(PreservedLayout.class));
        MockUI ui = new MockUI(session);
        ExtendedClientDetails details = (ExtendedClientDetails)Mockito.mock(ExtendedClientDetails.class);
        Mockito.when((Object)details.getWindowName()).thenReturn((Object)"ROOT.123");
        ui.getInternals().setExtendedClientDetails(details);
        renderer.handle(new NavigationEvent(this.router, new Location("preservedNested"), (UI)ui, NavigationTrigger.PAGE_LOAD));
        String currentLayoutUUID = layoutUUID;
        String currentViewUUID = viewUUID;
        Assertions.assertEquals((int)1, (int)layoutAttachCount.get());
        Assertions.assertEquals((int)1, (int)viewAttachCount.get());
        ui.getInternals().clearLastHandledNavigation();
        ui.refreshCurrentRoute(false);
        Assertions.assertEquals((int)1, (int)layoutAttachCount.get());
        Assertions.assertEquals((int)2, (int)viewAttachCount.get());
        Assertions.assertEquals((Object)currentLayoutUUID, (Object)layoutUUID);
        Assertions.assertNotEquals((Object)currentViewUUID, (Object)viewUUID);
        currentViewUUID = viewUUID;
        ui.refreshCurrentRoute(true);
        Assertions.assertEquals((int)2, (int)layoutAttachCount.get());
        Assertions.assertEquals((int)3, (int)viewAttachCount.get());
        Assertions.assertNotEquals((Object)currentLayoutUUID, (Object)layoutUUID);
        Assertions.assertNotEquals((Object)currentViewUUID, (Object)viewUUID);
    }

    @Test
    public void handle_normalView_refreshCurrentRouteRecreatesComponents() {
        layoutAttachCount = new AtomicInteger();
        viewAttachCount = new AtomicInteger();
        MockVaadinServletService service = this.createMockServiceWithInstantiator();
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service);
        this.router = session.getService().getRouter();
        NavigationStateRenderer renderer = new NavigationStateRenderer(new NavigationStateBuilder(this.router).withTarget(SingleView.class).withPath("single").build());
        this.router.getRegistry().setRoute("single", SingleView.class, List.of(RouteParentLayout.class));
        MockUI ui = new MockUI(session);
        renderer.handle(new NavigationEvent(this.router, new Location("single"), (UI)ui, NavigationTrigger.PAGE_LOAD));
        String currentLayoutUUID = layoutUUID;
        String currentViewUUID = viewUUID;
        Assertions.assertEquals((int)1, (int)layoutAttachCount.get());
        Assertions.assertEquals((int)1, (int)viewAttachCount.get());
        ui.getInternals().clearLastHandledNavigation();
        ui.refreshCurrentRoute(false);
        Assertions.assertEquals((int)1, (int)layoutAttachCount.get());
        Assertions.assertEquals((int)2, (int)viewAttachCount.get());
        Assertions.assertEquals((Object)currentLayoutUUID, (Object)layoutUUID);
        Assertions.assertNotEquals((Object)currentViewUUID, (Object)viewUUID);
        currentViewUUID = viewUUID;
        ui.refreshCurrentRoute(true);
        Assertions.assertEquals((int)2, (int)layoutAttachCount.get());
        Assertions.assertEquals((int)3, (int)viewAttachCount.get());
        Assertions.assertNotEquals((Object)currentLayoutUUID, (Object)layoutUUID);
        Assertions.assertNotEquals((Object)currentViewUUID, (Object)viewUUID);
    }

    @Test
    public void handle_clientNavigation_withMatchingFlowRoute() {
        viewAttachCount = new AtomicInteger();
        beforeEnterCount = new AtomicInteger();
        MockVaadinServletService service = this.createMockServiceWithInstantiator();
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service);
        this.router = session.getService().getRouter();
        NavigationStateRenderer renderer = new NavigationStateRenderer(new NavigationStateBuilder(this.router).withTarget(RootRouteWithParam.class).withPath("").build());
        this.router.getRegistry().setRoute("", RootRouteWithParam.class, null);
        MockUI ui = new MockUI(session);
        renderer.handle(new NavigationEvent(this.router, new Location(""), (UI)ui, NavigationTrigger.PAGE_LOAD));
        Assertions.assertEquals((int)1, (int)beforeEnterCount.get());
        Assertions.assertEquals((int)1, (int)viewAttachCount.get());
        ui.getInternals().clearLastHandledNavigation();
        try (MockedStatic menuRegistry = Mockito.mockStatic(MenuRegistry.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            menuRegistry.when(() -> MenuRegistry.getClientRoutes((boolean)true)).thenReturn(Collections.singletonMap("/client-route", new AvailableViewInfo("", null, false, "/client-route", false, false, null, null, null, false, null)));
            renderer.handle(new NavigationEvent(this.router, new Location("client-route"), (UI)ui, NavigationTrigger.CLIENT_SIDE));
            Assertions.assertEquals((int)1, (int)beforeEnterCount.get());
            Assertions.assertEquals((int)1, (int)viewAttachCount.get());
        }
    }

    @Test
    public void handle_refreshRoute_modalComponentsDetached() {
        beforeEnterCount = new AtomicInteger();
        viewAttachCount = new AtomicInteger();
        MockVaadinServletService service = this.createMockServiceWithInstantiator();
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service);
        this.router = session.getService().getRouter();
        NavigationStateRenderer renderer = new NavigationStateRenderer(new NavigationStateBuilder(this.router).withTarget(RootRouteWithParam.class).withPath("").build());
        this.router.getRegistry().setRoute("", RootRouteWithParam.class, null);
        @Tag(value="modal-component")
        class ModalComponent
        extends Component {
            private int attachCount;
            private int detachCount;

            ModalComponent() {
            }

            protected void onAttach(AttachEvent attachEvent) {
                ++this.attachCount;
                super.onAttach(attachEvent);
            }

            protected void onDetach(DetachEvent detachEvent) {
                ++this.detachCount;
                super.onDetach(detachEvent);
            }
        }
        ModalComponent modalComponent = new ModalComponent();
        MockUI ui = new MockUI(session);
        ui.addModal(modalComponent);
        renderer.handle(new NavigationEvent(this.router, new Location(""), (UI)ui, NavigationTrigger.REFRESH_ROUTE, (BaseJsonNode)null, false, true, true));
        Assertions.assertEquals((int)1, (int)modalComponent.attachCount);
        Assertions.assertEquals((int)1, (int)modalComponent.detachCount);
    }

    private MockVaadinServletService createMockServiceWithInstantiator() {
        MockVaadinServletService service = new MockVaadinServletService();
        service.init(new MockInstantiator(new VaadinServiceInitListener[0]){

            public <T extends HasElement> T createRouteTarget(Class<T> routeTargetType, NavigationEvent event) {
                try {
                    return (T)((HasElement)routeTargetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return service;
    }

    private NavigationState navigationStateFromTarget(Class<? extends Component> target) {
        return new NavigationStateBuilder(this.router).withTarget(target).build();
    }

    @Test
    public void handle_variousInputs_checkPushStateShouldBeCalledOrNot() {
        MockVaadinServletService service = this.createMockServiceWithInstantiator();
        ((MockDeploymentConfiguration)service.getDeploymentConfiguration()).setReactEnabled(false);
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service);
        MockDeploymentConfiguration configuration = new MockDeploymentConfiguration();
        configuration.setReactEnabled(false);
        new NavigationStateBuilder(this.router).withTarget(RegularView.class).build();
        NavigationStateRenderer renderer = new NavigationStateRenderer(this.navigationStateFromTarget(RegularView.class));
        final AtomicBoolean pushStateCalled = new AtomicBoolean(false);
        final ArrayList pushStateLocations = new ArrayList();
        MockUI ui = new MockUI(session){
            final Page page;
            {
                super(session);
                this.page = new Page(this){
                    final History history;
                    {
                        this.history = new History((UI)this.getUI().get()){

                            public void pushState(BaseJsonNode state, Location location) {
                                pushStateCalled.set(true);
                                pushStateLocations.add(location);
                            }
                        };
                    }

                    public History getHistory() {
                        return this.history;
                    }
                };
            }

            @Override
            public Page getPage() {
                return this.page;
            }
        };
        renderer.handle(new NavigationEvent(new Router((RouteRegistry)new TestRouteRegistry()), new Location("regular"), (UI)ui, NavigationTrigger.UI_NAVIGATE, (BaseJsonNode)null, true));
        Assertions.assertFalse((boolean)pushStateCalled.get(), (String)"No pushState invocation is expected when forwardTo is true.");
        ui.getInternals().clearLastHandledNavigation();
        renderer.handle(new NavigationEvent(new Router((RouteRegistry)new TestRouteRegistry()), new Location("regular"), (UI)ui, NavigationTrigger.PROGRAMMATIC));
        Assertions.assertFalse((boolean)pushStateCalled.get(), (String)"No pushState invocation is expected when navigation trigger is PROGRAMMATIC.");
        ui.getInternals().clearLastHandledNavigation();
        renderer.handle(new NavigationEvent(new Router((RouteRegistry)new TestRouteRegistry()), new Location("regular"), (UI)ui, NavigationTrigger.HISTORY));
        Assertions.assertFalse((boolean)pushStateCalled.get(), (String)"No pushState invocation is expected when navigation trigger is HISTORY.");
        ui.getInternals().clearLastHandledNavigation();
        renderer.handle(new NavigationEvent(new Router((RouteRegistry)new TestRouteRegistry()), new Location("regular"), (UI)ui, NavigationTrigger.PAGE_LOAD));
        Assertions.assertFalse((boolean)pushStateCalled.get(), (String)"No pushState invocation is expected when navigation trigger is PAGE_LOAD.");
        pushStateCalled.set(false);
        pushStateLocations.clear();
        ui.getInternals().clearLastHandledNavigation();
        renderer.handle(new NavigationEvent(new Router((RouteRegistry)new TestRouteRegistry()), new Location("regular"), (UI)ui, NavigationTrigger.UI_NAVIGATE));
        Assertions.assertFalse((boolean)pushStateCalled.get(), (String)"No pushState invocation is expected when navigating to the current location.");
    }

    @Test
    public void purgeInactiveUIPreservedChainCache_activeUI_throws() {
        MockVaadinServletService service = this.createMockServiceWithInstantiator();
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service);
        MockUI activeUI = new MockUI(session);
        PreservedView attachedToActiveUI = new PreservedView();
        activeUI.add(new Component[]{attachedToActiveUI});
        Assertions.assertThrows(IllegalStateException.class, () -> AbstractNavigationStateRenderer.purgeInactiveUIPreservedChainCache((UI)activeUI));
    }

    @Test
    public void purgeInactiveUIPreservedChainCache_inactiveUI_clearsCache() {
        MockVaadinServletService service = this.createMockServiceWithInstantiator();
        final WrappedSession wrappedSession = (WrappedSession)Mockito.mock(WrappedSession.class);
        Mockito.when((Object)wrappedSession.getId()).thenReturn((Object)"A-SESSION-ID");
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service){

            public WrappedSession getSession() {
                return wrappedSession;
            }
        };
        MockUI activeUI = new MockUI(session);
        PreservedView attachedToActiveUI = new PreservedView();
        activeUI.add(new Component[]{attachedToActiveUI});
        MockUI inActiveUI = new MockUI(session);
        PreservedView attachedToInactiveUI = new PreservedView();
        inActiveUI.add(new Component[]{attachedToInactiveUI});
        inActiveUI.close();
        Location location = new Location("preserved");
        AbstractNavigationStateRenderer.setPreservedChain((VaadinSession)session, (String)"ACTIVE", (Location)location, new ArrayList<PreservedView>(Collections.singletonList(attachedToActiveUI)));
        AbstractNavigationStateRenderer.setPreservedChain((VaadinSession)session, (String)"INACTIVE", (Location)location, new ArrayList<PreservedView>(Collections.singletonList(attachedToInactiveUI)));
        AbstractNavigationStateRenderer.purgeInactiveUIPreservedChainCache((UI)inActiveUI);
        Optional active = AbstractNavigationStateRenderer.getPreservedChain((VaadinSession)session, (String)"ACTIVE", (Location)location);
        Assertions.assertTrue((boolean)active.isPresent(), (String)"Expected preserved chain for active window to be present");
        Optional inactive = AbstractNavigationStateRenderer.getPreservedChain((VaadinSession)session, (String)"INACTIVE", (Location)location);
        Assertions.assertFalse((boolean)inactive.isPresent(), (String)"Expected preserved chain for inactive window to be removed");
    }

    @Test
    public void getRouteTarget_usageStatistics() {
        final DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        MockVaadinServletService service = new MockVaadinServletService();
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service){

            public DeploymentConfiguration getConfiguration() {
                return configuration;
            }
        };
        Mockito.when((Object)configuration.isReactEnabled()).thenReturn((Object)true);
        MockUI ui = new MockUI(session);
        NavigationEvent event = new NavigationEvent(new Router((RouteRegistry)new TestRouteRegistry()), new Location("home"), (UI)ui, NavigationTrigger.UI_NAVIGATE);
        NavigationStateRenderer renderer = new NavigationStateRenderer(this.navigationStateFromTarget(RegularView.class));
        UsageStatistics.removeEntry((String)"flow-router");
        renderer.handle(event);
        Assertions.assertTrue((boolean)UsageStatistics.getEntries().anyMatch(entry -> entry.getName().equals("flow-router")));
    }

    @Test
    public void handle_clientNavigationToFlowLayout_setTitleFromClientRoute() {
        this.testClientNavigationTitle("Client", true);
    }

    @Test
    public void handle_clientNavigation_doNotSetTitleFromClientRoute() {
        this.testClientNavigationTitle(null, false);
    }

    private void testClientNavigationTitle(String expectedDocumentTitle, boolean clientRouteHasFlowLayout) {
        UI ui = this.createTestClientNavigationTitleUIForTitleTests();
        try (MockedStatic menuRegistry = Mockito.mockStatic(MenuRegistry.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            menuRegistry.when(() -> MenuRegistry.getClientRoutes((boolean)true)).thenReturn(Collections.singletonMap("/client-route", new AvailableViewInfo("Client", null, false, "/client-route", false, false, null, null, null, clientRouteHasFlowLayout, null)));
            NavigationEvent event = new NavigationEvent(new Router((RouteRegistry)new TestRouteRegistry()), new Location("client-route"), ui, NavigationTrigger.UI_NAVIGATE);
            NavigationStateRenderer renderer = new NavigationStateRenderer(new NavigationStateBuilder(this.router).withTarget(MainLayout.class).withPath("client-route").build());
            renderer.handle(event);
            Assertions.assertNotNull((Object)ui.getPage());
            if (expectedDocumentTitle == null) {
                ((Page)Mockito.verify((Object)ui.getPage(), (VerificationMode)Mockito.never())).setTitle("Client");
            } else {
                ((Page)Mockito.verify((Object)ui.getPage())).setTitle(expectedDocumentTitle);
            }
        }
    }

    private UI createTestClientNavigationTitleUIForTitleTests() {
        final DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        MockVaadinServletService service = new MockVaadinServletService(configuration);
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service){

            public DeploymentConfiguration getConfiguration() {
                return configuration;
            }
        };
        Mockito.when((Object)configuration.isReactEnabled()).thenReturn((Object)false);
        final Page page = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)page.getHistory()).thenReturn((Object)((History)Mockito.mock(History.class)));
        return new MockUI(session){

            @Override
            public Page getPage() {
                return page;
            }
        };
    }

    @Test
    public void forwardToSameViewWithDifferentParams_reusesInstance() {
        this.redirectToSameViewWithDifferentParams_reusesInstance(ForwardToSameViewWithParams.class, "forward");
    }

    @Test
    public void rerouteToSameViewWithDifferentParams_reusesInstance() {
        this.redirectToSameViewWithDifferentParams_reusesInstance(RerouteToSameViewWithParams.class, "reroute");
    }

    private void redirectToSameViewWithDifferentParams_reusesInstance(Class<? extends Component> targetView, String redirectType) {
        RedirectToSameViewWithParams.reset();
        MockVaadinServletService service = this.createMockServiceWithInstantiator();
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service);
        this.router = session.getService().getRouter();
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.router.getRegistry());
        routeConfiguration.setAnnotatedRoute(targetView);
        MockUI ui = new MockUI(session);
        this.router.navigate((UI)ui, new Location(redirectType + "-param/unknown"), NavigationTrigger.UI_NAVIGATE);
        Assertions.assertEquals((int)1, (int)RedirectToSameViewWithParams.instanceCount, (String)("View should be instantiated only once when redirecting (" + redirectType + ") to same view"));
        Assertions.assertEquals((int)2, (int)RedirectToSameViewWithParams.beforeEnterCount, (String)("beforeEnter should be called twice (original + " + redirectType + ")"));
        Assertions.assertEquals((int)2, (int)RedirectToSameViewWithParams.receivedIds.size(), (String)"Should receive both parameter values");
        Assertions.assertEquals((Object)"unknown", (Object)RedirectToSameViewWithParams.receivedIds.get(0), (String)"First call should have 'unknown'");
        Assertions.assertEquals((Object)"valid-id", (Object)RedirectToSameViewWithParams.receivedIds.get(1), (String)"Second call should have 'valid-id'");
    }

    @Route(value="parent")
    @Tag(value="div")
    private static class RouteParentLayout
    extends Component
    implements RouterLayout {
        RouteParentLayout() {
            this.addAttachListener((ComponentEventListener & Serializable)e -> layoutAttachCount.getAndIncrement());
            layoutUUID = UUID.randomUUID().toString();
        }
    }

    @Route(value="single", layout=RouteParentLayout.class)
    @Tag(value="div")
    private static class SingleView
    extends Component {
        SingleView() {
            this.addAttachListener((ComponentEventListener & Serializable)e -> viewAttachCount.getAndIncrement());
            viewUUID = UUID.randomUUID().toString();
        }
    }

    @Route(value="child", layout=MiddleLayout.class)
    private static class ChildConfiguration
    extends Component {
        private ChildConfiguration() {
        }
    }

    @ParentLayout(value=RouteParentLayout.class)
    private static class MiddleLayout
    extends Component
    implements RouterLayout {
        private MiddleLayout() {
        }
    }

    @Route(value="proxyable")
    public static class ProxyableView
    extends Text {
        public ProxyableView() {
            super("");
        }
    }

    @Route(value="preserved")
    @PreserveOnRefresh
    private static class PreservedView
    extends Text {
        PreservedView() {
            super("");
        }
    }

    @Route(value="regular")
    public static class RegularView
    extends Text {
        public RegularView() {
            super("");
        }
    }

    @Route(value="preserved")
    @PreserveOnRefresh
    private static class PreservedEventView
    extends Text
    implements BeforeEnterObserver,
    AfterNavigationObserver {
        static boolean refreshBeforeEnter;
        static boolean refreshAfterNavigation;

        PreservedEventView() {
            super("");
        }

        public void beforeEnter(BeforeEnterEvent event) {
            refreshBeforeEnter = event.isRefreshEvent();
        }

        public void afterNavigation(AfterNavigationEvent event) {
            refreshAfterNavigation = event.isRefreshEvent();
        }
    }

    @PreserveOnRefresh
    @Route(value="preservedNested", layout=PreservedLayout.class)
    private static class PreservedNestedView
    extends Text {
        PreservedNestedView() {
            super("");
            this.addAttachListener((ComponentEventListener & Serializable)e -> viewAttachCount.getAndIncrement());
            viewUUID = UUID.randomUUID().toString();
        }
    }

    @Route(value="preservedLayout")
    @Tag(value="div")
    private static class PreservedLayout
    extends Component
    implements RouterLayout {
        PreservedLayout() {
            this.addAttachListener((ComponentEventListener & Serializable)e -> layoutAttachCount.getAndIncrement());
            layoutUUID = UUID.randomUUID().toString();
        }
    }

    @Route(value="/:samplePersonID?/:action?(edit)")
    @RouteAlias(value="")
    @Tag(value="div")
    private static class RootRouteWithParam
    extends Component
    implements BeforeEnterObserver {
        RootRouteWithParam() {
            this.addAttachListener((ComponentEventListener & Serializable)e -> viewAttachCount.getAndIncrement());
        }

        public void beforeEnter(BeforeEnterEvent event) {
            beforeEnterCount.getAndIncrement();
        }
    }

    @Layout
    @Tag(value="div")
    public static class MainLayout
    extends Component
    implements RouterLayout {
        private final Element element = new Element("div");

        public Element getElement() {
            return this.element;
        }
    }

    @Route(value="forward-param/:id")
    @Tag(value="div")
    public static class ForwardToSameViewWithParams
    extends RedirectToSameViewWithParams {
        @Override
        protected void selfRedirect(BeforeEnterEvent event, String id) {
            event.forwardTo(event.getNavigationTarget(), new RouteParameters("id", id));
        }
    }

    @Route(value="reroute-param/:id")
    @Tag(value="div")
    public static class RerouteToSameViewWithParams
    extends RedirectToSameViewWithParams {
        @Override
        protected void selfRedirect(BeforeEnterEvent event, String id) {
            event.rerouteTo(event.getNavigationTarget(), new RouteParameters("id", id));
        }
    }

    static abstract class RedirectToSameViewWithParams
    extends Component
    implements BeforeEnterObserver {
        static int instanceCount = 0;
        static int beforeEnterCount = 0;
        static List<String> receivedIds = new ArrayList<String>();
        final int instanceId = ++instanceCount;

        public void beforeEnter(BeforeEnterEvent event) {
            ++beforeEnterCount;
            String id = event.getRouteParameters().get("id").orElse("");
            receivedIds.add(id);
            if ("unknown".equals(id)) {
                this.selfRedirect(event, "valid-id");
            }
        }

        protected abstract void selfRedirect(BeforeEnterEvent var1, String var2);

        static void reset() {
            instanceCount = 0;
            beforeEnterCount = 0;
            receivedIds.clear();
        }
    }
}

