/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouteNotFoundError;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class RouteNotFoundErrorTest {
    RouteNotFoundErrorTest() {
    }

    @Test
    public void setErrorParameter_productionMode_pathContainRoutesTemplate_renderedElementHasNoRoutes() {
        RouteNotFoundError page = new RouteNotFoundError();
        BeforeEnterEvent event = this.createEvent(true);
        ErrorParameter param = new ErrorParameter(NotFoundException.class, (Exception)((Object)new NotFoundException()));
        Router router = (Router)Mockito.mock(Router.class);
        Mockito.when((Object)event.getSource()).thenReturn((Object)router);
        RouteRegistry registry = (RouteRegistry)Mockito.mock(RouteRegistry.class);
        Mockito.when((Object)router.getRegistry()).thenReturn((Object)registry);
        RouteData data = new RouteData(Collections.emptyList(), "bar", Collections.emptyList(), RouteTarget.class, Collections.emptyList());
        Mockito.when((Object)registry.getRegisteredRoutes()).thenReturn(Collections.singletonList(data));
        event.getSource().getRegistry().getRegisteredRoutes();
        try (MockedStatic service = Mockito.mockStatic(VaadinService.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            VaadinService vaadinService = (VaadinService)Mockito.mock(VaadinService.class);
            DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
            Mockito.when((Object)vaadinService.getDeploymentConfiguration()).thenReturn((Object)configuration);
            Mockito.when((Object)configuration.isProductionMode()).thenReturn((Object)true);
            Mockito.when((Object)configuration.getFrontendFolder()).thenReturn((Object)new File("front"));
            service.when(() -> VaadinService.getCurrent()).thenReturn((Object)vaadinService);
            page.setErrorParameter(event, param);
        }
        MatcherAssert.assertThat((Object)page.getElement().toString(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"bar")));
    }

    @Test
    public void setErrorParameter_devMode_noRoutes() {
        RouteNotFoundError page = new RouteNotFoundError();
        BeforeEnterEvent event = this.createEvent(false);
        ErrorParameter param = new ErrorParameter(NotFoundException.class, (Exception)((Object)new NotFoundException()));
        VaadinService vaadinService = (VaadinService)Mockito.mock(VaadinService.class);
        Mockito.when((Object)vaadinService.getDeploymentConfiguration()).thenReturn(null);
        Router router = (Router)Mockito.mock(Router.class);
        Mockito.when((Object)event.getSource()).thenReturn((Object)router);
        RouteRegistry registry = (RouteRegistry)Mockito.mock(RouteRegistry.class);
        Mockito.when((Object)router.getRegistry()).thenReturn((Object)registry);
        Mockito.when((Object)registry.getRegisteredRoutes()).thenReturn(List.of());
        event.getSource().getRegistry().getRegisteredRoutes();
        try (MockedStatic util = Mockito.mockStatic(FrontendUtils.class);
             MockedStatic service = Mockito.mockStatic(VaadinService.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            util.when(() -> FrontendUtils.getProjectFrontendDir((AbstractConfiguration)((AbstractConfiguration)Mockito.any()))).thenReturn(null);
            util.when(() -> FrontendUtils.isHillaUsed((File)((File)Mockito.any()))).thenReturn((Object)false);
            service.when(() -> VaadinService.getCurrent()).thenReturn((Object)vaadinService);
            page.setErrorParameter(event, param);
        }
        MatcherAssert.assertThat((Object)page.getElement().toString(), (Matcher)CoreMatchers.containsString((String)"No views found"));
    }

    private BeforeEnterEvent createEvent(boolean productionMode) {
        BeforeEnterEvent event = (BeforeEnterEvent)Mockito.mock(BeforeEnterEvent.class);
        Location location = (Location)Mockito.mock(Location.class);
        Mockito.when((Object)location.getPath()).thenReturn((Object)"{{routes}}");
        Mockito.when((Object)event.getLocation()).thenReturn((Object)location);
        UI ui = (UI)Mockito.mock(UI.class);
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        Mockito.when((Object)ui.getSession()).thenReturn((Object)session);
        DeploymentConfiguration config = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)session.getConfiguration()).thenReturn((Object)config);
        Mockito.when((Object)config.isProductionMode()).thenReturn((Object)productionMode);
        Mockito.when((Object)config.getFrontendFolder()).thenReturn((Object)new File("front"));
        Mockito.when((Object)event.getUI()).thenReturn((Object)ui);
        return event;
    }

    @Tag(value="a")
    private static class RouteTarget
    extends Component {
        private RouteTarget() {
        }
    }
}

