/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.node.BaseJsonNode;

class VirtualChildrenListTest {
    private StateNode node = new StateNode(new Class[]{VirtualChildrenList.class});
    private VirtualChildrenList list = (VirtualChildrenList)this.node.getFeature(VirtualChildrenList.class);
    private StateNode child = new StateNode(new Class[]{ElementData.class});

    VirtualChildrenListTest() {
    }

    @Test
    void insert_atIndexWithType_payloadIsSetAndElementIsInserted() {
        this.list.add(0, this.child, "foo", (String)null);
        Assertions.assertEquals((Object)this.child, (Object)this.list.get(0));
        BaseJsonNode payload = ((ElementData)this.child.getFeature(ElementData.class)).getPayload();
        Assertions.assertNotNull((Object)payload);
        Assertions.assertEquals((Object)"foo", (Object)payload.get("type").asString());
        StateNode anotherChild = new StateNode(new Class[]{ElementData.class});
        this.list.add(0, anotherChild, "bar", (String)null);
        Assertions.assertEquals((Object)anotherChild, (Object)this.list.get(0));
        payload = ((ElementData)anotherChild.getFeature(ElementData.class)).getPayload();
        Assertions.assertNotNull((Object)payload);
        Assertions.assertEquals((Object)"bar", (Object)payload.get("type").asString());
    }

    @Test
    void insert_atIndexWithPayload_payloadIsSetAndElementIsInserted() {
        this.list.add(0, this.child, "foo", "bar");
        Assertions.assertEquals((Object)this.child, (Object)this.list.get(0));
        BaseJsonNode payload = ((ElementData)this.child.getFeature(ElementData.class)).getPayload();
        Assertions.assertNotNull((Object)payload);
        Assertions.assertEquals((Object)"foo", (Object)payload.get("type").asString());
        Assertions.assertEquals((Object)"bar", (Object)payload.get("payload").asString());
    }

    @Test
    void iteratorAndSize_addTwoItems_methodsReturnCorrectValues() {
        this.list.append(this.child, "foo");
        StateNode anotherChild = new StateNode(new Class[]{ElementData.class});
        this.list.append(anotherChild, "bar");
        Assertions.assertEquals((int)2, (int)this.list.size());
        Set set = StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.list.iterator(), 16), false).collect(Collectors.toSet());
        Assertions.assertEquals((int)2, (int)set.size());
        set.remove(this.child);
        set.remove(anotherChild);
        Assertions.assertEquals((int)0, (int)set.size());
    }

    @Test
    void remove_withIndex_removesNodeAndPayload() {
        this.list.append(this.child, "foo");
        Assertions.assertEquals((Object)this.child, (Object)this.list.get(0));
        this.list.remove(0);
        Assertions.assertEquals((int)0, (int)this.list.size());
        Assertions.assertEquals((int)-1, (int)this.list.indexOf(this.child));
        BaseJsonNode payload = ((ElementData)this.child.getFeature(ElementData.class)).getPayload();
        Assertions.assertNull((Object)payload);
    }

    @Test
    void clear_throw() {
        this.list.append(this.child, "foo");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.list.clear());
    }
}

