/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.AbstractNodeFeatureTest;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.InertData;
import com.vaadin.flow.internal.nodefeature.ShadowRootHost;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class InertDataTest
extends AbstractNodeFeatureTest<InertData> {
    private StateNode parent;
    private StateNode child;
    private StateNode grandchild;

    InertDataTest() {
    }

    @BeforeEach
    void setup() {
        this.parent = InertDataTest.createNode(null);
        this.child = InertDataTest.createNode(this.parent);
        this.grandchild = InertDataTest.createNode(this.child);
    }

    @Test
    void inertData_defaults() {
        Element element = ElementFactory.createDiv();
        Assertions.assertFalse((boolean)element.getNode().getFeatureIfInitialized(InertData.class).isPresent(), (String)"Elements should not have InertData by default");
        InertData inertData = (InertData)element.getNode().getFeature(InertData.class);
        Assertions.assertFalse((boolean)inertData.isInertSelf());
        Assertions.assertFalse((boolean)inertData.isIgnoreParentInert());
        Assertions.assertTrue((boolean)inertData.allowsChanges());
    }

    @Test
    void inertData_hasShadowRoot_handlesInertCheck() {
        this.parent = InertDataTest.createNode(null);
        StateNode shadow = new StateNode(new Class[]{ElementChildrenList.class, ShadowRootHost.class});
        ((ElementChildrenList)this.parent.getFeature(ElementChildrenList.class)).add(0, shadow);
        this.grandchild = InertDataTest.createNode(shadow);
        InertData parentFeature = (InertData)this.parent.getFeature(InertData.class);
        parentFeature.setInertSelf(true);
        parentFeature.generateChangesFromEmpty();
        Assertions.assertTrue((boolean)parentFeature.isInert());
        Assertions.assertFalse((boolean)this.grandchild.getFeatureIfInitialized(InertData.class).isPresent());
    }

    @Test
    void inertData_inheritingInert_allPermutations() {
        InertData childFeature = (InertData)this.child.getFeature(InertData.class);
        childFeature.setIgnoreParentInert(true);
        Assertions.assertFalse((boolean)childFeature.isInert());
        childFeature.generateChangesFromEmpty();
        InertData parentFeature = (InertData)this.parent.getFeature(InertData.class);
        parentFeature.setInertSelf(true);
        parentFeature.generateChangesFromEmpty();
        Assertions.assertTrue((boolean)parentFeature.isInert());
        Assertions.assertFalse((boolean)childFeature.isInert());
        Assertions.assertFalse((boolean)this.grandchild.getFeatureIfInitialized(InertData.class).isPresent());
        childFeature.setIgnoreParentInert(false);
        childFeature.generateChangesFromEmpty();
        Assertions.assertTrue((boolean)parentFeature.isInert());
        Assertions.assertTrue((boolean)childFeature.isInert());
        Assertions.assertFalse((boolean)this.grandchild.getFeatureIfInitialized(InertData.class).isPresent());
        childFeature.setIgnoreParentInert(true);
        childFeature.generateChangesFromEmpty();
        Assertions.assertTrue((boolean)parentFeature.isInert());
        Assertions.assertFalse((boolean)childFeature.isInert());
        Assertions.assertFalse((boolean)this.grandchild.getFeatureIfInitialized(InertData.class).isPresent());
        childFeature.setInertSelf(true);
        childFeature.generateChangesFromEmpty();
        Assertions.assertTrue((boolean)parentFeature.isInert());
        Assertions.assertTrue((boolean)childFeature.isInert());
        Assertions.assertFalse((boolean)this.grandchild.getFeatureIfInitialized(InertData.class).isPresent());
        parentFeature.setInertSelf(false);
        parentFeature.generateChangesFromEmpty();
        Assertions.assertFalse((boolean)parentFeature.isInert());
        Assertions.assertTrue((boolean)childFeature.isInert());
        Assertions.assertFalse((boolean)this.grandchild.getFeatureIfInitialized(InertData.class).isPresent());
        childFeature.setInertSelf(false);
        childFeature.generateChangesFromEmpty();
        Assertions.assertFalse((boolean)parentFeature.isInert());
        Assertions.assertFalse((boolean)childFeature.isInert());
        Assertions.assertFalse((boolean)this.grandchild.getFeatureIfInitialized(InertData.class).isPresent());
        childFeature.setIgnoreParentInert(false);
        parentFeature.setInertSelf(true);
        parentFeature.generateChangesFromEmpty();
        Assertions.assertTrue((boolean)parentFeature.isInert());
        Assertions.assertTrue((boolean)childFeature.isInert());
        Assertions.assertFalse((boolean)this.grandchild.getFeatureIfInitialized(InertData.class).isPresent());
    }

    @Test
    void inertDataUpdates_hierarchyWithGaps_updatesCascaded() {
        StateNode greatgrandchild = InertDataTest.createNode(this.grandchild);
        InertData greatgrandchildFeature = (InertData)greatgrandchild.getFeature(InertData.class);
        greatgrandchildFeature.setInertSelf(false);
        greatgrandchildFeature.generateChangesFromEmpty();
        Assertions.assertFalse((boolean)greatgrandchild.isInert());
        InertData parentFeature = (InertData)this.parent.getFeature(InertData.class);
        parentFeature.setInertSelf(true);
        parentFeature.generateChangesFromEmpty();
        Assertions.assertTrue((boolean)this.parent.isInert());
        Assertions.assertTrue((boolean)this.child.isInert());
        Assertions.assertTrue((boolean)this.grandchild.isInert());
        Assertions.assertTrue((boolean)greatgrandchild.isInert());
        InertData grandchildFeature = (InertData)this.grandchild.getFeature(InertData.class);
        grandchildFeature.setIgnoreParentInert(true);
        grandchildFeature.generateChangesFromEmpty();
        Assertions.assertTrue((boolean)this.parent.isInert());
        Assertions.assertTrue((boolean)this.child.isInert());
        Assertions.assertFalse((boolean)this.grandchild.isInert());
        Assertions.assertFalse((boolean)greatgrandchild.isInert());
        parentFeature.setInertSelf(false);
        parentFeature.generateChangesFromEmpty();
        Assertions.assertFalse((boolean)this.parent.isInert());
        Assertions.assertFalse((boolean)this.child.isInert());
        Assertions.assertFalse((boolean)this.grandchild.isInert());
        Assertions.assertFalse((boolean)greatgrandchild.isInert());
        parentFeature.setInertSelf(true);
        parentFeature.generateChangesFromEmpty();
        Assertions.assertTrue((boolean)this.parent.isInert());
        Assertions.assertTrue((boolean)this.child.isInert());
        Assertions.assertFalse((boolean)this.grandchild.isInert());
        Assertions.assertFalse((boolean)greatgrandchild.isInert());
        grandchildFeature.setIgnoreParentInert(false);
        grandchildFeature.generateChangesFromEmpty();
        Assertions.assertTrue((boolean)this.parent.isInert());
        Assertions.assertTrue((boolean)this.child.isInert());
        Assertions.assertTrue((boolean)this.grandchild.isInert());
        Assertions.assertTrue((boolean)greatgrandchild.isInert());
        parentFeature.setInertSelf(false);
        parentFeature.generateChangesFromEmpty();
        Assertions.assertFalse((boolean)this.parent.isInert());
        Assertions.assertFalse((boolean)this.child.isInert());
        Assertions.assertFalse((boolean)this.grandchild.isInert());
        Assertions.assertFalse((boolean)greatgrandchild.isInert());
        parentFeature.setInertSelf(true);
        grandchildFeature.setIgnoreParentInert(true);
        parentFeature.generateChangesFromEmpty();
        Assertions.assertTrue((boolean)this.parent.isInert());
        Assertions.assertTrue((boolean)this.child.isInert());
        Assertions.assertFalse((boolean)this.grandchild.isInert());
        Assertions.assertFalse((boolean)greatgrandchild.isInert());
    }

    private static StateNode createNode(StateNode parent) {
        StateNode stateNode = new StateNode(new Class[]{ElementChildrenList.class, InertData.class});
        if (parent != null) {
            ((ElementChildrenList)parent.getFeature(ElementChildrenList.class)).add(0, stateNode);
        }
        return stateNode;
    }
}

