/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.change;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateNodeTest;
import com.vaadin.flow.internal.change.MapPutChange;
import com.vaadin.flow.internal.nodefeature.AbstractNodeFeatureTest;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.NodeFeatureRegistry;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ObjectNode;

class MapPutChangeTest {
    private NodeMap feature = (NodeMap)AbstractNodeFeatureTest.createFeature(ElementPropertyMap.class);

    MapPutChangeTest() {
    }

    @Test
    void testJson() {
        MapPutChange change = new MapPutChange((NodeFeature)this.feature, "some", (Object)"string");
        ObjectNode json = change.toJson(null);
        Assertions.assertEquals((int)change.getNode().getId(), (int)json.get("node").intValue());
        Assertions.assertEquals((int)NodeFeatureRegistry.getId(this.feature.getClass()), (int)json.get("feat").intValue());
        Assertions.assertEquals((Object)"put", (Object)json.get("type").textValue());
        Assertions.assertEquals((Object)"some", (Object)json.get("key").textValue());
        Assertions.assertEquals((Object)"string", (Object)json.get("value").textValue());
    }

    @Test
    void testJsonValueTypes() {
        JsonNode stringValue = this.getValue("string");
        Assertions.assertSame((Object)JsonNodeType.STRING, (Object)stringValue.getNodeType());
        Assertions.assertEquals((Object)"string", (Object)stringValue.textValue());
        JsonNode numberValue = this.getValue(1);
        Assertions.assertSame((Object)JsonNodeType.NUMBER, (Object)numberValue.getNodeType());
        Assertions.assertEquals((float)1.0f, (float)numberValue.intValue(), (float)0.0f);
        JsonNode booleanValue = this.getValue(Boolean.TRUE);
        Assertions.assertSame((Object)JsonNodeType.BOOLEAN, (Object)booleanValue.getNodeType());
        Assertions.assertTrue((boolean)booleanValue.asBoolean());
        ObjectNode jsonInput = JacksonUtils.createObjectNode();
        JsonNode jsonValue = this.getValue(jsonInput);
        Assertions.assertSame((Object)JsonNodeType.OBJECT, (Object)jsonValue.getNodeType());
        Assertions.assertEquals((Object)jsonInput, (Object)jsonValue);
    }

    @Test
    void testNodeValueType() {
        StateNode value = StateNodeTest.createEmptyNode("value");
        MapPutChange change = new MapPutChange((NodeFeature)this.feature, "myKey", (Object)value);
        ObjectNode json = change.toJson(null);
        Assertions.assertFalse((boolean)json.has("value"));
        JsonNode nodeValue = json.get("nodeValue");
        Assertions.assertSame((Object)JsonNodeType.NUMBER, (Object)nodeValue.getNodeType());
        Assertions.assertEquals((int)value.getId(), (int)nodeValue.intValue());
    }

    private JsonNode getValue(Object input) {
        MapPutChange change = new MapPutChange((NodeFeature)this.feature, "myKey", input);
        ObjectNode json = change.toJson(null);
        return json.get("value");
    }
}

