/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.internal.JacksonCodec;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.NumericNode;
import tools.jackson.databind.node.ObjectNode;

class JacksonCodecTest {
    private static final List<Object> complexTypeValues = Arrays.asList(new Object(), new StateNode(new Class[0]), new Date(), new String[0], new ArrayList(), new HashSet(), new HashMap());
    private static final ObjectMapper objectMapper = new ObjectMapper();

    JacksonCodecTest() {
    }

    @Test
    public void encodeWithoutTypeInfo_supportedTypes() {
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)true), JacksonCodec.encodeWithoutTypeInfo((Object)Boolean.TRUE));
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)"string"), JacksonCodec.encodeWithoutTypeInfo((Object)"string"));
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)3.14), JacksonCodec.encodeWithoutTypeInfo((Object)3.14));
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)42), JacksonCodec.encodeWithoutTypeInfo((Object)42));
        JacksonCodecTest.assertJsonEquals(objectMapper.nullNode(), JacksonCodec.encodeWithoutTypeInfo(null));
        ObjectNode json = objectMapper.createObjectNode();
        json.put("foo", "bar");
        JacksonCodecTest.assertJsonEquals((JsonNode)json, JacksonCodec.encodeWithoutTypeInfo((Object)json));
        JacksonCodecTest.assertJsonEquals(objectMapper.nullNode(), objectMapper.nullNode());
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)false), objectMapper.valueToTree((Object)false));
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)234), objectMapper.valueToTree((Object)234));
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)"string"), objectMapper.valueToTree((Object)"string"));
        JacksonCodecTest.assertJsonEquals((JsonNode)json, (JsonNode)json);
        JacksonCodecTest.assertJsonEquals((JsonNode)objectMapper.createArrayNode(), (JsonNode)objectMapper.createArrayNode());
        this.testComplexTypeSerialization();
    }

    @Test
    public void encodeWithoutTypeInfo_unsupportedTypes() {
        ArrayList<Object> unsupported = new ArrayList<Object>(complexTypeValues);
        unsupported.add(ElementFactory.createDiv());
        for (Object e : unsupported) {
            boolean thrown = false;
            try {
                JacksonCodec.encodeWithoutTypeInfo(e);
            }
            catch (AssertionError expected) {
                thrown = true;
            }
            if (thrown) continue;
            Assertions.fail((String)("Should throw for " + String.valueOf(e.getClass())));
        }
    }

    @Test
    public void encodeWithTypeInfo_basicTypes() {
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)true), JacksonCodec.encodeWithTypeInfo((Object)Boolean.TRUE));
        JacksonCodecTest.assertJsonEquals(objectMapper.nullNode(), JacksonCodec.encodeWithTypeInfo(null));
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)234), JacksonCodec.encodeWithTypeInfo((Object)objectMapper.valueToTree((Object)234)));
        JacksonCodecTest.assertJsonEquals(objectMapper.valueToTree((Object)"string"), JacksonCodec.encodeWithTypeInfo((Object)objectMapper.valueToTree((Object)"string")));
        JacksonCodecTest.assertJsonEquals((JsonNode)objectMapper.createObjectNode(), JacksonCodec.encodeWithTypeInfo((Object)objectMapper.createObjectNode()));
        JacksonCodecTest.assertJsonEquals((JsonNode)objectMapper.createArrayNode(), JacksonCodec.encodeWithTypeInfo((Object)objectMapper.createArrayNode()));
    }

    @Test
    public void encodeWithTypeInfo_attachedElement() {
        Element element = ElementFactory.createDiv();
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add(0, element.getNode());
        JsonNode json = JacksonCodec.encodeWithTypeInfo((Object)element);
        ObjectNode expected = objectMapper.createObjectNode();
        expected.put("@v-node", element.getNode().getId());
        JacksonCodecTest.assertJsonEquals((JsonNode)expected, json);
    }

    @Test
    public void encodeWithTypeInfo_detachedElement() {
        Element element = ElementFactory.createDiv();
        JsonNode json = JacksonCodec.encodeWithTypeInfo((Object)element);
        JacksonCodecTest.assertJsonEquals(objectMapper.nullNode(), json);
    }

    private static void assertJsonEquals(JsonNode expected, JsonNode actual) {
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)expected, (JsonNode)actual), (String)(actual.toString() + " does not equal " + expected.toString()));
    }

    @Test
    public void decodeAs_booleanJson() {
        JsonNode json = objectMapper.valueToTree((Object)true);
        Assertions.assertTrue((boolean)((Boolean)JacksonCodec.decodeAs((JsonNode)json, Boolean.class)));
        Assertions.assertEquals((Object)json, (Object)JacksonCodec.decodeAs((JsonNode)json, JsonNode.class));
    }

    @Test
    public void decodeAs_stringJson() {
        JsonNode json = objectMapper.valueToTree((Object)"Test123 String\n !%");
        Assertions.assertEquals((Object)"Test123 String\n !%", (Object)JacksonCodec.decodeAs((JsonNode)json, String.class));
        Assertions.assertEquals((Object)json, (Object)JacksonCodec.decodeAs((JsonNode)json, JsonNode.class));
    }

    @Test
    public void decodeAs_numberJson() {
        JsonNode intJson = objectMapper.valueToTree((Object)15);
        Assertions.assertEquals((Integer)15, (Integer)((Integer)JacksonCodec.decodeAs((JsonNode)intJson, Integer.class)));
        Assertions.assertEquals((Double)15.0, (Double)((Double)JacksonCodec.decodeAs((JsonNode)intJson, Double.class)));
        JsonNode doubleJson = objectMapper.valueToTree((Object)15.7);
        Assertions.assertEquals((Double)15.7, (Double)((Double)JacksonCodec.decodeAs((JsonNode)doubleJson, Double.class)));
        Assertions.assertEquals((Object)doubleJson, (Object)JacksonCodec.decodeAs((JsonNode)doubleJson, JsonNode.class));
    }

    @Test
    public void decodeAs_nullJson() {
        JsonNode json = objectMapper.nullNode();
        Assertions.assertNull((Object)JacksonCodec.decodeAs((JsonNode)json, Boolean.class));
        Assertions.assertNull((Object)JacksonCodec.decodeAs((JsonNode)json, String.class));
        Assertions.assertNull((Object)JacksonCodec.decodeAs((JsonNode)json, Integer.class));
        Assertions.assertNull((Object)JacksonCodec.decodeAs((JsonNode)json, Double.class));
        Assertions.assertNull((Object)JacksonCodec.decodeAs((JsonNode)json, JsonNode.class));
    }

    @Test
    public void decodeAs_jsonValue() {
        ObjectNode json = objectMapper.createObjectNode();
        json.put("foo", "bar");
        Assertions.assertEquals((Object)json, (Object)JacksonCodec.decodeAs((JsonNode)json, JsonNode.class));
    }

    @Test
    public void decodeAs_jsonValueWrongType_classCastException() {
        ObjectNode json = objectMapper.createObjectNode();
        json.put("foo", "bar");
        Assertions.assertThrows(ClassCastException.class, () -> JacksonCodec.decodeAs((JsonNode)json, NumericNode.class));
    }

    @Test
    public void decodeAs_unsupportedType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Assertions.assertNull((Object)JacksonCodec.decodeAs((JsonNode)objectMapper.valueToTree((Object)"foo"), Float.TYPE)));
    }

    @Test
    public void testSimpleBeanSerialization() {
        SimpleBean bean = new SimpleBean("Test", 42);
        JsonNode encoded = JacksonCodec.encodeWithTypeInfo((Object)bean);
        Assertions.assertTrue((boolean)encoded.isObject(), (String)"Should be object");
        Assertions.assertEquals((Object)"Test", (Object)encoded.get("text").asString());
        Assertions.assertEquals((int)42, (int)encoded.get("value").asInt());
    }

    @Test
    public void testNestedBeanSerialization() {
        NestedBean nested = new NestedBean("inner", 123);
        OuterBean outer = new OuterBean("outer", nested);
        JsonNode encoded = JacksonCodec.encodeWithTypeInfo((Object)outer);
        Assertions.assertTrue((boolean)encoded.isObject(), (String)"Should be object");
        Assertions.assertEquals((Object)"outer", (Object)encoded.get("name").asString());
        JsonNode nestedJson = encoded.get("nested");
        Assertions.assertEquals((Object)"inner", (Object)nestedJson.get("text").asString());
        Assertions.assertEquals((int)123, (int)nestedJson.get("number").asInt());
    }

    @Test
    public void testComplexTypeSerialization() {
        Object obj = new Object();
        JsonNode objEncoded = JacksonCodec.encodeWithTypeInfo((Object)obj);
        Assertions.assertTrue((boolean)objEncoded.isObject(), (String)"Object should serialize as JSON object");
        Assertions.assertEquals((int)0, (int)objEncoded.size(), (String)"Object should serialize as empty object");
        StateNode stateNode = new StateNode(new Class[0]);
        JsonNode stateNodeEncoded = JacksonCodec.encodeWithTypeInfo((Object)stateNode);
        Assertions.assertTrue((boolean)stateNodeEncoded.isObject(), (String)"StateNode should serialize as JSON object");
        Assertions.assertTrue((stateNodeEncoded.size() > 0 ? 1 : 0) != 0, (String)"StateNode should have properties");
        Date date = new Date(1234567890000L);
        JsonNode dateEncoded = JacksonCodec.encodeWithTypeInfo((Object)date);
        Assertions.assertTrue((dateEncoded.isNumber() || dateEncoded.isTextual() ? 1 : 0) != 0, (String)"Date should serialize as number or string");
        if (dateEncoded.isNumber()) {
            Assertions.assertEquals((long)1234567890000L, (long)dateEncoded.asLong(), (String)"Date should serialize to correct timestamp");
        }
        String[] stringArray = new String[]{"hello", "world"};
        JsonNode arrayEncoded = JacksonCodec.encodeWithTypeInfo((Object)stringArray);
        Assertions.assertTrue((boolean)arrayEncoded.isArray(), (String)"String array should serialize as JSON array");
        Assertions.assertEquals((int)2, (int)arrayEncoded.size(), (String)"Array should have correct length");
        Assertions.assertEquals((Object)"hello", (Object)arrayEncoded.get(0).asString(), (String)"First element should be correct");
        Assertions.assertEquals((Object)"world", (Object)arrayEncoded.get(1).asString(), (String)"Second element should be correct");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("item1");
        arrayList.add("item2");
        JsonNode listEncoded = JacksonCodec.encodeWithTypeInfo(arrayList);
        Assertions.assertTrue((boolean)listEncoded.isArray(), (String)"ArrayList should serialize as JSON array");
        Assertions.assertEquals((int)2, (int)listEncoded.size(), (String)"List should have correct size");
        Assertions.assertEquals((Object)"item1", (Object)listEncoded.get(0).asString(), (String)"First list item should be correct");
        Assertions.assertEquals((Object)"item2", (Object)listEncoded.get(1).asString(), (String)"Second list item should be correct");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("value1");
        hashSet.add("value2");
        JsonNode setEncoded = JacksonCodec.encodeWithTypeInfo(hashSet);
        Assertions.assertTrue((boolean)setEncoded.isArray(), (String)"HashSet should serialize as JSON array");
        Assertions.assertEquals((int)2, (int)setEncoded.size(), (String)"Set should have correct size");
        boolean hasValue1 = false;
        boolean hasValue2 = false;
        for (JsonNode node : setEncoded) {
            String value = node.asString();
            if ("value1".equals(value)) {
                hasValue1 = true;
            }
            if (!"value2".equals(value)) continue;
            hasValue2 = true;
        }
        Assertions.assertTrue((boolean)hasValue1, (String)"Set should contain value1");
        Assertions.assertTrue((boolean)hasValue2, (String)"Set should contain value2");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("key1", "stringValue");
        hashMap.put("key2", 42);
        hashMap.put("key3", true);
        JsonNode mapEncoded = JacksonCodec.encodeWithTypeInfo(hashMap);
        Assertions.assertTrue((boolean)mapEncoded.isObject(), (String)"HashMap should serialize as JSON object");
        Assertions.assertEquals((int)3, (int)mapEncoded.size(), (String)"Map should have correct size");
        Assertions.assertEquals((Object)"stringValue", (Object)mapEncoded.get("key1").asString(), (String)"String value should be correct");
        Assertions.assertEquals((int)42, (int)mapEncoded.get("key2").asInt(), (String)"Integer value should be correct");
        Assertions.assertEquals((Object)true, (Object)mapEncoded.get("key3").asBoolean(), (String)"Boolean value should be correct");
    }

    @Test
    public void testDecodeAsSimpleBean() {
        ObjectNode json = objectMapper.createObjectNode();
        json.put("text", "TestBean");
        json.put("value", 42);
        SimpleBean decoded = (SimpleBean)JacksonCodec.decodeAs((JsonNode)json, SimpleBean.class);
        Assertions.assertEquals((Object)"TestBean", (Object)decoded.text);
        Assertions.assertEquals((int)42, (int)decoded.value);
    }

    @Test
    public void testDecodeAsNestedBean() {
        ObjectNode nestedJson = objectMapper.createObjectNode();
        nestedJson.put("text", "NestedTest");
        nestedJson.put("number", 456);
        ObjectNode outerJson = objectMapper.createObjectNode();
        outerJson.put("name", "OuterTest");
        outerJson.set("nested", (JsonNode)nestedJson);
        OuterBean decoded = (OuterBean)JacksonCodec.decodeAs((JsonNode)outerJson, OuterBean.class);
        Assertions.assertEquals((Object)"OuterTest", (Object)decoded.name);
        Assertions.assertEquals((Object)"NestedTest", (Object)decoded.nested.text);
        Assertions.assertEquals((int)456, (int)decoded.nested.number);
    }

    @Test
    public void testDecodeAsNullValue() {
        JsonNode nullNode = objectMapper.nullNode();
        SimpleBean decoded = (SimpleBean)JacksonCodec.decodeAs((JsonNode)nullNode, SimpleBean.class);
        Assertions.assertNull((Object)decoded);
    }

    @Test
    public void testDecodeAsInvalidJson() {
        JsonNode invalidJson = objectMapper.valueToTree((Object)"not an object");
        try {
            JacksonCodec.decodeAs((JsonNode)invalidJson, SimpleBean.class);
            Assertions.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Cannot deserialize JSON to type"));
        }
    }

    @Test
    public void testDecodeAsForPrimitiveTypes() {
        Assertions.assertEquals((Object)"test", (Object)JacksonCodec.decodeAs((JsonNode)objectMapper.valueToTree((Object)"test"), String.class));
        Assertions.assertEquals((Integer)42, (Integer)((Integer)JacksonCodec.decodeAs((JsonNode)objectMapper.valueToTree((Object)42), Integer.class)));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)JacksonCodec.decodeAs((JsonNode)objectMapper.valueToTree((Object)true), Boolean.class));
        Assertions.assertEquals((Double)3.14, (Double)((Double)JacksonCodec.decodeAs((JsonNode)objectMapper.valueToTree((Object)3.14), Double.class)));
    }

    @Test
    public void testListOfBeansSerialization() {
        List<SimpleBean> beanList = Arrays.asList(new SimpleBean("First", 1), new SimpleBean("Second", 2), new SimpleBean("Third", 3));
        JsonNode encoded = JacksonCodec.encodeWithTypeInfo(beanList);
        Assertions.assertTrue((boolean)encoded.isArray(), (String)"Should be array");
        Assertions.assertEquals((int)3, (int)encoded.size(), (String)"Should have 3 beans");
        Assertions.assertEquals((Object)"First", (Object)encoded.get(0).get("text").asString());
        Assertions.assertEquals((int)1, (int)encoded.get(0).get("value").asInt());
        Assertions.assertEquals((Object)"Second", (Object)encoded.get(1).get("text").asString());
        Assertions.assertEquals((int)2, (int)encoded.get(1).get("value").asInt());
        Assertions.assertEquals((Object)"Third", (Object)encoded.get(2).get("text").asString());
        Assertions.assertEquals((int)3, (int)encoded.get(2).get("value").asInt());
    }

    @Test
    public void testListOfBeansDeserialization() {
        ObjectNode bean1 = objectMapper.createObjectNode();
        bean1.put("text", "FirstBean");
        bean1.put("value", 100);
        ObjectNode bean2 = objectMapper.createObjectNode();
        bean2.put("text", "SecondBean");
        bean2.put("value", 200);
        ArrayNode arrayJson = objectMapper.createArrayNode().add((JsonNode)bean1).add((JsonNode)bean2);
        List decoded = (List)JacksonUtils.getMapper().convertValue((Object)arrayJson, (JavaType)JacksonUtils.getMapper().getTypeFactory().constructCollectionType(List.class, SimpleBean.class));
        Assertions.assertEquals((int)2, (int)decoded.size(), (String)"Should have 2 elements");
        Assertions.assertEquals((Object)"FirstBean", (Object)((SimpleBean)decoded.get((int)0)).text);
        Assertions.assertEquals((int)100, (int)((SimpleBean)decoded.get((int)0)).value);
        Assertions.assertEquals((Object)"SecondBean", (Object)((SimpleBean)decoded.get((int)1)).text);
        Assertions.assertEquals((int)200, (int)((SimpleBean)decoded.get((int)1)).value);
    }

    @Test
    public void testSetOfBeansSerialization() {
        HashSet<SimpleBean> beanSet = new HashSet<SimpleBean>(Arrays.asList(new SimpleBean("Alpha", 10), new SimpleBean("Beta", 20)));
        JsonNode encoded = JacksonCodec.encodeWithTypeInfo(beanSet);
        Assertions.assertTrue((boolean)encoded.isArray(), (String)"Should be array");
        Assertions.assertEquals((int)2, (int)encoded.size(), (String)"Should have 2 elements");
        HashSet<String> texts = new HashSet<String>();
        HashSet<Integer> values = new HashSet<Integer>();
        for (JsonNode node : encoded) {
            texts.add(node.get("text").asString());
            values.add(node.get("value").asInt());
        }
        Assertions.assertTrue((boolean)texts.contains("Alpha"), (String)"Should contain Alpha");
        Assertions.assertTrue((boolean)texts.contains("Beta"), (String)"Should contain Beta");
        Assertions.assertTrue((boolean)values.contains(10), (String)"Should contain value 10");
        Assertions.assertTrue((boolean)values.contains(20), (String)"Should contain value 20");
    }

    @Test
    public void testSetOfBeansDeserialization() {
        ObjectNode bean1 = objectMapper.createObjectNode();
        bean1.put("text", "Gamma");
        bean1.put("value", 300);
        ObjectNode bean2 = objectMapper.createObjectNode();
        bean2.put("text", "Delta");
        bean2.put("value", 400);
        ArrayNode arrayJson = objectMapper.createArrayNode().add((JsonNode)bean1).add((JsonNode)bean2);
        Set decoded = (Set)JacksonUtils.getMapper().convertValue((Object)arrayJson, (JavaType)JacksonUtils.getMapper().getTypeFactory().constructCollectionType(Set.class, SimpleBean.class));
        Assertions.assertEquals((int)2, (int)decoded.size(), (String)"Should have 2 elements");
        Set texts = decoded.stream().map(b -> b.text).collect(Collectors.toSet());
        Set values = decoded.stream().map(b -> b.value).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)texts.contains("Gamma"), (String)"Should contain Gamma");
        Assertions.assertTrue((boolean)texts.contains("Delta"), (String)"Should contain Delta");
        Assertions.assertTrue((boolean)values.contains(300), (String)"Should contain value 300");
        Assertions.assertTrue((boolean)values.contains(400), (String)"Should contain value 400");
    }

    @Test
    public void testListOfIntegersSerialization() {
        List<Integer> integerList = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        JsonNode encoded = JacksonCodec.encodeWithTypeInfo(integerList);
        Assertions.assertTrue((boolean)encoded.isArray(), (String)"Should be array");
        Assertions.assertEquals((int)3, (int)encoded.size(), (String)"Should have 3 integers");
        Assertions.assertEquals((int)1, (int)encoded.get(0).asInt());
        Assertions.assertEquals((int)2, (int)encoded.get(1).asInt());
        Assertions.assertEquals((int)3, (int)encoded.get(2).asInt());
    }

    @Test
    public void testMapOfBeansSerialization() {
        HashMap<String, SimpleBean> beanMap = new HashMap<String, SimpleBean>();
        beanMap.put("first", new SimpleBean("FirstBean", 100));
        beanMap.put("second", new SimpleBean("SecondBean", 200));
        beanMap.put("third", new SimpleBean("ThirdBean", 300));
        JsonNode encoded = JacksonCodec.encodeWithTypeInfo(beanMap);
        Assertions.assertTrue((boolean)encoded.isObject(), (String)"Should be object");
        Assertions.assertEquals((int)3, (int)encoded.size(), (String)"Should have 3 entries");
        Assertions.assertEquals((Object)"FirstBean", (Object)encoded.get("first").get("text").asString());
        Assertions.assertEquals((int)100, (int)encoded.get("first").get("value").asInt());
        Assertions.assertEquals((Object)"SecondBean", (Object)encoded.get("second").get("text").asString());
        Assertions.assertEquals((int)200, (int)encoded.get("second").get("value").asInt());
        Assertions.assertEquals((Object)"ThirdBean", (Object)encoded.get("third").get("text").asString());
        Assertions.assertEquals((int)300, (int)encoded.get("third").get("value").asInt());
    }

    @Test
    public void testMapOfBeansDeserialization() {
        ObjectNode bean1 = objectMapper.createObjectNode();
        bean1.put("text", "Alpha");
        bean1.put("value", 111);
        ObjectNode bean2 = objectMapper.createObjectNode();
        bean2.put("text", "Beta");
        bean2.put("value", 222);
        ObjectNode mapJson = objectMapper.createObjectNode();
        mapJson.set("keyA", (JsonNode)bean1);
        mapJson.set("keyB", (JsonNode)bean2);
        Map decoded = (Map)JacksonUtils.getMapper().convertValue((Object)mapJson, (JavaType)JacksonUtils.getMapper().getTypeFactory().constructMapType(Map.class, String.class, SimpleBean.class));
        Assertions.assertEquals((int)2, (int)decoded.size(), (String)"Should have 2 entries");
        Assertions.assertNotNull(decoded.get("keyA"), (String)"Should have keyA");
        Assertions.assertEquals((Object)"Alpha", (Object)((SimpleBean)decoded.get((Object)"keyA")).text);
        Assertions.assertEquals((int)111, (int)((SimpleBean)decoded.get((Object)"keyA")).value);
        Assertions.assertNotNull(decoded.get("keyB"), (String)"Should have keyB");
        Assertions.assertEquals((Object)"Beta", (Object)((SimpleBean)decoded.get((Object)"keyB")).text);
        Assertions.assertEquals((int)222, (int)((SimpleBean)decoded.get((Object)"keyB")).value);
    }

    @Test
    public void testNestedMapSerialization() {
        HashMap<String, Object> nestedMap = new HashMap<String, Object>();
        nestedMap.put("bean", new SimpleBean("NestedBean", 999));
        nestedMap.put("number", 42);
        nestedMap.put("text", "Hello");
        HashMap<String, Object> outerMap = new HashMap<String, Object>();
        outerMap.put("nested", nestedMap);
        outerMap.put("simple", "value");
        JsonNode encoded = JacksonCodec.encodeWithTypeInfo(outerMap);
        Assertions.assertTrue((boolean)encoded.isObject(), (String)"Should be object");
        Assertions.assertEquals((int)2, (int)encoded.size(), (String)"Should have 2 entries");
        Assertions.assertEquals((Object)"value", (Object)encoded.get("simple").asString());
        JsonNode nestedJson = encoded.get("nested");
        Assertions.assertTrue((boolean)nestedJson.isObject(), (String)"Nested should be object");
        Assertions.assertEquals((int)42, (int)nestedJson.get("number").asInt());
        Assertions.assertEquals((Object)"Hello", (Object)nestedJson.get("text").asString());
        Assertions.assertEquals((Object)"NestedBean", (Object)nestedJson.get("bean").get("text").asString());
        Assertions.assertEquals((int)999, (int)nestedJson.get("bean").get("value").asInt());
    }

    @Test
    public void testListOfComponentElementsSerialization() {
        Element element1 = ElementFactory.createDiv();
        Element element2 = ElementFactory.createDiv();
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add(0, element1.getNode());
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add(1, element2.getNode());
        List<Element> elementList = Arrays.asList(element1, element2);
        JsonNode listEncoded = JacksonCodec.encodeWithTypeInfo(elementList);
        Assertions.assertTrue((boolean)listEncoded.isArray(), (String)"Should be array");
        Assertions.assertEquals((int)2, (int)listEncoded.size(), (String)"Should have 2 elements");
        JsonNode element1Json = listEncoded.get(0);
        Assertions.assertTrue((boolean)element1Json.isObject(), (String)"First element should be object");
        Assertions.assertTrue((boolean)element1Json.has("@v-node"), (String)"First element should have @v-node");
        Assertions.assertEquals((int)element1.getNode().getId(), (int)element1Json.get("@v-node").asInt());
        JsonNode element2Json = listEncoded.get(1);
        Assertions.assertTrue((boolean)element2Json.isObject(), (String)"Second element should be object");
        Assertions.assertTrue((boolean)element2Json.has("@v-node"), (String)"Second element should have @v-node");
        Assertions.assertEquals((int)element2.getNode().getId(), (int)element2Json.get("@v-node").asInt());
    }

    @Test
    public void testBeanWithComponentSerialization() {
        TestComponent component = new TestComponent();
        BeanWithComponent bean = new BeanWithComponent("TestComponent", component, 42);
        List<BeanWithComponent> beanList = Arrays.asList(bean);
        JsonNode listEncoded = JacksonCodec.encodeWithTypeInfo(beanList);
        Assertions.assertTrue((boolean)listEncoded.isArray(), (String)"Should be array");
        Assertions.assertEquals((int)1, (int)listEncoded.size(), (String)"Should have 1 bean");
        JsonNode beanJson = listEncoded.get(0);
        Assertions.assertTrue((boolean)beanJson.isObject(), (String)"Bean should serialize as object");
        Assertions.assertEquals((Object)"TestComponent", (Object)beanJson.get("name").asString());
        Assertions.assertEquals((int)42, (int)beanJson.get("value").asInt());
        Assertions.assertTrue((boolean)beanJson.has("component"), (String)"Bean should have component field");
        JsonNode componentJson = beanJson.get("component");
        Assertions.assertTrue((boolean)componentJson.isNull(), (String)"Detached component should serialize as null");
    }

    @Test
    public void testArrayWithComponentsSerialization() {
        TestComponent component1 = new TestComponent();
        TestComponent component2 = new TestComponent();
        TestComponent[] componentArray = new TestComponent[]{component1, component2};
        JsonNode encoded = JacksonCodec.encodeWithTypeInfo((Object)componentArray);
        Assertions.assertTrue((boolean)encoded.isArray(), (String)"Should be array");
        Assertions.assertEquals((int)2, (int)encoded.size(), (String)"Should have 2 components");
        JsonNode first = encoded.get(0);
        Assertions.assertTrue((boolean)first.isNull(), (String)"First detached component should be null");
        JsonNode second = encoded.get(1);
        Assertions.assertTrue((boolean)second.isNull(), (String)"Second detached component should be null");
    }

    @Test
    public void testListOfBeansWithComponentsSerialization() {
        TestComponent component1 = new TestComponent();
        TestComponent component2 = new TestComponent();
        List<BeanWithComponent> beanList = Arrays.asList(new BeanWithComponent("First", component1, 10), new BeanWithComponent("Second", component2, 20));
        JsonNode encoded = JacksonCodec.encodeWithTypeInfo(beanList);
        Assertions.assertTrue((boolean)encoded.isArray(), (String)"Should be array");
        Assertions.assertEquals((int)2, (int)encoded.size(), (String)"Should have 2 beans");
        JsonNode firstBean = encoded.get(0);
        Assertions.assertEquals((Object)"First", (Object)firstBean.get("name").asString());
        Assertions.assertEquals((int)10, (int)firstBean.get("value").asInt());
        Assertions.assertTrue((boolean)firstBean.has("component"), (String)"First bean should have component");
        JsonNode firstComponent = firstBean.get("component");
        Assertions.assertTrue((boolean)firstComponent.isNull(), (String)"First detached component should be null");
        JsonNode secondBean = encoded.get(1);
        Assertions.assertEquals((Object)"Second", (Object)secondBean.get("name").asString());
        Assertions.assertEquals((int)20, (int)secondBean.get("value").asInt());
        Assertions.assertTrue((boolean)secondBean.has("component"), (String)"Second bean should have component");
        JsonNode secondComponent = secondBean.get("component");
        Assertions.assertTrue((boolean)secondComponent.isNull(), (String)"Second detached component should be null");
    }

    @Test
    public void testTypeReferenceListDeserialization() {
        ObjectNode bean1 = objectMapper.createObjectNode();
        bean1.put("text", "FirstBean");
        bean1.put("value", 100);
        ObjectNode bean2 = objectMapper.createObjectNode();
        bean2.put("text", "SecondBean");
        bean2.put("value", 200);
        ArrayNode arrayJson = objectMapper.createArrayNode().add((JsonNode)bean1).add((JsonNode)bean2);
        TypeReference<List<SimpleBean>> typeRef = new TypeReference<List<SimpleBean>>(this){};
        List result = (List)JacksonCodec.decodeAs((JsonNode)arrayJson, (TypeReference)typeRef);
        Assertions.assertNotNull((Object)result, (String)"Result should not be null");
        Assertions.assertEquals((int)2, (int)result.size(), (String)"Should have 2 elements");
        Assertions.assertEquals((Object)"FirstBean", (Object)((SimpleBean)result.get((int)0)).text);
        Assertions.assertEquals((int)100, (int)((SimpleBean)result.get((int)0)).value);
        Assertions.assertEquals((Object)"SecondBean", (Object)((SimpleBean)result.get((int)1)).text);
        Assertions.assertEquals((int)200, (int)((SimpleBean)result.get((int)1)).value);
    }

    @Test
    public void testTypeReferenceMapDeserialization() {
        ObjectNode bean1 = objectMapper.createObjectNode();
        bean1.put("text", "Alpha");
        bean1.put("value", 111);
        ObjectNode bean2 = objectMapper.createObjectNode();
        bean2.put("text", "Beta");
        bean2.put("value", 222);
        ObjectNode mapJson = objectMapper.createObjectNode();
        mapJson.set("keyA", (JsonNode)bean1);
        mapJson.set("keyB", (JsonNode)bean2);
        TypeReference<Map<String, SimpleBean>> typeRef = new TypeReference<Map<String, SimpleBean>>(this){};
        Map result = (Map)JacksonCodec.decodeAs((JsonNode)mapJson, (TypeReference)typeRef);
        Assertions.assertNotNull((Object)result, (String)"Result should not be null");
        Assertions.assertEquals((int)2, (int)result.size(), (String)"Should have 2 entries");
        Assertions.assertEquals((Object)"Alpha", (Object)((SimpleBean)result.get((Object)"keyA")).text);
        Assertions.assertEquals((int)111, (int)((SimpleBean)result.get((Object)"keyA")).value);
        Assertions.assertEquals((Object)"Beta", (Object)((SimpleBean)result.get((Object)"keyB")).text);
        Assertions.assertEquals((int)222, (int)((SimpleBean)result.get((Object)"keyB")).value);
    }

    @Test
    public void testTypeReferenceNestedList() {
        ObjectNode innerBean = objectMapper.createObjectNode();
        innerBean.put("text", "Nested");
        innerBean.put("value", 999);
        ObjectNode innerMap = objectMapper.createObjectNode();
        innerMap.set("item", (JsonNode)innerBean);
        ArrayNode outerArray = objectMapper.createArrayNode().add((JsonNode)innerMap);
        TypeReference<List<Map<String, SimpleBean>>> typeRef = new TypeReference<List<Map<String, SimpleBean>>>(this){};
        List result = (List)JacksonCodec.decodeAs((JsonNode)outerArray, (TypeReference)typeRef);
        Assertions.assertNotNull((Object)result, (String)"Result should not be null");
        Assertions.assertEquals((int)1, (int)result.size(), (String)"Should have 1 element");
        Assertions.assertTrue((boolean)((Map)result.get(0)).containsKey("item"), (String)"First element should have 'item' key");
        Assertions.assertEquals((Object)"Nested", (Object)((SimpleBean)((Map)result.get((int)0)).get((Object)"item")).text);
        Assertions.assertEquals((int)999, (int)((SimpleBean)((Map)result.get((int)0)).get((Object)"item")).value);
    }

    @Test
    public void testTypeReferenceNullHandling() {
        JsonNode nullJson = objectMapper.nullNode();
        TypeReference<List<SimpleBean>> typeRef = new TypeReference<List<SimpleBean>>(this){};
        List result = (List)JacksonCodec.decodeAs((JsonNode)nullJson, (TypeReference)typeRef);
        Assertions.assertNull((Object)result, (String)"Null JSON should deserialize to null");
    }

    @Test
    public void testTypeReferenceListOfPrimitives() {
        ArrayNode arrayJson = objectMapper.createArrayNode().add(10).add(20).add(30);
        TypeReference<List<Integer>> typeRef = new TypeReference<List<Integer>>(this){};
        List result = (List)JacksonCodec.decodeAs((JsonNode)arrayJson, (TypeReference)typeRef);
        Assertions.assertNotNull((Object)result, (String)"Result should not be null");
        Assertions.assertEquals((int)3, (int)result.size(), (String)"Should have 3 elements");
        Assertions.assertEquals((Integer)10, (Integer)((Integer)result.get(0)));
        Assertions.assertEquals((Integer)20, (Integer)((Integer)result.get(1)));
        Assertions.assertEquals((Integer)30, (Integer)((Integer)result.get(2)));
    }

    @Test
    public void testNestedRecordDeserialization() {
        ObjectNode eventNode = objectMapper.createObjectNode();
        eventNode.put("button", 0);
        eventNode.put("clientX", 150);
        eventNode.put("clientY", 200);
        ObjectNode rootNode = objectMapper.createObjectNode();
        rootNode.set("event", (JsonNode)eventNode);
        rootNode.put("type", "click");
        record MouseEventData(EventDetails event, String type) {
            private final EventDetails event;

            MouseEventData {
                record EventDetails(int button, int clientX, int clientY) {
                }
            }

            public EventDetails event() {
                return this.event;
            }
        }
        MouseEventData result = (MouseEventData)JacksonCodec.decodeAs((JsonNode)rootNode, MouseEventData.class);
        Assertions.assertNotNull((Object)result, (String)"Result should not be null");
        Assertions.assertEquals((Object)"click", (Object)result.type(), (String)"Type should match");
        Assertions.assertNotNull((Object)result.event(), (String)"Event should not be null");
        Assertions.assertEquals((int)0, (int)result.event().button(), (String)"Button should be 0");
        Assertions.assertEquals((int)150, (int)result.event().clientX(), (String)"ClientX should be 150");
        Assertions.assertEquals((int)200, (int)result.event().clientY(), (String)"ClientY should be 200");
    }

    @Test
    public void testNestedRecordWithTypeReference() {
        ObjectNode point1 = objectMapper.createObjectNode();
        point1.put("x", 10);
        point1.put("y", 20);
        ObjectNode point2 = objectMapper.createObjectNode();
        point2.put("x", 30);
        point2.put("y", 40);
        ArrayNode arrayJson = objectMapper.createArrayNode().add((JsonNode)point1).add((JsonNode)point2);
        TypeReference<List<Point>> typeRef = new TypeReference<List<Point>>(this){};
        List result = (List)JacksonCodec.decodeAs((JsonNode)arrayJson, (TypeReference)typeRef);
        Assertions.assertNotNull((Object)result, (String)"Result should not be null");
        Assertions.assertEquals((int)2, (int)result.size(), (String)"Should have 2 points");
        record Point(int x, int y) {
        }
        Assertions.assertEquals((int)10, (int)((Point)result.get(0)).x());
        Assertions.assertEquals((int)20, (int)((Point)result.get(0)).y());
        Assertions.assertEquals((int)30, (int)((Point)result.get(1)).x());
        Assertions.assertEquals((int)40, (int)((Point)result.get(1)).y());
    }

    private static class SimpleBean {
        public String text;
        public int value;

        public SimpleBean() {
        }

        public SimpleBean(String text, int value) {
            this.text = text;
            this.value = value;
        }
    }

    private static class NestedBean {
        public String text;
        public int number;

        public NestedBean() {
        }

        public NestedBean(String text, int number) {
            this.text = text;
            this.number = number;
        }
    }

    private static class OuterBean {
        public String name;
        public NestedBean nested;

        public OuterBean() {
        }

        public OuterBean(String name, NestedBean nested) {
            this.name = name;
            this.nested = nested;
        }
    }

    public static class TestComponent
    extends Component {
        public TestComponent() {
            super(ElementFactory.createDiv());
        }
    }

    public static class BeanWithComponent {
        public String name;
        public TestComponent component;
        public int value;

        public BeanWithComponent() {
        }

        public BeanWithComponent(String name, TestComponent component, int value) {
            this.name = name;
            this.component = component;
            this.value = value;
        }
    }
}

