/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ElementBindVisibleTest
extends SignalsUnitTest {
    ElementBindVisibleTest() {
    }

    @Test
    public void bindVisible_elementAttachedBefore_bindingActive() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assertions.assertTrue((boolean)element.isVisible());
        ValueSignal signal = new ValueSignal((Object)false);
        element.bindVisible((Signal)signal);
        Assertions.assertFalse((boolean)element.isVisible());
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindVisible_elementAttachedAfter_bindingActive() {
        Element element = new Element("foo");
        Assertions.assertTrue((boolean)element.isVisible());
        ValueSignal signal = new ValueSignal((Object)false);
        element.bindVisible((Signal)signal);
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assertions.assertFalse((boolean)element.isVisible());
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindVisible_elementAttached_bindingActive() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)false);
        element.bindVisible((Signal)signal);
        Assertions.assertFalse((boolean)element.isVisible());
        signal.set((Object)true);
        Assertions.assertTrue((boolean)element.isVisible());
        signal.set(null);
        Assertions.assertFalse((boolean)element.isVisible());
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindVisible_elementNotAttached_bindingInactive() {
        Element element = new Element("foo");
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindVisible((Signal)signal);
        signal.set((Object)false);
        Assertions.assertTrue((boolean)element.isVisible());
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindVisible_elementDetached_bindingInactive() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindVisible((Signal)signal);
        element.removeFromParent();
        signal.set((Object)false);
        Assertions.assertTrue((boolean)element.isVisible());
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindVisible_elementReAttached_bindingActivate() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindVisible((Signal)signal);
        element.removeFromParent();
        signal.set((Object)false);
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assertions.assertFalse((boolean)element.isVisible());
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindVisible_setVisibleAndBindVisibleWhileBindingIsActive_throwException() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        element.bindVisible((Signal)new ValueSignal((Object)true));
        Assertions.assertThrows(BindingActiveException.class, () -> element.setVisible(false));
        Assertions.assertThrows(BindingActiveException.class, () -> element.bindVisible((Signal)new ValueSignal((Object)true)));
        Assertions.assertTrue((boolean)element.isVisible());
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindVisible_nullSignal_throwsNPE() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assertions.assertThrows(NullPointerException.class, () -> element.bindVisible(null));
    }
}

