/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.webcomponent.WebComponent;
import com.vaadin.flow.component.webcomponent.WebComponentUI;
import com.vaadin.flow.component.webcomponent.WebComponentWrapper;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.MockInstantiator;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.webcomponent.WebComponentBinding;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;

class WebComponentWrapperTest {
    private static final String MSG_PROPERTY = "message";
    private static final String INT_PROPERTY = "integer-value";
    private static final String BOOLEAN_PROPERTY = "boolean-value";
    private Element element;
    private MyComponent component;
    private WebComponentBinding<MyComponent> binding;
    private WebComponentExporter<MyComponent> exporter;
    private WebComponentWrapper wrapper;

    WebComponentWrapperTest() {
    }

    @BeforeEach
    public void init() {
        this.element = new Element("tag");
        this.exporter = new MyComponentExporter();
        this.binding = new WebComponentExporter.WebComponentConfigurationFactory().create(this.exporter).createWebComponentBinding((Instantiator)new MockInstantiator(new VaadinServiceInitListener[0]), this.element, (JsonNode)JacksonUtils.createObjectNode());
        this.wrapper = new WebComponentWrapper(this.element, this.binding);
        this.component = (MyComponent)this.binding.getComponent();
    }

    @Test
    public void wrappedMyComponent_syncSetsCorrectValuesToFields() {
        this.wrapper.sync(MSG_PROPERTY, JacksonUtils.writeValue((Object)"MyMessage"));
        Assertions.assertEquals((Object)"MyMessage", (Object)this.component.message, (String)"Message field should have updated with new value");
        this.wrapper.sync(INT_PROPERTY, JacksonUtils.writeValue((Object)10));
        Assertions.assertEquals((int)10, (int)this.component.integerValue, (String)"IntegerValue field should contain a matching integer value");
    }

    @Test
    public void wrappedComponentPropertyListener_listenerFiredWithCorrectValuesOnSync() {
        this.wrapper.sync(MSG_PROPERTY, JacksonUtils.writeValue((Object)"one"));
        this.wrapper.sync(INT_PROPERTY, JacksonUtils.writeValue((Object)2));
        this.wrapper.sync(MSG_PROPERTY, JacksonUtils.writeValue((Object)"three"));
        this.wrapper.sync(INT_PROPERTY, JacksonUtils.writeValue((Object)4));
        Assertions.assertEquals((int)3, (int)this.component.oldMessages.size(), (String)"Three string messages should have come through");
        Assertions.assertEquals((int)3, (int)this.component.oldIntegers.size(), (String)"Three integer messages should have come through");
        Assertions.assertEquals(Arrays.asList("", "one", "three"), this.component.oldMessages, (String)"String messages arrived in correct order");
        Assertions.assertEquals(Arrays.asList(0, 2, 4), this.component.oldIntegers, (String)"Integer messages arrived in correct order");
    }

    @Test
    public void exportingExtendedComponent_inheritedFieldsAreAvailableAndOverridden() {
        WebComponentBinding<MyExtension> binding = this.constructWrapperAndGetBinding(new MyExtensionExporter(), null, null);
        MyExtension component = (MyExtension)binding.getComponent();
        this.wrapper.sync(MSG_PROPERTY, JacksonUtils.writeValue((Object)"one"));
        this.wrapper.sync(INT_PROPERTY, JacksonUtils.writeValue((Object)2));
        this.wrapper.sync(MSG_PROPERTY, JacksonUtils.writeValue((Object)"three"));
        this.wrapper.sync(INT_PROPERTY, JacksonUtils.writeValue((Object)4));
        Assertions.assertEquals((int)3, (int)component.oldMessages.size(), (String)"Three string messages should have come through");
        Assertions.assertEquals((int)3, (int)component.oldIntegers.size(), (String)"Three integer messages should have come through");
        Assertions.assertEquals(Arrays.asList("Extended ", "Extended one", "Extended three"), (Object)component.oldMessages, (String)"String messages arrived in correct order");
        Assertions.assertEquals(Arrays.asList(0, 2, 4), (Object)component.oldIntegers, (String)"Integer messages arrived in correct order");
    }

    @Test
    public void extendedExporter_propertiesAreOverwrittenAndAvailable() {
        WebComponentBinding<MyComponent> binding = this.constructWrapperAndGetBinding(new ExtendedExporter(), null, null);
        MyComponent component = (MyComponent)binding.getComponent();
        this.wrapper.sync(MSG_PROPERTY, JacksonUtils.writeValue((Object)"one"));
        this.wrapper.sync(INT_PROPERTY, JacksonUtils.writeValue((Object)2));
        this.wrapper.sync(MSG_PROPERTY, JacksonUtils.writeValue((Object)"three"));
        this.wrapper.sync(INT_PROPERTY, JacksonUtils.writeValue((Object)4));
        this.wrapper.sync(BOOLEAN_PROPERTY, JacksonUtils.writeValue((Object)true));
        Assertions.assertEquals((int)3, (int)component.oldMessages.size(), (String)"Three string messages should have come through");
        Assertions.assertEquals((int)3, (int)component.oldIntegers.size(), (String)"Three integer messages should have come through");
        Assertions.assertEquals(Arrays.asList("Default", "one", "three"), component.oldMessages, (String)"String messages arrived in correct order");
        Assertions.assertEquals(Arrays.asList(0, 2, 4), component.oldIntegers, (String)"Integer messages arrived in correct order");
        Assertions.assertTrue((boolean)component.booleanValue, (String)"Boolean property should have been set to true");
    }

    @Test
    public void disconnectReconnect_componentIsNotCleaned() {
        Element element = new Element("tag");
        WebComponentUI ui = WebComponentWrapperTest.constructWebComponentUI(element);
        this.constructWrapperAndGetBinding(new MyComponentExporter(), element, ui);
        UIInternals internals = ui.getInternals();
        this.wrapper.disconnected();
        internals.setLastHeartbeatTimestamp(System.currentTimeMillis());
        Assertions.assertTrue((boolean)this.wrapper.getParent().isPresent(), (String)"Wrapper should still be connected on the server");
        this.wrapper.reconnect();
        internals.setLastHeartbeatTimestamp(System.currentTimeMillis() + 1200L);
        Assertions.assertTrue((boolean)this.wrapper.getParent().isPresent(), (String)"Wrapper should stay connected on the server");
    }

    @Test
    public void disconnectOnClient_componentIsCleaned() {
        Element element = new Element("tag");
        WebComponentUI ui = WebComponentWrapperTest.constructWebComponentUI(element);
        this.constructWrapperAndGetBinding(new MyComponentExporter(), element, ui);
        UIInternals internals = ui.getInternals();
        this.wrapper.disconnected();
        internals.setLastHeartbeatTimestamp(System.currentTimeMillis());
        Assertions.assertTrue((boolean)this.wrapper.getParent().isPresent(), (String)"Wrapper should still be connected on the server");
        internals.setLastHeartbeatTimestamp(System.currentTimeMillis() + 1200L);
        Assertions.assertFalse((boolean)this.wrapper.getParent().isPresent(), (String)"Wrapper should have been disconnected also on the server");
    }

    private <C extends Component> WebComponentBinding<C> constructWrapperAndGetBinding(WebComponentExporter<C> exporter, Element element, final WebComponentUI ui) {
        if (element == null) {
            element = new Element("tag");
        }
        WebComponentBinding binding = new WebComponentExporter.WebComponentConfigurationFactory().create(exporter).createWebComponentBinding((Instantiator)new MockInstantiator(new VaadinServiceInitListener[0]), element, (JsonNode)JacksonUtils.createObjectNode());
        this.wrapper = new WebComponentWrapper(element, binding){

            public Optional<UI> getUI() {
                return Optional.of(ui);
            }
        };
        return binding;
    }

    private static WebComponentUI constructWebComponentUI(Element wrapperElement) {
        WebComponentUI ui = (WebComponentUI)Mockito.mock(WebComponentUI.class);
        Mockito.when((Object)ui.getUI()).thenReturn(Optional.of(ui));
        Element body = new Element("body");
        Mockito.when((Object)ui.getElement()).thenReturn((Object)body);
        UIInternals internals = new UIInternals((UI)ui);
        internals.setSession((VaadinSession)new AlwaysLockedVaadinSession((VaadinService)new MockVaadinServletService()));
        Mockito.when((Object)ui.getInternals()).thenReturn((Object)internals);
        Parent parent = new Parent();
        parent.getElement().appendVirtualChild(new Element[]{wrapperElement});
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)ui.getSession()).thenReturn((Object)session);
        Mockito.when((Object)session.getConfiguration()).thenReturn((Object)configuration);
        Mockito.when((Object)configuration.getWebComponentDisconnect()).thenReturn((Object)1);
        return ui;
    }

    public static class MyComponentExporter
    extends WebComponentExporter<MyComponent> {
        public MyComponentExporter() {
            this("my-component");
        }

        protected MyComponentExporter(String tag) {
            super(tag);
            this.addProperty(WebComponentWrapperTest.MSG_PROPERTY, "").onChange(MyComponent::setMessage);
            this.addProperty(WebComponentWrapperTest.INT_PROPERTY, 0).onChange(MyComponent::setIntegerValue);
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    @Tag(value="my-component")
    public static class MyComponent
    extends Component {
        ArrayList<String> oldMessages = new ArrayList();
        ArrayList<Integer> oldIntegers = new ArrayList();
        protected String message;
        int integerValue;
        boolean booleanValue;

        public MyComponent() {
            super(new Element("div"));
        }

        public void setMessage(String message) {
            this.oldMessages.add(message);
            this.message = message;
        }

        public void setIntegerValue(int integerValue) {
            this.oldIntegers.add(integerValue);
            this.integerValue = integerValue;
        }

        public void setBooleanValue(boolean value) {
            this.booleanValue = value;
        }
    }

    public static class MyExtensionExporter
    extends WebComponentExporter<MyExtension> {
        public MyExtensionExporter() {
            super("extended-component");
            this.addProperty(WebComponentWrapperTest.MSG_PROPERTY, "").onChange(MyExtension::setMessage);
            this.addProperty(WebComponentWrapperTest.INT_PROPERTY, 0).onChange(MyComponent::setIntegerValue);
        }

        public void configureInstance(WebComponent<MyExtension> webComponent, MyExtension component) {
        }
    }

    public static class MyExtension
    extends MyComponent {
        @Override
        public void setMessage(String message) {
            super.setMessage("Extended " + message);
        }
    }

    public static class ExtendedExporter
    extends MyComponentExporter {
        public ExtendedExporter() {
            super("my-component-extended");
            this.addProperty(WebComponentWrapperTest.MSG_PROPERTY, "Default").onChange(MyComponent::setMessage);
            this.addProperty(WebComponentWrapperTest.BOOLEAN_PROPERTY, false).onChange(MyComponent::setBooleanValue);
        }

        @Override
        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
            super.configureInstance(webComponent, component);
        }
    }

    @Tag(value="div")
    public static class Parent
    extends Component {
    }
}

