/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.DependencyList;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.server.communication.UidlWriter;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import com.vaadin.tests.util.MockUI;
import java.util.Collection;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

class StylesheetRemovalTest {
    private UI ui;
    private Page page;
    private UIInternals internals;
    private DependencyList dependencyList;

    StylesheetRemovalTest() {
    }

    @BeforeEach
    public void setup() {
        this.ui = new MockUI();
        this.page = this.ui.getPage();
        this.internals = this.ui.getInternals();
        this.dependencyList = this.internals.getDependencyList();
    }

    @Test
    public void addStyleSheet_returnsNonNullRegistration() {
        Registration reg1 = this.page.addStyleSheet("styles.css");
        Registration reg2 = this.page.addStyleSheet("styles.css", LoadMode.LAZY);
        Assertions.assertNotNull((Object)reg1, (String)"addStyleSheet should return a Registration");
        Assertions.assertNotNull((Object)reg2, (String)"addStyleSheet with LoadMode should return a Registration");
    }

    @Test
    public void addStyleSheet_returnsRegistration_thatRemovesStylesheet() {
        String url = "http://example.com/style.css";
        Registration registration = this.page.addStyleSheet(url);
        Assertions.assertNotNull((Object)registration, (String)"Registration should not be null");
        Collection dependencies = this.dependencyList.getPendingSendToClient();
        Assertions.assertEquals((int)1, (int)dependencies.size(), (String)"Should have one dependency");
        Dependency dep = (Dependency)dependencies.iterator().next();
        Assertions.assertEquals((Object)url, (Object)dep.getUrl(), (String)"URL should match");
        Assertions.assertNotNull((Object)dep.getId(), (String)"Dependency should have ID");
        registration.remove();
        Set removals = this.internals.getPendingStyleSheetRemovals();
        Assertions.assertEquals((int)1, (int)removals.size(), (String)"Should have one removal pending");
        Assertions.assertEquals((Object)dep.getId(), removals.iterator().next(), (String)"Removal ID should match dependency ID");
    }

    @Test
    public void stylesheetCanBeReAddedAfterRemoval() {
        String url = "http://example.com/reusable.css";
        Registration reg1 = this.page.addStyleSheet(url);
        Collection deps1 = this.dependencyList.getPendingSendToClient();
        Assertions.assertEquals((int)1, (int)deps1.size());
        Dependency firstDep = (Dependency)deps1.iterator().next();
        String firstId = firstDep.getId();
        this.dependencyList.clearPendingSendToClient();
        reg1.remove();
        Assertions.assertTrue((boolean)this.internals.getPendingStyleSheetRemovals().contains(firstId));
        this.internals.clearPendingStyleSheetRemovals();
        Registration reg2 = this.page.addStyleSheet(url);
        Collection deps2 = this.dependencyList.getPendingSendToClient();
        Assertions.assertEquals((int)1, (int)deps2.size());
        Dependency secondDep = (Dependency)deps2.iterator().next();
        Assertions.assertNotEquals((Object)firstId, (Object)secondDep.getId(), (String)"IDs should differ");
        Assertions.assertEquals((Object)url, (Object)secondDep.getUrl(), (String)"URLs should match");
    }

    @Test
    public void stylesheetWithLoadMode_canBeReAddedWithDifferentMode() {
        String url = "http://example.com/lazy.css";
        Registration reg1 = this.page.addStyleSheet(url, LoadMode.LAZY);
        Dependency firstDep = (Dependency)this.dependencyList.getPendingSendToClient().iterator().next();
        String firstId = firstDep.getId();
        Assertions.assertEquals((Object)LoadMode.LAZY, (Object)firstDep.getLoadMode());
        this.dependencyList.clearPendingSendToClient();
        reg1.remove();
        this.internals.clearPendingStyleSheetRemovals();
        Registration reg2 = this.page.addStyleSheet(url, LoadMode.EAGER);
        Dependency secondDep = (Dependency)this.dependencyList.getPendingSendToClient().iterator().next();
        Assertions.assertNotEquals((Object)firstId, (Object)secondDep.getId(), (String)"IDs should differ");
        Assertions.assertEquals((Object)url, (Object)secondDep.getUrl(), (String)"URLs should match");
        Assertions.assertEquals((Object)LoadMode.EAGER, (Object)secondDep.getLoadMode());
    }

    @Test
    public void multipleStylesheets_removeOne_othersRemainIntact() {
        String url1 = "http://example.com/style1.css";
        String url2 = "http://example.com/style2.css";
        String url3 = "http://example.com/style3.css";
        Registration reg1 = this.page.addStyleSheet(url1);
        Registration reg2 = this.page.addStyleSheet(url2);
        Registration reg3 = this.page.addStyleSheet(url3);
        Collection allDeps = this.dependencyList.getPendingSendToClient();
        Assertions.assertEquals((int)3, (int)allDeps.size(), (String)"Should have three dependencies");
        String idToRemove = null;
        for (Dependency dep : allDeps) {
            if (!url2.equals(dep.getUrl())) continue;
            idToRemove = dep.getId();
            break;
        }
        Assertions.assertNotNull(idToRemove, (String)"Should find dependency for url2");
        this.dependencyList.clearPendingSendToClient();
        reg2.remove();
        Set removals = this.internals.getPendingStyleSheetRemovals();
        Assertions.assertEquals((int)1, (int)removals.size(), (String)"Should have one removal");
        Assertions.assertEquals((Object)idToRemove, removals.iterator().next(), (String)"Should remove the correct stylesheet");
    }

    @Test
    public void uidlWriter_includesStylesheetRemovals() {
        String url = "http://example.com/to-remove.css";
        Registration reg = this.page.addStyleSheet(url);
        Collection deps = this.dependencyList.getPendingSendToClient();
        String depId = ((Dependency)deps.iterator().next()).getId();
        this.dependencyList.clearPendingSendToClient();
        reg.remove();
        UidlWriter writer = new UidlWriter();
        ObjectNode response = writer.createUidl(this.ui, false);
        Assertions.assertTrue((boolean)response.has("stylesheetRemovals"), (String)"Response should contain stylesheetRemovals");
        ArrayNode removalsArray = (ArrayNode)response.get("stylesheetRemovals");
        Assertions.assertEquals((int)1, (int)removalsArray.size(), (String)"Should have one removal");
        Assertions.assertEquals((Object)depId, (Object)removalsArray.get(0).asString(), (String)"Removal ID should match");
        Set pendingRemovals = this.internals.getPendingStyleSheetRemovals();
        Assertions.assertTrue((boolean)pendingRemovals.isEmpty(), (String)"Pending removals should be cleared after UIDL creation");
    }

    @Test
    public void duplicateStylesheet_notAddedUntilRemovedFromCache() {
        String url = "http://example.com/cached-style.css";
        Registration reg = this.page.addStyleSheet(url);
        Assertions.assertEquals((int)1, (int)this.dependencyList.getPendingSendToClient().size());
        this.dependencyList.clearPendingSendToClient();
        this.page.addStyleSheet(url);
        Assertions.assertEquals((int)0, (int)this.dependencyList.getPendingSendToClient().size());
        reg.remove();
        this.page.addStyleSheet(url);
        Assertions.assertEquals((int)1, (int)this.dependencyList.getPendingSendToClient().size());
    }

    @Test
    public void duplicateStylesheet_firstRegistrationCanRemove() {
        String url = "http://example.com/duplicate.css";
        Registration reg1 = this.page.addStyleSheet(url);
        String firstDepId = ((Dependency)this.dependencyList.getPendingSendToClient().iterator().next()).getId();
        this.dependencyList.clearPendingSendToClient();
        Registration reg2 = this.page.addStyleSheet(url);
        Assertions.assertEquals((int)0, (int)this.dependencyList.getPendingSendToClient().size(), (String)"Second add should not create pending send");
        reg1.remove();
        Set removals = this.internals.getPendingStyleSheetRemovals();
        Assertions.assertEquals((int)1, (int)removals.size(), (String)"Should have one removal pending");
        Assertions.assertEquals((Object)firstDepId, removals.iterator().next(), (String)"Should use the same dependency ID");
    }

    @Test
    public void duplicateStylesheet_secondRegistrationCanRemove() {
        String url = "http://example.com/duplicate2.css";
        Registration reg1 = this.page.addStyleSheet(url);
        String firstDepId = ((Dependency)this.dependencyList.getPendingSendToClient().iterator().next()).getId();
        this.dependencyList.clearPendingSendToClient();
        Registration reg2 = this.page.addStyleSheet(url);
        Assertions.assertEquals((int)0, (int)this.dependencyList.getPendingSendToClient().size(), (String)"Second add should not create pending send");
        reg2.remove();
        Set removals = this.internals.getPendingStyleSheetRemovals();
        Assertions.assertEquals((int)1, (int)removals.size(), (String)"Should have one removal pending");
        String removedId = (String)removals.iterator().next();
        Assertions.assertEquals((Object)firstDepId, (Object)removedId, (String)"Should use the same ID as the original");
    }
}

