/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.BrowserWindowResizeListener;
import com.vaadin.flow.component.page.ColorScheme;
import com.vaadin.flow.component.page.ExtendedClientDetails;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import com.vaadin.tests.util.MockUI;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;

class PageTest {
    private UI ui = new TestUI();
    private TestPage page = new TestPage(this.ui);
    private BrowserWindowResizeListener listener = (BrowserWindowResizeListener & Serializable)event -> {};

    PageTest() {
    }

    @Test
    public void addNullAsAListener_trows() {
        Assertions.assertThrows(NullPointerException.class, () -> this.page.addBrowserWindowResizeListener(null));
    }

    @Test
    public void retrieveExtendedClientDetails_twice_jsOnceAndCallbackTwice() {
        MockUI mockUI = new MockUI();
        Page page = new Page(mockUI){

            public PendingJavaScriptResult executeJs(String expression, Object ... params) {
                super.executeJs(expression, params);
                return new PendingJavaScriptResult(){

                    public boolean cancelExecution() {
                        return false;
                    }

                    public boolean isSentToBrowser() {
                        return false;
                    }

                    public void then(SerializableConsumer<JsonNode> resultHandler, SerializableConsumer<String> errorHandler) {
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("v-sw", "2560");
                        params.put("v-sh", "1450");
                        params.put("v-tzo", "-270");
                        params.put("v-rtzo", "-210");
                        params.put("v-dstd", "60");
                        params.put("v-dston", "true");
                        params.put("v-tzid", "Asia/Tehran");
                        params.put("v-curdate", "1555000000000");
                        params.put("v-td", "false");
                        params.put("v-wn", "ROOT-1234567-0.1234567");
                        resultHandler.accept((Object)JacksonUtils.createObject(params, JacksonUtils::createNode));
                    }
                };
            }
        };
        mockUI.setPage(page);
        AtomicInteger callbackInvocations = new AtomicInteger();
        Page.ExtendedClientDetailsReceiver & Serializable receiver = (Page.ExtendedClientDetailsReceiver & Serializable)details -> callbackInvocations.incrementAndGet();
        page.retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver)receiver);
        page.retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver)receiver);
        int jsInvocations = mockUI.getInternals().dumpPendingJavaScriptInvocations().size();
        Assertions.assertEquals((int)1, (int)jsInvocations);
        Assertions.assertEquals((int)2, (int)callbackInvocations.get());
    }

    @Test
    public void fetchCurrentUrl_consumerReceivesCorrectURL() {
        MockUI mockUI = new MockUI();
        Page page = new Page(mockUI){

            public PendingJavaScriptResult executeJs(String expression, Object ... params) {
                super.executeJs(expression, params);
                Assertions.assertEquals((Object)"return window.location.href", (Object)expression, (String)"Expected javascript for fetching location is wrong.");
                return new PendingJavaScriptResult(){

                    public boolean cancelExecution() {
                        return false;
                    }

                    public boolean isSentToBrowser() {
                        return false;
                    }

                    public void then(SerializableConsumer<JsonNode> resultHandler, SerializableConsumer<String> errorHandler) {
                        resultHandler.accept((Object)JacksonUtils.createNode((Object)"http://localhost:8080/home"));
                    }
                };
            }
        };
        AtomicReference callbackInvocations = new AtomicReference();
        SerializableConsumer & Serializable receiver = (SerializableConsumer & Serializable)details -> callbackInvocations.compareAndSet(null, details);
        page.fetchCurrentURL((SerializableConsumer)receiver);
        Assertions.assertEquals((Object)"http://localhost:8080/home", (Object)((URL)callbackInvocations.get()).toString(), (String)"Returned URL was wrong");
    }

    @Test
    public void fetchCurrentUrl_passNullCallback_throwsNullPointerException() {
        MockUI mockUI = new MockUI();
        Page page = new Page((UI)mockUI);
        Assertions.assertThrows(NullPointerException.class, () -> page.fetchCurrentURL(null));
    }

    @Test
    public void addJsModule_accepts_onlyExternalAndStartingSlash() {
        LinkedList<String> urls = new LinkedList<String>();
        urls.add("http://sample.com/mod.js");
        urls.add("https://sample.com/mod.js");
        urls.add("//sample.com/mod.js");
        urls.add("/mod.js");
        for (String url : urls) {
            this.page.addJsModule(url);
        }
        Collection pendingSendToClient = this.ui.getInternals().getDependencyList().getPendingSendToClient();
        Assertions.assertEquals((int)4, (int)pendingSendToClient.size(), (String)"There should be 4 dependencies added.");
        for (Dependency dependency : pendingSendToClient) {
            Assertions.assertEquals((Object)Dependency.Type.JS_MODULE, (Object)dependency.getType(), (String)"Dependency should be a JSModule");
            Assertions.assertEquals((Object)LoadMode.EAGER, (Object)dependency.getLoadMode(), (String)"JS module dependency should be EAGER");
            Assertions.assertTrue((boolean)urls.contains(dependency.getUrl()), (String)("Dependency " + dependency.getUrl() + " is not found in the source list."));
            urls.remove(dependency.getUrl());
        }
        Assertions.assertEquals((int)0, (int)urls.size(), (String)"Not all urls were added as dependencies");
    }

    @Test
    public void addJsModule_rejects_files() {
        try {
            this.page.addJsModule("mod.js");
            Assertions.fail((String)"Adding a file without starting \"/\" is not to be allowed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void executeJavaScript_delegatesToExecJs() {
        final AtomicReference invokedExpression = new AtomicReference();
        final AtomicReference invokedParams = new AtomicReference();
        Page page = new Page(new MockUI()){

            public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
                String oldExpression = invokedExpression.getAndSet(expression);
                Assertions.assertNull((Object)oldExpression, (String)"There should be no old expression");
                Object[] oldParams = invokedParams.getAndSet(parameters);
                Assertions.assertNull((Object)oldParams, (String)"There should be no old params");
                return null;
            }
        };
        PendingJavaScriptResult executionCanceler = page.executeJs("foo", new Object[]{1, true});
        Assertions.assertNull((Object)executionCanceler);
        Assertions.assertEquals((Object)"foo", invokedExpression.get());
        Assertions.assertEquals((Object)1, (Object)((Object[])invokedParams.get())[0]);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)((Object[])invokedParams.get())[1]);
    }

    @Test
    public void open_openInSameWindow_closeTheClientApplication() {
        final AtomicReference capture = new AtomicReference();
        final ArrayList params = new ArrayList();
        Page page = new Page(new MockUI()){

            public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
                capture.set(expression);
                params.addAll(Arrays.asList(parameters));
                return (PendingJavaScriptResult)Mockito.mock(PendingJavaScriptResult.class);
            }
        };
        page.setLocation("foo");
        Assertions.assertEquals((Object)"_self", params.get(1));
        MatcherAssert.assertThat((Object)((String)capture.get()), (Matcher)CoreMatchers.containsString((String)"this.stopApplication();"));
    }

    @Test
    public void setLocation_dispatchesRedirectPendingEvent() {
        final AtomicReference capture = new AtomicReference();
        final ArrayList params = new ArrayList();
        Page page = new Page(new MockUI()){

            public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
                capture.set(expression);
                params.addAll(Arrays.asList(parameters));
                return (PendingJavaScriptResult)Mockito.mock(PendingJavaScriptResult.class);
            }
        };
        page.setLocation("/logout-landing");
        String expression = (String)capture.get();
        Assertions.assertTrue((boolean)expression.contains("vaadin-redirect-pending"), (String)"Should dispatch vaadin-redirect-pending event");
        Assertions.assertTrue((boolean)expression.contains("window.open"), (String)"Should call window.open");
        Assertions.assertEquals((Object)"/logout-landing", params.get(0), (String)"URL parameter should be passed");
    }

    @Test
    public void open_dispatchesRedirectPendingEventBeforeRedirect() {
        final AtomicReference capture = new AtomicReference();
        Page page = new Page(new MockUI()){

            public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
                capture.set(expression);
                return (PendingJavaScriptResult)Mockito.mock(PendingJavaScriptResult.class);
            }
        };
        page.open("https://example.com", "_blank");
        String expression = (String)capture.get();
        int eventDispatchIndex = expression.indexOf("vaadin-redirect-pending");
        int windowOpenIndex = expression.indexOf("window.open");
        Assertions.assertTrue((eventDispatchIndex >= 0 ? 1 : 0) != 0, (String)"Event dispatch should be present");
        Assertions.assertTrue((windowOpenIndex >= 0 ? 1 : 0) != 0, (String)"window.open should be present");
        Assertions.assertTrue((eventDispatchIndex < windowOpenIndex ? 1 : 0) != 0, (String)"Event dispatch should come before window.open in the script");
    }

    @Test
    public void setColorScheme_setsStyleProperty() {
        final AtomicReference capturedExpression = new AtomicReference();
        final AtomicReference capturedParams = new AtomicReference();
        MockUI mockUI = new MockUI();
        Page page = new Page(mockUI){

            public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
                capturedExpression.set(expression);
                capturedParams.set(parameters);
                return (PendingJavaScriptResult)Mockito.mock(PendingJavaScriptResult.class);
            }
        };
        page.setColorScheme(ColorScheme.Value.DARK);
        String js = (String)capturedExpression.get();
        Assertions.assertTrue((boolean)js.contains("setAttribute('theme', $0)"), (String)"Should set theme attribute");
        Assertions.assertTrue((boolean)js.contains("style.colorScheme = $1"), (String)"Should set color-scheme property");
        Object[] params = (Object[])capturedParams.get();
        Assertions.assertEquals((Object)"dark", (Object)params[0], (String)"Theme attribute should be 'dark'");
        Assertions.assertEquals((Object)"dark", (Object)params[1], (String)"Color scheme property should be 'dark'");
    }

    @Test
    public void setColorScheme_lightDark_setsCorrectValues() {
        final AtomicReference capturedExpression = new AtomicReference();
        final AtomicReference capturedParams = new AtomicReference();
        MockUI mockUI = new MockUI();
        Page page = new Page(mockUI){

            public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
                capturedExpression.set(expression);
                capturedParams.set(parameters);
                return (PendingJavaScriptResult)Mockito.mock(PendingJavaScriptResult.class);
            }
        };
        page.setColorScheme(ColorScheme.Value.LIGHT_DARK);
        String js = (String)capturedExpression.get();
        Assertions.assertTrue((boolean)js.contains("setAttribute('theme', $0)"), (String)"Should set theme attribute");
        Assertions.assertTrue((boolean)js.contains("style.colorScheme = $1"), (String)"Should set color-scheme property");
        Object[] params = (Object[])capturedParams.get();
        Assertions.assertEquals((Object)"light-dark", (Object)params[0], (String)"Theme attribute should use hyphen");
        Assertions.assertEquals((Object)"light dark", (Object)params[1], (String)"Color scheme property should use space");
    }

    @Test
    public void setColorScheme_null_clearsProperty() {
        MockUI mockUI = new MockUI();
        final AtomicReference capturedExpression = new AtomicReference();
        Page page = new Page(mockUI){

            public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
                capturedExpression.set(expression);
                return (PendingJavaScriptResult)Mockito.mock(PendingJavaScriptResult.class);
            }
        };
        page.setColorScheme(null);
        String js = (String)capturedExpression.get();
        Assertions.assertTrue((boolean)js.contains("removeAttribute('theme')"), (String)"Should remove theme attribute");
        Assertions.assertTrue((boolean)js.contains("style.colorScheme = ''"), (String)"Should clear inline style");
        Assertions.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)page.getColorScheme());
    }

    @Test
    public void setColorScheme_normal_clearsProperty() {
        MockUI mockUI = new MockUI();
        final AtomicReference capturedExpression = new AtomicReference();
        Page page = new Page(mockUI){

            public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
                capturedExpression.set(expression);
                return (PendingJavaScriptResult)Mockito.mock(PendingJavaScriptResult.class);
            }
        };
        page.setColorScheme(ColorScheme.Value.NORMAL);
        String js = (String)capturedExpression.get();
        Assertions.assertTrue((boolean)js.contains("style.colorScheme = ''"));
        Assertions.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)page.getColorScheme());
    }

    @Test
    public void getColorScheme_returnsNormal_whenNotSet() {
        Page page = new Page((UI)new MockUI());
        Assertions.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)page.getColorScheme());
    }

    @Test
    public void getColorScheme_returnsCachedValue() {
        MockUI mockUI = new MockUI();
        ExtendedClientDetails details = new ExtendedClientDetails((UI)mockUI, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "dark", null);
        mockUI.getInternals().setExtendedClientDetails(details);
        Page page = new Page((UI)mockUI);
        Assertions.assertEquals((Object)ColorScheme.Value.DARK, (Object)page.getColorScheme());
    }

    @Test
    public void setColorScheme_updatesGetColorScheme() {
        MockUI mockUI = new MockUI();
        ExtendedClientDetails details = new ExtendedClientDetails((UI)mockUI, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        mockUI.getInternals().setExtendedClientDetails(details);
        Page page = new Page(mockUI){

            public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
                return (PendingJavaScriptResult)Mockito.mock(PendingJavaScriptResult.class);
            }
        };
        Assertions.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)page.getColorScheme());
        page.setColorScheme(ColorScheme.Value.DARK);
        Assertions.assertEquals((Object)ColorScheme.Value.DARK, (Object)page.getColorScheme());
        page.setColorScheme(ColorScheme.Value.LIGHT);
        Assertions.assertEquals((Object)ColorScheme.Value.LIGHT, (Object)page.getColorScheme());
        page.setColorScheme(null);
        Assertions.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)page.getColorScheme());
        page.setColorScheme(ColorScheme.Value.NORMAL);
        Assertions.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)page.getColorScheme());
    }

    private class TestUI
    extends UI {
        private TestUI() {
        }

        public Page getPage() {
            return PageTest.this.page;
        }
    }

    private class TestPage
    extends Page {
        private int count;
        private String expression;
        private Object firstParam;

        public TestPage(UI ui) {
            super(ui);
            this.count = 0;
        }

        public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
            this.expression = expression;
            this.firstParam = parameters[0];
            ++this.count;
            return null;
        }
    }
}

