/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.geolocation;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.geolocation.Geolocation;
import com.vaadin.flow.component.geolocation.GeolocationCoordinates;
import com.vaadin.flow.component.geolocation.GeolocationError;
import com.vaadin.flow.component.geolocation.GeolocationPosition;
import com.vaadin.flow.component.geolocation.GeolocationState;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.tests.util.MockUI;
import java.io.Serializable;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class GeolocationTest {
    private MockUI ui;

    @BeforeEach
    void setUp() {
        this.ui = new MockUI();
    }

    @Test
    void geolocationCoordinates_jacksonRoundTrip() {
        GeolocationCoordinates coords = new GeolocationCoordinates(60.1699, 24.9384, 10.0, Double.valueOf(25.5), Double.valueOf(5.0), Double.valueOf(90.0), Double.valueOf(1.5));
        ObjectNode json = JacksonUtils.beanToJson((Object)coords);
        GeolocationCoordinates result = (GeolocationCoordinates)JacksonUtils.readValue((JsonNode)json, GeolocationCoordinates.class);
        Assertions.assertEquals((double)coords.latitude(), (double)result.latitude());
        Assertions.assertEquals((double)coords.longitude(), (double)result.longitude());
        Assertions.assertEquals((double)coords.accuracy(), (double)result.accuracy());
        Assertions.assertEquals((Double)coords.altitude(), (Double)result.altitude());
        Assertions.assertEquals((Double)coords.altitudeAccuracy(), (Double)result.altitudeAccuracy());
        Assertions.assertEquals((Double)coords.heading(), (Double)result.heading());
        Assertions.assertEquals((Double)coords.speed(), (Double)result.speed());
    }

    @Test
    void geolocationPosition_jacksonRoundTrip() {
        GeolocationCoordinates coords = new GeolocationCoordinates(60.1699, 24.9384, 10.0, null, null, null, null);
        GeolocationPosition pos = new GeolocationPosition(coords, 1700000000000L);
        ObjectNode json = JacksonUtils.beanToJson((Object)pos);
        GeolocationPosition result = (GeolocationPosition)JacksonUtils.readValue((JsonNode)json, GeolocationPosition.class);
        Assertions.assertEquals((long)pos.timestamp(), (long)result.timestamp());
        Assertions.assertEquals((double)pos.coords().latitude(), (double)result.coords().latitude());
        Assertions.assertEquals((double)pos.coords().longitude(), (double)result.coords().longitude());
    }

    @Test
    void geolocationError_jacksonRoundTrip() {
        GeolocationError error = new GeolocationError(1, "User denied geolocation");
        ObjectNode json = JacksonUtils.beanToJson((Object)error);
        GeolocationError result = (GeolocationError)JacksonUtils.readValue((JsonNode)json, GeolocationError.class);
        Assertions.assertEquals((int)error.code(), (int)result.code());
        Assertions.assertEquals((Object)error.message(), (Object)result.message());
    }

    @Test
    void get_executesPromiseJs() {
        TestComponent component = new TestComponent();
        this.ui.add(new Component[]{component});
        Geolocation.get((SerializableConsumer & Serializable)pos -> {});
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assertions.assertTrue((boolean)invocations.stream().anyMatch(inv -> inv.getInvocation().getExpression().contains("geolocation.get")));
    }

    @Test
    void track_registersListenersAndExecutesWatchJs() {
        TestComponent component = new TestComponent();
        this.ui.add(new Component[]{component});
        Geolocation geo = Geolocation.track((Component)component);
        Assertions.assertNotNull((Object)geo);
        Assertions.assertNotNull((Object)geo.state());
        Assertions.assertInstanceOf(GeolocationState.Pending.class, (Object)geo.state().get());
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assertions.assertTrue((boolean)invocations.stream().anyMatch(inv -> inv.getInvocation().getExpression().contains("geolocation.watch")));
    }

    @Test
    void track_signalUpdatesOnPositionEvent() {
        TestComponent component = new TestComponent();
        this.ui.add(new Component[]{component});
        Geolocation geo = Geolocation.track((Component)component);
        ObjectNode eventData = JacksonUtils.createObjectNode();
        ObjectNode detail = JacksonUtils.createObjectNode();
        ObjectNode coords = JacksonUtils.createObjectNode();
        coords.put("latitude", 60.1699);
        coords.put("longitude", 24.9384);
        coords.put("accuracy", 10.0);
        coords.put("altitude", 25.5);
        coords.put("altitudeAccuracy", 5.0);
        coords.put("heading", 90.0);
        coords.put("speed", 1.5);
        detail.set("coords", (JsonNode)coords);
        detail.put("timestamp", 1700000000000L);
        eventData.set("event.detail", (JsonNode)detail);
        this.fireEvent(component.getElement(), "vaadin-geolocation-position", eventData);
        Assertions.assertInstanceOf(GeolocationPosition.class, (Object)geo.state().get());
        GeolocationPosition pos = (GeolocationPosition)geo.state().get();
        Assertions.assertEquals((double)60.1699, (double)pos.coords().latitude());
        Assertions.assertEquals((double)24.9384, (double)pos.coords().longitude());
        Assertions.assertEquals((double)10.0, (double)pos.coords().accuracy());
        Assertions.assertEquals((double)25.5, (Double)pos.coords().altitude());
        Assertions.assertEquals((double)5.0, (Double)pos.coords().altitudeAccuracy());
        Assertions.assertEquals((double)90.0, (Double)pos.coords().heading());
        Assertions.assertEquals((double)1.5, (Double)pos.coords().speed());
        Assertions.assertEquals((long)1700000000000L, (long)pos.timestamp());
    }

    @Test
    void track_signalUpdatesOnErrorEvent() {
        TestComponent component = new TestComponent();
        this.ui.add(new Component[]{component});
        Geolocation geo = Geolocation.track((Component)component);
        ObjectNode eventData = JacksonUtils.createObjectNode();
        ObjectNode detail = JacksonUtils.createObjectNode();
        detail.put("code", 1);
        detail.put("message", "User denied geolocation");
        eventData.set("event.detail", (JsonNode)detail);
        this.fireEvent(component.getElement(), "vaadin-geolocation-error", eventData);
        Assertions.assertInstanceOf(GeolocationError.class, (Object)geo.state().get());
        GeolocationError error = (GeolocationError)geo.state().get();
        Assertions.assertEquals((int)1, (int)error.code());
        Assertions.assertEquals((Object)"User denied geolocation", (Object)error.message());
    }

    @Test
    void track_stateTransitionsFromErrorToPosition() {
        TestComponent component = new TestComponent();
        this.ui.add(new Component[]{component});
        Geolocation geo = Geolocation.track((Component)component);
        ObjectNode errEventData = JacksonUtils.createObjectNode();
        ObjectNode errDetail = JacksonUtils.createObjectNode();
        errDetail.put("code", 3);
        errDetail.put("message", "Timeout");
        errEventData.set("event.detail", (JsonNode)errDetail);
        this.fireEvent(component.getElement(), "vaadin-geolocation-error", errEventData);
        Assertions.assertInstanceOf(GeolocationError.class, (Object)geo.state().get());
        ObjectNode posEventData = JacksonUtils.createObjectNode();
        ObjectNode posDetail = JacksonUtils.createObjectNode();
        ObjectNode coords = JacksonUtils.createObjectNode();
        coords.put("latitude", 60.1699);
        coords.put("longitude", 24.9384);
        coords.put("accuracy", 10.0);
        posDetail.set("coords", (JsonNode)coords);
        posDetail.put("timestamp", 1700000000000L);
        posEventData.set("event.detail", (JsonNode)posDetail);
        this.fireEvent(component.getElement(), "vaadin-geolocation-position", posEventData);
        Assertions.assertInstanceOf(GeolocationPosition.class, (Object)geo.state().get());
    }

    @Test
    void track_autoStopsOnDetach() {
        TestComponent component = new TestComponent();
        this.ui.add(new Component[]{component});
        Geolocation geo = Geolocation.track((Component)component);
        ElementListenerMap listenerMap = (ElementListenerMap)component.getElement().getNode().getFeature(ElementListenerMap.class);
        Assertions.assertFalse((boolean)listenerMap.getExpressions("vaadin-geolocation-position").isEmpty());
        Assertions.assertFalse((boolean)listenerMap.getExpressions("vaadin-geolocation-error").isEmpty());
        this.ui.dumpPendingJsInvocations();
        this.ui.remove(new Component[]{component});
        Assertions.assertTrue((boolean)listenerMap.getExpressions("vaadin-geolocation-position").isEmpty());
        Assertions.assertTrue((boolean)listenerMap.getExpressions("vaadin-geolocation-error").isEmpty());
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assertions.assertTrue((boolean)invocations.stream().anyMatch(inv -> inv.getInvocation().getExpression().contains("geolocation.clearWatch")));
    }

    private void fireEvent(Element element, String eventType, ObjectNode eventData) {
        ElementListenerMap listenerMap = (ElementListenerMap)element.getNode().getFeature(ElementListenerMap.class);
        listenerMap.fireEvent(new DomEvent(element, eventType, (JsonNode)eventData));
    }

    @Tag(value="div")
    private static class TestComponent
    extends Component {
        private TestComponent() {
        }
    }
}

