/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.HasValue;
import java.io.Serializable;
import org.junit.jupiter.api.Assertions;

public class ValueChangeMonitor<T> {
    HasValue.ValueChangeEvent<T> capturedEvent;

    public ValueChangeMonitor(HasValue<?, T> obserable) {
        obserable.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (this.capturedEvent != null) {
                Assertions.fail((String)("There is already an event. Old event: " + String.valueOf(this.capturedEvent) + ", new event: " + String.valueOf(event)));
            }
            Assertions.assertSame((Object)obserable, (Object)event.getHasValue());
            if (event instanceof AbstractField.ComponentValueChangeEvent) {
                Assertions.assertSame((Object)obserable, (Object)((AbstractField.ComponentValueChangeEvent)event).getSource());
            }
            this.capturedEvent = event;
        });
    }

    public void discard() {
        Assertions.assertNotNull(this.capturedEvent, (String)"There should be an event");
        this.capturedEvent = null;
    }

    public void assertEvent(boolean fromClient, T oldValue, T newValue) {
        Assertions.assertNotNull(this.capturedEvent, (String)"There should be an event");
        Assertions.assertTrue((fromClient == this.capturedEvent.isFromClient() ? 1 : 0) != 0);
        ValueChangeMonitor.assertEventValues(this.capturedEvent, oldValue, newValue);
        this.discard();
    }

    public void assertNoEvent() {
        Assertions.assertNull(this.capturedEvent, (String)"There should be no event");
    }

    public static <T> void assertEventValues(HasValue.ValueChangeEvent<T> event, T oldValue, T newValue) {
        Assertions.assertEquals(oldValue, (Object)event.getOldValue());
        Assertions.assertEquals(newValue, (Object)event.getValue());
    }
}

