/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentTest;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Direction;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HeartbeatEvent;
import com.vaadin.flow.component.HeartbeatListener;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.ModalityMode;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.UIDetachedException;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.page.History;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementDetachEvent;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.dom.NodeVisitor;
import com.vaadin.flow.dom.impl.AbstractTextElementStateProvider;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.MockLogger;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.BeforeLeaveListener;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.ListenerPriority;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteNotFoundError;
import com.vaadin.flow.router.RouteParam;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.RoutePrefix;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.AfterNavigationHandler;
import com.vaadin.flow.router.internal.BeforeEnterHandler;
import com.vaadin.flow.router.internal.BeforeLeaveHandler;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.ErrorHandler;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.tests.util.MockUI;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class UITest {
    @AfterEach
    public void tearDown() {
        CurrentInstance.clearAll();
    }

    @Test
    public void elementIsBody() {
        UI ui = new UI();
        Assertions.assertEquals((Object)"body", (Object)ui.getElement().getTag());
    }

    private static UI createTestUI() {
        final MockLogger mockLogger = new MockLogger();
        UI ui = new UI(){

            public void doInit(VaadinRequest request, int uiId, String appId) {
            }

            Logger getLogger() {
                return mockLogger;
            }
        };
        return ui;
    }

    private static MockUI createAccessableTestUI() {
        MockVaadinSession session = new MockVaadinSession((VaadinService)new MockVaadinServletService());
        session.lock();
        MockUI ui = new MockUI(session);
        session.unlock();
        return ui;
    }

    private static void initUI(UI ui, String initialLocation, ArgumentCaptor<Integer> statusCodeCaptor) throws InvalidRouteConfigurationException {
        String pathInfo;
        VaadinServletRequest request = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        if (initialLocation.isEmpty()) {
            pathInfo = null;
        } else {
            Assertions.assertFalse((boolean)initialLocation.startsWith("/"));
            pathInfo = "/" + initialLocation;
        }
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)pathInfo);
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        service.setCurrentInstances((VaadinRequest)request, response);
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service);
        DeploymentConfiguration config = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)config.isProductionMode()).thenReturn((Object)false);
        Mockito.when((Object)config.getFrontendFolder()).thenReturn((Object)new File("front"));
        Mockito.when((Object)config.getProjectFolder()).thenReturn((Object)new File("./"));
        Mockito.when((Object)config.getBuildFolder()).thenReturn((Object)"build");
        session.lock();
        ((MockVaadinServletService)service).setConfiguration(config);
        ui.getInternals().setSession((VaadinSession)session);
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)ui.getInternals().getRouter().getRegistry());
        routeConfiguration.update((Command & Serializable)() -> {
            routeConfiguration.getHandledRegistry().clean();
            Arrays.asList(RootNavigationTarget.class, FooBarNavigationTarget.class, Parameterized.class, FooBarParamNavigationTarget.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        });
        ui.doInit((VaadinRequest)request, 0, "foo");
        ui.getInternals().getRouter().initializeUI(ui, UITest.requestToLocation((VaadinRequest)request));
        session.unlock();
        if (statusCodeCaptor != null) {
            ((VaadinResponse)Mockito.verify((Object)response)).setStatus(((Integer)statusCodeCaptor.capture()).intValue());
        }
    }

    public static Location requestToLocation(VaadinRequest request) {
        return new Location(request.getPathInfo(), QueryParameters.full((Map)request.getParameterMap()));
    }

    @Test
    public void scrollAttribute() {
        UI ui = new UI();
        Assertions.assertNull((Object)ui.getElement().getAttribute("scroll"), (String)"'scroll' attribute shouldn't be set for the UI element which represents 'body' tag");
    }

    @Test
    public void testInitialLocation() throws InvalidRouteConfigurationException {
        UI ui = new UI();
        UITest.initUI(ui, "", null);
        Assertions.assertEquals((Object)"", (Object)ui.getInternals().getActiveViewLocation().getPath());
    }

    @Test
    public void locationAfterServerNavigation() throws InvalidRouteConfigurationException {
        UI ui = new UI();
        UITest.initUI(ui, "", null);
        ui.navigate("foo/bar");
        Assertions.assertEquals((Object)"foo/bar", (Object)ui.getInternals().getActiveViewLocation().getPath());
        List chain = ui.getInternals().getActiveRouterTargetsChain();
        Assertions.assertEquals((int)1, (int)chain.size());
        Component currentRoute = ui.getCurrentView();
        MatcherAssert.assertThat((Object)currentRoute, (Matcher)CoreMatchers.instanceOf(FooBarNavigationTarget.class));
    }

    @Test
    @Disabled(value="Check what is the new Router.navigate for JavaScriptUI")
    public void navigateWithParameters_delegateToRouter() {
        String route = "params";
        Router router = (Router)Mockito.mock(Router.class);
        MockUI ui = new MockUI(router);
        QueryParameters params = QueryParameters.simple(Collections.singletonMap("test", "indeed"));
        ArgumentCaptor location = ArgumentCaptor.forClass(Location.class);
        ui.navigate("params", params);
        ((Router)Mockito.verify((Object)router)).navigate((UI)ArgumentMatchers.eq((Object)((Object)ui)), (Location)location.capture(), (NavigationTrigger)ArgumentMatchers.eq((Object)NavigationTrigger.UI_NAVIGATE));
        Location value = (Location)location.getValue();
        Assertions.assertEquals((Object)"params", (Object)value.getPath());
        Assertions.assertEquals((Object)params, (Object)value.getQueryParameters());
    }

    @Test
    public void navigateWithParameters_afterServerNavigation() throws InvalidRouteConfigurationException {
        UI ui = new UI();
        UITest.initUI(ui, "", null);
        Optional newView = ui.navigate(FooBarParamNavigationTarget.class, new RouteParameters(new RouteParam[]{new RouteParam("fooParam", "flu"), new RouteParam("barParam", "beer")}));
        Assertions.assertEquals(FooBarParamNavigationTarget.class, ((Object)((Object)((FooBarParamNavigationTarget)((Object)newView.get())))).getClass());
        Assertions.assertEquals((Object)"foo/flu/beer/bar", (Object)ui.getInternals().getActiveViewLocation().getPath());
        List chain = ui.getInternals().getActiveRouterTargetsChain();
        Assertions.assertEquals((int)2, (int)chain.size());
        MatcherAssert.assertThat((Object)((HasElement)chain.get(0)), (Matcher)CoreMatchers.instanceOf(FooBarParamNavigationTarget.class));
        MatcherAssert.assertThat((Object)((HasElement)chain.get(1)), (Matcher)CoreMatchers.instanceOf(FooBarParamParentNavigationTarget.class));
    }

    @Test
    public void navigateWithQueryAndRouteParameters_afterServerNavigation() throws InvalidRouteConfigurationException {
        UI ui = new UI();
        UITest.initUI(ui, "", null);
        Optional newView = ui.navigate(FooBarParamNavigationTarget.class, new RouteParameters(new RouteParam[]{new RouteParam("fooParam", "flu"), new RouteParam("barParam", "beer")}), QueryParameters.of((String)"bigBeer", (String)"forMePlease"));
        Assertions.assertEquals(FooBarParamNavigationTarget.class, ((Object)((Object)((FooBarParamNavigationTarget)((Object)newView.get())))).getClass());
        Assertions.assertEquals((Object)"foo/flu/beer/bar?bigBeer=forMePlease", (Object)ui.getInternals().getActiveViewLocation().getPathWithQueryParameters());
        List chain = ui.getInternals().getActiveRouterTargetsChain();
        Assertions.assertEquals((int)2, (int)chain.size());
        MatcherAssert.assertThat((Object)((HasElement)chain.get(0)), (Matcher)CoreMatchers.instanceOf(FooBarParamNavigationTarget.class));
        MatcherAssert.assertThat((Object)((HasElement)chain.get(1)), (Matcher)CoreMatchers.instanceOf(FooBarParamParentNavigationTarget.class));
    }

    @Test
    public void localeSet_directionUpdated() {
        MockUI ui = new MockUI();
        ui.setDirection(Direction.RIGHT_TO_LEFT);
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        List<PendingJavaScriptInvocation> pendingJavaScriptInvocations = ui.dumpPendingJsInvocations();
        Assertions.assertEquals((int)1, (int)pendingJavaScriptInvocations.size());
        Assertions.assertEquals((Object)"rtl", pendingJavaScriptInvocations.get(0).getInvocation().getParameters().get(0));
    }

    @Test
    public void locationAfterClientNavigation() throws InvalidRouteConfigurationException {
        UI ui = new UI();
        UITest.initUI(ui, "", null);
        History history = ui.getPage().getHistory();
        history.getHistoryStateChangeHandler().onHistoryStateChange(new History.HistoryStateChangeEvent(history, null, new Location("foo/bar"), NavigationTrigger.HISTORY));
        Assertions.assertEquals((Object)"foo/bar", (Object)ui.getInternals().getActiveViewLocation().getPath());
    }

    @Test
    public void noRouteMatches_404ViewAndCodeReturned() throws InvalidRouteConfigurationException {
        UI ui = new UI();
        ArgumentCaptor statusCodeCaptor = ArgumentCaptor.forClass(Integer.class);
        UITest.initUI(ui, "baz", (ArgumentCaptor<Integer>)statusCodeCaptor);
        Assertions.assertEquals((long)1L, (long)ui.getChildren().count());
        Optional errorComponent = ui.getChildren().findFirst();
        MatcherAssert.assertThat((Object)((Component)errorComponent.get()), (Matcher)CoreMatchers.instanceOf(RouteNotFoundError.class));
        Assertions.assertEquals((Integer)404, (Integer)((Integer)statusCodeCaptor.getValue()));
    }

    @Test
    public void addComponent() {
        UI ui = new UI();
        Text text = new Text("foo");
        ui.add(new Component[]{text});
        ComponentTest.assertChildren((Component)ui, new Component[]{text});
    }

    @Test
    public void addComponents() {
        UI ui = new UI();
        Text text = new Text("foo");
        Html html = new Html("<div>foobar</div>");
        ui.add(new Component[]{text, html});
        ComponentTest.assertChildren((Component)ui, new Component[]{text, html});
    }

    @Test
    public void removeComponent() {
        UI ui = new UI();
        Text text = new Text("foo");
        ui.add(new Component[]{text});
        ui.remove(new Component[]{text});
        ComponentTest.assertChildren((Component)ui, new Component[0]);
    }

    @Test
    public void setLastHeartbeatTimestamp_heartbeatEventIsFired() {
        UI ui = new UI();
        UITest.initUI(ui, "", null);
        long heartbeatTimestamp = System.currentTimeMillis();
        ArrayList events = new ArrayList();
        ui.addHeartbeatListener(events::add);
        ui.getInternals().setLastHeartbeatTimestamp(heartbeatTimestamp);
        Assertions.assertEquals((int)1, (int)events.size());
        Assertions.assertEquals((Object)ui, (Object)((HeartbeatEvent)events.get(0)).getSource());
        Assertions.assertEquals((long)heartbeatTimestamp, (long)((HeartbeatEvent)events.get(0)).getHeartbeatTime());
    }

    @Test
    public void setLastHeartbeatTimestamp_multipleHeartbeatListenerRegistered_eachHeartbeatListenerIsCalled() {
        UI ui = new UI();
        UITest.initUI(ui, "", null);
        ArrayList events = new ArrayList();
        ui.addHeartbeatListener(events::add);
        ui.addHeartbeatListener(events::add);
        ui.getInternals().setLastHeartbeatTimestamp(System.currentTimeMillis());
        Assertions.assertEquals((int)2, (int)events.size());
    }

    @Test
    public void setLastHeartbeatTimestamp_heartbeatListenerRemoved_listenerNotRun() {
        UI ui = new UI();
        UITest.initUI(ui, "", null);
        AtomicReference<Registration> reference = new AtomicReference<Registration>();
        AtomicInteger runCount = new AtomicInteger();
        Registration registration = ui.addHeartbeatListener((HeartbeatListener & Serializable)event -> {
            runCount.incrementAndGet();
            ((Registration)reference.get()).remove();
        });
        reference.set(registration);
        ui.getInternals().setLastHeartbeatTimestamp(System.currentTimeMillis());
        Assertions.assertEquals((int)1, (int)runCount.get(), (String)"Listener should have been run once");
        ui.getInternals().setLastHeartbeatTimestamp(System.currentTimeMillis());
        Assertions.assertEquals((int)1, (int)runCount.get(), (String)"Listener should not have been run again since it was removed");
    }

    @Test
    public void setSession_attachEventIsFired() throws InvalidRouteConfigurationException {
        UI ui = new UI();
        ArrayList events = new ArrayList();
        ui.addAttachListener(events::add);
        UITest.initUI(ui, "", null);
        Assertions.assertEquals((int)1, (int)events.size());
        Assertions.assertEquals((Object)ui, (Object)((AttachEvent)events.get(0)).getSource());
    }

    @Test
    public void unsetSession_detachEventIsFired() throws InvalidRouteConfigurationException {
        UI ui = UITest.createTestUI();
        ArrayList events = new ArrayList();
        ui.addDetachListener(events::add);
        UITest.initUI(ui, "", null);
        ui.getSession().access((Command & Serializable)() -> ui.getInternals().setSession(null));
        ui.getSession().unlock();
        Assertions.assertEquals((int)1, (int)events.size());
        Assertions.assertEquals((Object)ui, (Object)((DetachEvent)events.get(0)).getSource());
    }

    @Test
    public void unsetSession_detachEventIsFiredForUIChildren() throws InvalidRouteConfigurationException {
        UI ui = UITest.createTestUI();
        ArrayList events = new ArrayList();
        UITest.initUI(ui, "", null);
        AttachableComponent childComponent = new AttachableComponent();
        ui.add(new Component[]{childComponent});
        childComponent.addDetachListener(events::add);
        ui.getSession().access((Command & Serializable)() -> ui.getInternals().setSession(null));
        ui.getSession().unlock();
        Assertions.assertEquals((int)1, (int)events.size());
        Assertions.assertEquals((Object)((Object)childComponent), (Object)((DetachEvent)events.get(0)).getSource());
    }

    @Test
    public void unsetSession_detachEventIsFiredForElements() {
        UI ui = UITest.createTestUI();
        ArrayList events = new ArrayList();
        ui.getElement().addDetachListener(events::add);
        UITest.initUI(ui, "", null);
        AttachableComponent childComponent = new AttachableComponent();
        ui.add(new Component[]{childComponent});
        childComponent.getElement().addDetachListener(events::add);
        ui.getSession().access((Command & Serializable)() -> ui.getInternals().setSession(null));
        ui.getSession().unlock();
        Assertions.assertEquals((int)2, (int)events.size());
        Assertions.assertEquals((Object)childComponent.getElement(), (Object)((ElementDetachEvent)events.get(0)).getSource());
        Assertions.assertEquals((Object)ui.getElement(), (Object)((ElementDetachEvent)events.get(1)).getSource());
    }

    @Test
    public void unsetSession_accessErrorHandlerStillWorks() throws IOException {
        UI ui = UITest.createTestUI();
        UITest.initUI(ui, "", null);
        ui.getSession().access((Command & Serializable)() -> ui.getInternals().setSession(null));
        ui.access((Command & Serializable)() -> Assertions.fail((String)"We should never get here because the UI is detached"));
        ui.getSession().unlock();
        String logOutput = ((MockLogger)ui.getLogger()).getLogs();
        String logOutputNoDebug = logOutput.replaceAll("^\\[Debug\\].*", "");
        Assertions.assertFalse((boolean)logOutput.contains("NullPointerException"), (String)("No NullPointerException should be logged but got: " + logOutput));
        Assertions.assertFalse((boolean)logOutputNoDebug.contains("UIDetachedException"), (String)("No UIDetachedException should be logged but got: " + logOutputNoDebug));
    }

    @Test
    public void access_currentUIFilledInErrorHandler() {
        UI ui = UITest.createTestUI();
        UITest.initUI(ui, "", null);
        AtomicReference uiInErrorHandler = new AtomicReference();
        AtomicBoolean errorHandlerCalled = new AtomicBoolean();
        ui.getSession().setErrorHandler((ErrorHandler & Serializable)event -> {
            errorHandlerCalled.set(true);
            uiInErrorHandler.set(UI.getCurrent());
        });
        ui.access((Command & Serializable)() -> {
            throw new RuntimeException("Simulated");
        });
        ui.getSession().unlock();
        Assertions.assertTrue((boolean)errorHandlerCalled.get());
        Assertions.assertEquals((Object)ui, uiInErrorHandler.get());
    }

    @Test
    public void beforeClientResponse_regularOrder() {
        UI ui = UITest.createTestUI();
        AttachableComponent rootComponent = new AttachableComponent();
        ui.add(new Component[]{rootComponent});
        ArrayList results = new ArrayList();
        ui.beforeClientResponse((Component)rootComponent, (SerializableConsumer & Serializable)context -> results.add(0));
        ui.beforeClientResponse((Component)rootComponent, (SerializableConsumer & Serializable)context -> results.add(1));
        ui.beforeClientResponse((Component)rootComponent, (SerializableConsumer & Serializable)context -> results.add(2));
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        Assertions.assertTrue((results.size() == 3 ? 1 : 0) != 0, (String)"There should be 3 results in the list");
        for (int i = 0; i < results.size(); ++i) {
            Assertions.assertEquals((int)i, (int)((Integer)results.get(i)), (String)("The result at index '" + i + "' should be " + i));
        }
    }

    @Test
    public void beforeClientResponse_withInnerRunnables() {
        UI ui = UITest.createTestUI();
        AttachableComponent rootComponent = new AttachableComponent();
        ui.add(new Component[]{rootComponent});
        ArrayList results = new ArrayList();
        ui.beforeClientResponse((Component)rootComponent, (SerializableConsumer & Serializable)context -> results.add(0));
        ui.beforeClientResponse((Component)rootComponent, (SerializableConsumer & Serializable)context -> {
            results.add(1);
            ui.beforeClientResponse(rootComponent, (SerializableConsumer & Serializable)context2 -> results.add(3));
            ui.beforeClientResponse(rootComponent, (SerializableConsumer & Serializable)context2 -> results.add(4));
        });
        ui.beforeClientResponse((Component)rootComponent, (SerializableConsumer & Serializable)context -> results.add(2));
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        Assertions.assertTrue((results.size() == 5 ? 1 : 0) != 0, (String)"There should be 5 results in the list");
        for (int i = 0; i < results.size(); ++i) {
            Assertions.assertEquals((int)i, (int)((Integer)results.get(i)), (String)("The result at index '" + i + "' should be " + i));
        }
    }

    @Test
    public void beforeClientResponse_withUnattachedNodes() {
        UI ui = UITest.createTestUI();
        AttachableComponent rootComponent = new AttachableComponent();
        ui.add(new Component[]{rootComponent});
        AttachableComponent emptyComponent = new AttachableComponent();
        ArrayList results = new ArrayList();
        ui.beforeClientResponse((Component)emptyComponent, (SerializableConsumer & Serializable)context -> results.add(0));
        ui.beforeClientResponse((Component)rootComponent, (SerializableConsumer & Serializable)context -> results.add(1));
        ui.beforeClientResponse((Component)emptyComponent, (SerializableConsumer & Serializable)context -> results.add(2));
        ui.beforeClientResponse((Component)rootComponent, (SerializableConsumer & Serializable)context -> results.add(3));
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        Assertions.assertTrue((results.size() == 2 ? 1 : 0) != 0, (String)"There should be 2 results in the list");
        Assertions.assertEquals((int)1, (int)((Integer)results.get(0)), (String)"The result at index '0' should be 1");
        Assertions.assertEquals((int)3, (int)((Integer)results.get(1)), (String)"The result at index '1' should be 3");
    }

    @Test
    public void beforeClientResponse_withAttachedNodesDuringExecution() {
        UI ui = UITest.createTestUI();
        AttachableComponent rootComponent = new AttachableComponent();
        ui.add(new Component[]{rootComponent});
        AttachableComponent emptyComponent1 = new AttachableComponent();
        AttachableComponent emptyComponent2 = new AttachableComponent();
        ArrayList results = new ArrayList();
        ui.beforeClientResponse((Component)emptyComponent1, (SerializableConsumer & Serializable)context -> {
            results.add(0);
            ui.add(new Component[]{emptyComponent2});
        });
        ui.beforeClientResponse((Component)rootComponent, (SerializableConsumer & Serializable)context -> {
            results.add(1);
            ui.add(new Component[]{emptyComponent1});
        });
        ui.beforeClientResponse((Component)emptyComponent2, (SerializableConsumer & Serializable)context -> results.add(2));
        ui.beforeClientResponse((Component)rootComponent, (SerializableConsumer & Serializable)context -> results.add(3));
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        Assertions.assertTrue((results.size() == 4 ? 1 : 0) != 0, (String)"There should be 4 results in the list");
        Assertions.assertEquals((int)1, (int)((Integer)results.get(0)), (String)"The result at index '0' should be 1");
        Assertions.assertEquals((int)3, (int)((Integer)results.get(1)), (String)"The result at index '1' should be 3");
        Assertions.assertEquals((int)0, (int)((Integer)results.get(2)), (String)"The result at index '2' should be 0");
        Assertions.assertEquals((int)2, (int)((Integer)results.get(3)), (String)"The result at index '3' should be 2");
    }

    @Test
    public void beforeClientResponse_withReattachedNodes() {
        UI ui = UITest.createTestUI();
        AttachableComponent root = new AttachableComponent();
        ui.add(new Component[]{root});
        ui.getInternals().getStateTree().collectChanges(change -> {});
        AttachableComponent leaf = new AttachableComponent();
        ui.add(new Component[]{leaf});
        AtomicInteger callCounter = new AtomicInteger();
        ui.beforeClientResponse((Component)root, (SerializableConsumer & Serializable)context -> {
            Assertions.assertTrue((boolean)context.isClientSideInitialized(), (String)"Root component should be marked as 'clientSideInitialized'");
            callCounter.incrementAndGet();
        });
        ui.beforeClientResponse((Component)leaf, (SerializableConsumer & Serializable)context -> {
            Assertions.assertFalse((boolean)context.isClientSideInitialized(), (String)"Leaf component should NOT be marked as 'clientSideInitialized'");
            callCounter.incrementAndGet();
        });
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        ui.remove(new Component[]{root});
        ui.add(new Component[]{root});
        ui.beforeClientResponse((Component)root, (SerializableConsumer & Serializable)context -> {
            Assertions.assertTrue((boolean)context.isClientSideInitialized(), (String)"Reattached root component (in the same request) should be marked as 'clientSideInitialized'");
            callCounter.incrementAndGet();
        });
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        ui.remove(new Component[]{root});
        ui.getInternals().getStateTree().collectChanges(change -> {});
        ui.add(new Component[]{root});
        ui.beforeClientResponse((Component)root, (SerializableConsumer & Serializable)context -> {
            Assertions.assertFalse((boolean)context.isClientSideInitialized(), (String)"Reattached root component (in different requests) should NOT be marked as 'clientSideInitialized'");
            callCounter.incrementAndGet();
        });
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        Assertions.assertEquals((int)4, (int)callCounter.get(), (String)"There should be 4 invocations");
    }

    @Test
    public void beforeClientResponse_componentNotAttachedToUi_noException() {
        UI ui = UITest.createTestUI();
        AttachableComponent component = new AttachableComponent();
        ui.beforeClientResponse((Component)component, (SerializableConsumer & Serializable)context -> {});
    }

    @Test
    public void beforeClientResponse_componentBelongsToAnotherUI_throws() {
        UI firstUI = UITest.createTestUI();
        UI anotherUI = UITest.createTestUI();
        AttachableComponent component = new AttachableComponent();
        anotherUI.add(new Component[]{component});
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> firstUI.beforeClientResponse(component, (SerializableConsumer & Serializable)context -> {}));
        Assertions.assertEquals((Object)"The given component doesn't belong to the UI the task to be executed on", (Object)exception.getMessage());
    }

    @Test
    public void before_enter_listener_priority_should_dictate_sort_order() throws InvalidRouteConfigurationException {
        UI ui = UITest.createTestUI();
        UITest.initUI(ui, "", null);
        ui.addBeforeEnterListener((BeforeEnterListener)new BeforeEnterListenerThird());
        ui.addBeforeEnterListener((BeforeEnterListener)new BeforeEnterListenerThird());
        ui.addBeforeEnterListener((BeforeEnterListener)new BeforeEnterListenerFirst());
        ui.addBeforeEnterListener((BeforeEnterListener)new BeforeEnterListenerSecond());
        List beforeEnterListeners = ui.getNavigationListeners(BeforeEnterHandler.class);
        Assertions.assertEquals((int)4, (int)beforeEnterListeners.size());
        Assertions.assertTrue((boolean)(beforeEnterListeners.get(0) instanceof BeforeEnterListenerFirst));
        Assertions.assertTrue((boolean)(beforeEnterListeners.get(1) instanceof BeforeEnterListenerSecond));
        Assertions.assertTrue((boolean)(beforeEnterListeners.get(2) instanceof BeforeEnterListenerThird));
        Assertions.assertTrue((boolean)(beforeEnterListeners.get(3) instanceof BeforeEnterListenerThird));
    }

    @Test
    public void before_Leave_listener_priority_should_dictate_sort_order() throws InvalidRouteConfigurationException {
        UI ui = UITest.createTestUI();
        UITest.initUI(ui, "", null);
        ui.addBeforeLeaveListener((BeforeLeaveListener)new BeforeLeaveListenerFirst());
        ui.addBeforeLeaveListener((BeforeLeaveListener)new BeforeLeaveListenerThird());
        ui.addBeforeLeaveListener((BeforeLeaveListener)new BeforeLeaveListenerSecond());
        ui.addBeforeLeaveListener((BeforeLeaveListener)new BeforeLeaveListenerThird());
        List beforeLeaveListeners = ui.getNavigationListeners(BeforeLeaveHandler.class);
        Assertions.assertEquals((int)4, (int)beforeLeaveListeners.size());
        Assertions.assertTrue((boolean)(beforeLeaveListeners.get(0) instanceof BeforeLeaveListenerFirst));
        Assertions.assertTrue((boolean)(beforeLeaveListeners.get(1) instanceof BeforeLeaveListenerSecond));
        Assertions.assertTrue((boolean)(beforeLeaveListeners.get(2) instanceof BeforeLeaveListenerThird));
        Assertions.assertTrue((boolean)(beforeLeaveListeners.get(3) instanceof BeforeLeaveListenerThird));
    }

    @Test
    public void after_navigation_listener_priority_should_dictate_sort_order() throws InvalidRouteConfigurationException {
        UI ui = UITest.createTestUI();
        UITest.initUI(ui, "", null);
        ui.addAfterNavigationListener((AfterNavigationListener)new AfterNavigationListenerThird());
        ui.addAfterNavigationListener((AfterNavigationListener)new AfterNavigationListenerThird());
        ui.addAfterNavigationListener((AfterNavigationListener)new AfterNavigationListenerFirst());
        ui.addAfterNavigationListener((AfterNavigationListener)new AfterNavigationListenerSecond());
        List AfterNavigationListeners = ui.getNavigationListeners(AfterNavigationHandler.class);
        Assertions.assertEquals((int)4, (int)AfterNavigationListeners.size());
        Assertions.assertTrue((boolean)(AfterNavigationListeners.get(0) instanceof AfterNavigationListenerFirst));
        Assertions.assertTrue((boolean)(AfterNavigationListeners.get(1) instanceof AfterNavigationListenerSecond));
        Assertions.assertTrue((boolean)(AfterNavigationListeners.get(2) instanceof AfterNavigationListenerThird));
        Assertions.assertTrue((boolean)(AfterNavigationListeners.get(3) instanceof AfterNavigationListenerThird));
    }

    @Test
    public void accessLaterRunnable_nullHandler_exception() {
        MockUI ui = UITest.createAccessableTestUI();
        Assertions.assertThrows(NullPointerException.class, () -> ui.accessLater(null, (SerializableRunnable & Serializable)() -> {}));
    }

    @Test
    public void accessLaterRunnable_attachedUnlockedUi_runnableIsRun() {
        AtomicInteger runCount = new AtomicInteger();
        MockUI ui = UITest.createAccessableTestUI();
        CurrentInstance.clearAll();
        SerializableRunnable wrapped = ui.accessLater((SerializableRunnable & Serializable)() -> {
            Assertions.assertSame((Object)((Object)ui), (Object)UI.getCurrent(), (String)"Current UI should be defined");
            runCount.incrementAndGet();
        }, null);
        Assertions.assertNull((Object)UI.getCurrent(), (String)"Should not have a current UI outside the caller");
        Assertions.assertEquals((int)0, (int)runCount.get(), (String)"Task should not yet have run");
        wrapped.run();
        Assertions.assertNull((Object)UI.getCurrent(), (String)"Should not have a current UI outside the caller");
        Assertions.assertEquals((int)1, (int)runCount.get(), (String)"Task should have run once");
    }

    @Test
    public void accessLaterRunnable_detachedUiNoHandler_throws() {
        UI ui = UITest.createTestUI();
        SerializableRunnable wrapped = ui.accessLater((SerializableRunnable & Serializable)() -> Assertions.fail((String)"Action should never run"), null);
        Assertions.assertThrows(UIDetachedException.class, () -> wrapped.run());
    }

    @Test
    public void accessLaterRunnable_detachedUi_detachHandlerCalled() {
        AtomicInteger runCount = new AtomicInteger();
        UI ui = UITest.createTestUI();
        SerializableRunnable wrapped = ui.accessLater((SerializableRunnable & Serializable)() -> Assertions.fail((String)"Action should never run"), runCount::incrementAndGet);
        Assertions.assertEquals((int)0, (int)runCount.get(), (String)"Handler should not yet have run");
        wrapped.run();
        Assertions.assertEquals((int)1, (int)runCount.get(), (String)"Handler should have run once");
    }

    @Test
    public void getCurrentOrThrow_withCurrentUI_returnsUI() {
        UI ui = UITest.createTestUI();
        UI.setCurrent((UI)ui);
        UI result = UI.getCurrentOrThrow();
        Assertions.assertSame((Object)ui, (Object)result, (String)"getCurrentOrThrow should return the current UI");
    }

    @Test
    public void getCurrentOrThrow_withoutCurrentUI_throws() {
        CurrentInstance.clearAll();
        Assertions.assertThrows(IllegalStateException.class, () -> UI.getCurrentOrThrow());
    }

    @Test
    public void getCurrentOrThrow_withoutCurrentUI_throwsWithHelpfulMessage() {
        CurrentInstance.clearAll();
        try {
            UI.getCurrentOrThrow();
            Assertions.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("UI context"), (String)"Exception message should mention UI context");
            Assertions.assertTrue((boolean)e.getMessage().contains("UI.access()"), (String)"Exception message should mention UI.access()");
        }
    }

    @Test
    public void csrfToken_differentUIs_shouldBeUnique() {
        String token1 = new UI().getCsrfToken();
        String token2 = new UI().getCsrfToken();
        Assertions.assertNotEquals((Object)token1, (Object)token2, (String)"Each UI should have a unique CSRF token");
    }

    @Test
    public void csrfToken_sameUI_shouldBeSame() {
        UI ui = new UI();
        String token1 = ui.getCsrfToken();
        String token2 = ui.getCsrfToken();
        Assertions.assertEquals((Object)token1, (Object)token2, (String)"getCsrfToken() should always return the same value for the same UI");
    }

    @Test
    public void accessLaterConsumer_nullHandler_exception() {
        MockUI ui = UITest.createAccessableTestUI();
        Assertions.assertThrows(NullPointerException.class, () -> ui.accessLater(null, (SerializableRunnable & Serializable)() -> {}));
    }

    @Test
    public void accessLaterConsumer_attachedUnlockedUi_runnableIsRun() {
        AtomicInteger sum = new AtomicInteger();
        MockUI ui = UITest.createAccessableTestUI();
        CurrentInstance.clearAll();
        SerializableConsumer wrapped = ui.accessLater((SerializableConsumer & Serializable)value -> {
            Assertions.assertSame((Object)((Object)ui), (Object)UI.getCurrent(), (String)"Current UI should be defined");
            sum.addAndGet((int)value);
        }, null);
        Assertions.assertNull((Object)UI.getCurrent(), (String)"Should not have a current UI outside the caller");
        Assertions.assertEquals((int)0, (int)sum.get(), (String)"Task should not yet have run");
        wrapped.accept((Object)5);
        Assertions.assertNull((Object)UI.getCurrent(), (String)"Should not have a current UI outside the caller");
        Assertions.assertEquals((int)5, (int)sum.get(), (String)"Task should have run once");
    }

    @Test
    public void accessLaterConsumer_detachedUiNoHandler_throws() {
        UI ui = UITest.createTestUI();
        SerializableConsumer wrapped = ui.accessLater((SerializableConsumer & Serializable)value -> Assertions.fail((String)"Action should never run"), null);
        Assertions.assertThrows(UIDetachedException.class, () -> wrapped.accept(null));
    }

    @Test
    public void accessLaterConsumer_detachedUi_detachHandlerCalled() {
        AtomicInteger runCount = new AtomicInteger();
        UI ui = UITest.createTestUI();
        SerializableConsumer wrapped = ui.accessLater((SerializableConsumer & Serializable)value -> Assertions.fail((String)"Action should never run"), runCount::incrementAndGet);
        Assertions.assertEquals((int)0, (int)runCount.get(), (String)"Handler should not yet have run");
        wrapped.accept(null);
        Assertions.assertEquals((int)1, (int)runCount.get(), (String)"Handler should have run once");
    }

    @Test
    public void navigate_useParameterizedTarget_noOptionalAnnotation_navigationSucceded() {
        final AtomicReference loc = new AtomicReference();
        UI ui = new UI(){

            public void navigate(String location) {
                loc.set(location);
            }
        };
        UITest.initUI(ui, "", null);
        ui.navigate(Parameterized.class, (Object)"baz");
        Assertions.assertEquals((Object)"foo-bar/baz", loc.get());
    }

    @Test
    public void navigate_throws_illegal_argument_exception() {
        UI ui = new UI();
        UITest.initUI(ui, "", null);
        try {
            ui.navigate(Parameterized.class);
            Assertions.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().endsWith("requires a parameter."));
        }
        try {
            ui.navigate(Parameterized.class, (Object)null);
            Assertions.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().endsWith("requires a parameter."));
        }
        try {
            ui.navigate(Parameterized.class, RouteParameters.empty());
            Assertions.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().endsWith("requires a parameter."));
        }
        try {
            ui.navigate(Parameterized.class, new RouteParameters("some", "value"));
            Assertions.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().endsWith("requires a parameter."));
        }
    }

    @Test
    public void navigate_throws_null_pointer_exception() {
        UI ui = new UI();
        UITest.initUI(ui, "", null);
        try {
            ui.navigate((String)null);
            Assertions.fail((String)"NullPointerException expected.");
        }
        catch (NullPointerException e) {
            Assertions.assertEquals((Object)"Location must not be null", (Object)e.getMessage());
        }
        try {
            ui.navigate((String)null, QueryParameters.empty());
            Assertions.fail((String)"NullPointerException expected.");
        }
        catch (NullPointerException e) {
            Assertions.assertEquals((Object)"Location must not be null", (Object)e.getMessage());
        }
        try {
            ui.navigate("foo-bar", null);
            Assertions.fail((String)"NullPointerException expected.");
        }
        catch (NullPointerException e) {
            Assertions.assertEquals((Object)"Query parameters must not be null", (Object)e.getMessage());
        }
    }

    @Test
    public void navigate_throws_not_found_exception() {
        UI ui = new UI();
        UITest.initUI(ui, "", null);
        try {
            ui.navigate(FooBarParamNavigationTarget.class);
            Assertions.fail((String)"NotFoundException expected.");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            ui.navigate(ParameterizedNotRoute.class, (Object)1);
            Assertions.fail((String)"NotFoundException expected.");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            ui.navigate(FooBarParamNavigationTarget.class, new RouteParameters("fooParam", "123"));
            Assertions.fail((String)"NotFoundException expected.");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void modalComponent_addedAndRemoved_hasModalReturnsCorrectValue() {
        TestFixture fixture = new TestFixture();
        Assertions.assertTrue((boolean)fixture.ui.hasModalComponent(), (String)"Fixture should have set a modal component");
        fixture.ui.setChildComponentModal(fixture.modalComponent, false);
        Assertions.assertFalse((boolean)fixture.ui.hasModalComponent(), (String)"Setting modal to false should have removed all modality");
    }

    @Test
    public void modalVisualComponent_addedAndRemoved_hasModalReturnsCorrectValue() {
        TestFixture fixture = new TestFixture();
        Assertions.assertTrue((boolean)fixture.ui.hasModalComponent(), (String)"Fixture should have set a modal component");
        fixture.ui.setChildComponentModal(fixture.modalComponent, ModalityMode.VISUAL);
        Assertions.assertFalse((boolean)fixture.ui.hasModalComponent(), (String)"Setting modal to VISUAL should have removed all server side modality");
    }

    @Test
    public void modalComponentPresent_getActiveModalComponent_returnsExpectedComponent() {
        TestFixture fixture = new TestFixture();
        Assertions.assertEquals((Object)fixture.modalComponent, (Object)fixture.ui.getInternals().getActiveModalComponent(), (String)"modalComponent should be modal");
        fixture.ui.setChildComponentModal(fixture.routingComponent, true);
        Assertions.assertEquals((Object)fixture.routingComponent, (Object)fixture.ui.getInternals().getActiveModalComponent(), (String)"routingComponent should override modalComponent as active modal component");
        fixture.ui.setChildComponentModal(fixture.routingComponent, false);
        Assertions.assertEquals((Object)fixture.modalComponent, (Object)fixture.ui.getInternals().getActiveModalComponent(), (String)"modalComponent should return to active modal component when routingComponent made non modal");
    }

    @Test
    public void addToModalComponent_newComponentAdded_isAddedCorrectlyAsChild() {
        TestFixture fixture = new TestFixture();
        AttachableComponent test = new AttachableComponent();
        fixture.ui.addToModalComponent((Component)test);
        Optional testComponentParent = test.getParent();
        Assertions.assertTrue((boolean)testComponentParent.isPresent(), (String)"test component was not attached");
        Assertions.assertEquals((Object)fixture.ui.getInternals().getActiveModalComponent(), testComponentParent.get(), (String)"test component should have been attached to modalComponent");
    }

    @Test
    public void routingComponentVisible_modalComponentAdded_routingComponentInert() {
        TestFixture fixture = new TestFixture();
        this.verifyInert((Component)fixture.ui, false);
        this.verifyInert(fixture.routingComponent, false);
        this.verifyInert(fixture.modalComponent, false);
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, false);
        fixture.ui.remove(new Component[]{fixture.modalComponent});
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, false);
        this.verifyInert(fixture.routingComponent, false);
        this.verifyInert(fixture.modalComponent, false);
        fixture.ui.addModal(fixture.modalComponent);
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, false);
    }

    @Test
    public void routingComponentAndModalComponentVisible_modalComponentAdded_anotherModalComponentInert() {
        TestFixture fixture = new TestFixture();
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, false);
        AttachableComponent secondModal = new AttachableComponent();
        fixture.ui.addModal((Component)secondModal);
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, true);
        this.verifyInert(secondModal, false);
        fixture.ui.remove(new Component[]{secondModal});
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, false);
    }

    @Test
    public void modalComponentPresent_modalityChanged_routingComponentNotInert() {
        TestFixture fixture = new TestFixture();
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, false);
        fixture.ui.setChildComponentModal(fixture.modalComponent, false);
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, false);
        this.verifyInert(fixture.routingComponent, false);
        this.verifyInert(fixture.modalComponent, false);
        fixture.ui.setChildComponentModal(fixture.modalComponent, true);
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, false);
    }

    @Test
    public void modalComponentsPresent_newComponentAdded_isInert() {
        TestFixture fixture = new TestFixture();
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, false);
        AttachableComponent component = new AttachableComponent();
        fixture.ui.add(new Component[]{component});
        this.verifyInert(component, true);
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, false);
        this.verifyInert(component, true);
    }

    @Test
    public void modalComponent_addedAndRemovedBeforeResponse_noInertChanged() {
        TestFixture fixture = new TestFixture();
        this.verifyInert((Component)fixture.ui, false);
        this.verifyInert(fixture.routingComponent, false);
        this.verifyInert(fixture.modalComponent, false);
        fixture.ui.remove(new Component[]{fixture.modalComponent});
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, false);
        this.verifyInert(fixture.routingComponent, false);
        this.verifyInert(fixture.modalComponent, false);
    }

    @Test
    public void modalComponentsPresent_componentMoved_notModal() {
        TestFixture fixture = new TestFixture();
        fixture.collectUiChanges();
        fixture.ui.add(new Component[]{fixture.modalComponent});
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, false);
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, false);
        this.verifyInert(fixture.routingComponent, false);
        this.verifyInert(fixture.modalComponent, false);
    }

    @Test
    public void modalComponentPresent_sameModalAddedAgain_modeless() {
        TestFixture fixture = new TestFixture();
        fixture.collectUiChanges();
        fixture.ui.add(new Component[]{fixture.modalComponent});
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, false);
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, false);
        this.verifyInert(fixture.routingComponent, false);
        this.verifyInert(fixture.modalComponent, false);
    }

    @Test
    public void modalComponentPresent_toggleTopModalAgain_noChanges() {
        TestFixture fixture = new TestFixture();
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, false);
        fixture.ui.setChildComponentModal(fixture.modalComponent, true);
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, false);
    }

    @Test
    public void modelessComponentPresent_toggleModelessAgain_noChanges() {
        TestFixture fixture = new TestFixture();
        fixture.ui.setChildComponentModal(fixture.modalComponent, false);
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, false);
        this.verifyInert(fixture.routingComponent, false);
        this.verifyInert(fixture.modalComponent, false);
        fixture.ui.setChildComponentModal(fixture.modalComponent, true);
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, false);
    }

    @Test
    public void twoModalComponents_lowerComponentModelssAndTopMostRemoved_routingComponentNotInert() {
        TestFixture fixture = new TestFixture();
        AttachableComponent secondModal = new AttachableComponent();
        fixture.ui.addModal((Component)secondModal);
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, true);
        this.verifyInert(secondModal, false);
        fixture.ui.setChildComponentModal(fixture.modalComponent, false);
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, true);
        this.verifyInert(secondModal, false);
        fixture.ui.remove(new Component[]{secondModal});
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, false);
        this.verifyInert(fixture.routingComponent, false);
        this.verifyInert(fixture.modalComponent, false);
    }

    @Test
    public void twoModalComponents_topComponentMoved_modalComponentSwitches() {
        TestFixture fixture = new TestFixture();
        AttachableComponent secondModal = new AttachableComponent();
        fixture.ui.addModal((Component)secondModal);
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, true);
        this.verifyInert(secondModal, false);
        fixture.ui.add(new Component[]{secondModal});
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, false);
        this.verifyInert(secondModal, true);
    }

    @Test
    public void twoModalComponents_lowerComponentModalAgain_topComponentInert() {
        TestFixture fixture = new TestFixture();
        AttachableComponent secondModal = new AttachableComponent();
        fixture.ui.addModal((Component)secondModal);
        fixture.collectUiChanges();
        fixture.ui.setChildComponentModal(fixture.modalComponent, true);
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, false);
        this.verifyInert(secondModal, true);
        fixture.ui.remove(new Component[]{fixture.modalComponent});
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(secondModal, false);
    }

    @Test
    public void threeModalComponents_topComponentRemoved_onlyTopMostNotInert() {
        TestFixture fixture = new TestFixture();
        AttachableComponent secondModal = new AttachableComponent();
        AttachableComponent thirdModal = new AttachableComponent();
        fixture.ui.addModal((Component)secondModal);
        fixture.ui.addModal((Component)thirdModal);
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, true);
        this.verifyInert(secondModal, true);
        this.verifyInert(thirdModal, false);
        fixture.ui.remove(new Component[]{thirdModal});
        fixture.collectUiChanges();
        this.verifyInert((Component)fixture.ui, true);
        this.verifyInert(fixture.routingComponent, true);
        this.verifyInert(fixture.modalComponent, true);
        this.verifyInert(secondModal, false);
    }

    @Test
    public void getCurrentView_routingInitialized_getsCurrentRouteComponent() throws InvalidRouteConfigurationException {
        UI ui = new UI();
        UITest.initUI(ui, "", null);
        Component currentRoute = ui.getCurrentView();
        MatcherAssert.assertThat((Object)currentRoute, (Matcher)CoreMatchers.instanceOf(RootNavigationTarget.class));
        ui.navigate("foo/bar");
        currentRoute = ui.getCurrentView();
        MatcherAssert.assertThat((Object)currentRoute, (Matcher)CoreMatchers.instanceOf(FooBarNavigationTarget.class));
    }

    @Test
    public void getCurrentView_routingNotInitialized_throws() throws InvalidRouteConfigurationException {
        UI ui = new UI();
        Assertions.assertThrows(IllegalStateException.class, () -> ((UI)ui).getCurrentView());
    }

    private void verifyInert(Component component, boolean inert) {
        Assertions.assertEquals((Object)inert, (Object)component.getElement().getNode().isInert(), (String)"Invalid inert state");
    }

    @Route(value="foo/bar")
    @Tag(value="div")
    public static class FooBarNavigationTarget
    extends Component {
    }

    @Route(value=":barParam/bar", layout=FooBarParamParentNavigationTarget.class)
    @Tag(value="div")
    public static class FooBarParamNavigationTarget
    extends Component {
    }

    @RoutePrefix(value="foo/:fooParam")
    @Tag(value="div")
    public static class FooBarParamParentNavigationTarget
    extends Component
    implements RouterLayout {
    }

    private static class AttachableComponent
    extends Component {
        public AttachableComponent() {
            super(new Element("div"));
        }
    }

    @ListenerPriority(value=-5)
    private static class BeforeEnterListenerThird
    implements BeforeEnterListener {
        private BeforeEnterListenerThird() {
        }

        public void beforeEnter(BeforeEnterEvent event) {
        }
    }

    @ListenerPriority(value=5)
    private static class BeforeEnterListenerFirst
    implements BeforeEnterListener {
        private BeforeEnterListenerFirst() {
        }

        public void beforeEnter(BeforeEnterEvent event) {
        }
    }

    private static class BeforeEnterListenerSecond
    implements BeforeEnterListener {
        private BeforeEnterListenerSecond() {
        }

        public void beforeEnter(BeforeEnterEvent event) {
        }
    }

    @ListenerPriority(value=5)
    private static class BeforeLeaveListenerFirst
    implements BeforeLeaveListener {
        private BeforeLeaveListenerFirst() {
        }

        public void beforeLeave(BeforeLeaveEvent event) {
        }
    }

    @ListenerPriority(value=-5)
    private static class BeforeLeaveListenerThird
    implements BeforeLeaveListener {
        private BeforeLeaveListenerThird() {
        }

        public void beforeLeave(BeforeLeaveEvent event) {
        }
    }

    private static class BeforeLeaveListenerSecond
    implements BeforeLeaveListener {
        private BeforeLeaveListenerSecond() {
        }

        public void beforeLeave(BeforeLeaveEvent event) {
        }
    }

    @ListenerPriority(value=-5)
    private static class AfterNavigationListenerThird
    implements AfterNavigationListener {
        private AfterNavigationListenerThird() {
        }

        public void afterNavigation(AfterNavigationEvent event) {
        }
    }

    @ListenerPriority(value=5)
    private static class AfterNavigationListenerFirst
    implements AfterNavigationListener {
        private AfterNavigationListenerFirst() {
        }

        public void afterNavigation(AfterNavigationEvent event) {
        }
    }

    private static class AfterNavigationListenerSecond
    implements AfterNavigationListener {
        private AfterNavigationListenerSecond() {
        }

        public void afterNavigation(AfterNavigationEvent event) {
        }
    }

    @Route(value="foo-bar")
    @Tag(value="div")
    public static class Parameterized
    extends Component
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    @Tag(value="div")
    public static class ParameterizedNotRoute
    extends Component
    implements HasUrlParameter<Integer> {
        public void setParameter(BeforeEvent event, Integer parameter) {
        }
    }

    private static class TestFixture {
        public final UI ui = UITest.createTestUI();
        public final Component routingComponent;
        public final Component modalComponent;

        public TestFixture() {
            UITest.initUI(this.ui, "", null);
            this.routingComponent = (Component)this.ui.getChildren().findFirst().get();
            this.modalComponent = new AttachableComponent();
            this.ui.addModal(this.modalComponent);
        }

        public void collectUiChanges() {
            this.ui.getInternals().getStateTree().collectChanges(nodeChange -> {});
        }
    }

    @Route(value="")
    @Tag(value="div")
    public static class RootNavigationTarget
    extends Component {
    }

    private static class AttachedElementStateProvider
    extends AbstractTextElementStateProvider {
        private AttachedElementStateProvider() {
        }

        public boolean supports(StateNode node) {
            return true;
        }

        public Node getParent(StateNode node) {
            return null;
        }

        public String getTextContent(StateNode node) {
            return null;
        }

        public void setTextContent(StateNode node, String textContent) {
        }

        public void visit(StateNode node, NodeVisitor visitor) {
        }
    }
}

