/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Unit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HasSizeTest {
    HasSizeTest() {
    }

    @Test
    public void setWidth() {
        HasSizeComponent c = new HasSizeComponent();
        c.setWidth("100px");
        Assertions.assertEquals((Object)"100px", (Object)c.getWidth());
    }

    @Test
    public void setMinWidth() {
        HasSizeComponent c = new HasSizeComponent();
        c.setMinWidth("100px");
        Assertions.assertEquals((Object)"100px", (Object)c.getMinWidth());
    }

    @Test
    public void setMaxWidth() {
        HasSizeComponent c = new HasSizeComponent();
        c.setMaxWidth("100px");
        Assertions.assertEquals((Object)"100px", (Object)c.getMaxWidth());
    }

    @Test
    public void removeWidth() {
        HasSizeComponent c = new HasSizeComponent();
        c.setWidth("100px");
        Assertions.assertEquals((Object)"100px", (Object)c.getWidth());
        c.setWidth(null);
        Assertions.assertNull((Object)c.getWidth());
    }

    @Test
    public void removeMinWidth() {
        HasSizeComponent c = new HasSizeComponent();
        c.setMinWidth("100px");
        Assertions.assertEquals((Object)"100px", (Object)c.getMinWidth());
        c.setMinWidth(null);
        Assertions.assertNull((Object)c.getMinWidth());
    }

    @Test
    public void removeMaxWidth() {
        HasSizeComponent c = new HasSizeComponent();
        c.setMaxWidth("100px");
        Assertions.assertEquals((Object)"100px", (Object)c.getMaxWidth());
        c.setMaxWidth(null);
        Assertions.assertNull((Object)c.getMaxWidth());
    }

    @Test
    public void setHeight() {
        HasSizeComponent c = new HasSizeComponent();
        c.setHeight("100px");
        Assertions.assertEquals((Object)"100px", (Object)c.getHeight());
    }

    @Test
    public void setMinHeight() {
        HasSizeComponent c = new HasSizeComponent();
        c.setMinHeight("100px");
        Assertions.assertEquals((Object)"100px", (Object)c.getMinHeight());
    }

    @Test
    public void setMaxHeight() {
        HasSizeComponent c = new HasSizeComponent();
        c.setMaxHeight("100px");
        Assertions.assertEquals((Object)"100px", (Object)c.getMaxHeight());
    }

    @Test
    public void removeHeight() {
        HasSizeComponent c = new HasSizeComponent();
        c.setHeight("100px");
        Assertions.assertEquals((Object)"100px", (Object)c.getHeight());
        c.setHeight(null);
        Assertions.assertNull((Object)c.getHeight());
    }

    @Test
    public void removeMinHeight() {
        HasSizeComponent c = new HasSizeComponent();
        c.setMinHeight("100px");
        Assertions.assertEquals((Object)"100px", (Object)c.getMinHeight());
        c.setMinHeight(null);
        Assertions.assertNull((Object)c.getMinHeight());
    }

    @Test
    public void removeMaxHeight() {
        HasSizeComponent c = new HasSizeComponent();
        c.setMaxHeight("100px");
        Assertions.assertEquals((Object)"100px", (Object)c.getMaxHeight());
        c.setMaxHeight(null);
        Assertions.assertNull((Object)c.getMaxHeight());
    }

    @Test
    public void setSizeFull() {
        HasSizeComponent component = new HasSizeComponent();
        component.setSizeFull();
        Assertions.assertEquals((Object)"100%", (Object)component.getWidth());
        Assertions.assertEquals((Object)"100%", (Object)component.getHeight());
    }

    @Test
    public void setSizeFull_addsDataAttribute() {
        HasSizeComponent component = new HasSizeComponent();
        component.setSizeFull();
        Assertions.assertTrue((boolean)component.getElement().hasAttribute("data-width-full"));
        Assertions.assertTrue((boolean)component.getElement().hasAttribute("data-height-full"));
    }

    @Test
    public void setSizeFull_setSize_removesDataAttribute() {
        HasSizeComponent component = new HasSizeComponent();
        component.setSizeFull();
        component.setWidth("10px");
        Assertions.assertFalse((boolean)component.getElement().hasAttribute("data-width-full"));
        Assertions.assertTrue((boolean)component.getElement().hasAttribute("data-height-full"));
        component.setHeight("10px");
        Assertions.assertFalse((boolean)component.getElement().hasAttribute("data-width-full"));
        Assertions.assertFalse((boolean)component.getElement().hasAttribute("data-height-full"));
    }

    @Test
    public void setSizeFull_setSizeUndefined_removesDataAttribute() {
        HasSizeComponent component = new HasSizeComponent();
        component.setSizeFull();
        component.setSizeUndefined();
        Assertions.assertFalse((boolean)component.getElement().hasAttribute("data-width-full"));
        Assertions.assertFalse((boolean)component.getElement().hasAttribute("data-height-full"));
    }

    @Test
    public void setWidthFull() {
        HasSizeComponent component = new HasSizeComponent();
        component.setWidthFull();
        Assertions.assertEquals((Object)"100%", (Object)component.getWidth());
    }

    @Test
    public void setWidthFull_addsDataAttribute() {
        HasSizeComponent component = new HasSizeComponent();
        component.setWidthFull();
        Assertions.assertTrue((boolean)component.getElement().hasAttribute("data-width-full"));
        Assertions.assertFalse((boolean)component.getElement().hasAttribute("data-height-full"));
    }

    @Test
    public void setWidthFull_setWidth_removesDataAttribute() {
        HasSizeComponent component = new HasSizeComponent();
        component.setWidthFull();
        component.setWidth("10px");
        Assertions.assertFalse((boolean)component.getElement().hasAttribute("data-width-full"));
        Assertions.assertFalse((boolean)component.getElement().hasAttribute("data-height-full"));
    }

    @Test
    public void setHeightFull() {
        HasSizeComponent component = new HasSizeComponent();
        component.setHeightFull();
        Assertions.assertEquals((Object)"100%", (Object)component.getHeight());
    }

    @Test
    public void setHeightFull_addsDataAttribute() {
        HasSizeComponent component = new HasSizeComponent();
        component.setHeightFull();
        Assertions.assertFalse((boolean)component.getElement().hasAttribute("data-width-full"));
        Assertions.assertTrue((boolean)component.getElement().hasAttribute("data-height-full"));
    }

    @Test
    public void setHeightFull_setHeight_removesDataAttribute() {
        HasSizeComponent component = new HasSizeComponent();
        component.setHeightFull();
        component.setHeight("10px");
        Assertions.assertFalse((boolean)component.getElement().hasAttribute("data-width-full"));
        Assertions.assertFalse((boolean)component.getElement().hasAttribute("data-height-full"));
    }

    @Test
    public void setSizeUndefined() {
        HasSizeComponent component = new HasSizeComponent();
        component.setWidth("10px");
        component.setHeight("5em");
        component.setSizeUndefined();
        Assertions.assertNull((Object)component.getWidth());
        Assertions.assertNull((Object)component.getHeight());
    }

    @Test
    public void getWidthUnit() {
        HasSizeComponent component = new HasSizeComponent();
        Assertions.assertFalse((boolean)component.getWidthUnit().isPresent());
        component.setWidth("10px");
        Assertions.assertTrue((boolean)component.getWidthUnit().isPresent());
        Assertions.assertEquals((Object)Unit.PIXELS, component.getWidthUnit().get());
        component.setSizeUndefined();
        Assertions.assertFalse((boolean)component.getWidthUnit().isPresent());
    }

    @Test
    public void getHeightUnit() {
        HasSizeComponent component = new HasSizeComponent();
        Assertions.assertFalse((boolean)component.getHeightUnit().isPresent());
        component.setHeight("10%");
        Assertions.assertTrue((boolean)component.getHeightUnit().isPresent());
        Assertions.assertEquals((Object)Unit.PERCENTAGE, component.getHeightUnit().get());
        component.setSizeUndefined();
        Assertions.assertFalse((boolean)component.getHeightUnit().isPresent());
    }

    @Tag(value="div")
    public static class HasSizeComponent
    extends Component
    implements HasSize {
    }
}

