/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Html;
import com.vaadin.flow.dom.Element;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HTMLTest {
    HTMLTest() {
    }

    @Test
    public void attachedToElement() {
        new Html("<b>Hello</b>").getParent();
    }

    @Test
    public void nullHtml() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Html((String)null));
    }

    @Test
    public void nullStream() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Html((InputStream)null));
    }

    @Test
    public void emptyHtml() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Html(""));
    }

    @Test
    public void twoRoots() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Html("<b></b><div></div>"));
    }

    @Test
    public void text() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Html("hello"));
    }

    @Test
    public void simpleHtml() {
        Html html = new Html("<span>hello</span>");
        Assertions.assertEquals((Object)"span", (Object)html.getElement().getTag());
        Assertions.assertEquals((Object)"hello", (Object)html.getInnerHtml());
    }

    @Test
    public void setHtmlContent() {
        Html html = new Html("<span>hello</span>");
        Assertions.assertEquals((Object)"span", (Object)html.getElement().getTag());
        Assertions.assertEquals((Object)"hello", (Object)html.getInnerHtml());
        html.setHtmlContent("<span>world</span>");
        Assertions.assertEquals((Object)"world", (Object)html.getInnerHtml());
    }

    @Test
    public void setHtmlContent_tagMismatch() {
        Html html = new Html("<span>hello</span>");
        Assertions.assertEquals((Object)"span", (Object)html.getElement().getTag());
        Assertions.assertEquals((Object)"hello", (Object)html.getInnerHtml());
        Assertions.assertThrows(IllegalStateException.class, () -> html.setHtmlContent("<div>world</div>"));
    }

    @Test
    public void rootAttributes() {
        Html html = new Html("<span foo='bar'>hello</span>");
        Assertions.assertEquals((Object)"span", (Object)html.getElement().getTag());
        Assertions.assertEquals((long)1L, (long)html.getElement().getAttributeNames().count());
        Assertions.assertEquals((Object)"bar", (Object)html.getElement().getAttribute("foo"));
        Assertions.assertEquals((Object)"hello", (Object)html.getInnerHtml());
    }

    @Test
    public void rootSpecialAttributes() {
        Html html = new Html("<span class='foo' style='color: red'>hello</span>");
        Element element = html.getElement();
        Assertions.assertEquals((Object)"span", (Object)element.getTag());
        Assertions.assertEquals((long)2L, (long)element.getAttributeNames().count());
        Assertions.assertEquals((Object)"foo", (Object)element.getAttribute("class"));
        Assertions.assertEquals((Object)"color:red", (Object)element.getAttribute("style"));
        Assertions.assertEquals((Object)"hello", (Object)html.getInnerHtml());
    }

    @Test
    public void fromStream() {
        new Html((InputStream)new ByteArrayInputStream("<div><span>contents</span></div>".getBytes()));
    }

    @Test
    public void brokenHtml() {
        Html html = new Html("<b></div>");
        Assertions.assertEquals((Object)"b", (Object)html.getElement().getTag());
        Assertions.assertEquals((Object)"", (Object)html.getInnerHtml());
    }

    @Test
    public void extraWhitespace() {
        String input = "   <span>        <div>       <b>Hello!</b>    </div></span>  ";
        Html html = new Html(input);
        Assertions.assertEquals((Object)"span", (Object)html.getElement().getTag());
        String expectedInnerHtml = input.replaceAll("^[ ]*<span>", "").replaceAll("</span>[ ]*$", "");
        Assertions.assertEquals((Object)expectedInnerHtml, (Object)html.getInnerHtml());
    }

    @Test
    public void emptyAttribute_elementIsCreatedAndHasAttribute() {
        Html html = new Html("<audio controls></audio>");
        Assertions.assertEquals((Object)"", (Object)html.getElement().getAttribute("controls"));
        Assertions.assertEquals((Object)"<audio controls></audio>", (Object)html.getElement().getOuterHTML());
    }

    @Test
    public void styleElementAsString_elementIsUsed() {
        Html html = new Html("<style></style>");
        Assertions.assertEquals((Object)"style", (Object)html.getElement().getTag());
    }

    @Test
    public void styleElementAsStream_elementIsUsed() {
        Html html = new Html((InputStream)new ByteArrayInputStream("<style></style>".getBytes(StandardCharsets.UTF_8)));
        Assertions.assertEquals((Object)"style", (Object)html.getElement().getTag());
    }
}

