/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentTest;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.CompositeTest;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CompositeNestedTest {
    TestLayout layout;
    ComponentTest.TestComponent componentInComposite;
    Composite<?> compositeOuter;
    Composite<?> compositeInner;

    CompositeNestedTest() {
    }

    @BeforeEach
    public void setup() {
        this.layout = new TestLayout();
        this.componentInComposite = new ComponentTest.TestComponent(ElementFactory.createDiv((String)"Inside composite"));
        this.compositeInner = new TestComposite(this.componentInComposite){

            public String toString() {
                return "compositeInner";
            }
        };
        this.compositeOuter = new TestComposite((Component)this.compositeInner){

            public String toString() {
                return "compositeOuter";
            }
        };
        this.layout.addComponent(new Component[]{this.compositeOuter});
    }

    @Test
    public void compositeOuterElement() {
        Assertions.assertEquals((Object)this.componentInComposite.getElement(), (Object)this.compositeOuter.getElement());
    }

    @Test
    public void compositeInnerElement() {
        Assertions.assertEquals((Object)this.componentInComposite.getElement(), (Object)this.compositeInner.getElement());
    }

    @Test
    public void getParentElement_compositeOuter() {
        Assertions.assertEquals((Object)this.layout.getElement(), (Object)this.compositeOuter.getElement().getParent());
    }

    @Test
    public void getParentElement_compositeInner() {
        Assertions.assertEquals((Object)this.layout.getElement(), (Object)this.compositeInner.getElement().getParent());
    }

    @Test
    public void layoutChildElements() {
        CompositeTest.assertElementChildren(this.layout.getElement(), this.componentInComposite.getElement());
    }

    @Test
    public void getParent_compositeOuter() {
        Assertions.assertEquals((Object)this.layout, this.compositeOuter.getParent().get());
    }

    @Test
    public void getParent_compositeInner() {
        Assertions.assertEquals(this.compositeOuter, this.compositeInner.getParent().get());
    }

    @Test
    public void getParent_componentInComposite() {
        Assertions.assertEquals(this.compositeInner, this.componentInComposite.getParent().get());
    }

    @Test
    public void getChildren_layout() {
        ComponentTest.assertChildren(this.layout, new Component[]{this.compositeOuter});
    }

    @Test
    public void getChildren_compositeOuter() {
        ComponentTest.assertChildren(this.compositeOuter, new Component[]{this.compositeInner});
    }

    @Test
    public void getChildren_compositeInner() {
        ComponentTest.assertChildren(this.compositeInner, new Component[]{this.componentInComposite});
    }

    public static class TestLayout
    extends ComponentTest.TestComponent {
        public TestLayout() {
            super(ElementFactory.createDiv());
        }

        public void addComponent(Component ... components) {
            for (Component component : components) {
                this.getElement().appendChild(new Element[]{component.getElement()});
            }
        }
    }

    public static class TestComposite
    extends Composite<Component>
    implements ComponentTest.TracksAttachDetach {
        private Component content;
        private AtomicInteger attachEvents = new AtomicInteger();
        private AtomicInteger detachEvents = new AtomicInteger();

        public TestComposite(Component content) {
            this.content = content;
        }

        protected Component initContent() {
            return this.content;
        }

        @Override
        public AtomicInteger getAttachEvents() {
            return this.attachEvents;
        }

        @Override
        public AtomicInteger getDetachEvents() {
            return this.detachEvents;
        }
    }
}

