/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.communication.rpc.RpcDecodeException;
import com.vaadin.flow.server.communication.rpc.StringToEnumDecoder;
import org.junit.Assert;
import org.junit.Test;

public class EnumDecoderTest {
    private StringToEnumDecoder decoder = new StringToEnumDecoder();

    @Test
    public void isApplicable_applicableToStringAndEnum() {
        Assert.assertTrue((boolean)this.decoder.isApplicable(JacksonUtils.createNode((Object)"foo"), Title.class));
    }

    @Test
    public void isApplicable_notApplicableToBooleanAndEnum() {
        Assert.assertFalse((boolean)this.decoder.isApplicable(JacksonUtils.createNode((Object)true), Enum.class));
    }

    @Test
    public void isApplicable_notApplicableToStringAndString() {
        Assert.assertFalse((boolean)this.decoder.isApplicable(JacksonUtils.createNode((Object)"foo"), String.class));
    }

    @Test
    public void isApplicable_notApplicableToStringAndAbstractEnum() {
        Assert.assertFalse((boolean)this.decoder.isApplicable(JacksonUtils.createNode((Object)"foo"), Enum.class));
    }

    @Test
    public void stringToEnum_convertableString_valueIsConverted() throws RpcDecodeException {
        Title title = Title.MRS;
        Title decoded = (Title)((Object)this.decoder.decode(JacksonUtils.createNode((Object)title.name()), Title.class));
        Assert.assertEquals((Object)((Object)title), (Object)((Object)decoded));
    }

    @Test(expected=IllegalArgumentException.class)
    public void stringToEnum_nonConvertableString_valueIsConverted() throws RpcDecodeException {
        this.decoder.decode(JacksonUtils.createNode((Object)"foo"), Title.class);
    }

    static enum Title {
        MR,
        MRS;

    }
}

