/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.WebBrowser;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class WebBrowserTest {
    private WebBrowser browser = new WebBrowser();

    @Test
    public void isLinux_noDetails_returnsFalse() {
        Assert.assertFalse((boolean)this.browser.isLinux());
    }

    @Test
    public void isMacOSX_noDetails_returnsFalse() {
        Assert.assertFalse((boolean)this.browser.isMacOSX());
    }

    @Test
    public void isWindows_noDetails_returnsFalse() {
        Assert.assertFalse((boolean)this.browser.isWindows());
    }

    @Test
    public void isWindowsPhone_noDetails_returnsFalse() {
        Assert.assertFalse((boolean)this.browser.isWindowsPhone());
    }

    @Test
    public void isAndroid_noDetails_returnsFalse() {
        Assert.assertFalse((boolean)this.browser.isAndroid());
    }

    @Test
    public void isIPhone_noDetails_returnsFalse() {
        Assert.assertFalse((boolean)this.browser.isIPhone());
    }

    @Test
    public void isChromeOS_noDetails_returnsFalse() {
        Assert.assertFalse((boolean)this.browser.isChromeOS());
    }

    @Test
    public void isSafariOnMac_userDetails_returnsTrue() {
        VaadinRequest request = WebBrowserTest.initRequest("Mozilla/5.0 (Macintosh; Intel Mac OS X 11_6_2) AppleWebKit/611.3.10.1.5 (KHTML, like Gecko) Version/14.1.2 Safari/611.3.10.1.5");
        this.browser = new WebBrowser(request);
        Assert.assertTrue((boolean)this.browser.isSafari());
        Assert.assertTrue((boolean)this.browser.isMacOSX());
    }

    @Test
    public void isChromeOnWindows_userDetails_returnsTrue() {
        VaadinRequest request = WebBrowserTest.initRequest("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36");
        this.browser = new WebBrowser(request);
        Assert.assertTrue((boolean)this.browser.isChrome());
        Assert.assertTrue((boolean)this.browser.isWindows());
    }

    @Test
    public void isOperaOnWindows_userDetails_returnsTrue() {
        VaadinRequest request = WebBrowserTest.initRequest("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 OPR/115.0.0.0");
        this.browser = new WebBrowser(request);
        Assert.assertTrue((boolean)this.browser.isOpera());
        Assert.assertTrue((boolean)this.browser.isWindows());
    }

    @Test
    public void isFirefoxOnAndroid_userDetails_returnsTrue() {
        VaadinRequest request = WebBrowserTest.initRequest("Mozilla/5.0 (Android; Tablet; rv:33.0) Gecko/33.0 Firefox/33.0");
        this.browser = new WebBrowser(request);
        Assert.assertTrue((boolean)this.browser.isFirefox());
        Assert.assertTrue((boolean)this.browser.isAndroid());
    }

    private static VaadinRequest initRequest(String userAgent) {
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        Mockito.when((Object)request.getLocale()).thenReturn((Object)Locale.ENGLISH);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"0.0.0.0");
        Mockito.when((Object)request.isSecure()).thenReturn((Object)false);
        Mockito.when((Object)request.getHeader("User-Agent")).thenReturn((Object)userAgent);
        return request;
    }
}

