/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.junit.Assert;
import org.junit.Test;
import tools.jackson.databind.node.BaseJsonNode;

public class VirtualChildrenListTest {
    private StateNode node = new StateNode(new Class[]{VirtualChildrenList.class});
    private VirtualChildrenList list = (VirtualChildrenList)this.node.getFeature(VirtualChildrenList.class);
    private StateNode child = new StateNode(new Class[]{ElementData.class});

    @Test
    public void insert_atIndexWithType_payloadIsSetAndElementIsInserted() {
        this.list.add(0, this.child, "foo", (String)null);
        Assert.assertEquals((Object)this.child, (Object)this.list.get(0));
        BaseJsonNode payload = ((ElementData)this.child.getFeature(ElementData.class)).getPayload();
        Assert.assertNotNull((Object)payload);
        Assert.assertEquals((Object)"foo", (Object)payload.get("type").asString());
        StateNode anotherChild = new StateNode(new Class[]{ElementData.class});
        this.list.add(0, anotherChild, "bar", (String)null);
        Assert.assertEquals((Object)anotherChild, (Object)this.list.get(0));
        payload = ((ElementData)anotherChild.getFeature(ElementData.class)).getPayload();
        Assert.assertNotNull((Object)payload);
        Assert.assertEquals((Object)"bar", (Object)payload.get("type").asString());
    }

    @Test
    public void insert_atIndexWithPayload_payloadIsSetAndElementIsInserted() {
        this.list.add(0, this.child, "foo", "bar");
        Assert.assertEquals((Object)this.child, (Object)this.list.get(0));
        BaseJsonNode payload = ((ElementData)this.child.getFeature(ElementData.class)).getPayload();
        Assert.assertNotNull((Object)payload);
        Assert.assertEquals((Object)"foo", (Object)payload.get("type").asString());
        Assert.assertEquals((Object)"bar", (Object)payload.get("payload").asString());
    }

    @Test
    public void iteratorAndSize_addTwoItems_methodsReturnCorrectValues() {
        this.list.append(this.child, "foo");
        StateNode anotherChild = new StateNode(new Class[]{ElementData.class});
        this.list.append(anotherChild, "bar");
        Assert.assertEquals((long)2L, (long)this.list.size());
        Set set = StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.list.iterator(), 16), false).collect(Collectors.toSet());
        Assert.assertEquals((long)2L, (long)set.size());
        set.remove(this.child);
        set.remove(anotherChild);
        Assert.assertEquals((long)0L, (long)set.size());
    }

    @Test
    public void remove_withIndex_removesNodeAndPayload() {
        this.list.append(this.child, "foo");
        Assert.assertEquals((Object)this.child, (Object)this.list.get(0));
        this.list.remove(0);
        Assert.assertEquals((long)0L, (long)this.list.size());
        Assert.assertEquals((long)-1L, (long)this.list.indexOf(this.child));
        BaseJsonNode payload = ((ElementData)this.child.getFeature(ElementData.class)).getPayload();
        Assert.assertNull((Object)payload);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void clear_throw() {
        this.list.append(this.child, "foo");
        this.list.clear();
    }
}

