/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.component.page.History;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.impl.BasicElementStateProvider;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.menu.MenuRegistry;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.BeforeLeaveObserver;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLink;
import com.vaadin.flow.server.MockServletServiceSessionSetup;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.SyntheticState;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class JavaScriptBootstrapUITest {
    private static final String CLIENT_PUSHSTATE_TO = "setTimeout(() => { window.history.pushState($0, '', $1); window.dispatchEvent(new CustomEvent('vaadin-navigated')); })";
    private static final String REACT_PUSHSTATE_TO = "window.dispatchEvent(new CustomEvent('vaadin-navigate', { detail: { state: $0, url: $1, replace: false, callback: $2 } }));";
    private MockServletServiceSessionSetup mocks;
    private UI ui;

    @Before
    public void setup() throws Exception {
        this.mocks = new MockServletServiceSessionSetup();
        this.mocks.getService().getRouter().getRegistry().setRoute("clean", Clean.class, Collections.emptyList());
        this.mocks.getService().getRouter().getRegistry().setRoute("clean/1", Clean.class, Collections.emptyList());
        this.mocks.getService().getRouter().getRegistry().setRoute("dirty", Dirty.class, Collections.emptyList());
        this.mocks.getService().getRouter().getRegistry().setRoute("product", ProductView.class, Collections.emptyList());
        Class routeProxyClass = new ByteBuddy().subclass(ProductView.class).modifiers(new ModifierContributor.ForType[]{Visibility.PUBLIC, SyntheticState.SYNTHETIC}).make().load(ProductView.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded();
        this.mocks.getService().getRouter().getRegistry().setRoute("proxy-product", routeProxyClass, Collections.emptyList());
        this.mocks.getService().getRouter().getRegistry().setRoute("exception", FailOnException.class, Collections.emptyList());
        this.mocks.getService().getRouter().getRegistry().setRoute("forwardToClientSideViewOnBeforeEnter", ForwardToClientSideViewOnBeforeEnter.class, Collections.emptyList());
        this.mocks.getService().getRouter().getRegistry().setRoute("forwardToClientSideViewOnBeforeLeave", ForwardToClientSideViewOnBeforeLeave.class, Collections.emptyList());
        this.mocks.getService().getRouter().getRegistry().setRoute("rerouteToClientSideViewOnReroute", ForwardToClientSideViewOnReroute.class, Collections.emptyList());
        this.mocks.getService().getRouter().getRegistry().setRoute("forwardToServerSideViewOnBeforeEnter", ForwardToServerViewOnBeforeEnter.class, Collections.emptyList());
        this.ui = new UI();
        this.ui.getInternals().setSession(this.mocks.getSession());
        this.ui.doInit(null, 0, "appIdABC");
        CurrentInstance.setCurrent((UI)this.ui);
    }

    @After
    public void cleanup() {
        this.mocks.cleanup();
    }

    @Test
    public void should_allow_navigation() {
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "/clean", "", "", null, ""));
        Assert.assertEquals((Object)"header", (Object)this.ui.wrapperElement.getChild(0).getTag());
        Assert.assertEquals((Object)"h2", (Object)this.ui.wrapperElement.getChild(0).getChild(0).getTag());
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "/dirty", "", "", null, ""));
        Assert.assertEquals((Object)"span", (Object)this.ui.wrapperElement.getChild(0).getTag());
        Assert.assertEquals((Object)"h1", (Object)this.ui.wrapperElement.getChild(0).getChild(0).getTag());
    }

    @Test
    public void should_navigate_when_endingSlash() {
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "/clean/", "", "", null, ""));
        Assert.assertEquals((Object)"header", (Object)this.ui.wrapperElement.getChild(0).getTag());
        Assert.assertEquals((Object)"h2", (Object)this.ui.wrapperElement.getChild(0).getChild(0).getTag());
    }

    @Test
    public void getChildren_should_notReturnAnEmptyList() {
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "/clean", "", "", null, ""));
        Assert.assertEquals((long)1L, (long)this.ui.getChildren().count());
    }

    @Test
    public void addRemoveComponent_clientSideRouting_addsToBody() {
        Element uiElement = this.ui.getElement();
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "/clean", "", "", null, ""));
        Assert.assertEquals((long)1L, (long)this.ui.getChildren().count());
        Assert.assertEquals((long)0L, (long)uiElement.getChildCount());
        Assert.assertEquals((long)0L, (long)this.ui.getElement().getChildCount());
        RouterLink routerLink = new RouterLink();
        this.ui.add(new Component[]{routerLink});
        Assert.assertEquals((long)2L, (long)this.ui.getChildren().count());
        Assert.assertEquals((long)1L, (long)this.ui.getElement().getChildCount());
        Assert.assertEquals((long)1L, (long)uiElement.getChildCount());
        this.ui.add(new Component[]{new RouterLink()});
        Assert.assertEquals((long)3L, (long)this.ui.getChildren().count());
        Assert.assertEquals((long)2L, (long)this.ui.getElement().getChildCount());
        Assert.assertEquals((long)2L, (long)uiElement.getChildCount());
        this.ui.remove(new Component[]{routerLink});
        Assert.assertEquals((long)2L, (long)this.ui.getChildren().count());
        Assert.assertEquals((long)1L, (long)this.ui.getElement().getChildCount());
        Assert.assertEquals((long)1L, (long)uiElement.getChildCount());
    }

    @Test
    public void addComponent_clientSideRouterAndNavigation_componentsRemain() {
        Element uiElement = this.ui.getElement();
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "/clean", "", "", null, ""));
        RouterLink routerLink = new RouterLink();
        this.ui.add(new Component[]{routerLink});
        Assert.assertEquals((long)2L, (long)this.ui.getChildren().count());
        Assert.assertEquals((long)1L, (long)this.ui.getElement().getChildCount());
        Assert.assertEquals((long)1L, (long)uiElement.getChildCount());
        this.ui.navigate("product");
        Assert.assertEquals((long)2L, (long)this.ui.getChildren().count());
        Assert.assertEquals((long)1L, (long)this.ui.getElement().getChildCount());
        Assert.assertEquals((long)1L, (long)uiElement.getChildCount());
    }

    @Test
    public void should_prevent_navigation_on_dirty() {
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "/dirty", "", "", null, ""));
        Assert.assertEquals((Object)"span", (Object)this.ui.wrapperElement.getChild(0).getTag());
        Assert.assertEquals((Object)"h1", (Object)this.ui.wrapperElement.getChild(0).getChild(0).getTag());
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "/clean", "", "", null, ""));
        Assert.assertEquals((Object)"h1", (Object)this.ui.wrapperElement.getChild(0).getChild(0).getTag());
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "/errr", "", "", null, ""));
        Assert.assertEquals((Object)"h1", (Object)this.ui.wrapperElement.getChild(0).getChild(0).getTag());
    }

    @Test
    public void should_remove_content_on_leaveNavigation() {
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "/clean", "", "", null, ""));
        Assert.assertEquals((Object)"header", (Object)this.ui.wrapperElement.getChild(0).getTag());
        Assert.assertEquals((Object)"h2", (Object)this.ui.wrapperElement.getChild(0).getChild(0).getTag());
        this.ui.leaveNavigation(new UI.BrowserLeaveNavigationEvent(this.ui, true, "/client-view", ""));
        Assert.assertEquals((long)0L, (long)this.ui.wrapperElement.getChildCount());
    }

    @Test
    public void should_keep_content_on_leaveNavigation_postpone() {
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "/dirty", "", "", null, ""));
        Assert.assertEquals((Object)"span", (Object)this.ui.wrapperElement.getChild(0).getTag());
        Assert.assertEquals((Object)"h1", (Object)this.ui.wrapperElement.getChild(0).getChild(0).getTag());
        this.ui.leaveNavigation(new UI.BrowserLeaveNavigationEvent(this.ui, true, "/client-view", ""));
        Assert.assertEquals((Object)"span", (Object)this.ui.wrapperElement.getChild(0).getTag());
        Assert.assertEquals((Object)"h1", (Object)this.ui.wrapperElement.getChild(0).getChild(0).getTag());
    }

    @Test
    public void should_handle_forward_to_client_side_view_on_beforeEnter() {
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "/forwardToClientSideViewOnBeforeEnter", "", "", null, ""));
        Assert.assertEquals((Object)"client-view", (Object)this.ui.getForwardToClientUrl());
    }

    @Test
    public void should_not_handle_forward_to_client_side_view_on_beforeLeave() {
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "/forwardToClientSideViewOnBeforeLeave", "", "", null, ""));
        Assert.assertNull((Object)this.ui.getForwardToClientUrl());
    }

    @Test
    public void should_not_handle_forward_to_client_side_view_on_reroute() {
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "/forwardToClientSideViewOnReroute", "", "", null, ""));
        Assert.assertNull((Object)this.ui.getForwardToClientUrl());
    }

    @Test
    public void should_handle_forward_to_server_side_view_on_beforeEnter_and_update_url() {
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "/forwardToServerSideViewOnBeforeEnter", "", "", null, ""));
        Assert.assertEquals((Object)"header", (Object)this.ui.wrapperElement.getChild(0).getTag());
        Assert.assertEquals((Object)"h2", (Object)this.ui.wrapperElement.getChild(0).getChild(0).getTag());
        this.ui.navigate("product");
        Assert.assertEquals((Object)"my-product", (Object)this.ui.getInternals().getTitle());
        Assert.assertEquals((Object)"productView", ((Component)this.ui.getChildren().findFirst().get()).getId().get());
        this.ui.navigate("forwardToServerSideViewOnBeforeEnter");
        Assert.assertEquals((Object)"header", (Object)this.ui.wrapperElement.getChild(0).getTag());
        Assert.assertEquals((Object)"h2", (Object)this.ui.wrapperElement.getChild(0).getChild(0).getTag());
    }

    @Test
    public void should_show_error_page() {
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "/err", "", "", null, ""));
        Assert.assertEquals((Object)"div", (Object)this.ui.wrapperElement.getChild(0).getTag());
        Assert.assertTrue((boolean)this.ui.wrapperElement.toString().contains("Available routes:"));
    }

    @Test
    public void should_invoke_clientRoute_when_navigationHasNotBeenStarted() {
        this.ui = (UI)Mockito.spy((Object)this.ui);
        Page page = this.mockPage();
        ArgumentCaptor execJs = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor execArg = ArgumentCaptor.forClass(String.class);
        this.ui.navigate("whatever");
        ((Page)Mockito.verify((Object)page)).executeJs((String)execJs.capture(), new Object[]{execArg.capture()});
        Assert.assertEquals((Object)"const url = new URL($0, document.baseURI);\nurl[\"clientNavigation\"] = true;\nwindow.dispatchEvent(new CustomEvent('vaadin-router-go', { detail: url}));\n", (Object)execJs.getValue());
        Assert.assertEquals((Object)"whatever", (Object)execArg.getValue());
    }

    @Test
    public void should_update_pushState_when_navigationHasBeenAlreadyStarted() {
        this.ui = (UI)Mockito.spy((Object)this.ui);
        Page page = this.mockPage();
        UIInternals internals = this.mockUIInternals();
        VaadinSession session = this.mocks.getSession();
        DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)internals.getSession()).thenReturn((Object)session);
        Mockito.when((Object)session.getConfiguration()).thenReturn((Object)configuration);
        ((MockDeploymentConfiguration)session.getService().getDeploymentConfiguration()).setReactEnabled(false);
        Mockito.when((Object)internals.hasLastHandledLocation()).thenReturn((Object)true);
        Location lastLocation = new Location("clean");
        Mockito.when((Object)internals.getLastHandledLocation()).thenReturn((Object)lastLocation);
        StateTree stateTree = (StateTree)Mockito.mock(StateTree.class);
        Mockito.when((Object)internals.getStateTree()).thenReturn((Object)stateTree);
        Mockito.when((Object)internals.getTitle()).thenReturn((Object)"");
        StateNode stateNode = BasicElementStateProvider.createStateNode((String)"foo-element");
        Mockito.when((Object)stateTree.getRootNode()).thenReturn((Object)stateNode);
        ArgumentCaptor execJs = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor execArg = ArgumentCaptor.forClass(Object[].class);
        try (MockedStatic menuRegistry = Mockito.mockStatic(MenuRegistry.class);){
            menuRegistry.when(() -> MenuRegistry.hasClientRoute((String)"clean/1", (boolean)true)).thenReturn((Object)false);
            this.ui.navigate("clean/1");
            ((Page)Mockito.verify((Object)page)).executeJs((String)execJs.capture(), (Object[])execArg.capture());
            boolean reactEnabled = this.ui.getSession().getConfiguration().isReactEnabled();
            Object[] execValues = (Object[])execArg.getValue();
            if (reactEnabled) {
                Assert.assertEquals((Object)REACT_PUSHSTATE_TO, (Object)execJs.getValue());
                Assert.assertEquals((long)1L, (long)execValues.length);
                Assert.assertEquals((Object)"clean/1", (Object)execValues[0]);
            } else {
                Assert.assertEquals((Object)CLIENT_PUSHSTATE_TO, (Object)execJs.getValue());
                Assert.assertEquals((long)2L, (long)execValues.length);
                Assert.assertNull((Object)execValues[0]);
                Assert.assertEquals((Object)"clean/1", (Object)execValues[1]);
            }
        }
    }

    @Test
    public void should_not_notify_clientRoute_when_navigatingToTheSame() {
        this.ui = (UI)Mockito.spy((Object)this.ui);
        Page page = this.mockPage();
        UIInternals internals = this.mockUIInternals();
        Mockito.when((Object)internals.hasLastHandledLocation()).thenReturn((Object)true);
        Location lastLocation = new Location("clean");
        Mockito.when((Object)internals.getLastHandledLocation()).thenReturn((Object)lastLocation);
        this.ui.navigate("clean/");
        ((Page)Mockito.verify((Object)page, (VerificationMode)Mockito.never())).executeJs(Mockito.anyString(), new Object[]{Mockito.anyString()});
    }

    @Test
    public void server_should_not_doClientRoute_when_navigatingToServer() {
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "/clean", "", "", null, ""));
        Assert.assertEquals((Object)"header", (Object)this.ui.wrapperElement.getChild(0).getTag());
        Assert.assertEquals((Object)"h2", (Object)this.ui.wrapperElement.getChild(0).getChild(0).getTag());
        this.ui = (UI)Mockito.spy((Object)this.ui);
        Page page = this.mockPage();
        ArgumentCaptor execJs = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor execArg = ArgumentCaptor.forClass(Object[].class);
        this.ui.navigate("dirty");
        Assert.assertEquals((Object)"span", (Object)this.ui.wrapperElement.getChild(0).getTag());
        ((Page)Mockito.verify((Object)page)).executeJs((String)execJs.capture(), (Object[])execArg.capture());
        boolean reactEnabled = this.ui.getSession().getConfiguration().isReactEnabled();
        Object[] execValues = (Object[])execArg.getValue();
        if (reactEnabled) {
            Assert.assertEquals((Object)REACT_PUSHSTATE_TO, (Object)execJs.getValue());
        } else {
            Assert.assertEquals((Object)CLIENT_PUSHSTATE_TO, (Object)execJs.getValue());
        }
        Assert.assertEquals((long)3L, (long)execValues.length);
        Assert.assertNull((Object)execValues[0]);
        Assert.assertEquals((Object)"dirty", (Object)execValues[1]);
    }

    @Test
    public void should_updatePageTitle_when_serverNavigation() {
        this.ui.navigate("empty");
        Assert.assertNull((Object)this.ui.getInternals().getTitle());
        this.ui.navigate("product");
        Assert.assertEquals((Object)"my-product", (Object)this.ui.getInternals().getTitle());
    }

    @Test
    public void should_updatePageTitle_when_serverNavigationToProxyViewClass() {
        this.ui.navigate("empty");
        Assert.assertNull((Object)this.ui.getInternals().getTitle());
        this.ui.navigate("proxy-product");
        Assert.assertEquals((Object)"my-product", (Object)this.ui.getInternals().getTitle());
    }

    @Test
    public void should_removeTitle_when_noAppShellTitle() {
        this.ui.navigate("empty");
        Assert.assertNull((Object)this.ui.getInternals().getTitle());
        this.ui.navigate("dirty");
        Assert.assertEquals((Object)"", (Object)this.ui.getInternals().getTitle());
    }

    @Test
    public void should_restoreIndexHtmlTitle() {
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "empty", "", "app-shell-title", null, ""));
        Assert.assertEquals((Object)"", (Object)this.ui.getInternals().getTitle());
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "dirty", "", "app-shell-title", null, ""));
        Assert.assertEquals((Object)"app-shell-title", (Object)this.ui.getInternals().getTitle());
    }

    @Test
    public void should_not_share_dynamic_app_title_for_different_UIs() {
        String dynamicTitle = UUID.randomUUID().toString();
        this.ui.browserNavigate(new UI.BrowserNavigateEvent(this.ui, true, "clean", "", dynamicTitle, null, ""));
        Assert.assertEquals((Object)dynamicTitle, (Object)this.ui.getInternals().getTitle());
        String anotherDynamicTitle = UUID.randomUUID().toString();
        UI anotherUI = new UI();
        anotherUI.getInternals().setSession(this.mocks.getSession());
        anotherUI.doInit(null, 0, "anotherUiId");
        anotherUI.browserNavigate(new UI.BrowserNavigateEvent(anotherUI, true, "clean", "", anotherDynamicTitle, null, ""));
        Assert.assertEquals((Object)anotherDynamicTitle, (Object)anotherUI.getInternals().getTitle());
        this.ui.navigate("dirty");
        Assert.assertEquals((Object)dynamicTitle, (Object)this.ui.getInternals().getTitle());
    }

    @Test
    public void navigate_firsClientSideRoutingThrows_navigationInProgressIsReset_secondClientSideRoutingWorks() {
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        Mockito.when((Object)session.getService()).thenReturn((Object)service);
        Router router = (Router)Mockito.mock(Router.class);
        Mockito.when((Object)service.getRouter()).thenReturn((Object)router);
        ((Router)Mockito.doThrow(RuntimeException.class).when((Object)router)).resolveNavigationTarget((Location)Mockito.any());
        UI ui = new UI();
        ui.getInternals().setSession(session);
        try {
            ui.navigate("foo", QueryParameters.empty());
        }
        catch (RuntimeException expected) {
            router = (Router)Mockito.mock(Router.class);
            Mockito.when((Object)service.getRouter()).thenReturn((Object)router);
            Mockito.when((Object)router.resolveNavigationTarget((Location)Mockito.any())).thenReturn(Optional.empty());
            ui.navigate("foo", QueryParameters.empty());
            ((Router)Mockito.verify((Object)router)).resolveNavigationTarget((Location)Mockito.any());
            return;
        }
        Assert.fail();
    }

    private void assertExceptionComponent(Class<?> errorClass, String ... exceptionTexts) {
        Optional visibleComponent = this.ui.getElement().getChild(0).getComponent();
        Assert.assertTrue((String)"No navigation component visible", (boolean)visibleComponent.isPresent());
        Component internalServerError = (Component)visibleComponent.get();
        Assert.assertEquals(errorClass, internalServerError.getClass());
        String errorText = internalServerError.getElement().getText();
        for (String exceptionText : exceptionTexts) {
            Assert.assertTrue((String)("Expected the error text to contain '" + exceptionText + "'"), (boolean)errorText.contains(exceptionText));
        }
    }

    private Page mockPage() {
        Page page = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)this.ui.getPage()).thenReturn((Object)page);
        History history = new History(this.ui);
        Mockito.when((Object)page.getHistory()).thenReturn((Object)history);
        return page;
    }

    private UIInternals mockUIInternals() {
        UIInternals internals = (UIInternals)Mockito.mock(UIInternals.class);
        Mockito.when((Object)this.ui.getInternals()).thenReturn((Object)internals);
        Mockito.when((Object)internals.getRouter()).thenReturn((Object)this.mocks.getService().getRouter());
        return internals;
    }

    @Route(value="clean")
    @Tag(value="header")
    public static class Clean
    extends Component
    implements HasComponents {
        public Clean() {
            this.add(new Component[]{new CleanChild()});
        }
    }

    @Route(value="dirty")
    @Tag(value="span")
    public static class Dirty
    extends Component
    implements HasComponents {
        public Dirty() {
            this.add(new Component[]{new DirtyChild()});
        }
    }

    @Route(value="product")
    @Tag(value="span")
    @PageTitle(value="my-product")
    public static class ProductView
    extends Component
    implements HasComponents {
        public ProductView() {
            UI.getCurrent().navigate("product");
            this.setId("productView");
        }
    }

    @Route(value="exception")
    @Tag(value="div")
    public static class FailOnException
    extends Component
    implements BeforeEnterObserver {
        public void beforeEnter(BeforeEnterEvent event) {
            throw new RuntimeException("Failed on an exception");
        }
    }

    @Route(value="forwardToClientSideViewOnBeforeEnter")
    @Tag(value="div")
    public static class ForwardToClientSideViewOnBeforeEnter
    extends Component
    implements BeforeEnterObserver {
        public void beforeEnter(BeforeEnterEvent event) {
            event.forwardTo("client-view");
        }
    }

    @Route(value="forwardToClientSideViewOnBeforeLeave")
    @Tag(value="div")
    public static class ForwardToClientSideViewOnBeforeLeave
    extends Component
    implements BeforeLeaveObserver {
        public void beforeLeave(BeforeLeaveEvent event) {
            event.forwardTo("client-view");
        }
    }

    @Route(value="rerouteToClientSideViewOnReroute")
    @Tag(value="div")
    public static class ForwardToClientSideViewOnReroute
    extends Component
    implements BeforeLeaveObserver,
    BeforeEnterObserver {
        public void beforeLeave(BeforeLeaveEvent event) {
            event.rerouteTo("client-view");
        }

        public void beforeEnter(BeforeEnterEvent event) {
            event.rerouteTo("client-view");
        }
    }

    @Route(value="forwardToServerSideViewOnBeforeEnter")
    @Tag(value="div")
    public static class ForwardToServerViewOnBeforeEnter
    extends Component
    implements BeforeEnterObserver {
        public void beforeEnter(BeforeEnterEvent event) {
            event.forwardTo("clean");
        }
    }

    @Tag(value="h1")
    public static class DirtyChild
    extends Component
    implements BeforeLeaveObserver {
        public void beforeLeave(BeforeLeaveEvent event) {
            event.postpone();
        }
    }

    @Tag(value="h2")
    public static class CleanChild
    extends Component
    implements BeforeLeaveObserver {
        public void beforeLeave(BeforeLeaveEvent event) {
        }
    }

    @PageTitle(value="app-shell-title")
    public static class AppShell
    implements AppShellConfigurator {
    }
}

