/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.ClipboardCopy;
import com.vaadin.flow.component.page.ClipboardEvent;
import com.vaadin.flow.component.page.ClipboardFile;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.nodefeature.ReturnChannelMap;
import com.vaadin.flow.internal.nodefeature.ReturnChannelRegistration;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.StreamRegistration;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.streams.UploadHandler;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import tools.jackson.databind.JsonNode;

public interface Clipboard
extends Serializable {
    public static ClipboardCopy copyOnClick(Component trigger, String text) {
        Objects.requireNonNull(trigger, "Trigger component must not be null");
        Element element = trigger.getElement();
        element.setProperty("__clipboardText", text != null ? text : "");
        element.executeJs("window.Vaadin.Flow.clipboard.setupCopyOnClick(this)", new Object[0]);
        Registration cleanup = Registration.once(() -> element.executeJs("window.Vaadin.Flow.clipboard.cleanupCopyOnClick(this)", new Object[0]));
        return new ClipboardCopy(element, cleanup);
    }

    public static ClipboardCopy copyOnClick(Component trigger, String text, Command onSuccess, Command onError) {
        Objects.requireNonNull(trigger, "Trigger component must not be null");
        Element element = trigger.getElement();
        element.setProperty("__clipboardText", text != null ? text : "");
        ReturnChannelRegistration successChannel = element.getNode().getFeature(ReturnChannelMap.class).registerChannel(args -> {
            if (onSuccess != null) {
                onSuccess.execute();
            }
        });
        ReturnChannelRegistration errorChannel = element.getNode().getFeature(ReturnChannelMap.class).registerChannel(args -> {
            if (onError != null) {
                onError.execute();
            }
        });
        element.executeJs("window.Vaadin.Flow.clipboard.setupCopyOnClickWithCallbacks(this, $0, $1)", successChannel, errorChannel);
        Registration cleanup = Registration.once(() -> {
            successChannel.remove();
            errorChannel.remove();
            element.executeJs("window.Vaadin.Flow.clipboard.cleanupCopyOnClick(this)", new Object[0]);
        });
        return new ClipboardCopy(element, cleanup);
    }

    public static ClipboardCopy copyOnClick(Component trigger, Component source) {
        Objects.requireNonNull(trigger, "Trigger component must not be null");
        Objects.requireNonNull(source, "Source component must not be null");
        Element element = trigger.getElement();
        element.executeJs("window.Vaadin.Flow.clipboard.setupCopyOnClickFromSource(this, $0)", source.getElement());
        Registration cleanup = Registration.once(() -> element.executeJs("window.Vaadin.Flow.clipboard.cleanupCopyOnClick(this)", new Object[0]));
        return new ClipboardCopy(element, cleanup);
    }

    public static ClipboardCopy copyImageOnClick(Component trigger, Component imageSource) {
        Objects.requireNonNull(trigger, "Trigger component must not be null");
        Objects.requireNonNull(imageSource, "Image source component must not be null");
        Element element = trigger.getElement();
        element.executeJs("window.Vaadin.Flow.clipboard.setupCopyImageOnClick(this, $0)", imageSource.getElement());
        Registration cleanup = Registration.once(() -> element.executeJs("window.Vaadin.Flow.clipboard.cleanupCopyOnClick(this)", new Object[0]));
        return new ClipboardCopy(element, cleanup);
    }

    public static PendingJavaScriptResult writeText(String text) {
        return Clipboard.writeText(UI.getCurrentOrThrow(), text);
    }

    public static PendingJavaScriptResult writeText(UI ui, String text) {
        return ui.getPage().executeJs("return window.Vaadin.Flow.clipboard.writeText($0)", text);
    }

    public static void writeText(String text, Command onSuccess, SerializableConsumer<String> onError) {
        Clipboard.writeText(UI.getCurrentOrThrow(), text, onSuccess, onError);
    }

    public static void writeText(UI ui, String text, Command onSuccess, SerializableConsumer<String> onError) {
        PendingJavaScriptResult result = Clipboard.writeText(ui, text);
        result.then(JsonNode.class, value -> {
            if (onSuccess != null) {
                onSuccess.execute();
            }
        }, error -> {
            if (onError != null) {
                onError.accept((String)error);
            }
        });
    }

    public static void readText(SerializableConsumer<String> callback) {
        Clipboard.readText(UI.getCurrentOrThrow(), callback);
    }

    public static void readText(UI ui, SerializableConsumer<String> callback) {
        Objects.requireNonNull(callback, "Callback must not be null");
        ui.getPage().executeJs("return window.Vaadin.Flow.clipboard.readText()", new Object[0]).then(String.class, callback);
    }

    public static PendingJavaScriptResult writeImage(String imageUrl) {
        return Clipboard.writeImage(UI.getCurrentOrThrow(), imageUrl);
    }

    public static PendingJavaScriptResult writeImage(UI ui, String imageUrl) {
        return ui.getPage().executeJs("return window.Vaadin.Flow.clipboard.writeImage($0)", imageUrl);
    }

    public static PendingJavaScriptResult writeImage(StreamResource resource) {
        return Clipboard.writeImage(UI.getCurrentOrThrow(), resource);
    }

    public static PendingJavaScriptResult writeImage(UI ui, StreamResource resource) {
        Objects.requireNonNull(resource, "Resource must not be null");
        StreamRegistration registration = ui.getSession().getResourceRegistry().registerResource(resource);
        String url = registration.getResourceUri().toString();
        return Clipboard.writeImage(ui, url);
    }

    public static Registration addPasteListener(Component target, SerializableConsumer<ClipboardEvent> listener) {
        Objects.requireNonNull(target, "Target component must not be null");
        Objects.requireNonNull(listener, "Listener must not be null");
        Element element = target.getElement();
        PasteState pasteState = new PasteState(listener);
        element.setAttribute("__clipboard-paste-upload", UploadHandler.inMemory((metadata, data) -> pasteState.addFile(new ClipboardFile(metadata.fileName(), metadata.contentType(), metadata.contentLength(), data))));
        ReturnChannelRegistration channel = element.getNode().getFeature(ReturnChannelMap.class).registerChannel(args -> {
            String text = args.get(0).isNull() ? null : args.get(0).asText();
            String html = args.get(1).isNull() ? null : args.get(1).asText();
            int fileCount = args.get(2).asInt();
            pasteState.setTextData(text, html, fileCount);
        });
        element.executeJs("window.Vaadin.Flow.clipboard.setupPasteListener(this, $0)", channel);
        return Registration.once(() -> {
            channel.remove();
            element.removeAttribute("__clipboard-paste-upload");
            element.executeJs("window.Vaadin.Flow.clipboard.cleanupPasteListener(this)", new Object[0]);
        });
    }

    public static Registration addCopyListener(Component target, SerializableConsumer<ClipboardEvent> listener) {
        return Clipboard.addClipboardEventListener(target, "copy", listener);
    }

    public static Registration addCutListener(Component target, SerializableConsumer<ClipboardEvent> listener) {
        return Clipboard.addClipboardEventListener(target, "cut", listener);
    }

    private static Registration addClipboardEventListener(Component target, String eventType, SerializableConsumer<ClipboardEvent> listener) {
        Objects.requireNonNull(target, "Target component must not be null");
        Objects.requireNonNull(listener, "Listener must not be null");
        Element element = target.getElement();
        DomListenerRegistration reg = element.addEventListener(eventType, domEvent -> {
            JsonNode data = domEvent.getEventData();
            String textKey = "event.clipboardData.getData('text/plain')";
            String htmlKey = "event.clipboardData.getData('text/html')";
            String text = data.has(textKey) && !data.get(textKey).isNull() ? data.get(textKey).asText() : null;
            String html = data.has(htmlKey) && !data.get(htmlKey).isNull() ? data.get(htmlKey).asText() : null;
            listener.accept(new ClipboardEvent(eventType, text, html, List.of()));
        });
        reg.addEventData("event.clipboardData.getData('text/plain')");
        reg.addEventData("event.clipboardData.getData('text/html')");
        return reg;
    }

    public static class PasteState
    implements Serializable {
        private final SerializableConsumer<ClipboardEvent> listener;
        private String text;
        private String html;
        private int expectedFileCount = -1;
        private final List<ClipboardFile> files = new ArrayList<ClipboardFile>();
        private boolean dispatched = false;

        PasteState(SerializableConsumer<ClipboardEvent> listener) {
            this.listener = listener;
        }

        synchronized void setTextData(String text, String html, int fileCount) {
            this.text = text;
            this.html = html;
            this.expectedFileCount = fileCount;
            this.dispatched = false;
            this.files.clear();
            this.tryDispatch();
        }

        synchronized void addFile(ClipboardFile file) {
            this.files.add(file);
            this.tryDispatch();
        }

        private void tryDispatch() {
            if (this.dispatched || this.expectedFileCount < 0) {
                return;
            }
            if (this.files.size() >= this.expectedFileCount) {
                this.dispatched = true;
                this.listener.accept(new ClipboardEvent("paste", this.text, this.html, new ArrayList<ClipboardFile>(this.files)));
            }
        }
    }
}

