/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared.impl;

import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.Node;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.shared.SharedListSignal;
import com.vaadin.flow.signals.shared.impl.TreeRevision;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TreeRevisionTest {
    @Test
    void assertValidTree_emptyTree_passes() {
        MutableTestRevision revision = new MutableTestRevision();
        Assert.assertTrue((boolean)revision.assertValidTree());
    }

    @Test
    void assertValidTree_validTree_passes() {
        MutableTestRevision revision = new MutableTestRevision();
        Id listChildId = Id.random();
        Id mapChildId = Id.random();
        revision.nodes().put(Id.ZERO, new Node.Data(null, Id.ZERO, null, null, List.of(listChildId), Map.of("key", mapChildId)));
        revision.nodes().put(listChildId, new Node.Data(Id.ZERO, Id.ZERO, Id.ZERO, null, List.of(), Map.of()));
        revision.nodes().put(mapChildId, new Node.Data(Id.ZERO, Id.ZERO, Id.random(), null, List.of(), Map.of()));
        revision.nodes().put(Id.random(), new Node.Alias(listChildId));
        revision.originalInserts().put(listChildId, new SignalCommand.InsertCommand(listChildId, Id.ZERO, Id.ZERO, null, SharedListSignal.ListPosition.first()));
        Assert.assertTrue((boolean)revision.assertValidTree());
    }

    @Test
    void assertValidTree_rootMissing_fails() {
        MutableTestRevision revision = new MutableTestRevision();
        revision.nodes().remove(Id.ZERO);
        Assertions.assertThrows(AssertionError.class, () -> ((MutableTestRevision)revision).assertValidTree());
    }

    @Test
    void assertValidTree_rootHasParent_fails() {
        MutableTestRevision revision = new MutableTestRevision();
        revision.nodes().put(Id.ZERO, TreeRevisionTest.createSimpleNode(Id.random()));
        Assertions.assertThrows(AssertionError.class, () -> ((MutableTestRevision)revision).assertValidTree());
    }

    @Test
    void assertValidTree_detachedNode_fails() {
        MutableTestRevision revision = new MutableTestRevision();
        revision.nodes().put(Id.random(), TreeRevisionTest.createSimpleNode(Id.random()));
        Assertions.assertThrows(AssertionError.class, () -> ((MutableTestRevision)revision).assertValidTree());
    }

    @Test
    void assertValidTree_missingListChild_fails() {
        MutableTestRevision revision = new MutableTestRevision();
        revision.nodes().put(Id.ZERO, new Node.Data(null, Id.ZERO, null, null, List.of(Id.random()), Map.of()));
        Assertions.assertThrows(AssertionError.class, () -> ((MutableTestRevision)revision).assertValidTree());
    }

    @Test
    void assertValidTree_missingMapChild_fails() {
        MutableTestRevision revision = new MutableTestRevision();
        revision.nodes().put(Id.ZERO, new Node.Data(null, Id.ZERO, null, null, List.of(), Map.of("key", Id.random())));
        Assertions.assertThrows(AssertionError.class, () -> ((MutableTestRevision)revision).assertValidTree());
    }

    @Test
    void assertValidTree_aliasChild_fails() {
        MutableTestRevision revision = new MutableTestRevision();
        Id childId = Id.random();
        revision.nodes().put(Id.ZERO, new Node.Data(null, Id.ZERO, null, null, List.of(childId), Map.of()));
        revision.nodes().put(childId, new Node.Alias(Id.ZERO));
        Assertions.assertThrows(AssertionError.class, () -> ((MutableTestRevision)revision).assertValidTree());
    }

    @Test
    void assertValidTree_childWithoutParentPointer_fails() {
        MutableTestRevision revision = new MutableTestRevision();
        Id childId = Id.random();
        revision.nodes().put(Id.ZERO, new Node.Data(null, Id.ZERO, null, null, List.of(childId), Map.of()));
        revision.nodes().put(childId, TreeRevisionTest.createSimpleNode(null));
        Assertions.assertThrows(AssertionError.class, () -> ((MutableTestRevision)revision).assertValidTree());
    }

    @Test
    void assertValidTree_childWithoutMissingParent_fails() {
        MutableTestRevision revision = new MutableTestRevision();
        Id childId = Id.random();
        revision.nodes().put(Id.ZERO, new Node.Data(null, Id.ZERO, null, null, List.of(childId), Map.of()));
        revision.nodes().put(childId, TreeRevisionTest.createSimpleNode(Id.random()));
        Assertions.assertThrows(AssertionError.class, () -> ((MutableTestRevision)revision).assertValidTree());
    }

    @Test
    void assertValidTree_childWithWrongParent_fails() {
        MutableTestRevision revision = new MutableTestRevision();
        Id childId = Id.random();
        Id otherChildId = Id.random();
        revision.nodes().put(Id.ZERO, new Node.Data(null, Id.ZERO, null, null, List.of(childId, otherChildId), Map.of()));
        revision.nodes().put(childId, TreeRevisionTest.createSimpleNode(Id.ZERO));
        revision.nodes().put(otherChildId, TreeRevisionTest.createSimpleNode(childId));
        Assertions.assertThrows(AssertionError.class, () -> ((MutableTestRevision)revision).assertValidTree());
    }

    @Test
    void assertValidTree_aliasTargetMissing_fails() {
        MutableTestRevision revision = new MutableTestRevision();
        revision.nodes().put(Id.random(), new Node.Alias(Id.random()));
        Assertions.assertThrows(AssertionError.class, () -> ((MutableTestRevision)revision).assertValidTree());
    }

    @Test
    void assertValidTree_aliasTargetOtherAlias_fails() {
        MutableTestRevision revision = new MutableTestRevision();
        Id aliasId = Id.random();
        revision.nodes().put(aliasId, new Node.Alias(Id.ZERO));
        revision.nodes().put(Id.random(), new Node.Alias(aliasId));
        Assertions.assertThrows(AssertionError.class, () -> ((MutableTestRevision)revision).assertValidTree());
    }

    @Test
    void assertValidTree_missingOriginalInsert_fails() {
        MutableTestRevision revision = new MutableTestRevision();
        revision.nodes().put(Id.ZERO, new Node.Data(null, Id.ZERO, Id.ZERO, null, List.of(), Map.of()));
        Assertions.assertThrows(AssertionError.class, () -> ((MutableTestRevision)revision).assertValidTree());
    }

    @Test
    void assertValidTree_redundantOriginalInsert_fails() {
        MutableTestRevision revision = new MutableTestRevision();
        revision.originalInserts().put(Id.ZERO, new SignalCommand.InsertCommand(Id.ZERO, Id.ZERO, Id.ZERO, null, SharedListSignal.ListPosition.first()));
        Assertions.assertThrows(AssertionError.class, () -> ((MutableTestRevision)revision).assertValidTree());
    }

    private static Node.Data createSimpleNode(Id parent) {
        return new Node.Data(parent, Id.ZERO, null, null, List.of(), Map.of());
    }

    private static class MutableTestRevision
    extends TreeRevision {
        public MutableTestRevision() {
            super(Id.ZERO, new HashMap<Id, Node.Data>(Map.of(Id.ZERO, new Node.Data(null, Id.ZERO, null, null, List.of(), Map.of()))), new HashMap());
        }
    }
}

