/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared.impl;

import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.TestUtil;
import com.vaadin.flow.signals.shared.impl.AsynchronousSignalTree;
import com.vaadin.flow.signals.shared.impl.CommandResult;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.node.StringNode;

public class AsynchronousSignalTreeTest {
    @Test
    void newInstance_type_asynchronous() {
        AsyncTestTree tree = new AsyncTestTree();
        Assertions.assertEquals((Object)SignalTree.Type.ASYNCHRONOUS, (Object)tree.type());
    }

    @Test
    void applyChange_happyPath_submittedThenConfirmed() {
        AsyncTestTree tree = new AsyncTestTree();
        AtomicReference result = new AtomicReference();
        SignalCommand command = TestUtil.writeRootValueCommand();
        tree.commitSingleCommand(command, result::set);
        Assertions.assertNull(result.get());
        Assertions.assertNull((Object)TestUtil.readConfirmedRootValue((SignalTree)tree));
        Assertions.assertNotNull((Object)TestUtil.readSubmittedRootValue((SignalTree)tree));
        Assertions.assertEquals(List.of(List.of(command)), tree.submitted);
        tree.confirmSubmitted();
        Assertions.assertInstanceOf(CommandResult.Accept.class, result.get());
        Assertions.assertNotNull((Object)TestUtil.readConfirmedRootValue((SignalTree)tree));
        Assertions.assertNotNull((Object)TestUtil.readSubmittedRootValue((SignalTree)tree));
    }

    @Test
    void applyChange_invalidCommand_submittedThenConfirmed() {
        AsyncTestTree tree = new AsyncTestTree();
        AtomicReference result = new AtomicReference();
        SignalCommand command = TestUtil.failingCommand();
        tree.commitSingleCommand(command, result::set);
        Assertions.assertNull(result.get());
        Assertions.assertEquals(List.of(List.of(command)), tree.submitted);
        tree.confirmSubmitted();
        Assertions.assertInstanceOf(CommandResult.Reject.class, result.get());
    }

    @Test
    void confirm_externalCommand_applied() {
        AsyncTestTree tree = new AsyncTestTree();
        tree.confirm(List.of(TestUtil.writeRootValueCommand()));
        Assertions.assertNotNull((Object)TestUtil.readConfirmedRootValue((SignalTree)tree));
        Assertions.assertNotNull((Object)TestUtil.readSubmittedRootValue((SignalTree)tree));
    }

    @Test
    void confirm_overwritingSubmitted_submittedWins() {
        AsyncTestTree tree = new AsyncTestTree();
        tree.commitSingleCommand(TestUtil.writeRootValueCommand("Submitted"));
        tree.confirm(List.of(TestUtil.writeRootValueCommand("Confirmed")));
        Assertions.assertEquals((Object)new StringNode("Submitted"), (Object)TestUtil.readSubmittedRootValue((SignalTree)tree));
        Assertions.assertEquals((Object)new StringNode("Confirmed"), (Object)TestUtil.readConfirmedRootValue((SignalTree)tree));
        tree.confirmSubmitted();
        Assertions.assertEquals((Object)new StringNode("Submitted"), (Object)TestUtil.readSubmittedRootValue((SignalTree)tree));
        Assertions.assertEquals((Object)new StringNode("Submitted"), (Object)TestUtil.readConfirmedRootValue((SignalTree)tree));
    }

    @Test
    void subscribeToProcessed_noChanges_doesNotReceive() {
        AsyncTestTree tree = new AsyncTestTree();
        AtomicReference resultContainer = new AtomicReference();
        tree.subscribeToProcessed((SignalTree.CommandSubscriber & Serializable)(event, result) -> resultContainer.set(Map.entry(event, result)));
        Assertions.assertNull(resultContainer.get());
    }

    @Test
    void subscribeToProcessed_changesConfirmed_receives() {
        AsyncTestTree tree = new AsyncTestTree();
        AtomicReference resultContainer = new AtomicReference();
        tree.subscribeToProcessed((SignalTree.CommandSubscriber & Serializable)(event, result) -> resultContainer.set(Map.entry(event, result)));
        SignalCommand command = TestUtil.writeRootValueCommand("submitted");
        tree.commitSingleCommand(command);
        Assertions.assertNull(resultContainer.get());
        tree.confirm(List.of(TestUtil.writeRootValueCommand("confirmed")));
        Assertions.assertEquals((Object)new StringNode("confirmed"), (Object)((SignalCommand.SetCommand)((Map.Entry)resultContainer.get()).getKey()).value());
        tree.confirmSubmitted();
        Assertions.assertEquals((Object)new StringNode("submitted"), (Object)((SignalCommand.SetCommand)((Map.Entry)resultContainer.get()).getKey()).value());
        resultContainer.set(null);
        tree.confirmSubmitted();
        Assertions.assertNull(resultContainer.get());
    }

    @Test
    void subscribeToProcessed_failingCommandConfirmed_receives() {
        AsyncTestTree tree = new AsyncTestTree();
        AtomicReference resultContainer = new AtomicReference();
        tree.subscribeToProcessed((SignalTree.CommandSubscriber & Serializable)(event, result) -> resultContainer.set(Map.entry(event, result)));
        SignalCommand command = TestUtil.failingCommand();
        tree.commitSingleCommand(command);
        Assertions.assertNull(resultContainer.get());
        tree.confirmSubmitted();
        Assertions.assertEquals((Object)command, ((Map.Entry)resultContainer.get()).getKey());
    }

    public static class AsyncTestTree
    extends AsynchronousSignalTree {
        public List<List<SignalCommand>> submitted = new ArrayList<List<SignalCommand>>();

        protected void submit(List<SignalCommand> commands) {
            this.submitted.add(commands);
        }

        public void confirmSubmitted() {
            List<List<SignalCommand>> oldSubmitted = this.submitted;
            this.submitted = new ArrayList<List<SignalCommand>>();
            oldSubmitted.forEach(arg_0 -> ((AsyncTestTree)this).confirm(arg_0));
        }
    }
}

