/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared;

import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.TestUtil;
import com.vaadin.flow.signals.function.CommandValidator;
import com.vaadin.flow.signals.function.TransactionTask;
import com.vaadin.flow.signals.function.ValueSupplier;
import com.vaadin.flow.signals.impl.Transaction;
import com.vaadin.flow.signals.impl.UsageTracker;
import com.vaadin.flow.signals.operations.InsertOperation;
import com.vaadin.flow.signals.operations.SignalOperation;
import com.vaadin.flow.signals.shared.AbstractSignal;
import com.vaadin.flow.signals.shared.SharedListSignal;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SharedListSignalTest
extends SignalTestBase {
    @Test
    void constructor_initialValue_isEmpty() {
        SharedListSignal signal = new SharedListSignal(String.class);
        int size = signal.get().size();
        Assertions.assertEquals((int)0, (int)size);
    }

    @Test
    void insertFirst_twoInserts_insertedInOrder() {
        SharedListSignal signal = new SharedListSignal(String.class);
        signal.insertFirst((Object)"a");
        signal.insertFirst((Object)"b");
        SharedListSignalTest.assertChildren((SharedListSignal<String>)signal, "b", "a");
    }

    @Test
    void insertFirst_concurrentInserts_insertedInConfirmOrder() {
        SharedListSignal signal = new SharedListSignal(String.class);
        signal.insertFirst((Object)"initial");
        Signal.runInTransaction((TransactionTask & Serializable)() -> {
            signal.insertFirst((Object)"transaction");
            SharedListSignalTest.assertChildren((SharedListSignal<String>)signal, "transaction", "initial");
            Signal.runWithoutTransaction((TransactionTask & Serializable)() -> {
                signal.insertFirst((Object)"direct");
                SharedListSignalTest.assertChildren((SharedListSignal<String>)signal, "direct", "initial");
            });
        });
        SharedListSignalTest.assertChildren((SharedListSignal<String>)signal, "transaction", "direct", "initial");
    }

    @Test
    void insertLast_twoInserts_insertedInOrder() {
        SharedListSignal signal = new SharedListSignal(String.class);
        signal.insertLast((Object)"a");
        signal.insertLast((Object)"b");
        SharedListSignalTest.assertChildren((SharedListSignal<String>)signal, "a", "b");
    }

    @Test
    void insertLast_concurrentInserts_insertedInConfirmOrder() {
        SharedListSignal signal = new SharedListSignal(String.class);
        signal.insertLast((Object)"initial");
        Signal.runInTransaction((TransactionTask & Serializable)() -> {
            signal.insertLast((Object)"transaction");
            SharedListSignalTest.assertChildren((SharedListSignal<String>)signal, "initial", "transaction");
            Signal.runWithoutTransaction((TransactionTask & Serializable)() -> {
                signal.insertLast((Object)"direct");
                SharedListSignalTest.assertChildren((SharedListSignal<String>)signal, "initial", "direct");
            });
        });
        SharedListSignalTest.assertChildren((SharedListSignal<String>)signal, "initial", "direct", "transaction");
    }

    @Test
    void insertAt_validLocation_insertSuccessful() {
        SharedListSignal signal = new SharedListSignal(String.class);
        signal.insertFirst((Object)"first").signal();
        signal.insertLast((Object)"last").signal();
        InsertOperation operation = signal.insertAt((Object)"afterLast", SharedListSignal.ListPosition.before(null));
        TestUtil.assertSuccess(operation);
        SharedListSignalTest.assertChildren((SharedListSignal<String>)signal, "first", "last", "afterLast");
    }

    @Test
    void insertAt_invalidLocation_insertFailed() {
        SharedListSignal signal = new SharedListSignal(String.class);
        SharedValueSignal first = (SharedValueSignal)signal.insertFirst((Object)"first").signal();
        SharedValueSignal last = (SharedValueSignal)signal.insertLast((Object)"last").signal();
        InsertOperation operation = signal.insertAt((Object)"invalid", SharedListSignal.ListPosition.between((AbstractSignal)last, (AbstractSignal)first));
        TestUtil.assertFailure(operation);
        SharedListSignalTest.assertChildren((SharedListSignal<String>)signal, "first", "last");
    }

    @Test
    void insert_updateUnconfirmedInsertedSignal_valueUpdated() {
        SharedListSignal signal = new SharedListSignal(String.class);
        SharedValueSignal child = (SharedValueSignal)Transaction.runInTransaction((ValueSupplier & Serializable)() -> {
            SharedValueSignal childInner = (SharedValueSignal)signal.insertLast((Object)"insert").signal();
            Assertions.assertEquals((int)0, (int)signal.peekConfirmed().size());
            Assertions.assertNull((Object)childInner.peekConfirmed());
            childInner.set((Object)"update");
            return childInner;
        }).returnValue();
        Assertions.assertEquals((int)1, (int)signal.peekConfirmed().size());
        Assertions.assertEquals((Object)"update", (Object)child.peekConfirmed());
    }

    @Test
    void moveTo_validLocation_moveSuccessful() {
        SharedListSignal signal = new SharedListSignal(String.class);
        signal.insertFirst((Object)"first").signal();
        SharedValueSignal middle = (SharedValueSignal)signal.insertLast((Object)"middle").signal();
        SharedValueSignal last = (SharedValueSignal)signal.insertLast((Object)"last").signal();
        SignalOperation operation = signal.moveTo((AbstractSignal)middle, SharedListSignal.ListPosition.after((AbstractSignal)last));
        TestUtil.assertSuccess(operation);
        SharedListSignalTest.assertChildren((SharedListSignal<String>)signal, "first", "last", "middle");
    }

    @Test
    void moveTo_invalidLocation_moveFailed() {
        SharedListSignal signal = new SharedListSignal(String.class);
        SharedValueSignal first = (SharedValueSignal)signal.insertFirst((Object)"first").signal();
        SharedValueSignal middle = (SharedValueSignal)signal.insertLast((Object)"middle").signal();
        SharedValueSignal last = (SharedValueSignal)signal.insertLast((Object)"last").signal();
        SignalOperation operation = signal.moveTo((AbstractSignal)middle, SharedListSignal.ListPosition.between((AbstractSignal)last, (AbstractSignal)first));
        TestUtil.assertFailure(operation);
        SharedListSignalTest.assertChildren((SharedListSignal<String>)signal, "first", "middle", "last");
    }

    @Test
    void remove_existingChild_removeSuccessful() {
        SharedListSignal signal = new SharedListSignal(String.class);
        SharedValueSignal first = (SharedValueSignal)signal.insertFirst((Object)"first").signal();
        signal.insertLast((Object)"last").signal();
        SignalOperation operation = signal.remove(first);
        TestUtil.assertSuccess(operation);
        SharedListSignalTest.assertChildren((SharedListSignal<String>)signal, "last");
    }

    @Test
    void remove_nonExtistentChild_removeFails() {
        SharedListSignal other = new SharedListSignal(String.class);
        SharedValueSignal child = (SharedValueSignal)other.insertLast((Object)"child").signal();
        SharedListSignal signal = new SharedListSignal(String.class);
        signal.insertLast((Object)"child");
        SignalOperation operation = signal.remove(child);
        TestUtil.assertFailure(operation);
        SharedListSignalTest.assertChildren((SharedListSignal<String>)signal, "child");
    }

    @Test
    void clear_listWithChildren_listCleared() {
        SharedListSignal signal = new SharedListSignal(String.class);
        signal.insertFirst((Object)"first").signal();
        signal.insertLast((Object)"last").signal();
        SignalOperation operation = signal.clear();
        TestUtil.assertSuccess(operation);
        SharedListSignalTest.assertChildren((SharedListSignal<String>)signal, new String[0]);
    }

    @Test
    void verifyPosition_correctPosition_successful() {
        SharedListSignal signal = new SharedListSignal(String.class);
        SharedValueSignal first = (SharedValueSignal)signal.insertFirst((Object)"first").signal();
        SharedValueSignal last = (SharedValueSignal)signal.insertLast((Object)"last").signal();
        SignalOperation operation = signal.verifyPosition((AbstractSignal)last, SharedListSignal.ListPosition.after((AbstractSignal)first));
        TestUtil.assertSuccess(operation);
    }

    @Test
    void verifyPosition_invalidPosition_failure() {
        SharedListSignal signal = new SharedListSignal(String.class);
        SharedValueSignal first = (SharedValueSignal)signal.insertFirst((Object)"first").signal();
        SharedValueSignal last = (SharedValueSignal)signal.insertLast((Object)"last").signal();
        SignalOperation operation = signal.verifyPosition((AbstractSignal)last, SharedListSignal.ListPosition.before((AbstractSignal)first));
        TestUtil.assertFailure(operation);
    }

    @Test
    void verifyChild_isChild_successful() {
        SharedListSignal signal = new SharedListSignal(String.class);
        SharedValueSignal child = (SharedValueSignal)signal.insertFirst((Object)"child").signal();
        SignalOperation operation = signal.verifyChild((AbstractSignal)child);
        TestUtil.assertSuccess(operation);
    }

    @Test
    void verifyChild_isNotChild_failure() {
        SharedListSignal signal = new SharedListSignal(String.class);
        signal.insertFirst((Object)"child").signal();
        SignalOperation operation = signal.verifyChild((AbstractSignal)new SharedValueSignal((Object)"child"));
        TestUtil.assertFailure(operation);
    }

    @Test
    void value_modifyListInstance_isImmutable() {
        SharedListSignal signal = new SharedListSignal(String.class);
        signal.insertFirst((Object)"first");
        List value = signal.get();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> value.add(new SharedValueSignal((Object)"new")));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> value.set(0, new SharedValueSignal((Object)"new")));
    }

    @Test
    void value_changeSignalBeforeIterating_iteratesOldState() {
        SharedListSignal signal = new SharedListSignal(String.class);
        signal.insertFirst((Object)"first");
        List value = signal.get();
        signal.insertLast((Object)"last");
        List<String> list = value.stream().map(AbstractSignal::get).toList();
        Assertions.assertEquals(List.of("first"), list);
    }

    @Test
    void withValidator_spyingValidator_seesParentAndChildOperations() {
        SharedListSignal signal = new SharedListSignal(String.class);
        ArrayList validatedCommands = new ArrayList();
        SharedListSignal wrapper = signal.withValidator((CommandValidator & Serializable)command -> {
            validatedCommands.add(command);
            return true;
        });
        SharedValueSignal child = (SharedValueSignal)wrapper.insertFirst((Object)"child").signal();
        Assertions.assertEquals((int)1, (int)validatedCommands.size());
        Assertions.assertInstanceOf(SignalCommand.InsertCommand.class, validatedCommands.get(0));
        child.set((Object)"update");
        Assertions.assertEquals((int)2, (int)validatedCommands.size());
        Assertions.assertInstanceOf(SignalCommand.ValueCommand.class, validatedCommands.get(1));
    }

    @Test
    void readonly_makeChangesToListAndChild_allChangesRejected() {
        SharedListSignal signal = new SharedListSignal(String.class);
        signal.insertLast((Object)"child");
        SharedListSignal readonly = signal.asReadonly();
        SharedValueSignal readonlyChild = (SharedValueSignal)readonly.get().get(0);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> readonly.clear());
        SharedListSignalTest.assertChildren((SharedListSignal<String>)signal, "child");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> readonlyChild.set((Object)"update"));
        SharedListSignalTest.assertChildren((SharedListSignal<String>)signal, "child");
    }

    @Test
    void usageTracking_changeDifferentValues_onlyListChangeDetected() {
        SharedListSignal signal = new SharedListSignal(String.class);
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        signal.asNode().asValue(String.class).set((Object)"value");
        Assertions.assertFalse((boolean)usage.hasChanges());
        signal.insertLast((Object)"insert");
        Assertions.assertTrue((boolean)usage.hasChanges());
    }

    @Test
    void equalsHashCode() {
        SharedListSignal signal = new SharedListSignal(String.class);
        Assertions.assertEquals((Object)signal, (Object)signal);
        SharedListSignal copy = new SharedListSignal(signal.tree(), signal.id(), signal.validator(), String.class);
        Assertions.assertEquals((Object)signal, (Object)copy);
        Assertions.assertEquals((int)signal.hashCode(), (int)copy.hashCode());
        SharedListSignal asList = signal.asNode().asList(String.class);
        Assertions.assertEquals((Object)signal, (Object)asList);
        Assertions.assertEquals((int)signal.hashCode(), (int)asList.hashCode());
        Assertions.assertNotEquals((Object)signal, (Object)new SharedListSignal(String.class));
        Assertions.assertNotEquals((Object)signal, (Object)signal.asReadonly());
        Assertions.assertNotEquals((Object)signal, (Object)signal.asNode());
        Assertions.assertNotEquals((Object)signal, (Object)signal.asNode().asList(Double.class));
    }

    @Test
    void equalsHashCode_children() {
        SharedListSignal signal = new SharedListSignal(String.class);
        SharedValueSignal operationChild = (SharedValueSignal)signal.insertLast((Object)"value").signal();
        SharedValueSignal other = (SharedValueSignal)signal.insertLast((Object)"other").signal();
        SharedValueSignal valueChild = (SharedValueSignal)signal.get().get(0);
        Assertions.assertEquals((Object)operationChild, (Object)valueChild);
        Assertions.assertEquals((int)operationChild.hashCode(), (int)valueChild.hashCode());
        Assertions.assertNotEquals((Object)operationChild, (Object)other);
    }

    @Test
    void toString_includesValue() {
        SharedListSignal signal = new SharedListSignal(String.class);
        signal.insertLast((Object)"one");
        signal.insertLast((Object)"two");
        Assertions.assertEquals((Object)"SharedListSignal[one, two]", (Object)signal.toString());
    }

    static void assertChildren(SharedListSignal<String> signal, String ... expectedValue) {
        List<String> value = signal.get().stream().map(AbstractSignal::get).toList();
        Assertions.assertEquals(List.of(expectedValue), value);
    }
}

