/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.impl;

import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.function.TransactionTask;
import com.vaadin.flow.signals.function.ValueSupplier;
import com.vaadin.flow.signals.impl.TransientListener;
import com.vaadin.flow.signals.impl.UsageTracker;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UsageTrackerTest
extends SignalTestBase {
    @Test
    void hasChanges_runInTransaction_readsFromTransaction() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        Signal.runInTransaction((TransactionTask & Serializable)() -> {
            signal.set((Object)"changed");
            Assertions.assertTrue((boolean)usage.hasChanges());
            Signal.runWithoutTransaction((TransactionTask & Serializable)() -> Assertions.assertFalse((boolean)usage.hasChanges()));
        });
    }

    @Test
    void track_noUsage_noChnages() {
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> {});
        Assertions.assertFalse((boolean)usage.hasChanges());
    }

    @Test
    void track_readValueInCallback_tracked() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        signal.set((Object)"update");
        Assertions.assertTrue((boolean)usage.hasChanges());
    }

    @Test
    void track_peekInCallback_notTracked() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.peek());
        signal.set((Object)"update");
        Assertions.assertFalse((boolean)usage.hasChanges());
    }

    @Test
    void track_peekConfirmedInCallback_notTracked() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.peekConfirmed());
        signal.set((Object)"update");
        Assertions.assertFalse((boolean)usage.hasChanges());
    }

    @Test
    void untracked_useValue_notRegistered() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> Signal.untracked((ValueSupplier & Serializable)() -> {
            signal.get();
            return null;
        }));
        signal.set((Object)"update");
        Assertions.assertFalse((boolean)usage.hasChanges());
    }

    @Test
    void untracked_writeInCallback_allowedNoUsageTracked() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> Signal.untracked((ValueSupplier & Serializable)() -> {
            signal.set((Object)"update");
            return null;
        }));
        signal.set((Object)"another");
        Assertions.assertFalse((boolean)usage.hasChanges());
    }

    @Test
    void track_multipleUsages_combinedUsage() {
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> {
            UsageTracker.registerUsage((UsageTracker.Usage)new TestUsage());
            UsageTracker.registerUsage((UsageTracker.Usage)new TestUsage());
        });
        Assertions.assertInstanceOf(UsageTracker.CombinedUsage.class, (Object)usage);
    }

    @Test
    void track_singleUsage_notCombinedUsage() {
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> UsageTracker.registerUsage((UsageTracker.Usage)new TestUsage()));
        Assertions.assertFalse((boolean)(usage instanceof UsageTracker.CombinedUsage));
    }

    @Test
    void isActive_activeInsideTrackerInactiveOutsdide() {
        UsageTracker.track((SerializableRunnable & Serializable)() -> {
            Assertions.assertTrue((boolean)UsageTracker.isActive());
            Signal.untracked((ValueSupplier & Serializable)() -> {
                Assertions.assertFalse((boolean)UsageTracker.isActive());
                return null;
            });
        });
        Assertions.assertFalse((boolean)UsageTracker.isActive());
    }

    @Test
    void combinedUsage_anyUsageChanged_isChanged() {
        TestUsage a = new TestUsage();
        TestUsage b = new TestUsage();
        UsageTracker.CombinedUsage usage = new UsageTracker.CombinedUsage(List.of(a, b));
        Assertions.assertFalse((boolean)usage.hasChanges());
        a.hasChanges = true;
        Assertions.assertTrue((boolean)usage.hasChanges());
        b.hasChanges = true;
        Assertions.assertTrue((boolean)usage.hasChanges());
        a.hasChanges = false;
        Assertions.assertTrue((boolean)usage.hasChanges());
        b.hasChanges = false;
        Assertions.assertFalse((boolean)usage.hasChanges());
    }

    @Test
    void combinedUsage_onNextChange_registersWithAll() {
        TestUsage a = new TestUsage();
        TestUsage b = new TestUsage();
        UsageTracker.CombinedUsage usage = new UsageTracker.CombinedUsage(List.of(a, b));
        Registration cleanup = usage.onNextChange((TransientListener & Serializable)immediate -> false);
        Assertions.assertEquals((int)1, (int)a.listeners.size());
        Assertions.assertEquals((int)1, (int)b.listeners.size());
        cleanup.remove();
        Assertions.assertEquals((int)0, (int)a.listeners.size());
        Assertions.assertEquals((int)0, (int)b.listeners.size());
    }

    @Test
    void combinedOnNextChange_nonRepeatingListener_removedAfterFirstTrigger() {
        TestUsage a = new TestUsage();
        TestUsage b = new TestUsage();
        AtomicInteger count = new AtomicInteger();
        UsageTracker.CombinedUsage usage = new UsageTracker.CombinedUsage(List.of(a, b));
        usage.onNextChange((TransientListener & Serializable)immediate -> {
            count.incrementAndGet();
            return false;
        });
        boolean keep = a.listeners.get(0).invoke(false);
        Assertions.assertFalse((boolean)keep);
        Assertions.assertEquals((int)1, (int)count.intValue());
        Assertions.assertEquals((int)0, (int)a.listeners.size());
        Assertions.assertEquals((int)0, (int)b.listeners.size());
    }

    @Test
    void combinedOnNextChange_repeatingListener_remainsInUse() {
        TestUsage a = new TestUsage();
        TestUsage b = new TestUsage();
        AtomicInteger count = new AtomicInteger();
        UsageTracker.CombinedUsage usage = new UsageTracker.CombinedUsage(List.of(a, b));
        usage.onNextChange((TransientListener & Serializable)immediate -> {
            count.incrementAndGet();
            return true;
        });
        boolean keep = a.listeners.get(0).invoke(false);
        Assertions.assertTrue((boolean)keep);
        Assertions.assertEquals((int)1, (int)count.intValue());
        Assertions.assertEquals((int)1, (int)a.listeners.size());
        Assertions.assertEquals((int)1, (int)b.listeners.size());
    }

    @Test
    void combinedOnNextChange_immediatelyNotifiedNonRepeatingListener_immediatelyNotifiedThenRemoved() {
        TestUsage a = new TestUsage(){

            @Override
            public Registration onNextChange(TransientListener listener) {
                Registration cleanup = super.onNextChange(listener);
                listener.invoke(true);
                return cleanup;
            }
        };
        TestUsage b = new TestUsage();
        AtomicInteger count = new AtomicInteger();
        UsageTracker.CombinedUsage usage = new UsageTracker.CombinedUsage(List.of(a, b));
        usage.onNextChange((TransientListener & Serializable)immediate -> {
            count.incrementAndGet();
            return false;
        });
        Assertions.assertEquals((int)1, (int)count.intValue());
        Assertions.assertEquals((int)0, (int)a.listeners.size());
        Assertions.assertEquals((int)0, (int)b.listeners.size());
    }

    @Test
    void combinedOnNextChange_immediatelyNotifiedRepeatingListener_immediatelyNotifiedAndKeptInUse() {
        TestUsage a = new TestUsage(){

            @Override
            public Registration onNextChange(TransientListener listener) {
                Registration cleanup = super.onNextChange(listener);
                listener.invoke(true);
                return cleanup;
            }
        };
        TestUsage b = new TestUsage();
        AtomicInteger count = new AtomicInteger();
        UsageTracker.CombinedUsage usage = new UsageTracker.CombinedUsage(List.of(a, b));
        usage.onNextChange((TransientListener & Serializable)immediate -> {
            count.incrementAndGet();
            return true;
        });
        Assertions.assertEquals((int)1, (int)count.intValue());
        Assertions.assertEquals((int)1, (int)a.listeners.size());
        Assertions.assertEquals((int)1, (int)b.listeners.size());
    }

    private static class TestUsage
    implements UsageTracker.Usage {
        boolean hasChanges;
        List<TransientListener> listeners = new ArrayList<TransientListener>();

        private TestUsage() {
        }

        public boolean hasChanges() {
            return this.hasChanges;
        }

        public Registration onNextChange(TransientListener listener) {
            this.listeners.add(listener);
            return (Registration & Serializable)() -> this.listeners.remove(listener);
        }
    }
}

