/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.impl;

import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.TestUtil;
import com.vaadin.flow.signals.function.TransactionTask;
import com.vaadin.flow.signals.function.ValueSupplier;
import com.vaadin.flow.signals.impl.Transaction;
import com.vaadin.flow.signals.impl.TransientListener;
import com.vaadin.flow.signals.operations.SignalOperation;
import com.vaadin.flow.signals.operations.TransactionOperation;
import com.vaadin.flow.signals.shared.impl.AsynchronousSignalTreeTest;
import com.vaadin.flow.signals.shared.impl.CommandResult;
import com.vaadin.flow.signals.shared.impl.CommandsAndHandlers;
import com.vaadin.flow.signals.shared.impl.CommandsAndHandlersTest;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import com.vaadin.flow.signals.shared.impl.StagedTransaction;
import com.vaadin.flow.signals.shared.impl.SynchronousSignalTree;
import com.vaadin.flow.signals.shared.impl.TreeRevision;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.JsonNode;

public class TransactionTest {
    @Test
    void getCurrentTransaction_noTransaction_rootTransaction() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Transaction transaction = Transaction.getCurrent();
        Assertions.assertFalse((boolean)Transaction.inTransaction());
        TreeRevision revision = transaction.read((SignalTree)tree);
        Assertions.assertSame((Object)tree.submitted(), (Object)revision);
        transaction.include((SignalTree)tree, TestUtil.writeRootValueCommand(), null);
        Assertions.assertNotNull((Object)TestUtil.readSubmittedRootValue((SignalTree)tree));
    }

    @Test
    void runInTransaction_supplier_valueReturned() {
        String value = "the value";
        TransactionOperation operation = Transaction.runInTransaction((ValueSupplier & Serializable)() -> {
            Assertions.assertTrue((boolean)Transaction.inTransaction());
            return value;
        });
        Assertions.assertSame((Object)value, (Object)operation.returnValue());
    }

    @Test
    void runInTransaction_defaultTransactionType_isFull() {
        Transaction transaction = (Transaction)Transaction.runInTransaction((ValueSupplier & Serializable)() -> Transaction.getCurrent()).returnValue();
        Assertions.assertInstanceOf(StagedTransaction.class, (Object)transaction);
    }

    @Test
    void runInTransaction_successfulFull_committed() throws InterruptedException, ExecutionException {
        AsynchronousSignalTreeTest.AsyncTestTree tree = new AsynchronousSignalTreeTest.AsyncTestTree();
        SignalCommand command = TestUtil.writeRootValueCommand();
        TransactionOperation operation = Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            Transaction transaction = Transaction.getCurrent();
            Assertions.assertInstanceOf(StagedTransaction.class, (Object)transaction);
            transaction.include((SignalTree)tree, command, null);
            Assertions.assertEquals(List.of(), tree.submitted, (String)"Nothing should be submitted before the transaction ends");
        });
        List<SignalCommand> commands = tree.submitted.get(0);
        Assertions.assertEquals((int)1, (int)commands.size());
        Assertions.assertInstanceOf(SignalCommand.TransactionCommand.class, (Object)commands.get(0));
        SignalCommand.TransactionCommand tx = (SignalCommand.TransactionCommand)commands.get(0);
        Assertions.assertEquals(List.of(command), (Object)tx.commands());
        Assertions.assertFalse((boolean)operation.result().isDone());
        tree.confirmSubmitted();
        Assertions.assertTrue((boolean)operation.result().isDone());
        Assertions.assertTrue((boolean)((SignalOperation.ResultOrError)operation.result().get()).successful());
    }

    @Test
    void runInTransaction_throwingFull_rolledBack() {
        AsynchronousSignalTreeTest.AsyncTestTree tree = new AsynchronousSignalTreeTest.AsyncTestTree();
        CommandsAndHandlersTest.ResultHandler handler = new CommandsAndHandlersTest.ResultHandler();
        Assertions.assertThrows(RuntimeException.class, () -> Transaction.runInTransaction((ValueSupplier & Serializable)() -> {
            Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand(), (CommandsAndHandlers.CommandResultHandler)handler);
            throw new RuntimeException();
        }));
        Assertions.assertFalse((boolean)Transaction.inTransaction());
        Assertions.assertEquals(List.of(), tree.submitted);
        Assertions.assertInstanceOf(CommandResult.Reject.class, (Object)handler.result);
    }

    @Test
    void runInTransaction_throwingWriteThrough_appliedAsExecuted() {
        AsynchronousSignalTreeTest.AsyncTestTree tree = new AsynchronousSignalTreeTest.AsyncTestTree();
        CommandsAndHandlersTest.ResultHandler handler = new CommandsAndHandlersTest.ResultHandler();
        Assertions.assertThrows(RuntimeException.class, () -> Transaction.runInTransaction((ValueSupplier & Serializable)() -> {
            Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand(), (CommandsAndHandlers.CommandResultHandler)handler);
            throw new RuntimeException();
        }, (Transaction.Type)Transaction.Type.WRITE_THROUGH));
        Assertions.assertEquals((int)1, (int)tree.submitted.size());
        tree.confirmSubmitted();
        Assertions.assertInstanceOf(CommandResult.Accept.class, (Object)handler.result);
    }

    @Test
    void runWithoutTransaction_runnable_isRun() {
        AtomicBoolean invoked = new AtomicBoolean();
        Transaction.runWithoutTransaction((TransactionTask & Serializable)() -> {
            Assertions.assertFalse((boolean)Transaction.inTransaction());
            invoked.set(true);
        });
        Assertions.assertTrue((boolean)invoked.get());
    }

    @Test
    void runWithoutTransaction_supplier_valueIsReturned() {
        String value = "value";
        String result = (String)Transaction.runWithoutTransaction((ValueSupplier & Serializable)() -> value);
        Assertions.assertSame((Object)value, (Object)result);
    }

    @Test
    void writeThrough_acceptedChange_operationResultSuccessful() throws InterruptedException, ExecutionException {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        CommandsAndHandlersTest.ResultHandler handler = new CommandsAndHandlersTest.ResultHandler();
        TransactionOperation operation = Transaction.runInTransaction((TransactionTask & Serializable)() -> Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand(), (CommandsAndHandlers.CommandResultHandler)handler), (Transaction.Type)Transaction.Type.WRITE_THROUGH);
        Assertions.assertTrue((boolean)operation.result().isDone());
        Assertions.assertTrue((boolean)((SignalOperation.ResultOrError)operation.result().get()).successful());
        Assertions.assertTrue((boolean)handler.result.accepted());
    }

    @Test
    void writeThrough_rejectedChange_operationResultSuccessful() throws InterruptedException, ExecutionException {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        CommandsAndHandlersTest.ResultHandler handler = new CommandsAndHandlersTest.ResultHandler();
        TransactionOperation operation = Transaction.runInTransaction((TransactionTask & Serializable)() -> Transaction.getCurrent().include((SignalTree)tree, TestUtil.failingCommand(), (CommandsAndHandlers.CommandResultHandler)handler), (Transaction.Type)Transaction.Type.WRITE_THROUGH);
        Assertions.assertTrue((boolean)operation.result().isDone());
        Assertions.assertTrue((boolean)((SignalOperation.ResultOrError)operation.result().get()).successful());
        Assertions.assertFalse((boolean)handler.result.accepted());
    }

    @Test
    void writeThrough_externalChange_repeatableRead() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            JsonNode beforeUpdate = TestUtil.readTransactionRootValue((SignalTree)tree);
            tree.commitSingleCommand(TestUtil.writeRootValueCommand());
            JsonNode afterUpdate = TestUtil.readTransactionRootValue((SignalTree)tree);
            Assertions.assertNull((Object)afterUpdate);
            Assertions.assertSame((Object)beforeUpdate, (Object)afterUpdate);
        }, (Transaction.Type)Transaction.Type.WRITE_THROUGH);
        JsonNode outsideTransaction = TestUtil.readTransactionRootValue((SignalTree)tree);
        Assertions.assertNotNull((Object)outsideTransaction);
    }

    @Test
    void writeThrough_changeThroughTransaction_visibleAndWrittenImmediately() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            JsonNode beforeUpdate = TestUtil.readTransactionRootValue((SignalTree)tree);
            Assertions.assertNull((Object)beforeUpdate);
            Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand(), null);
            Assertions.assertNotNull((Object)TestUtil.readSubmittedRootValue((SignalTree)tree));
            JsonNode afterUpdate = TestUtil.readTransactionRootValue((SignalTree)tree);
            Assertions.assertNotNull((Object)afterUpdate);
        }, (Transaction.Type)Transaction.Type.WRITE_THROUGH);
    }

    @Test
    void writeThrough_writesBypassingTransaction_readValuesLockedAfterFirstTxUse() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            tree.commitSingleCommand(TestUtil.writeRootValueCommand("value"));
            String value = TestUtil.readTransactionRootValue((SignalTree)tree).asString();
            Assertions.assertEquals((Object)"value", (Object)value);
            tree.commitSingleCommand(TestUtil.writeRootValueCommand("value2"));
            String value2 = TestUtil.readTransactionRootValue((SignalTree)tree).asString();
            Assertions.assertEquals((Object)"value", (Object)value2);
        }, (Transaction.Type)Transaction.Type.WRITE_THROUGH);
    }

    @Test
    void writeThrough_readInNestedTx_readsFromOuterTx() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            TestUtil.readTransactionRootValue((SignalTree)tree);
            tree.commitSingleCommand(TestUtil.writeRootValueCommand());
            Transaction.runInTransaction((TransactionTask & Serializable)() -> Assertions.assertNull((Object)TestUtil.readTransactionRootValue((SignalTree)tree), (String)"Inner transaction should read values from the outer transaction"));
        }, (Transaction.Type)Transaction.Type.WRITE_THROUGH);
    }

    @Test
    void writeThrough_writeInNestedTx_visibleInOuterTx() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            TestUtil.readTransactionRootValue((SignalTree)tree);
            Transaction.runInTransaction((TransactionTask & Serializable)() -> Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand(), null), (Transaction.Type)Transaction.Type.WRITE_THROUGH);
            Assertions.assertNotNull((Object)TestUtil.readTransactionRootValue((SignalTree)tree));
        }, (Transaction.Type)Transaction.Type.WRITE_THROUGH);
    }

    @Test
    void writeThrough_readValueInObserver_updatedValueRead() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        ArrayList invocations = new ArrayList();
        tree.observeNextChange(Id.ZERO, (TransientListener & Serializable)immediate -> {
            invocations.add(TestUtil.readTransactionRootValue((SignalTree)tree).asString());
            return true;
        });
        Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            TestUtil.readTransactionRootValue((SignalTree)tree);
            Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand("update"), null);
        }, (Transaction.Type)Transaction.Type.WRITE_THROUGH);
        Assertions.assertEquals(List.of("update"), invocations);
    }

    @Test
    void transactionWrapping_inFull_acceptAll() {
        Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            Transaction.runInTransaction((TransactionTask)TransactionTest.dummyTask(), (Transaction.Type)Transaction.Type.STAGED);
            Transaction.runInTransaction((TransactionTask)TransactionTest.dummyTask(), (Transaction.Type)Transaction.Type.WRITE_THROUGH);
            Transaction.runWithoutTransaction((TransactionTask)TransactionTest.dummyTask());
        }, (Transaction.Type)Transaction.Type.STAGED);
    }

    @Test
    void transactionWrapping_inWriteThrough_acceptAll() {
        Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            Transaction.runInTransaction((TransactionTask)TransactionTest.dummyTask(), (Transaction.Type)Transaction.Type.STAGED);
            Transaction.runInTransaction((TransactionTask)TransactionTest.dummyTask(), (Transaction.Type)Transaction.Type.WRITE_THROUGH);
            Transaction.runWithoutTransaction((TransactionTask)TransactionTest.dummyTask());
        }, (Transaction.Type)Transaction.Type.WRITE_THROUGH);
    }

    @AfterEach
    void cleanupFallback() {
        Transaction.setTransactionFallback(null);
    }

    @Test
    void fallback_providesRepeatableReads() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Transaction fallbackTx = Transaction.createWriteThrough();
        Transaction.setTransactionFallback((SerializableSupplier & Serializable)() -> fallbackTx);
        JsonNode firstRead = TestUtil.readTransactionRootValue((SignalTree)tree);
        tree.commitSingleCommand(TestUtil.writeRootValueCommand("external"));
        JsonNode secondRead = TestUtil.readTransactionRootValue((SignalTree)tree);
        Assertions.assertSame((Object)firstRead, (Object)secondRead, (String)"Fallback transaction should provide repeatable reads");
    }

    @Test
    void noFallback_withoutRegistration_rootBehavior() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Assertions.assertFalse((boolean)Transaction.inTransaction());
        Transaction current = Transaction.getCurrent();
        TreeRevision revision = current.read((SignalTree)tree);
        Assertions.assertSame((Object)tree.submitted(), (Object)revision);
    }

    @Test
    void runWithoutTransaction_bypassesFallback() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Transaction fallbackTx = Transaction.createWriteThrough();
        Transaction.setTransactionFallback((SerializableSupplier & Serializable)() -> fallbackTx);
        Assertions.assertTrue((boolean)Transaction.inTransaction(), (String)"Fallback should make inTransaction() return true");
        Transaction.runWithoutTransaction((TransactionTask & Serializable)() -> {
            Assertions.assertFalse((boolean)Transaction.inTransaction(), (String)"runWithoutTransaction should bypass fallback");
            TreeRevision revision = Transaction.getCurrent().read((SignalTree)tree);
            Assertions.assertSame((Object)tree.submitted(), (Object)revision);
        });
        Assertions.assertTrue((boolean)Transaction.inTransaction(), (String)"Fallback should be restored after runWithoutTransaction");
    }

    @Test
    void runInTransaction_nestsWithFallback() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Transaction fallbackTx = Transaction.createWriteThrough();
        Transaction.setTransactionFallback((SerializableSupplier & Serializable)() -> fallbackTx);
        Assertions.assertTrue((boolean)Transaction.inTransaction());
        Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            Assertions.assertTrue((boolean)Transaction.inTransaction());
            Assertions.assertInstanceOf(StagedTransaction.class, (Object)Transaction.getCurrent());
        });
        Assertions.assertTrue((boolean)Transaction.inTransaction(), (String)"Fallback should still be active after nested transaction");
    }

    @Test
    void inTransaction_reflectsFallback() {
        Transaction fallbackTx = Transaction.createWriteThrough();
        Assertions.assertFalse((boolean)Transaction.inTransaction());
        Transaction.setTransactionFallback((SerializableSupplier & Serializable)() -> fallbackTx);
        Assertions.assertTrue((boolean)Transaction.inTransaction(), (String)"inTransaction should return true when fallback is active");
        Transaction.runWithoutTransaction((TransactionTask & Serializable)() -> Assertions.assertFalse((boolean)Transaction.inTransaction(), (String)"inTransaction should return false inside runWithoutTransaction"));
        Assertions.assertTrue((boolean)Transaction.inTransaction());
    }

    private static TransactionTask dummyTask() {
        return (TransactionTask & Serializable)() -> {};
    }
}

