/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentTest;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.InertData;
import com.vaadin.flow.server.communication.rpc.EventRpcHandler;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

class EventRpcHandlerTest {
    EventRpcHandlerTest() {
    }

    @Test
    public void testElementEventNoData() throws Exception {
        ComponentTest.TestComponent c = new ComponentTest.TestComponent();
        Element element = c.getElement();
        UI ui = new UI();
        ui.add(new Component[]{c});
        AtomicInteger invocations = new AtomicInteger(0);
        element.addEventListener("test-event", (DomEventListener & Serializable)e -> invocations.incrementAndGet());
        EventRpcHandlerTest.sendElementEvent(element, ui, "test-event", null);
        Assertions.assertEquals((int)1, (int)invocations.get());
    }

    @Test
    public void testElementEventData() throws Exception {
        ComponentTest.TestComponent c = new ComponentTest.TestComponent();
        Element element = c.getElement();
        UI ui = new UI();
        ui.add(new Component[]{c});
        AtomicInteger invocationData = new AtomicInteger(0);
        DomListenerRegistration domListenerRegistration = element.addEventListener("test-event", (DomEventListener & Serializable)e -> invocationData.addAndGet(e.getEventData().get("nr").intValue()));
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.put("nr", 123);
        EventRpcHandlerTest.sendElementEvent(element, ui, "test-event", (JsonNode)eventData);
        Assertions.assertEquals((int)123, (int)invocationData.get());
        invocationData.set(0);
        eventData.put("nr", 124);
        InertData inertData = (InertData)element.getNode().getFeature(InertData.class);
        inertData.setInertSelf(true);
        inertData.generateChangesFromEmpty();
        EventRpcHandlerTest.sendElementEvent(element, ui, "test-event", (JsonNode)eventData);
        Assertions.assertEquals((int)0, (int)invocationData.get());
        domListenerRegistration.allowInert();
        EventRpcHandlerTest.sendElementEvent(element, ui, "test-event", (JsonNode)eventData);
        Assertions.assertEquals((int)124, (int)invocationData.get());
    }

    private static JsonNode createElementEventInvocation(Element element, String eventType, JsonNode eventData) {
        StateNode node = element.getNode();
        ObjectNode message = JacksonUtils.createObjectNode();
        message.put("node", node.getId());
        message.put("event", eventType);
        if (eventData != null) {
            message.set("data", eventData);
        }
        return message;
    }

    private static void sendElementEvent(Element element, UI ui, String eventType, JsonNode eventData) throws Exception {
        new EventRpcHandler().handle(ui, EventRpcHandlerTest.createElementEventInvocation(element, eventType, eventData));
    }
}

