/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.communication.rpc.RpcDecodeException;
import com.vaadin.flow.server.communication.rpc.StringToEnumDecoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class EnumDecoderTest {
    private StringToEnumDecoder decoder = new StringToEnumDecoder();

    EnumDecoderTest() {
    }

    @Test
    public void isApplicable_applicableToStringAndEnum() {
        Assertions.assertTrue((boolean)this.decoder.isApplicable(JacksonUtils.createNode((Object)"foo"), Title.class));
    }

    @Test
    public void isApplicable_notApplicableToBooleanAndEnum() {
        Assertions.assertFalse((boolean)this.decoder.isApplicable(JacksonUtils.createNode((Object)true), Enum.class));
    }

    @Test
    public void isApplicable_notApplicableToStringAndString() {
        Assertions.assertFalse((boolean)this.decoder.isApplicable(JacksonUtils.createNode((Object)"foo"), String.class));
    }

    @Test
    public void isApplicable_notApplicableToStringAndAbstractEnum() {
        Assertions.assertFalse((boolean)this.decoder.isApplicable(JacksonUtils.createNode((Object)"foo"), Enum.class));
    }

    @Test
    public void stringToEnum_convertableString_valueIsConverted() throws RpcDecodeException {
        Title title = Title.MRS;
        Title decoded = (Title)((Object)this.decoder.decode(JacksonUtils.createNode((Object)title.name()), Title.class));
        Assertions.assertEquals((Object)((Object)title), (Object)((Object)decoded));
    }

    @Test
    public void stringToEnum_nonConvertableString_valueIsConverted() throws RpcDecodeException {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.decoder.decode(JacksonUtils.createNode((Object)"foo"), Title.class));
    }

    static enum Title {
        MR,
        MRS;

    }
}

