/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentTest;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.UITest;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.internal.BundleUtils;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RoutePathProvider;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.MockServletServiceSessionSetup;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.UidlWriter;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jcip.annotations.NotThreadSafe;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

@NotThreadSafe
class UidlWriterTest {
    private static final String CSS_STYLE_NAME = Dependency.Type.STYLESHEET.name();
    private MockServletServiceSessionSetup mocks;

    UidlWriterTest() {
    }

    @AfterEach
    public void tearDown() {
        if (this.mocks != null) {
            this.mocks.cleanup();
        }
    }

    @Test
    public void testEncodeExecuteJavaScript_npmMode() {
        Element element = ElementFactory.createDiv();
        UIInternals.JavaScriptInvocation invocation1 = new UIInternals.JavaScriptInvocation("$0.focus()", new Object[]{element});
        UIInternals.JavaScriptInvocation invocation2 = new UIInternals.JavaScriptInvocation("console.log($0, $1)", new Object[]{"Lives remaining:", 3});
        List executeJavaScriptList = Stream.of(invocation1, invocation2).map(invocation -> new PendingJavaScriptInvocation(element.getNode(), invocation)).collect(Collectors.toList());
        ArrayNode json = UidlWriter.encodeExecuteJavaScriptList(executeJavaScriptList);
        ArrayNode expectedJson = JacksonUtils.createArray((JsonNode[])new JsonNode[]{JacksonUtils.createArray((JsonNode[])new JsonNode[]{JacksonUtils.nullNode(), JacksonUtils.createNode((Object)"$0.focus()")}), JacksonUtils.createArray((JsonNode[])new JsonNode[]{JacksonUtils.createNode((Object)"Lives remaining:"), JacksonUtils.createNode((Object)3), JacksonUtils.createNode((Object)"console.log($0, $1)")})});
        Assertions.assertTrue((boolean)JacksonUtils.jsonEquals((JsonNode)expectedJson, (JsonNode)json));
    }

    @Test
    public void componentDependencies_npmMode() throws Exception {
        UI ui = this.initializeUIForDependenciesTest(new TestUI());
        UidlWriter uidlWriter = new UidlWriter();
        this.addInitialComponentDependencies(ui, uidlWriter);
        ObjectNode response = uidlWriter.createUidl(ui, false);
        Assertions.assertFalse((boolean)response.has(LoadMode.EAGER.name()));
        Assertions.assertFalse((boolean)response.has(LoadMode.INLINE.name()));
        Assertions.assertFalse((boolean)response.has(LoadMode.LAZY.name()));
    }

    @Test
    public void componentDependencies_productionMode_scanForParentClasses() throws Exception {
        UI ui = this.initializeUIForDependenciesTest(new TestUI());
        this.mocks.getDeploymentConfiguration().setProductionMode(true);
        UidlWriter uidlWriter = new UidlWriter();
        ui.add(new Component[]{new ChildComponent()});
        ObjectNode response = uidlWriter.createUidl(ui, false);
        Set chunks = this.getDependenciesMap(response).keySet().stream().filter(key -> key.startsWith("return window.Vaadin.Flow.loadOnDemand('")).map(key -> key.replace("return window.Vaadin.Flow.loadOnDemand('", "").replace("');", "")).collect(Collectors.toSet());
        Set expectedChunks = Stream.of(TestUI.class, BaseClass.class, ChildComponent.class, ActualComponent.class, EmptyClassWithInterface.class, SuperComponent.class).map(BundleUtils::getChunkId).collect(Collectors.toSet());
        Assertions.assertEquals(expectedChunks, chunks);
    }

    @Test
    public void componentDependencies_developmentMode_onlySendComponentSpecificChunks() throws Exception {
        UidlWriter uidlWriter = new UidlWriter();
        UI ui = this.initializeUIForDependenciesTest(new TestUI());
        ui.add(new Component[]{new ChildComponent()});
        ObjectNode response = uidlWriter.createUidl(ui, false);
        Set chunks = this.getDependenciesMap(response).keySet().stream().filter(key -> key.startsWith("return window.Vaadin.Flow.loadOnDemand('")).map(key -> key.replace("return window.Vaadin.Flow.loadOnDemand('", "").replace("');", "")).collect(Collectors.toSet());
        Set expectedChunks = Stream.of(TestUI.class, BaseClass.class, ChildComponent.class).map(BundleUtils::getChunkId).collect(Collectors.toSet());
        Assertions.assertEquals(expectedChunks, chunks);
    }

    @Test
    public void testComponentInterfaceDependencies_npmMode() throws Exception {
        UI ui = this.initializeUIForDependenciesTest(new TestUI());
        UidlWriter uidlWriter = new UidlWriter();
        this.addInitialComponentDependencies(ui, uidlWriter);
        ui.add(new Component[]{new ActualComponent(), new SuperComponent(), new ChildComponent()});
        ObjectNode response = uidlWriter.createUidl(ui, false);
        Map<String, ObjectNode> dependenciesMap = ComponentTest.filterLazyLoading(this.getDependenciesMap(response));
        Assertions.assertEquals((int)4, (int)dependenciesMap.size());
        this.assertDependency("childinterface1-" + CSS_STYLE_NAME, CSS_STYLE_NAME, dependenciesMap);
        this.assertDependency("childinterface2-" + CSS_STYLE_NAME, CSS_STYLE_NAME, dependenciesMap);
        this.assertDependency("child1-" + CSS_STYLE_NAME, CSS_STYLE_NAME, dependenciesMap);
        this.assertDependency("child2-" + CSS_STYLE_NAME, CSS_STYLE_NAME, dependenciesMap);
    }

    @Test
    public void checkAllTypesOfDependencies_npmMode() throws Exception {
        UI ui = this.initializeUIForDependenciesTest(new TestUI());
        UidlWriter uidlWriter = new UidlWriter();
        this.addInitialComponentDependencies(ui, uidlWriter);
        ui.add(new Component[]{new ComponentWithAllDependencyTypes()});
        ObjectNode response = uidlWriter.createUidl(ui, false);
        Map<LoadMode, List> dependenciesMap = Stream.of(LoadMode.values()).map(mode -> (ArrayNode)response.get(mode.name())).flatMap(JacksonUtils::stream).collect(Collectors.toMap(jsonObject -> LoadMode.valueOf((String)jsonObject.get("loadMode").textValue()), Collections::singletonList, (list1, list2) -> {
            ArrayList result = new ArrayList(list1);
            result.addAll(list2);
            return result;
        }));
        dependenciesMap.get(LoadMode.LAZY).removeIf(obj -> obj.get("url").textValue().contains("Flow.loadOnDemand"));
        MatcherAssert.assertThat((String)"Dependencies with all types of load mode should be present in this response", (Object)dependenciesMap.size(), (Matcher)Is.is((Object)LoadMode.values().length));
        List eagerDependencies = dependenciesMap.get(LoadMode.EAGER);
        MatcherAssert.assertThat((String)"Should have an eager dependency", (Object)eagerDependencies, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((String)"Eager dependencies should not have inline contents", eagerDependencies.stream().filter(json -> json.has("contents")).collect(Collectors.toList()), (Matcher)Matchers.hasSize((int)0));
        ObjectNode eagerDependency = (ObjectNode)eagerDependencies.get(0);
        Assertions.assertEquals((Object)"eager.css", (Object)eagerDependency.get("url").textValue());
        Assertions.assertEquals((Object)Dependency.Type.STYLESHEET, (Object)Dependency.Type.valueOf((String)eagerDependency.get("type").textValue()));
        List lazyDependencies = dependenciesMap.get(LoadMode.LAZY);
        ObjectNode lazyDependency = (ObjectNode)lazyDependencies.get(0);
        Assertions.assertEquals((Object)"lazy.css", (Object)lazyDependency.get("url").textValue());
        Assertions.assertEquals((Object)Dependency.Type.STYLESHEET, (Object)Dependency.Type.valueOf((String)lazyDependency.get("type").textValue()));
        List inlineDependencies = dependenciesMap.get(LoadMode.INLINE);
        this.assertInlineDependencies(inlineDependencies);
    }

    @Test
    public void resynchronizationRequested_responseFieldContainsResynchronize() throws Exception {
        UI ui = this.initializeUIForDependenciesTest(new TestUI());
        UidlWriter uidlWriter = new UidlWriter();
        ObjectNode response = uidlWriter.createUidl(ui, false, true);
        Assertions.assertTrue((boolean)response.has("resynchronize"), (String)"Response contains resynchronize field");
        Assertions.assertTrue((boolean)response.get("resynchronize").booleanValue(), (String)"Response resynchronize field is set to true");
    }

    @Test
    public void createUidl_allChangesCollected_uiIsNotDirty() throws Exception {
        UI ui = this.initializeUIForDependenciesTest(new TestUI());
        ComponentsContainer container = new ComponentsContainer();
        container.add(new Component[]{new ChildComponent()});
        ui.add(new Component[]{container});
        container.removeAll();
        UidlWriter uidlWriter = new UidlWriter();
        uidlWriter.createUidl(ui, false, true);
        Assertions.assertFalse((boolean)ui.getInternals().isDirty(), (String)"UI is still dirty after creating UIDL");
    }

    @Test
    public void createUidl_collectChangesUIStillDirty_shouldNotLoopEndlessly() throws Exception {
        UI ui = this.initializeUIForDependenciesTest((UI)Mockito.spy((Object)((Object)new TestUI())));
        StateTree stateTree = (StateTree)Mockito.spy((Object)ui.getInternals().getStateTree());
        UIInternals internals = (UIInternals)Mockito.spy((Object)ui.getInternals());
        Mockito.when((Object)ui.getInternals()).thenReturn((Object)internals);
        Mockito.when((Object)internals.getStateTree()).thenReturn((Object)stateTree);
        Mockito.when((Object)stateTree.hasDirtyNodes()).thenReturn((Object)true);
        UidlWriter uidlWriter = new UidlWriter();
        uidlWriter.createUidl(ui, false, true);
        Assertions.assertTrue((boolean)ui.getInternals().isDirty(), (String)"Simulating collectChanges bug and expecting UI to be still dirty after creating UIDL");
    }

    private void assertInlineDependencies(List<ObjectNode> inlineDependencies) {
        MatcherAssert.assertThat((String)"Should have an inline dependency", inlineDependencies, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((String)"Eager dependencies should not have urls", inlineDependencies.stream().filter(json -> json.has("url")).collect(Collectors.toList()), (Matcher)Matchers.hasSize((int)0));
        ObjectNode inlineDependency = inlineDependencies.get(0);
        String url = inlineDependency.get("contents").textValue();
        Assertions.assertEquals((Object)"inline.css", (Object)url);
        Assertions.assertEquals((Object)Dependency.Type.STYLESHEET, (Object)Dependency.Type.valueOf((String)inlineDependency.get("type").textValue()));
    }

    private UI initializeUIForDependenciesTest(UI ui) throws Exception {
        this.mocks = new MockServletServiceSessionSetup();
        VaadinServletContext context = (VaadinServletContext)this.mocks.getService().getContext();
        Lookup lookup = (Lookup)context.getAttribute(Lookup.class);
        Mockito.when((Object)((RoutePathProvider)lookup.lookup(RoutePathProvider.class))).thenReturn((Object)new MockVaadinContext.RoutePathProviderImpl());
        VaadinSession session = this.mocks.getSession();
        session.lock();
        ui.getInternals().setSession(session);
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)ui.getInternals().getRouter().getRegistry());
        routeConfiguration.update((Command & Serializable)() -> {
            routeConfiguration.getHandledRegistry().clean();
            routeConfiguration.setAnnotatedRoute(BaseClass.class);
        });
        for (String type : new String[]{"html", "js", "css"}) {
            this.mocks.getServlet().addServletContextResource("inline." + type, "inline." + type);
        }
        HttpServletRequest servletRequestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        VaadinServletRequest vaadinRequestMock = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        Mockito.when((Object)vaadinRequestMock.getHttpServletRequest()).thenReturn((Object)servletRequestMock);
        ui.doInit((VaadinRequest)vaadinRequestMock, 1, "foo");
        ui.getInternals().getRouter().initializeUI(ui, UITest.requestToLocation((VaadinRequest)vaadinRequestMock));
        return ui;
    }

    private void addInitialComponentDependencies(UI ui, UidlWriter uidlWriter) {
        ui.add(new Component[]{new ActualComponent()});
        ObjectNode response = uidlWriter.createUidl(ui, false);
        Map<String, ObjectNode> dependenciesMap = ComponentTest.filterLazyLoading(this.getDependenciesMap(response));
        Assertions.assertEquals((int)4, (int)dependenciesMap.size());
        this.assertDependency("super-" + CSS_STYLE_NAME, CSS_STYLE_NAME, dependenciesMap);
        this.assertDependency("anotherinterface-" + CSS_STYLE_NAME, CSS_STYLE_NAME, dependenciesMap);
        this.assertDependency("interface-" + CSS_STYLE_NAME, CSS_STYLE_NAME, dependenciesMap);
        this.assertDependency(CSS_STYLE_NAME, CSS_STYLE_NAME, dependenciesMap);
    }

    private Map<String, ObjectNode> getDependenciesMap(ObjectNode response) {
        return Stream.of(LoadMode.values()).map(mode -> (ArrayNode)response.get(mode.name())).flatMap(JacksonUtils::stream).collect(Collectors.toMap(jsonObject -> jsonObject.get("url").textValue(), Function.identity()));
    }

    private void assertDependency(String url, String type, Map<String, ObjectNode> dependenciesMap) {
        ObjectNode jsonValue = dependenciesMap.get(url);
        Assertions.assertNotNull((Object)jsonValue, (String)("Expected dependencies map to have dependency with key=" + url));
        Assertions.assertEquals((Object)url, (Object)jsonValue.get("url").textValue());
        Assertions.assertEquals((Object)type, (Object)jsonValue.get("type").textValue());
    }

    @JavaScript(value="UI-JAVASCRIPT")
    private static class TestUI
    extends ParentUI {
        private TestUI() {
        }
    }

    @JavaScript.Container(value={@JavaScript(value="child1-JAVASCRIPT"), @JavaScript(value="child2-JAVASCRIPT")})
    @StyleSheet.Container(value={@StyleSheet(value="child1-STYLESHEET"), @StyleSheet(value="child2-STYLESHEET")})
    public static class ChildComponent
    extends ActualComponent
    implements ChildComponentInterface2 {
    }

    @Tag(value="base")
    @Route(value="", layout=ParentClass.class)
    public static class BaseClass
    extends Component {
    }

    @JavaScript(value="JAVASCRIPT")
    @StyleSheet(value="STYLESHEET")
    public static class ActualComponent
    extends EmptyClassWithInterface
    implements ComponentInterface {
    }

    public static class EmptyClassWithInterface
    extends SuperComponent
    implements AnotherComponentInterface {
    }

    @Tag(value="div")
    @JavaScript(value="super-JAVASCRIPT")
    @StyleSheet(value="super-STYLESHEET")
    public static class SuperComponent
    extends Component {
    }

    @Tag(value="test")
    @JavaScript.Container(value={@JavaScript(value="lazy.js", loadMode=LoadMode.LAZY), @JavaScript(value="inline.js", loadMode=LoadMode.INLINE), @JavaScript(value="eager.js")})
    @StyleSheet.Container(value={@StyleSheet(value="lazy.css", loadMode=LoadMode.LAZY), @StyleSheet(value="inline.css", loadMode=LoadMode.INLINE), @StyleSheet(value="eager.css")})
    public static class ComponentWithAllDependencyTypes
    extends Component {
    }

    @Tag(value="components-container")
    public static class ComponentsContainer
    extends Component
    implements HasComponents {
    }

    @Tag(value="super-parent")
    public static class SuperParentClass
    extends Component
    implements RouterLayout {
    }

    @Tag(value="parent")
    @ParentLayout(value=SuperParentClass.class)
    public static class ParentClass
    extends Component
    implements RouterLayout {
    }

    @JavaScript(value="childinterface2-JAVASCRIPT")
    @StyleSheet(value="childinterface2-STYLESHEET")
    public static interface ChildComponentInterface2
    extends ChildComponentInterface1 {
    }

    @JavaScript(value="childinterface1-JAVASCRIPT")
    @StyleSheet(value="childinterface1-STYLESHEET")
    public static interface ChildComponentInterface1 {
    }

    @JavaScript(value="anotherinterface-JAVASCRIPT")
    @StyleSheet(value="anotherinterface-STYLESHEET")
    public static interface AnotherComponentInterface {
    }

    @JavaScript(value="interface-JAVASCRIPT")
    @StyleSheet(value="interface-STYLESHEET")
    public static interface ComponentInterface {
    }

    @JavaScript(value="UI-parent-JAVASCRIPT")
    private static class ParentUI
    extends UI {
        private ParentUI() {
        }
    }
}

