/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import java.util.Locale;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class VaadinSessionLocaleSignalTest
extends SignalsUnitTest {
    VaadinSessionLocaleSignalTest() {
    }

    private VaadinSession getSession() {
        return UI.getCurrent().getSession();
    }

    @Test
    public void localeSignal_initialValue_matchesGetLocale() {
        VaadinSession session = this.getSession();
        SharedValueSignal signal = session.localeSignal();
        Assertions.assertNotNull((Object)signal, (String)"localeSignal() should never return null");
        Assertions.assertEquals((Object)session.getLocale(), (Object)signal.get(), (String)"Signal value should match getLocale()");
    }

    @Test
    public void localeSignal_setLocale_signalUpdated() {
        Locale newLocale;
        VaadinSession session = this.getSession();
        SharedValueSignal signal = session.localeSignal();
        Locale initialLocale = session.getLocale();
        if (initialLocale.equals(newLocale = Locale.FRENCH)) {
            newLocale = Locale.GERMAN;
        }
        session.setLocale(newLocale);
        Assertions.assertEquals((Object)newLocale, (Object)signal.get(), (String)"Signal should reflect the new locale after setLocale()");
        Assertions.assertEquals((Object)newLocale, (Object)session.getLocale(), (String)"getLocale() should also return the new locale");
    }

    @Test
    public void localeSignal_writeToSignal_updatesGetLocale() {
        Locale newLocale;
        VaadinSession session = this.getSession();
        SharedValueSignal signal = session.localeSignal();
        Locale initialLocale = session.getLocale();
        if (initialLocale.equals(newLocale = Locale.FRENCH)) {
            newLocale = Locale.GERMAN;
        }
        signal.set((Object)newLocale);
        Assertions.assertEquals((Object)newLocale, (Object)session.getLocale(), (String)"getLocale() should reflect the new locale after writing to signal");
        Assertions.assertEquals((Object)newLocale, (Object)signal.get(), (String)"Signal should have the new value");
    }

    @Test
    public void localeSignal_sameInstance_returnedOnMultipleCalls() {
        VaadinSession session = this.getSession();
        SharedValueSignal signal1 = session.localeSignal();
        SharedValueSignal signal2 = session.localeSignal();
        Assertions.assertSame((Object)signal1, (Object)signal2, (String)"localeSignal() should return the same instance on multiple calls");
    }

    @Test
    public void localeSignal_multipleLocaleChanges_signalFollows() {
        VaadinSession session = this.getSession();
        SharedValueSignal signal = session.localeSignal();
        session.setLocale(Locale.FRENCH);
        Assertions.assertEquals((Object)Locale.FRENCH, (Object)signal.get());
        session.setLocale(Locale.GERMAN);
        Assertions.assertEquals((Object)Locale.GERMAN, (Object)signal.get());
        session.setLocale(Locale.JAPANESE);
        Assertions.assertEquals((Object)Locale.JAPANESE, (Object)signal.get());
    }

    @Test
    public void localeSignal_multipleSignalWrites_getLocaleFollows() {
        VaadinSession session = this.getSession();
        SharedValueSignal signal = session.localeSignal();
        signal.set((Object)Locale.FRENCH);
        Assertions.assertEquals((Object)Locale.FRENCH, (Object)session.getLocale());
        signal.set((Object)Locale.GERMAN);
        Assertions.assertEquals((Object)Locale.GERMAN, (Object)session.getLocale());
        signal.set((Object)Locale.JAPANESE);
        Assertions.assertEquals((Object)Locale.JAPANESE, (Object)session.getLocale());
    }
}

