/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.function.ContentTypeResolver;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import jakarta.servlet.ServletContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class StreamResourceTest {
    StreamResourceTest() {
    }

    @Test
    public void getDefaultContentTypeResolver() {
        StreamResource resource = new StreamResource("foo", (InputStreamFactory & Serializable)() -> this.makeEmptyStream());
        ContentTypeResolver resolver = resource.getContentTypeResolver();
        Assertions.assertNotNull((Object)resolver);
        this.assertContentType(resource, resolver);
    }

    @Test
    public void setContentTypeResolver() {
        StreamResource resource = new StreamResource("foo", (InputStreamFactory & Serializable)() -> this.makeEmptyStream());
        resource.setContentTypeResolver((ContentTypeResolver & Serializable)(res, context) -> "bar");
        Assertions.assertNotNull((Object)resource.getContentTypeResolver());
        this.assertContentType(resource, resource.getContentTypeResolver());
    }

    @Test
    public void setContentType() {
        StreamResource resource = new StreamResource("foo", (InputStreamFactory & Serializable)() -> this.makeEmptyStream());
        resource.setContentType("bar");
        Assertions.assertNotNull((Object)resource.getContentTypeResolver());
        this.assertContentType(resource, resource.getContentTypeResolver());
    }

    @Test
    public void setHeader_headerIsInHeadersListAndGetterReturnsTheValue() {
        StreamResource resource = new StreamResource("foo", (InputStreamFactory & Serializable)() -> this.makeEmptyStream());
        resource.setHeader("foo", "bar");
        Assertions.assertEquals((Object)"bar", resource.getHeader("foo").get());
        Map headers = resource.getHeaders();
        Assertions.assertEquals((int)1, (int)headers.size());
        Assertions.assertEquals((Object)"bar", headers.get("foo"));
    }

    private void assertContentType(StreamResource resource, ContentTypeResolver resolver) {
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)context.getMimeType("foo")).thenReturn((Object)"bar");
        String mimeType = (String)resolver.apply((Object)resource, (Object)context);
        Assertions.assertEquals((Object)"bar", (Object)mimeType);
    }

    private InputStream makeEmptyStream() {
        return new ByteArrayInputStream(new byte[0]);
    }
}

