/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.menu.MenuRegistry;
import com.vaadin.flow.router.Layout;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteResolver;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RoutingTestBase;
import com.vaadin.flow.router.internal.DefaultRouteResolver;
import com.vaadin.flow.router.internal.ResolveRequest;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.menu.AvailableViewInfo;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class DefaultRouteResolverTest
extends RoutingTestBase {
    private RouteResolver resolver;

    DefaultRouteResolverTest() {
    }

    @Override
    @BeforeEach
    public void init() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        super.init();
        this.resolver = new DefaultRouteResolver();
        CurrentInstance.clearAll();
    }

    @Test
    public void basic_route_navigation_target_resolved_correctly() throws InvalidRouteConfigurationException {
        this.setRoutes(this.router.getRegistry(), Stream.of(RoutingTestBase.RootNavigationTarget.class, RoutingTestBase.FooNavigationTarget.class, RoutingTestBase.FooBarNavigationTarget.class, RoutingTestBase.GreetingNavigationTarget.class).collect(Collectors.toSet()));
        Assertions.assertEquals(RoutingTestBase.RootNavigationTarget.class, this.resolveNavigationTarget(""));
        Assertions.assertEquals(RoutingTestBase.FooNavigationTarget.class, this.resolveNavigationTarget("foo"));
        Assertions.assertEquals(RoutingTestBase.FooBarNavigationTarget.class, this.resolveNavigationTarget("foo/bar"));
    }

    private void setRoutes(RouteRegistry registry, Set<Class<? extends Component>> routes) {
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)registry);
        routeConfiguration.update((Command & Serializable)() -> {
            routeConfiguration.getHandledRegistry().clean();
            routes.forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        });
    }

    @Test
    public void no_route_found_resolves_to_null() {
        Assertions.assertNull((Object)this.resolver.resolve(new ResolveRequest(this.router, new Location("Not a configured location"))), (String)"Attempting to resolve an invalid location should return null");
    }

    @Test
    public void string_url_parameter_correctly_set_to_state() throws InvalidRouteConfigurationException {
        this.setRoutes(this.router.getRegistry(), Collections.singleton(RoutingTestBase.GreetingNavigationTarget.class));
        Assertions.assertEquals(Collections.singletonList("World"), this.resolveNavigationState("greeting/World").getUrlParameters().get());
    }

    @Test
    public void route_precedence_with_parameters() throws InvalidRouteConfigurationException {
        this.setRoutes(this.router.getRegistry(), Stream.of(RoutingTestBase.GreetingNavigationTarget.class, RoutingTestBase.OtherGreetingNavigationTarget.class).collect(Collectors.toSet()));
        Assertions.assertEquals(RoutingTestBase.GreetingNavigationTarget.class, this.resolveNavigationTarget("greeting/World"));
        Assertions.assertEquals(RoutingTestBase.OtherGreetingNavigationTarget.class, this.resolveNavigationTarget("greeting/other/World"));
    }

    @Test
    public void wrong_number_of_parameters_does_not_match() throws InvalidRouteConfigurationException {
        this.setRoutes(this.router.getRegistry(), Collections.singleton(RoutingTestBase.GreetingNavigationTarget.class));
        Assertions.assertEquals(null, (Object)this.resolveNavigationState("greeting/World/something"));
        Assertions.assertEquals(null, (Object)this.resolveNavigationState("greeting"));
    }

    @Test
    public void clientRouteRequest_getDefinedLayout() {
        String path = "route";
        this.router.getRegistry().setLayout(DefaultLayout.class);
        try (MockedStatic menuRegistry = Mockito.mockStatic(MenuRegistry.class);){
            menuRegistry.when(() -> MenuRegistry.getClientRoutes((boolean)false)).thenReturn(Collections.singletonMap("/route", new AvailableViewInfo("", null, false, "/route", false, false, null, null, null, true, null)));
            NavigationState greeting = this.resolveNavigationState(path);
            Assertions.assertEquals(DefaultLayout.class, (Object)greeting.getRouteTarget().getTarget(), (String)"Layout should be returned for a non server route when matching @Layout exists");
        }
    }

    @Test
    public void clientRouteRequest_getDefinedLayoutAndParentLayouts() {
        String path = "route";
        this.router.getRegistry().setLayout(DefaultWithParentLayout.class);
        try (MockedStatic menuRegistry = Mockito.mockStatic(MenuRegistry.class);){
            menuRegistry.when(() -> MenuRegistry.getClientRoutes((boolean)false)).thenReturn(Collections.singletonMap("/route", new AvailableViewInfo("", null, false, "/route", false, false, null, null, null, true, null)));
            NavigationState greeting = this.resolveNavigationState(path);
            Assertions.assertEquals(DefaultWithParentLayout.class, (Object)greeting.getRouteTarget().getTarget(), (String)"Layout should be returned for a non server route when matching @Layout exists");
            Assertions.assertEquals((int)1, (int)greeting.getRouteTarget().getParentLayouts().size(), (String)"@ParentLayout annotation should be followed. @Layout class should not be in parent layout list.");
            Assertions.assertEquals(DefaultParentLayout.class, greeting.getRouteTarget().getParentLayouts().get(0), (String)"@ParentLayout annotation should be followed. @Layout class should not be in parent layout list.");
        }
    }

    @Test
    public void clientRouteRequest_withRouteParameters_getDefinedLayout() {
        this.router.getRegistry().setLayout(DefaultLayout.class);
        try (MockedStatic menuRegistry = Mockito.mockStatic(MenuRegistry.class);){
            menuRegistry.when(() -> MenuRegistry.getClientRoutes((boolean)false)).thenReturn(this.buildClientRoutes("/route/:param", "/opt_route/:param?", "/wildcard_route/:param*", "/one/:param/two/:param2", "/foo/:param?/bar/:param2?"));
            Stream.of("route/1", "/route/abc", "/opt_route", "/opt_route/", "/opt_route/1", "/wildcard_route", "wildcard_route", "wildcard_route/", "wildcard_route/1", "/wildcard_route/1/2", "one/1/two/2", "foo/bar", "foo/a/bar", "foo/bar/b", "foo/a/bar/b").forEach(path -> {
                String msg = String.format("Layout should be returned for path '%s' a non server route when matching @Layout exists", path);
                NavigationState state = this.resolveNavigationState((String)path);
                Assertions.assertNotNull((Object)state, (String)msg);
                Assertions.assertEquals(DefaultLayout.class, (Object)this.resolveNavigationState((String)path).getRouteTarget().getTarget(), (String)msg);
            });
        }
    }

    @Test
    public void clientRouteRequest_withRouteParameters_noLayout() {
        this.router.getRegistry().setLayout(DefaultLayout.class);
        try (MockedStatic menuRegistry = Mockito.mockStatic(MenuRegistry.class);){
            menuRegistry.when(() -> MenuRegistry.getClientRoutes((boolean)false)).thenReturn(this.buildClientRoutes("/route/:param", "/opt_route/:param?", "/wildcard_route/:param*", "/one/:param/two/:param2", "/foo/:param?/bar/:param2?"));
            Stream.of("route", "/route/abc/def", "/unknown_route", "/opt_route/1/2", "/", "", "one/1/two/2/3", "one/two/2", "one/two/", "foo", "foo/foo/foo/bar/bar/").forEach(path -> Assertions.assertNull((Object)this.resolveNavigationState((String)path), (String)String.format("Layout should not be returned for a non server route '%s' when matching @Layout doesn't exist", path)));
        }
    }

    @Test
    public void clientRouteRequest_withRouteParameters_ambiguousRoutesFirstAddedWins() {
        this.router.getRegistry().setLayout(DefaultLayout.class);
        try (MockedStatic menuRegistry = Mockito.mockStatic(MenuRegistry.class);){
            menuRegistry.when(() -> MenuRegistry.getClientRoutes((boolean)false)).thenReturn(this.buildClientRoutes("/route", "/route/:param?", "/foo", "/foo/:param*"));
            Stream.of("route", "foo", "foo/1").forEach(path -> {
                String msg = String.format("Layout should be returned for path '%s' a non server route when matching @Layout exists", path);
                NavigationState state = this.resolveNavigationState((String)path);
                Assertions.assertNotNull((Object)state, (String)msg);
                Assertions.assertEquals(DefaultLayout.class, (Object)this.resolveNavigationState((String)path).getRouteTarget().getTarget(), (String)msg);
            });
            Stream.of("route/1").forEach(path -> Assertions.assertNull((Object)this.resolveNavigationState((String)path), (String)String.format("Layout should not be returned for a non server route '%s' when matching @Layout doesn't exist", path)));
        }
    }

    private Map<String, AvailableViewInfo> buildClientRoutes(String ... routes) {
        LinkedHashMap<String, AvailableViewInfo> clientRoutes = new LinkedHashMap<String, AvailableViewInfo>();
        for (String route : routes) {
            clientRoutes.put(route, this.createAvailableViewInfo(route));
        }
        return clientRoutes;
    }

    private AvailableViewInfo createAvailableViewInfo(String route) {
        return new AvailableViewInfo("", null, false, route, false, false, null, null, null, true, null);
    }

    @Test
    public void clientRouteRequest_noLayoutForPath_Throws() {
        String path = "route";
        try (MockedStatic menuRegistry = Mockito.mockStatic(MenuRegistry.class);){
            menuRegistry.when(() -> MenuRegistry.getClientRoutes((boolean)false)).thenReturn(Collections.singletonMap("/route", new AvailableViewInfo("", null, false, "/route", false, false, null, null, null, true, null)));
            NotFoundException ex = (NotFoundException)Assertions.assertThrows(NotFoundException.class, () -> this.resolveNavigationState(path));
            Assertions.assertTrue((boolean)ex.getMessage().contains("No layout for client path 'route'"));
        }
    }

    private Class<? extends Component> resolveNavigationTarget(String path) {
        return this.resolveNavigationState(path).getNavigationTarget();
    }

    private NavigationState resolveNavigationState(String path) {
        return this.resolver.resolve(new ResolveRequest(this.router, new Location(path)));
    }

    @Tag(value="div")
    @Layout
    private static class DefaultLayout
    extends Component
    implements RouterLayout {
        private DefaultLayout() {
        }
    }

    @Tag(value="div")
    @Layout
    @ParentLayout(value=DefaultParentLayout.class)
    private static class DefaultWithParentLayout
    extends Component
    implements RouterLayout {
        private DefaultWithParentLayout() {
        }
    }

    @Tag(value="div")
    private static class DefaultParentLayout
    extends Component
    implements RouterLayout {
        private DefaultParentLayout() {
        }
    }
}

