/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.nodefeature.AbstractNodeFeatureTest;
import com.vaadin.flow.internal.nodefeature.PushConfigurationMap;
import com.vaadin.flow.shared.ui.Transport;
import java.util.Arrays;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PushConfigurationMapTest
extends AbstractNodeFeatureTest<PushConfigurationMap> {
    private PushConfigurationMap ns = (PushConfigurationMap)this.createFeature();

    PushConfigurationMapTest() {
    }

    @Test
    void transportWebsocket() {
        this.ns.setTransport(Transport.WEBSOCKET);
        Assertions.assertEquals((Object)Transport.WEBSOCKET.getIdentifier(), (Object)this.ns.getParameter("transport"));
        Assertions.assertFalse((boolean)this.ns.contains("alwaysXhrToServer"));
        Assertions.assertEquals((Object)Transport.WEBSOCKET, (Object)this.ns.getTransport());
    }

    @Test
    void transportLongPolling() {
        this.ns.setTransport(Transport.LONG_POLLING);
        Assertions.assertEquals((Object)Transport.LONG_POLLING.getIdentifier(), (Object)this.ns.getParameter("transport"));
        Assertions.assertFalse((boolean)this.ns.contains("alwaysXhrToServer"));
        Assertions.assertEquals((Object)Transport.LONG_POLLING, (Object)this.ns.getTransport());
    }

    @Test
    void transportLongWebsocketXHR() {
        this.ns.setTransport(Transport.WEBSOCKET_XHR);
        Assertions.assertEquals((Object)Transport.WEBSOCKET.getIdentifier(), (Object)this.ns.getParameter("transport"));
        Assertions.assertTrue((boolean)((Boolean)this.ns.get("alwaysXhrToServer")));
        Assertions.assertEquals((Object)Transport.WEBSOCKET_XHR, (Object)this.ns.getTransport());
    }

    @Test
    void fallbackTransportLongPolling() {
        this.ns.setFallbackTransport(Transport.LONG_POLLING);
        Assertions.assertEquals((Object)Transport.LONG_POLLING.getIdentifier(), (Object)this.ns.getParameter("fallbackTransport"));
        Assertions.assertEquals((Object)Transport.LONG_POLLING, (Object)this.ns.getFallbackTransport());
    }

    @Test
    void fallbackTransportWebsocket() {
        this.ns.setFallbackTransport(Transport.WEBSOCKET);
        Assertions.assertEquals((Object)Transport.WEBSOCKET.getIdentifier(), (Object)this.ns.getParameter("fallbackTransport"));
        Assertions.assertEquals((Object)Transport.WEBSOCKET, (Object)this.ns.getFallbackTransport());
    }

    @Test
    void fallbackTransportWebsocketXHR() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.ns.setFallbackTransport(Transport.WEBSOCKET_XHR));
    }

    @Test
    void parameterNames() {
        this.ns.setParameter("foo", "bar");
        Assertions.assertArrayEquals((Object[])new String[]{"foo"}, (Object[])this.ns.getParameterNames().toArray());
        this.ns.setTransport(Transport.WEBSOCKET);
        this.ns.setFallbackTransport(Transport.LONG_POLLING);
        Object[] expected = new String[]{"foo", "transport", "fallbackTransport"};
        Collection paramNames = this.ns.getParameterNames();
        Object[] actual = paramNames.toArray(new String[paramNames.size()]);
        Arrays.sort(expected);
        Arrays.sort(actual);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }
}

