/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.EmptyChange;
import com.vaadin.flow.internal.change.MapPutChange;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class NodeMapEmptyRequiredFeatureTest {
    private StateNode node;
    private NodeMap nodeMap;

    NodeMapEmptyRequiredFeatureTest() {
    }

    @BeforeEach
    void setUp() {
        this.node = new StateNode(Arrays.asList(ElementPropertyMap.class), new Class[0]){

            public boolean isAttached() {
                return true;
            }
        };
        this.nodeMap = (NodeMap)this.node.getFeature(ElementPropertyMap.class);
    }

    @Test
    void generateChangesFromEmpty_featureHasChangesToCollect() {
        this.nodeMap.generateChangesFromEmpty();
        AtomicReference change = new AtomicReference();
        this.node.collectChanges(change::set);
        Assertions.assertTrue((boolean)(change.get() instanceof EmptyChange));
        this.nodeMap.generateChangesFromEmpty();
        change.set(null);
        this.node.collectChanges(change::set);
        Assertions.assertNull(change.get());
    }

    @Test
    void generateChangesFromEmpty_noEmptyChange() {
        this.nodeMap.put("foo", (Serializable)((Object)"bar"));
        this.node.clearChanges();
        this.nodeMap.generateChangesFromEmpty();
        ArrayList changes = new ArrayList();
        this.node.collectChanges(changes::add);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertTrue((boolean)(changes.get(0) instanceof MapPutChange));
    }

    @Test
    void collectChanges_featureHasEmptyChange() {
        AtomicReference change = new AtomicReference();
        this.nodeMap.collectChanges(change::set);
        Assertions.assertTrue((boolean)(change.get() instanceof EmptyChange));
        change.set(null);
        this.nodeMap.collectChanges(change::set);
        Assertions.assertNull(change.get());
    }

    @Test
    void collectChanges_noEmptyChange() {
        this.nodeMap.put("foo", (Serializable)((Object)"bar"));
        ArrayList changes = new ArrayList();
        this.node.collectChanges(changes::add);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertTrue((boolean)(changes.get(0) instanceof MapPutChange));
    }
}

