/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.AbstractNodeFeatureTest;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class ElementListenersTest
extends AbstractNodeFeatureTest<ElementListenerMap> {
    private static final DomEventListener noOp = (DomEventListener & Serializable)e -> {};
    private ElementListenerMap ns;

    @BeforeEach
    void init() {
        this.ns = (ElementListenerMap)this.createFeature();
    }

    @Test
    void addedListenerGetsEvent() {
        AtomicInteger eventCount = new AtomicInteger();
        DomListenerRegistration handle = this.ns.add("foo", (DomEventListener & Serializable)e -> eventCount.incrementAndGet());
        Assertions.assertEquals((int)0, (int)eventCount.get());
        this.ns.fireEvent(ElementListenersTest.createEvent("foo"));
        Assertions.assertEquals((int)1, (int)eventCount.get());
        handle.remove();
        this.ns.fireEvent(ElementListenersTest.createEvent("foo"));
        Assertions.assertEquals((int)1, (int)eventCount.get());
    }

    @Test
    void eventNameInClientData() {
        Assertions.assertFalse((boolean)this.ns.contains("foo"));
        DomListenerRegistration handle = this.ns.add("foo", noOp);
        Assertions.assertEquals((int)0, (int)this.getExpressions("foo").size());
        handle.remove();
        Assertions.assertFalse((boolean)this.ns.contains("foo"));
    }

    @Test
    void addAndRemoveEventData() {
        this.ns.add("eventType", noOp).addEventData("data1").addEventData("data2");
        Set<String> expressions = this.getExpressions("eventType");
        Assertions.assertTrue((boolean)expressions.contains("data1"));
        Assertions.assertTrue((boolean)expressions.contains("data2"));
        Assertions.assertFalse((boolean)expressions.contains("data3"));
        DomListenerRegistration handle = this.ns.add("eventType", new DomEventListener(){

            public void handleEvent(DomEvent event) {
            }
        }).addEventData("data3");
        expressions = this.getExpressions("eventType");
        Assertions.assertTrue((boolean)expressions.contains("data1"));
        Assertions.assertTrue((boolean)expressions.contains("data2"));
        Assertions.assertTrue((boolean)expressions.contains("data3"));
        handle.remove();
        expressions = this.getExpressions("eventType");
        Assertions.assertTrue((boolean)expressions.contains("data1"));
        Assertions.assertTrue((boolean)expressions.contains("data2"));
        Assertions.assertFalse((boolean)expressions.contains("data3"));
    }

    @Test
    void settingsAreOnlyUpdated_should_ListenersSharingTheTypeOfRemovedListenerExist() {
        this.ns = (ElementListenerMap)Mockito.spy((Object)((ElementListenerMap)this.createFeature()));
        DomEventListener & Serializable del1 = (DomEventListener & Serializable)event -> {};
        DomEventListener & Serializable del2 = (DomEventListener & Serializable)event -> {};
        DomEventListener & Serializable del3 = (DomEventListener & Serializable)event -> {};
        DomListenerRegistration handle1 = this.ns.add("eventType", (DomEventListener)del1).addEventData("data1");
        DomListenerRegistration handle2 = this.ns.add("eventType", (DomEventListener)del2).addEventData("data2");
        DomListenerRegistration handle3 = this.ns.add("eventTypeOther", (DomEventListener)del3).addEventData("data3");
        Mockito.reset((Object[])new ElementListenerMap[]{this.ns});
        Set<String> expressions = this.getExpressions("eventType");
        expressions.addAll(this.getExpressions("eventTypeOther"));
        Assertions.assertTrue((boolean)expressions.contains("data1"));
        Assertions.assertTrue((boolean)expressions.contains("data2"));
        Assertions.assertTrue((boolean)expressions.contains("data3"));
        handle1.remove();
        ((ElementListenerMap)Mockito.verify((Object)this.ns, (VerificationMode)Mockito.times((int)1))).put((String)ArgumentMatchers.eq((Object)"eventType"), (Serializable)ArgumentMatchers.any(Serializable.class));
        expressions = this.getExpressions("eventType");
        expressions.addAll(this.getExpressions("eventTypeOther"));
        Assertions.assertFalse((boolean)expressions.contains("data1"));
        Assertions.assertTrue((boolean)expressions.contains("data2"));
        Assertions.assertTrue((boolean)expressions.contains("data3"));
        handle2.remove();
        ((ElementListenerMap)Mockito.verify((Object)this.ns, (VerificationMode)Mockito.times((int)1))).put((String)ArgumentMatchers.eq((Object)"eventType"), (Serializable)ArgumentMatchers.any(Serializable.class));
        expressions = this.getExpressions("eventType");
        expressions.addAll(this.getExpressions("eventTypeOther"));
        Assertions.assertFalse((boolean)expressions.contains("data1"));
        Assertions.assertFalse((boolean)expressions.contains("data2"));
        Assertions.assertTrue((boolean)expressions.contains("data3"));
    }

    @Test
    void addingRemovingAndAddingListenerOfTheSameType() {
        DomEventListener & Serializable del1 = (DomEventListener & Serializable)event -> {};
        DomEventListener & Serializable del2 = (DomEventListener & Serializable)event -> {};
        DomListenerRegistration handle = this.ns.add("eventType", (DomEventListener)del1).addEventData("data1");
        Set<String> expressions = this.getExpressions("eventType");
        Assertions.assertTrue((boolean)expressions.contains("data1"));
        handle.remove();
        expressions = this.getExpressions("eventType");
        Assertions.assertFalse((boolean)expressions.contains("data1"));
        handle = this.ns.add("eventType", (DomEventListener)del2).addEventData("data2");
        expressions = this.getExpressions("eventType");
        Assertions.assertFalse((boolean)expressions.contains("data1"));
        Assertions.assertTrue((boolean)expressions.contains("data2"));
        handle.remove();
        expressions = this.getExpressions("eventType");
        Assertions.assertFalse((boolean)expressions.contains("data1"));
        Assertions.assertFalse((boolean)expressions.contains("data2"));
    }

    @Test
    void eventDataInEvent() {
        AtomicReference eventDataReference = new AtomicReference();
        this.ns.add("foo", (DomEventListener & Serializable)e -> {
            Assertions.assertNull(eventDataReference.get());
            eventDataReference.set(e.getEventData());
        });
        Assertions.assertNull(eventDataReference.get());
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.put("baz", true);
        this.ns.fireEvent(new DomEvent(new Element("element"), "foo", (JsonNode)eventData));
        JsonNode capturedJson = (JsonNode)eventDataReference.get();
        Assertions.assertNotNull((Object)capturedJson);
        Assertions.assertEquals((int)1, (int)JacksonUtils.getKeys((JsonNode)capturedJson).size());
        Assertions.assertEquals((Object)"true", (Object)capturedJson.get("baz").toString());
    }

    @Test
    void disabledElement_listenerDoesntReceiveEvent() {
        AtomicInteger eventCount = new AtomicInteger();
        this.ns.add("foo", (DomEventListener & Serializable)e -> eventCount.incrementAndGet());
        Assertions.assertEquals((int)0, (int)eventCount.get());
        DomEvent event = ElementListenersTest.createEvent("foo");
        event.getSource().setEnabled(false);
        this.ns.fireEvent(event);
        Assertions.assertEquals((int)0, (int)eventCount.get());
    }

    @Test
    void implicitlyDisabledElement_listenerDoesntReceiveEvent() {
        AtomicInteger eventCount = new AtomicInteger();
        this.ns.add("foo", (DomEventListener & Serializable)e -> eventCount.incrementAndGet());
        Assertions.assertEquals((int)0, (int)eventCount.get());
        DomEvent event = ElementListenersTest.createEvent("foo");
        Element parent = new Element("parent");
        parent.appendChild(new Element[]{event.getSource()});
        parent.setEnabled(false);
        this.ns.fireEvent(event);
        Assertions.assertEquals((int)0, (int)eventCount.get());
    }

    @Test
    void disabledElement_listenerWithAlwaysUpdateModeReceivesEvent() {
        AtomicInteger eventCount = new AtomicInteger();
        this.ns.add("foo", (DomEventListener & Serializable)e -> eventCount.incrementAndGet()).setDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
        Assertions.assertEquals((int)0, (int)eventCount.get());
        DomEvent event = ElementListenersTest.createEvent("foo");
        event.getSource().setEnabled(false);
        this.ns.fireEvent(event);
        Assertions.assertEquals((int)1, (int)eventCount.get());
    }

    @Test
    void serializable() {
        this.ns.add("click", noOp).addEventData("eventdata");
        ElementListenerMap roundtrip = (ElementListenerMap)SerializationUtils.roundtrip((Serializable)this.ns);
        Set expressions = roundtrip.getExpressions("click");
        Assertions.assertEquals(Collections.singleton("eventdata"), (Object)expressions);
    }

    @Test
    void synchronizeProperty_hasSynchronizedProperty() {
        DomListenerRegistration registration = this.ns.add("foo", noOp);
        Assertions.assertNull((Object)this.ns.getPropertySynchronizationMode("name"));
        registration.synchronizeProperty("anotherName");
        Assertions.assertNull((Object)this.ns.getPropertySynchronizationMode("name"));
        registration.synchronizeProperty("name");
        Assertions.assertSame((Object)DisabledUpdateMode.ONLY_WHEN_ENABLED, (Object)this.ns.getPropertySynchronizationMode("name"));
    }

    @Test
    void synchronizeProperty_alwaysMode() {
        DomListenerRegistration registration = this.ns.add("foo", noOp).setDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
        registration.synchronizeProperty("name");
        Assertions.assertSame((Object)DisabledUpdateMode.ALWAYS, (Object)this.ns.getPropertySynchronizationMode("name"));
    }

    @Test
    void synchronizeProperty_bothModes() {
        DomListenerRegistration registration1 = this.ns.add("foo", noOp).setDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
        registration1.synchronizeProperty("name");
        DomListenerRegistration registration2 = this.ns.add("foo", noOp);
        registration2.synchronizeProperty("name");
        Assertions.assertSame((Object)DisabledUpdateMode.ALWAYS, (Object)this.ns.getPropertySynchronizationMode("name"));
    }

    @Test
    void synchronizeProperty_hasExpressionToken() {
        DomListenerRegistration registration = this.ns.add("foo", noOp);
        Assertions.assertEquals(Collections.emptySet(), this.getExpressions("foo"));
        registration.synchronizeProperty("name");
        Assertions.assertEquals(Collections.singleton("}name"), this.getExpressions("foo"));
    }

    @Test
    void synchronizeProperty_nullArgument_illegalArgumentException() {
        DomListenerRegistration registration = this.ns.add("foo", noOp);
        Assertions.assertThrows(IllegalArgumentException.class, () -> registration.synchronizeProperty(null));
    }

    @Test
    void synchronizeProperty_emptyArgument_illegalArgumentException() {
        DomListenerRegistration registration = this.ns.add("foo", noOp);
        Assertions.assertThrows(IllegalArgumentException.class, () -> registration.synchronizeProperty(""));
    }

    @Test
    void mapEventTargetToElement_targetNodeIdInJsonData_elementMapped() {
        Element parent = new Element("parent");
        Element child = new Element("child");
        Element grandChild = new Element("grandChild");
        parent.appendChild(new Element[]{(Element)child.appendChild(new Element[]{grandChild})});
        new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class}).getUI().getElement().appendChild(new Element[]{parent});
        String eventType = "click";
        AtomicReference capturedTarget = new AtomicReference();
        DomListenerRegistration registration = parent.addEventListener("click", (DomEventListener & Serializable)e -> capturedTarget.set(e.getEventTarget().orElse(null)));
        ElementListenerMap listenerMap = (ElementListenerMap)parent.getNode().getFeature(ElementListenerMap.class);
        Set<String> expressions = ElementListenersTest.getExpressions(listenerMap, "click");
        Assertions.assertEquals((int)0, (int)expressions.size());
        registration.mapEventTargetElement();
        expressions = ElementListenersTest.getExpressions(listenerMap, "click");
        Assertions.assertEquals((int)1, (int)expressions.size());
        Assertions.assertEquals((Object)"]", (Object)expressions.iterator().next());
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.put("]", child.getNode().getId());
        listenerMap.fireEvent(new DomEvent(parent, "click", (JsonNode)eventData));
        Assertions.assertEquals((Object)child, capturedTarget.get());
        listenerMap.fireEvent(new DomEvent(parent, "click", (JsonNode)JacksonUtils.createObjectNode()));
        Assertions.assertNull(capturedTarget.get(), (String)"no element should be reported");
        eventData.put("]", grandChild.getNode().getId());
        listenerMap.fireEvent(new DomEvent(parent, "click", (JsonNode)eventData));
        Assertions.assertEquals((Object)grandChild, capturedTarget.get());
        eventData.put("]", -1);
        listenerMap.fireEvent(new DomEvent(parent, "click", (JsonNode)eventData));
        Assertions.assertNull(capturedTarget.get(), (String)"no element should be reported");
    }

    @Test
    void addEventDataElement_targetNodeInJsonData_elementMapped() {
        Element parent = new Element("parent");
        Element child = new Element("child");
        Element sibling = new Element("sibling");
        parent.appendChild(new Element[]{child});
        new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class}).getUI().getElement().appendChild(new Element[]{parent, sibling});
        String eventType = "click";
        String expression = "expression";
        String key = "]expression";
        AtomicReference capturedTarget = new AtomicReference();
        DomListenerRegistration registration = parent.addEventListener("click", capturedTarget::set);
        ElementListenerMap listenerMap = (ElementListenerMap)parent.getNode().getFeature(ElementListenerMap.class);
        Set<String> expressions = ElementListenersTest.getExpressions(listenerMap, "click");
        Assertions.assertEquals((int)0, (int)expressions.size());
        registration.addEventDataElement("expression");
        expressions = ElementListenersTest.getExpressions(listenerMap, "click");
        Assertions.assertEquals((int)1, (int)expressions.size());
        Assertions.assertEquals((Object)"]expression", (Object)expressions.iterator().next());
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.put("]expression", child.getNode().getId());
        listenerMap.fireEvent(new DomEvent(parent, "click", (JsonNode)eventData));
        Assertions.assertEquals((Object)child, ((DomEvent)capturedTarget.get()).getEventDataElement("expression").get());
        listenerMap.fireEvent(new DomEvent(parent, "click", (JsonNode)JacksonUtils.createObjectNode()));
        Assertions.assertFalse((boolean)((DomEvent)capturedTarget.get()).getEventDataElement("expression").isPresent(), (String)"no element should be reported");
        eventData.put("]expression", sibling.getNode().getId());
        listenerMap.fireEvent(new DomEvent(parent, "click", (JsonNode)eventData));
        Assertions.assertEquals((Object)sibling, ((DomEvent)capturedTarget.get()).getEventDataElement("expression").get());
    }

    @Test
    void addEventDataElement_eventTarget_usesMapEventTargetInstead() {
        Element parent = new Element("parent");
        Element child = new Element("child");
        parent.appendChild(new Element[]{child});
        new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class}).getUI().getElement().appendChild(new Element[]{parent});
        String eventType = "click";
        AtomicReference capturedTarget = new AtomicReference();
        DomListenerRegistration registration = parent.addEventListener("click", capturedTarget::set);
        ElementListenerMap listenerMap = (ElementListenerMap)parent.getNode().getFeature(ElementListenerMap.class);
        registration.addEventDataElement("event.target");
        Set<String> expressions = ElementListenersTest.getExpressions(listenerMap, "click");
        Assertions.assertEquals((int)1, (int)expressions.size());
        Assertions.assertEquals((Object)"]", (Object)expressions.iterator().next());
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.put("]", child.getNode().getId());
        listenerMap.fireEvent(new DomEvent(parent, "click", (JsonNode)eventData));
        Assertions.assertEquals((Object)child, ((DomEvent)capturedTarget.get()).getEventTarget().get());
        Assertions.assertEquals((Object)child, ((DomEvent)capturedTarget.get()).getEventDataElement("event.target").get());
    }

    @Test
    void eventDataKeyNotPresentNotFail() {
        AtomicInteger eventCount = new AtomicInteger();
        DomListenerRegistration registration = this.ns.add("foo", (DomEventListener & Serializable)e -> eventCount.incrementAndGet());
        registration.setFilter("filterKey");
        this.ns.fireEvent(ElementListenersTest.createEvent("foo"));
        Assertions.assertEquals((int)0, (int)eventCount.get());
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.put("filterKey", true);
        this.ns.fireEvent(new DomEvent(new Element("element"), "foo", (JsonNode)eventData));
        Assertions.assertEquals((int)1, (int)eventCount.get());
    }

    @Test
    void testPreventDefaultWithFilter() {
        DomListenerRegistration registration = this.ns.add("keydown", noOp);
        registration.setFilter("event.key === ' ' || event.key === 'Enter'");
        registration.preventDefault();
        Set<String> expressions = this.getExpressions("keydown");
        Assertions.assertTrue((boolean)expressions.contains("event.key === ' ' || event.key === 'Enter'"), (String)"Should have the filter expression");
        Assertions.assertTrue((boolean)expressions.contains("(event.key === ' ' || event.key === 'Enter') && event.preventDefault()"), (String)"Should have conditional preventDefault expression");
        Assertions.assertFalse((boolean)expressions.contains("event.preventDefault()"), (String)"Should NOT have unconditional preventDefault");
    }

    @Test
    void testPreventDefaultWithoutFilter() {
        DomListenerRegistration registration = this.ns.add("keydown", noOp);
        registration.preventDefault();
        Set<String> expressions = this.getExpressions("keydown");
        Assertions.assertTrue((boolean)expressions.contains("event.preventDefault()"), (String)"Should have preventDefault expression");
        Assertions.assertEquals((int)1, (int)expressions.size(), (String)"Should only have preventDefault expression");
    }

    @Test
    void testPreventDefaultThenSetFilter() {
        DomListenerRegistration registration = this.ns.add("keydown", noOp);
        registration.preventDefault();
        registration.setFilter("event.key === 'Escape'");
        Set<String> expressions = this.getExpressions("keydown");
        Assertions.assertTrue((boolean)expressions.contains("(event.key === 'Escape') && event.preventDefault()"), (String)"Should have conditional preventDefault expression");
        Assertions.assertFalse((boolean)expressions.contains("event.preventDefault()"), (String)"Should NOT have unconditional preventDefault");
    }

    @Test
    void testSetFilterThenPreventDefault() {
        DomListenerRegistration registration = this.ns.add("keydown", noOp);
        registration.setFilter("event.key === 'Delete'");
        registration.preventDefault();
        Set<String> expressions = this.getExpressions("keydown");
        Assertions.assertTrue((boolean)expressions.contains("(event.key === 'Delete') && event.preventDefault()"), (String)"Should have conditional preventDefault expression");
        Assertions.assertFalse((boolean)expressions.contains("event.preventDefault()"), (String)"Should NOT have unconditional preventDefault");
    }

    @Test
    void testStopPropagationWithFilter() {
        DomListenerRegistration registration = this.ns.add("keydown", noOp);
        registration.setFilter("event.key === ' ' || event.key === 'Enter'");
        registration.stopPropagation();
        Set<String> expressions = this.getExpressions("keydown");
        Assertions.assertTrue((boolean)expressions.contains("event.key === ' ' || event.key === 'Enter'"), (String)"Should have the filter expression");
        Assertions.assertTrue((boolean)expressions.contains("(event.key === ' ' || event.key === 'Enter') && event.stopPropagation()"), (String)"Should have conditional stopPropagation expression");
        Assertions.assertFalse((boolean)expressions.contains("event.stopPropagation()"), (String)"Should NOT have unconditional stopPropagation");
    }

    @Test
    void testStopPropagationWithoutFilter() {
        DomListenerRegistration registration = this.ns.add("keydown", noOp);
        registration.stopPropagation();
        Set<String> expressions = this.getExpressions("keydown");
        Assertions.assertTrue((boolean)expressions.contains("event.stopPropagation()"), (String)"Should have stopPropagation expression");
        Assertions.assertEquals((int)1, (int)expressions.size(), (String)"Should only have stopPropagation expression");
    }

    @Test
    void testStopPropagationThenSetFilter() {
        DomListenerRegistration registration = this.ns.add("keydown", noOp);
        registration.stopPropagation();
        registration.setFilter("event.key === 'Escape'");
        Set<String> expressions = this.getExpressions("keydown");
        Assertions.assertTrue((boolean)expressions.contains("(event.key === 'Escape') && event.stopPropagation()"), (String)"Should have conditional stopPropagation expression");
        Assertions.assertFalse((boolean)expressions.contains("event.stopPropagation()"), (String)"Should NOT have unconditional stopPropagation");
    }

    @Test
    void testSetFilterThenStopPropagation() {
        DomListenerRegistration registration = this.ns.add("keydown", noOp);
        registration.setFilter("event.key === 'Delete'");
        registration.stopPropagation();
        Set<String> expressions = this.getExpressions("keydown");
        Assertions.assertTrue((boolean)expressions.contains("(event.key === 'Delete') && event.stopPropagation()"), (String)"Should have conditional stopPropagation expression");
        Assertions.assertFalse((boolean)expressions.contains("event.stopPropagation()"), (String)"Should NOT have unconditional stopPropagation");
    }

    @Test
    void testAddEventDataWithRecord() {
        DomListenerRegistration registration = this.ns.add("click", noOp);
        record MouseEventData(1EventDetails event, String type) {
            private final 1EventDetails event;

            MouseEventData {
                record EventDetails(int button, int clientX, int clientY) {
                }
            }

            public 1EventDetails event() {
                return this.event;
            }
        }
        registration.addEventData(MouseEventData.class);
        Set<String> expressions = this.getExpressions("click");
        Assertions.assertTrue((boolean)expressions.contains("event.button"), (String)"Should capture event.button");
        Assertions.assertTrue((boolean)expressions.contains("event.clientX"), (String)"Should capture event.clientX");
        Assertions.assertTrue((boolean)expressions.contains("event.clientY"), (String)"Should capture event.clientY");
        Assertions.assertTrue((boolean)expressions.contains("type"), (String)"Should capture type");
        Assertions.assertEquals((int)4, (int)expressions.size(), (String)"Should have 4 expressions");
    }

    @Test
    void testAddEventDataWithSimpleBean() {
        DomListenerRegistration registration = this.ns.add("custom", noOp);
        class SimpleEventData {
            private String message;
            private int code;

            SimpleEventData(ElementListenersTest this$0) {
            }

            public String getMessage() {
                return this.message;
            }

            public int getCode() {
                return this.code;
            }
        }
        registration.addEventData(SimpleEventData.class);
        Set<String> expressions = this.getExpressions("custom");
        Assertions.assertTrue((boolean)expressions.contains("message"), (String)"Should capture message");
        Assertions.assertTrue((boolean)expressions.contains("code"), (String)"Should capture code");
        Assertions.assertEquals((int)2, (int)expressions.size(), (String)"Should have 2 expressions");
    }

    @Test
    void testAddEventDetail() {
        DomListenerRegistration registration = this.ns.add("color-change", noOp);
        registration.addEventDetail();
        Set<String> expressions = this.getExpressions("color-change");
        Assertions.assertTrue((boolean)expressions.contains("event.detail"), (String)"Should capture event.detail");
        Assertions.assertEquals((int)1, (int)expressions.size(), (String)"Should have 1 expression");
    }

    @Test
    void testAddEventDetailChaining() {
        DomListenerRegistration registration = this.ns.add("custom-event", noOp);
        registration.addEventDetail().addEventData("event.timestamp");
        Set<String> expressions = this.getExpressions("custom-event");
        Assertions.assertTrue((boolean)expressions.contains("event.detail"), (String)"Should capture event.detail");
        Assertions.assertTrue((boolean)expressions.contains("event.timestamp"), (String)"Should capture event.timestamp");
        Assertions.assertEquals((int)2, (int)expressions.size(), (String)"Should have 2 expressions");
    }

    @Test
    void testAddEventDetailWithClass() {
        DomListenerRegistration registration = this.ns.add("color-change", noOp);
        record RgbColor(int r, int g, int b) {
        }
        registration.addEventDetail(RgbColor.class);
        Set<String> expressions = this.getExpressions("color-change");
        Assertions.assertTrue((boolean)expressions.contains("event.detail.r"), (String)"Should capture event.detail.r");
        Assertions.assertTrue((boolean)expressions.contains("event.detail.g"), (String)"Should capture event.detail.g");
        Assertions.assertTrue((boolean)expressions.contains("event.detail.b"), (String)"Should capture event.detail.b");
        Assertions.assertFalse((boolean)expressions.contains("event.detail"), (String)"Should NOT capture entire event.detail");
        Assertions.assertEquals((int)3, (int)expressions.size(), (String)"Should have 3 expressions");
    }

    @Test
    void testAddEventDetailWithClassAndGetEventDetail() {
        Element element = new Element("div");
        AtomicReference capturedColor = new AtomicReference();
        record RgbColor(int r, int g, int b) {
        }
        element.addEventListener("color-change", (DomEventListener & Serializable)e -> capturedColor.set((RgbColor)e.getEventDetail(RgbColor.class))).addEventDetail(RgbColor.class);
        ElementListenerMap listenerMap = (ElementListenerMap)element.getNode().getFeature(ElementListenerMap.class);
        Set<String> expressions = ElementListenersTest.getExpressions(listenerMap, "color-change");
        Assertions.assertTrue((boolean)expressions.contains("event.detail.r"), (String)"Should capture event.detail.r");
        Assertions.assertTrue((boolean)expressions.contains("event.detail.g"), (String)"Should capture event.detail.g");
        Assertions.assertTrue((boolean)expressions.contains("event.detail.b"), (String)"Should capture event.detail.b");
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.put("event.detail.r", 255);
        eventData.put("event.detail.g", 128);
        eventData.put("event.detail.b", 64);
        listenerMap.fireEvent(new DomEvent(element, "color-change", (JsonNode)eventData));
        RgbColor result = (RgbColor)capturedColor.get();
        Assertions.assertNotNull((Object)result, (String)"Should have captured color");
        Assertions.assertEquals((int)255, (int)result.r(), (String)"Red should be 255");
        Assertions.assertEquals((int)128, (int)result.g(), (String)"Green should be 128");
        Assertions.assertEquals((int)64, (int)result.b(), (String)"Blue should be 64");
    }

    @Test
    void testAddEventDetailWithNestedClass() {
        DomListenerRegistration registration = this.ns.add("drag", noOp);
        record DragDetail(1Position start, 1Position end) {
            private final 1Position start;
            private final 1Position end;

            DragDetail {
                record Position(int x, int y) {
                }
            }

            public 1Position start() {
                return this.start;
            }

            public 1Position end() {
                return this.end;
            }
        }
        registration.addEventDetail(DragDetail.class);
        Set<String> expressions = this.getExpressions("drag");
        Assertions.assertTrue((boolean)expressions.contains("event.detail.start.x"), (String)"Should capture event.detail.start.x");
        Assertions.assertTrue((boolean)expressions.contains("event.detail.start.y"), (String)"Should capture event.detail.start.y");
        Assertions.assertTrue((boolean)expressions.contains("event.detail.end.x"), (String)"Should capture event.detail.end.x");
        Assertions.assertTrue((boolean)expressions.contains("event.detail.end.y"), (String)"Should capture event.detail.end.y");
        Assertions.assertEquals((int)4, (int)expressions.size(), (String)"Should have 4 expressions");
    }

    @Test
    void testGetEventDetailWithRecord() {
        ObjectNode eventData = JacksonUtils.createObjectNode();
        ObjectNode detailData = JacksonUtils.createObjectNode();
        detailData.put("r", 255);
        detailData.put("g", 128);
        detailData.put("b", 64);
        eventData.set("event.detail", (JsonNode)detailData);
        DomEvent event = new DomEvent(new Element("element"), "color-change", (JsonNode)eventData);
        record RgbColor(int r, int g, int b) {
        }
        RgbColor color = (RgbColor)event.getEventDetail(RgbColor.class);
        Assertions.assertNotNull((Object)color, (String)"Color should not be null");
        Assertions.assertEquals((int)255, (int)color.r(), (String)"Red should be 255");
        Assertions.assertEquals((int)128, (int)color.g(), (String)"Green should be 128");
        Assertions.assertEquals((int)64, (int)color.b(), (String)"Blue should be 64");
    }

    @Test
    void testGetEventDetailWithBean() {
        ObjectNode eventData = JacksonUtils.createObjectNode();
        ObjectNode detailData = JacksonUtils.createObjectNode();
        detailData.put("message", "Hello World");
        detailData.put("code", 42);
        eventData.set("event.detail", (JsonNode)detailData);
        DomEvent event = new DomEvent(new Element("element"), "custom-event", (JsonNode)eventData);
        EventPayload payload = (EventPayload)event.getEventDetail(EventPayload.class);
        Assertions.assertNotNull((Object)payload, (String)"Payload should not be null");
        Assertions.assertEquals((Object)"Hello World", (Object)payload.getMessage(), (String)"Message should match");
        Assertions.assertEquals((int)42, (int)payload.getCode(), (String)"Code should match");
    }

    @Test
    void testGetEventDetailWithTypeReference() {
        ObjectNode eventData = JacksonUtils.createObjectNode();
        ArrayNode detailArray = JacksonUtils.createArrayNode();
        detailArray.add("first");
        detailArray.add("second");
        detailArray.add("third");
        eventData.set("event.detail", (JsonNode)detailArray);
        DomEvent event = new DomEvent(new Element("element"), "list-change", (JsonNode)eventData);
        List items = (List)event.getEventDetail((TypeReference)new TypeReference<List<String>>(this){});
        Assertions.assertNotNull((Object)items, (String)"Items should not be null");
        Assertions.assertEquals((int)3, (int)items.size(), (String)"Should have 3 items");
        Assertions.assertEquals((Object)"first", items.get(0), (String)"First item");
        Assertions.assertEquals((Object)"second", items.get(1), (String)"Second item");
        Assertions.assertEquals((Object)"third", items.get(2), (String)"Third item");
    }

    @Test
    void testGetEventDetailReturnsNullWhenNotPresent() {
        ObjectNode eventData = JacksonUtils.createObjectNode();
        DomEvent event = new DomEvent(new Element("element"), "event", (JsonNode)eventData);
        record SomeData(String value) {
        }
        SomeData data = (SomeData)event.getEventDetail(SomeData.class);
        Assertions.assertNull((Object)data, (String)"Should return null when event.detail not present");
    }

    @Test
    void testGetEventDetailReturnsNullWhenNull() {
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.set("event.detail", (JsonNode)JacksonUtils.nullNode());
        DomEvent event = new DomEvent(new Element("element"), "event", (JsonNode)eventData);
        record SomeData(String value) {
        }
        SomeData data = (SomeData)event.getEventDetail(SomeData.class);
        Assertions.assertNull((Object)data, (String)"Should return null when event.detail is null");
    }

    public static Set<String> getExpressions(ElementListenerMap elementListenerMap, String eventName) {
        return new HashSet<String>(elementListenerMap.getExpressions(eventName));
    }

    private Set<String> getExpressions(String name) {
        return ElementListenersTest.getExpressions(this.ns, name);
    }

    private static DomEvent createEvent(String type) {
        return new DomEvent(new Element("fake"), type, (JsonNode)JacksonUtils.createObjectNode());
    }

    public static class EventPayload {
        private String message;
        private int code;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }
    }
}

