/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.page.ClipboardEvent;
import com.vaadin.flow.component.page.ClipboardFile;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ClipboardEventTest {
    @Test
    public void textEvent_hasCorrectValues() {
        ClipboardEvent event = new ClipboardEvent("paste", "hello", null, List.of());
        Assert.assertEquals((Object)"paste", (Object)event.getType());
        Assert.assertEquals((Object)"hello", (Object)event.getText());
        Assert.assertNull((Object)event.getHtml());
        Assert.assertTrue((boolean)event.hasText());
        Assert.assertFalse((boolean)event.hasHtml());
        Assert.assertFalse((boolean)event.hasFiles());
        Assert.assertTrue((boolean)event.getFiles().isEmpty());
    }

    @Test
    public void htmlEvent_hasCorrectValues() {
        ClipboardEvent event = new ClipboardEvent("paste", "plain", "<b>bold</b>", List.of());
        Assert.assertTrue((boolean)event.hasText());
        Assert.assertTrue((boolean)event.hasHtml());
        Assert.assertEquals((Object)"<b>bold</b>", (Object)event.getHtml());
    }

    @Test
    public void emptyTextAndHtml_hasTextReturnsFalse() {
        ClipboardEvent event = new ClipboardEvent("paste", "", "", List.of());
        Assert.assertFalse((boolean)event.hasText());
        Assert.assertFalse((boolean)event.hasHtml());
    }

    @Test
    public void nullTextAndHtml_hasTextReturnsFalse() {
        ClipboardEvent event = new ClipboardEvent("paste", null, null, List.of());
        Assert.assertFalse((boolean)event.hasText());
        Assert.assertFalse((boolean)event.hasHtml());
    }

    @Test
    public void eventWithFiles_hasFilesReturnsTrue() {
        ClipboardFile file = new ClipboardFile("test.png", "image/png", 100L, new byte[100]);
        ClipboardEvent event = new ClipboardEvent("paste", null, null, List.of(file));
        Assert.assertTrue((boolean)event.hasFiles());
        Assert.assertEquals((long)1L, (long)event.getFiles().size());
        Assert.assertEquals((Object)"test.png", (Object)((ClipboardFile)event.getFiles().get(0)).getName());
    }

    @Test
    public void filesListIsUnmodifiable() {
        ClipboardEvent event = new ClipboardEvent("paste", null, null, List.of(new ClipboardFile("f.txt", "text/plain", 5L, new byte[5])));
        Assert.assertThrows(UnsupportedOperationException.class, () -> event.getFiles().add(new ClipboardFile("x.txt", "text/plain", 1L, new byte[1])));
    }

    @Test
    public void nullFilesList_becomesEmptyList() {
        ClipboardEvent event = new ClipboardEvent("paste", "text", null, null);
        Assert.assertNotNull((Object)event.getFiles());
        Assert.assertTrue((boolean)event.getFiles().isEmpty());
        Assert.assertFalse((boolean)event.hasFiles());
    }

    @Test
    public void copyEvent_hasCorrectType() {
        ClipboardEvent event = new ClipboardEvent("copy", "copied text", null, List.of());
        Assert.assertEquals((Object)"copy", (Object)event.getType());
    }

    @Test
    public void cutEvent_hasCorrectType() {
        ClipboardEvent event = new ClipboardEvent("cut", "cut text", null, List.of());
        Assert.assertEquals((Object)"cut", (Object)event.getType());
    }

    @Test
    public void clipboardFile_hasCorrectValues() {
        byte[] data = new byte[]{1, 2, 3, 4, 5};
        ClipboardFile file = new ClipboardFile("photo.jpg", "image/jpeg", 5L, data);
        Assert.assertEquals((Object)"photo.jpg", (Object)file.getName());
        Assert.assertEquals((Object)"image/jpeg", (Object)file.getMimeType());
        Assert.assertEquals((long)5L, (long)file.getSize());
        Assert.assertArrayEquals((byte[])data, (byte[])file.getData());
    }
}

